/* FileName : PLAYANM.C ______________________________ LastUpdate : 94.11.11 */
/* Comments : 43 lines mode would be nice to read..		*/
/*

	The Deluxe Paint Animation Player ...

	Hack & Reprogram by kwanny

	Date : 1994. 11. 3

	Presented by ͻɻɻͻɻ o tm
		     ͻ ȹȹ ʻ
		     ͼ ȼ ʼ ȼ

       ..Note..

       * Special Thanks to HP-500k Printer for his astonishing

	 amounts of print-out.

       * Sorry. This codes are not optimized.

	 Why ? Because I'm not a coder.

  */



		    #include <stdio.h>
		    #include <stdlib.h>
		    #include <dos.h>
		    #include <conio.h>
		    #include <malloc.h>
		    #include <memory.h>
		    #include <time.h>
		    #include <string.h>

		    #include "playanm.h"
		    #include "playlib.h"
		    #include "vsync.h"



	// EXTERNAL PROTO-TYPE

char	 *RLEdecode( char *buffPtr, char *destPtr );  // RLDECODE.ASM



	// GLOBAL VARs

DA	 da;
PLAY     play;



	// STATIC VARs

static	 FILE	     *io;
static	 unsigned    char far *VGA=(unsigned char far*)0xa0000000L;
static	 unsigned    getWord( void );
static	 void	     groupRead( void );
static	 long	     defTick;
static	 char	     *VERSION = "1.0";
static	 char	     *title = " DPaint Animation Player By kwanny Ver ";
static   char        *usage =
                     " Usage : PLAYANM filename.anm [/Rxx] [/Lxx]\n" \
                     " [/R] : framesPerSec\n"                        \
                     " [/L] : loopCounts\n";


/*
    SUB  ROUTINES  
  */


#define  getByte() ( *play.anmPtr++ )

unsigned getWord( void )
{
unsigned x;

	 x = *((unsigned*)play.anmPtr);
	 play.anmPtr += 2;

	 return x;
}

void	 makeNewExt(char *new, char *old, char *ext)
{
	 while(*old != 0 && *old != '.' ) *new++=*old++;
	 *new++='.';
	 while(*ext) *new++=*ext++;
	 *new=0;
}

long	 originalSize( void )
{

long si = 0;
int  i;

	for(i=0;i<da.groups;i++)
	    si += da.index[i].size;

	return si;
}


/**/
	int playANM( char far *buff )
/**/
{
unsigned char data;
unsigned char *buffPtr;
unsigned      i, count;

	 buffPtr = buff;

	 if( da.frameSizeTable[ play.inFrame ] != 0 )
	 {
	      memcpy(play.frameHeader, play.anmPtr, 4);
	      play.anmPtr += 4;

	      play.anmPtr = RLEdecode( play.anmPtr, buffPtr ); /* ASM-CALL */

	      /*  If you want to decode with C, delete this remarks and
		  remove above 'ASM-CALL' line.

	      while(1)
	      {

		 data = getByte();

		 if( data == 0x80 )
		 {
		     if( (count = getWord()) == 0 ) break;

		     if( count & 0x8000 )
		     {
			 if( count & 0x4000 )
			 {
			     count &= 0x3fff;
			     data   = getByte();
			     while( count-- )	*buffPtr++ = data;

			 } else {

			     count &= 0x3fff;
			     while( count-- )	*buffPtr++ = getByte();
			 }

		     } else {

			 buffPtr += count & 0x7fff;
		     }

		 } else {

		     count = data;

		     if( count )
		     {
			 if( count & 0x80 )
			 {
			     buffPtr += count & 0x7f;

			 } else {

			     count &= 0x7f;
			     while( count-- )	*buffPtr++ = getByte();
			 }

		     } else {

			 count = getByte();
			 data  = getByte();
			 while( count-- )   *buffPtr++ = data;
		     }
		 }
	      }

	      */
	 }

	 play.nowFrame ++;
	 play.inFrame ++;

	 if( play.inFrame == da.frames ) groupRead();

}





/**/
        void groupRead( void )
/**/
{
int  i, j;
long off;

	for(i=0, j = 0;i<da.groups;i++)
	{
	     if( da.index[i].start == play.nowFrame ) j = i;
	}

	off = 0x10000 * j + 0xb00;

	fseek(io, off, SEEK_SET);

	da.start     = getw( io );
	da.frames    = getw( io );
	da.groupSize = getw( io );
	getw(io);

	fread( da.frameSizeTable, da.frames, 2, io );
	fread( play.anmBuff, (size_t)da.groupSize, 1, io );

	play.anmPtr  = play.anmBuff;
	play.inFrame = 0;

}



/**/
        int initANM( char *name )
/**/
{
int i;
	io = fopen( name, "rb" );

	if( io == NULL ) return(1);

	fread( da.msg1, 0x100, 1, io );

	if( strncmp( da.msg2, "ANIM", 4 ) != 0 ) return(2);

	for(i=0;i<256;i++)
	{
	    da.palette[i*3+2] = getc(io)>>2;   /* NOT RGB, GBR */
	    da.palette[i*3+1] = getc(io)>>2;
	    da.palette[i*3+0] = getc(io)>>2;
	    getc(io);			       /* Dummy Data   */
	}

	for(i=0;i<16;i++)		       /* Init Gradient */
	    da.grad[i].unknown2 = da.grad[i].speed/4;

	fread( &da.index, da.groups, 6, io);

	play.anmBuff	 = (char *)malloc( 0xff00 );

	if( play.anmBuff == NULL )
	{
	    fclose(io);
	    return(3);
	}

	return(0);
}




/**/
        int closeANM( void )
/**/
{
	if( fclose(io) == EOF ) return(1);

	free( play.anmBuff );

	return(0);
}





/**/
        void rewindANM( void )
/**/
{
	play.nowFrame = 0;

	groupRead();
}



static	int   palCnt=-1;


#pragma check_stack (off)


void vsyncPaletteRotate( void )
{
int    cnt, rapCnt;
char   *palPtr;
char   buff[3];

	for(rapCnt=0;rapCnt<16;rapCnt++)
	{
	    palCnt = ++palCnt % 16;

	    if( da.grad[palCnt].speed == 0 )
		continue;

	    if( da.grad[palCnt].end == da.grad[palCnt].start )
		continue;

	    if( ++da.grad[palCnt].unknown2 > 17 )
	    {
		da.grad[palCnt].unknown2 = da.grad[palCnt].speed/4;

		palPtr = da.palette + da.grad[palCnt].end * 3 + 2;

		for(cnt=0;cnt<3;cnt++)
		    buff[cnt] = *(palPtr+cnt-2);

		cnt = (da.grad[palCnt].end - da.grad[palCnt].start ) * 3;

		while(cnt--)
		{
		    *palPtr = *(palPtr - 3);
		    palPtr --;
		}

		for(cnt=0;cnt<3;cnt++)
		    *palPtr-- = buff[2-cnt];

		setVsyncDac( da.palette, da.grad[palCnt].start,
		      da.grad[palCnt].end - da.grad[palCnt].start + 1  );

		break;
	    }
	}
}

#pragma check_stack (on)


/**/
/**/void  main( int argc, char *argv[] )/**/
/**/
{
int  err;
int  loop=1;
char name[30];

     if( argc < 2 )
     {
	 printf("%s%s\n", title, VERSION );
	 puts( usage );
	 exit(0);
     }

     makeNewExt(name, argv[1], "ANM" );

     if( (err = initANM( name )) == 0 )
     {
	 for(err=2;err<4;err++)
	 {
	     if( strnicmp(argv[err],"/R",2)==0 )
		 sscanf(argv[err]+2,"%d",&da.framesPerSec );

	     if( strnicmp(argv[err],"/L",2)==0 )
		 sscanf(argv[err]+2,"%d",&loop );
	 }

	 changeVideo( 0x13 );
	 setDac( da.palette );
	 setUserVsyncHandler( vsyncPaletteRotate );
	 installVsyncHandler();
	 defTick = 600000 / da.framesPerSec;	   /* Not precise */

	 while( loop-- )
	 {
	     rewindANM();			   /* Init File Pointer */

	     while( !kbhit() && da.totalFrames-1 != play.nowFrame )
	     {
		 playANM( VGA );
		 delay( defTick );
	     }
	 }

	 closeANM();
	 getch();
	 removeVsyncHandler();
	 changeVideo(3);

	 printf("%s%s\n", title, VERSION );
	 printf(" Data Size  : %ld\n", originalSize() );
	 printf(" Groups     : %d\n MaxFrames  : %d\n Frames/Sec : %d\n"
		,da.groups, da.totalFrames-1, da.framesPerSec );

     } else {

	 switch( err )
	 {
	    case 1 :
	    puts("\007File Open Error.");
	    break;

	    case 2 :
	    puts("\007That file not DeluxePaint Anmation File.");
	    break;

	    case 3 :
	    puts("\007Memory allocate error !.");
	    break;

	 }
     }
}
