/* FileName : PLAYANM.H __________________________ LastUpdate : 94.11. 8 */

/*

      DeluxePaint Animation File (ANM) Header Format

		& Player Header 	   by kwanny

   */


#ifndef _PLAYANM_H
#define _PLAYANM_H


#define MAX_INDEX_TABLE   256

typedef struct {

    unsigned   start;
    unsigned   frames;
    unsigned   size;

} INDEX;


typedef struct {

	 unsigned     char   unknown1[ 3 ];

	 unsigned     char   speed;
	 unsigned     char   attr;

	 unsigned     char   unknown2;

	 unsigned     char   start;
	 unsigned     char   end;

} GRADIENT;



typedef struct {

	 char	      msg1[ 5 ];		// "LPF "

	 char	      unknownData1;

	 int	      groups;			// Group Number in a File
	 int	      totalFrames;

	 char	      unknownField1[ 6 ];

	 char	      msg2[ 4 ];		// "ANIM"
	 int	      xSize;			// 320
	 int	      ySize;			// 200

	 char	      unknownField2[ 44 ];

	 int	      framesPerSec;

	 char	      unknownField3[ 58 ];

	 GRADIENT     grad[ 16 ];		// palette gradient table

	 char	      palette[256*3];

	 INDEX	      index[ MAX_INDEX_TABLE ];

	 unsigned     start;			// start frame
	 unsigned     frames;			// frames in Group

	 unsigned     groupSize;		// ANM Block Size in a Group
	 unsigned     frameSizeTable[256];

} DA;



typedef struct {

	 char	      fileName[14];
	 char	      frameHeader[4];		// unknowned Specify or ID

	 long	      nextOffset;

     unsigned     nowFrame;         // total played frame count
	 unsigned     inFrame;			// local frame in Group

	 unsigned     char *anmBuff;
	 unsigned     char *anmPtr;

} PLAY;



    // Global Proto-Type


int	 playANM( char far *buff );
int	 initANM( char *name );
int	 closeANM( void );
void	 rewindANM( void );

extern	 DA	      da;
extern	 PLAY	      play;

#endif
