; FileName : RLDECODE.ASM __________________________ LastUpDate : 94. 11. 11

comment (

	  					      
	    Enhanced Run-Length Decoding SubRoutine  
	  					      
	  			      Code by kwanny  
	  					      

(;)
		  .286
		  .MODEL  LARGE, C

    ; MACROS


    GETBYTE  MACRO  reg

	     mov    reg, byte ptr ds:[si]
	     inc    si

	     ENDM



    GETWORD  MACRO  reg

	     mov    reg, word ptr ds:[si]
	     add    si,  2

	     ENDM



    DUMPDATA MACRO			; CX : count, AL : data , USES AX
	     LOCAL dumpLoop, dumpExit

             mov   ah, al
             shr   cx, 1
             jnc   dumpLoop
	     mov   es:[di], al
	     inc   di
             jcxz  dumpExit

	     dumpLoop:
             mov   es:[di], ax
             add   di, 2
	     dec   cx
	     jnz   dumpLoop

             dumpExit:

	     ENDM


    LISTDATA MACRO			; CX : count
	     LOCAL listLoop

	     listLoop:
	     mov   al, byte ptr ds:[si]
	     mov   es:[di], al
	     inc   si
	     inc   di
	     dec   cx
	     jnz   listLoop

	     ENDM



    .CODE

;
     RLEdecode PROC c USES si di ds es, buffPtr:DWORD, destPtr:DWORD
;

	lds	si, buffPtr
	les	di, destPtr

        EVEN

decodeWhile:
	GETBYTE al
	cmp	al, 80h
	jne	not80h

	GETWORD cx
	and	cx, cx
	jz	decodeDone

	mov	ax, 8000h
	and	ax, cx
	jz	wordSkip

	mov	ax, 4000h
	and	ax, cx
	jz	wordList

	and	cx, 3fffh
	GETBYTE al
	DUMPDATA
	jmp	decodeWhile

wordList:
	and	 cx, 3fffh
	LISTDATA
	jmp	decodeWhile

wordSkip:
	and	cx, 7fffh
	add	di, cx
	jmp	decodeWhile

not80h:
	mov	ah, 0
	mov	cx, ax
	and	cx, cx
	jz	byteDump

	mov	ax, 080h
	and	ax, cx
	jz	byteList

	and	cx, 7fh
	add	di, cx
	jmp	decodeWhile

byteList:
	and	cx, 7fh
	LISTDATA
	jmp	decodeWhile

byteDump:
	GETBYTE al
	mov	ah, 0
	mov	cx, ax
	GETBYTE al
	DUMPDATA
	jmp	decodeWhile

decodeDone:
	mov	dx, ds
	mov	ax, si

	ret

RLEdecode ENDP


END
