; FileName : VSYNC.ASM _________________________________ LastUpDate : 94.11.9
comment (

  ͻ
  								   
    
    Virtual Vertical Retrace Syncronized Interrupt Handler  
    
  								   
         Only  Arrange     by    kwanny                           
         Codes are based   upon                                   
               XLIB6.0     by    Tore Bastiansen,                 
               REND386     by    Dave Stampe and Bernie Roehl     
  								   
  	  For Rotating Palette in DeluxePaint Animation Player	   
  								   
  ͼ

(;)  Hi..?

		  .286
		  .MODEL  LARGE, C


TIMER_VECT	  EQU	  08h

PIC_CMD 	  EQU	  20h
NONSPEC_EOI	  EQU	  20h
TIMER_MODE	  EQU	  34h
TIMER_CONTROL	  EQU	  43h
TIMER_0 	  EQU	  40h

LATCH_COUNT	  EQU	  00h

INT_IN_ADVANCE	  EQU	  100

DOS_GETVECT	  EQU	  3500h
DOS_SETVECT	  EQU	  2500h

STATUS_PORT	  EQU	  03dah

DAC_WRITE_INDEX   EQU	  03c8h
DAC_DATA	  EQU	  03c9h

TRUE		  EQU	  1
FALSE		  EQU	  0



WaitVsyncStart	 MACRO

	LOCAL	WaitNotVsync,WaitVsync

	mov	dx,STATUS_PORT

	WaitNotVsync:
	in	al,dx
	test	al,08h
	jnz	WaitNotVsync

	WaitVsync:
	in	al,dx
	test	al,08h
	jz	WaitVsync

	ENDM


WaitVsyncEnd	MACRO

	LOCAL WaitNotVsync,WaitVsync

	mov	dx,STATUS_PORT

	WaitVsync2:
	in      al,dx
	test    al,08h
	jz	WaitVsync2

	WaitNotVsync2:
	in      al,dx
	test    al,08h
	jnz	WaitNotVsync2

	ENDM



	.DATA


_VsyncHandlerActive dw	 0

_TicksPerSecond    dw	 0

_VsyncIntTicks	   label dword
VsyncIntTicksLo    dw	 0
VsyncIntTicksHi    dw	 0
_VsyncPeriod	   dw	 0	       ;Time (in clicks) between each vsync
				       ;1 click = 1.193 microseconds
ClockRate	   dw	 0	       ;Clock rate (in clicks) for timer 0
ClockCounter	   dw	 0	       ;Counts total clicks modulo 65536

UserVsyncHandler   label dword	       ;Pointer to user routine called
UserVsyncOffs	   dw	 0	       ;called once each vsync period.
UserVsyncSeg	   dw	 0
InUserHandler	   dw	 0
		   db 100h dup(?)

LocalStack	   label byte	       ;Local stack for user handler

StackSeg	   dw	 0
StackPtr	   dw	 0

vsyncPal	   dd	 0
vsyncPalStart	   dw	 0
vsyncPalCnt	   dw	 0


	.code

;
	getVsyncPeriod proc near
;

	mov    al, TIMER_MODE
	out    TIMER_CONTROL, al
	mov    al, 0
	out    TIMER_0, al
	out    TIMER_0, al

	WaitVsyncStart

	mov    al, LATCH_COUNT
	out    TIMER_CONTROL, al
	in     al, TIMER_0
	mov    cl, al
	in     al, TIMER_0
	mov    ch, al

	WaitVsyncStart

	mov    al, LATCH_COUNT
	out    TIMER_CONTROL, al
	in     al, TIMER_0
	mov    dl, al
	in     al, TIMER_0
	mov    dh, al

	sub    cx, dx
	mov    ax, cx

	ret

getVsyncPeriod endp


;
	vsyncIntHandler proc far
;

	pusha
	push   ds
	push   es

	mov    ax, @data
	mov    ds, ax
	add    [VsyncIntTicksLo], 1
	adc    [VsyncIntTicksHi], 0

	cli
	mov    al, TIMER_MODE
	out    TIMER_CONTROL, al
	mov    al, 255
	out    TIMER_0, al
	out    TIMER_0, al
	sti

	cli
	mov    dx, STATUS_PORT
@@WaitVS:
	in     al, dx
	test   al, 08h
	jz     @@WaitVS

	mov    al, TIMER_MODE
	out    TIMER_CONTROL, al
	mov    ax, [ClockRate]
	out    TIMER_0, al
	mov    al, ah
	out    TIMER_0, al

@@PaletteInt:
	cmp    vsyncPalCnt, 0
	je     @@UserInt

	push   ds

	mov    cx, vsyncPalCnt
	mov    ax, vsyncPalStart
	lds    si, vsyncPal
	mov    dx, DAC_WRITE_INDEX
	out    dx, al
	mov    dx, DAC_DATA

@@DacOutLoop:
	outsb
	outsb
	outsb
	loop	@@DacOutLoop

	pop	ds

	mov	vsyncPalCnt, 0


@@UserInt:
	cmp    [ UserVsyncSeg ], 0
	je     short @@Sim182
	cmp    [InUserHandler ], 0
	jne    short @@Sim182
	mov    [ InUserHandler ], 1
	mov    [ StackSeg ], ss
	mov    [ StackPtr ], sp
	push    ds
	pop     ss
	mov     sp, offset LocalStack
	sti
	call    dword ptr [UserVsyncHandler]
	cli
	mov	sp, [StackPtr]
	mov	ss, [StackSeg]
	mov	[InUserHandler], 0

;	SIM 18.2 Hz
@@Sim182:
	mov	ax, [_VsyncPeriod]
	add	[ClockCounter], ax
	jnc	short @@DontChainOld
	pop	es
	pop	ds
	popa
	sti

	db     0eah
	OldTimerInt    dd 0
        ; = jmp    dword ptr [OldTimerInt] Chain to old

@@DontChainOld:

; CLEAN UP AND RETURN

	mov    al, NONSPEC_EOI
	out    PIC_CMD, al

	pop    es
	pop    ds
	popa
	sti

	iret

vsyncIntHandler endp


;
	installVsyncHandler proc
;

        push    bp
	mov	bp, sp

	cmp	[_VsyncHandlerActive], TRUE
	je	short @@Return
	call	getVsyncPeriod

	mov	[_VsyncPeriod], ax
	sub	ax, INT_IN_ADVANCE
	mov	[ClockRate], ax

	mov	dx, 18
	mov	ax, 13352
	idiv	[_VsyncPeriod]
	mov	[_TicksPerSecond], ax

	mov	word ptr [_VsyncIntTicks], 0
	mov	word ptr [_VsyncIntTicks+2], 0

	cli
	mov	ax, DOS_GETVECT + TIMER_VECT
	int     21h
	mov	ax, es
	mov	word ptr cs:[OldTimerInt], bx
	mov	word ptr cs:[OldTimerInt+2], ax

	mov	[_VsyncHandlerActive], TRUE
	mov	ax, DOS_SETVECT+TIMER_VECT
	push	ds
	mov	dx, seg vsyncIntHandler
	mov	ds, dx
	mov	dx, offset vsyncIntHandler
	int	21h
	pop	ds

	mov	al, TIMER_MODE
	out	TIMER_CONTROL, al
	mov	ax, ClockRate
	out	TIMER_0, al
	mov	al, ah
	out	TIMER_0, al
	sti

@@Return:

	pop	bp

	ret

installVsyncHandler endp



;
	removeVsyncHandler proc
;

	cmp	[_VsyncHandlerActive], FALSE
	je	short @@Return

	mov     dx, word ptr cs:[OldTimerInt]
	mov     ax, word ptr cs:[OldTimerInt+2]
	push    ds
	mov     ds,ax
	mov	ax, DOS_SETVECT+TIMER_VECT	 ;Restore the old timer int
	cli
	int     21h
	pop	ds

	mov	al, TIMER_MODE			 ;Restore timer 0
	out	TIMER_CONTROL, al
	mov	al, 0
	out	TIMER_0, al
	out	TIMER_0, al
	sti

@@Return:

	ret


removeVsyncHandler endp




; WARNING:  The user vsync handler cannot use the 386 specific registers
;           (EAX,EBX,ECX,EDX,ESI,EDI,ESP,EBP,FS,GS)
;			whithout saving them first.
;                       It must not do any drawing.
;			Only 256 butes of stack is provided.
;
	setUserVsyncHandler proc c, handler_proc:dword
;

	mov	ax, word ptr [handler_proc]
	mov     dx, word ptr [handler_proc+2]
	cli
	mov	word ptr [UserVsyncHandler], ax
	mov	word ptr [UserVsyncHandler+2], dx
	sti

	ret

setUserVsyncHandler endp



;
    setVsyncDac PROC C ,   pal:dword, start:word, len:word
;

	cli

	mov	cx, start
	mov	vsyncPalStart, cx
	add	cx, start  ; st * 3
	add	cx, start

	mov	ax, word ptr pal[0]
	mov	dx, word ptr pal[2]
	add	ax, cx

	mov	word ptr vsyncPal[0], ax
	mov	word ptr vsyncPal[2], dx

	mov	ax, len
	mov	vsyncPalCnt, ax

	sti

	ret

setVsyncDac endp


end
