/*Module:g_game.c*/

SIGNED LONG startepisode;
UNSIGNED BYTE byte *demobuffer;
SIGNED LONG gameactiondata;
skill_t skilllevel;
gameaction_t gameaction;
gamestart_t gamestart;
boolean controlmenumap;
skill_t startskill;
SIGNED LONG startplayer;
gamestate_t gamestate;
SIGNED BYTE char startname[9];
SIGNED BYTE char playmap[9];

VOID G_InitPlayer( SIGNED LONG )
/*-08*/ SIGNED LONG player;
{
/*-04*/ player_t *p;

LINE:45		push    0028                
LINE:45		call    __CHK               
LINE:45		push    ebx                 
LINE:45		push    ecx                 
LINE:45		push    edx                 
LINE:45		push    esi                 
LINE:45		push    edi                 
LINE:45		push    ebp                 
LINE:45		mov     ebp,esp             
LINE:45		sub     esp,0008            
LINE:45		mov     [player],eax        

LINE:50		cmp     dword ptr [player],00004h 
LINE:50		jc      label0              

LINE:51		mov     eax,3C74 "G_InitPlayer: bad player number" 
LINE:51		push    eax                 
LINE:51		call    IO_Error_           
LINE:51		add     esp,00004h          

LINE:53:lable0		mov     eax,[_sd]           
LINE:53		add     eax,[player]        
LINE:53		mov     byte ptr [eax+00010h],001h 

LINE:54		mov     eax,[player]        
LINE:54		shl     eax,007h            
LINE:54		mov     edx,_playerobjs     
LINE:54		add     edx,eax             
LINE:54		mov     [p],edx             

LINE:55		mov     ebx,0080            
LINE:55		xor     edx,edx             
LINE:55		mov     eax,[p]             
LINE:55		call    memset_             

LINE:57		mov     eax,[p]             
LINE:57		mov     dword ptr [eax+0003Ch],0001 

LINE:58		mov     eax,[p]             
LINE:58		mov     dword ptr [eax+00040h],000F 

LINE:59		mov     ebx,0020            
LINE:59		xor     edx,edx             
LINE:59		mov     eax,[p]             
LINE:59		add     eax,00044h          
LINE:59		call    memset_             

LINE:60		mov     ebx,0014            
LINE:60		xor     edx,edx             
LINE:60		mov     eax,[p]             
LINE:60		add     eax,00064h          
LINE:60		call    memset_             

LINE:61		mov     eax,[p]             
LINE:61		mov     dword ptr [eax+00044h],0001 

LINE:62		mov     eax,[p]             
LINE:62		mov     dword ptr [eax+00048h],0001 

LINE:63		mov     eax,[p]             
LINE:63		mov     dword ptr [eax+00064h],000E 

LINE:65		mov     eax,[p]             
LINE:65		mov     dword ptr [eax+00018h],0003 

LINE:66		mov     eax,[p]             
LINE:66		mov     dword ptr [eax+0001Ch],0000 

LINE:67		mov     eax,[p]             
LINE:67		mov     dword ptr [eax+00020h],2710 

LINE:68		mov     eax,[p]             
LINE:68		mov     dword ptr [eax+00024h],000F 

LINE:69		mov     eax,[p]             
LINE:69		mov     dword ptr [eax+00028h],0007 

LINE:71		mov     ebx,000C            
LINE:71		xor     edx,edx             
LINE:71		mov     eax,[p]             
LINE:71		add     eax,00030h          
LINE:71		call    memset_             

LINE:72		mov     esp,ebp             
LINE:72		pop     ebp                 
LINE:72		pop     edi                 
LINE:72		pop     esi                 
LINE:72		pop     edx                 
LINE:72		pop     ecx                 
LINE:72		pop     ebx                 
LINE:72		ret                         
}

VOID G_WarpToMap( SIGNED BYTE char *)
/*-08*/ SIGNED BYTE char *mapname;
{
/*-04*/ SIGNED LONG i;

LINE:92		push    0030                
LINE:92		call    __CHK               
LINE:92		push    ebx                 
LINE:92		push    ecx                 
LINE:92		push    edx                 
LINE:92		push    esi                 
LINE:92		push    edi                 
LINE:92		push    ebp                 
LINE:92		mov     ebp,esp             
LINE:92		sub     esp,0008            
LINE:92		mov     [mapname],eax       

LINE:99		mov     eax,[_playzone]     
LINE:99		call    Z_ClearZone_        

LINE:100		call    P_InitThinkers_     

LINE:101		call    P_InitActors_       

LINE:102		call    M_ClearMenus_       

LINE:108		mov     ebx,0010            
LINE:108		xor     edx,edx             
LINE:108		mov     eax,_playerthingfound 
LINE:108		call    memset_             

LINE:109		mov     eax,[mapname]       
LINE:109		call    R_LoadMap_          

LINE:110		mov     dword ptr [i],0000  
LINE:110:lable2		cmp     dword ptr [i],00004h 
LINE:110		jl      label0              
LINE:110		jmp     short label1        
LINE:110:lable4		mov     eax,[i]             
LINE:110		inc     dword ptr [i]       
LINE:110		jmp     short label2        

LINE:111:lable0		mov     eax,[i]             
LINE:111		shl     eax,002h            
LINE:111		cmp     dword ptr [eax+000017268h],00000h 
LINE:111		jne     label3              

LINE:112		mov     eax,[mapname]       
LINE:112		push    eax                 
LINE:112		mov     eax,[i]             
LINE:112		push    eax                 
LINE:112		mov     eax,3C94 "G_WarpToMap: player %i not spawned on map %s" 
LINE:112		push    eax                 
LINE:112		call    IO_Error_           
LINE:112		add     esp,0000Ch          
LINE:112:lable3		jmp     short label4        

LINE:114:lable1		mov     ebx,0008            
LINE:114		mov     edx,[mapname]       
LINE:114		mov     eax,[_sd]           
LINE:114		add     eax,026C            
LINE:114		call    strncpy_            

LINE:115		mov     esp,ebp             
LINE:115		pop     ebp                 
LINE:115		pop     edi                 
LINE:115		pop     esi                 
LINE:115		pop     edx                 
LINE:115		pop     ecx                 
LINE:115		pop     ebx                 
LINE:115		ret                         
}

VOID G_PlayerDied( SIGNED LONG )
/*-04*/ SIGNED LONG player;
{

LINE:131		push    0020                
LINE:131		call    __CHK               
LINE:131		push    ebx                 
LINE:131		push    ecx                 
LINE:131		push    edx                 
LINE:131		push    esi                 
LINE:131		push    edi                 
LINE:131		push    ebp                 
LINE:131		mov     ebp,esp             
LINE:131		sub     esp,0004            
LINE:131		mov     [player],eax        

LINE:133		mov     esp,ebp             
LINE:133		pop     ebp                 
LINE:133		pop     edi                 
LINE:133		pop     esi                 
LINE:133		pop     edx                 
LINE:133		pop     ecx                 
LINE:133		pop     ebx                 
LINE:133		ret                         
}

VOID G_RecordDemo( SIGNED BYTE char *,SIGNED BYTE char *)
/*-08*/ SIGNED BYTE char *map;
/*-04*/ SIGNED BYTE char *demoname;
{

LINE:156		push    0024                
LINE:156		call    __CHK               
LINE:156		push    ebx                 
LINE:156		push    ecx                 
LINE:156		push    esi                 
LINE:156		push    edi                 
LINE:156		push    ebp                 
LINE:156		mov     ebp,esp             
LINE:156		sub     esp,0008            
LINE:156		mov     [map],eax           
LINE:156		mov     [demoname],edx      

LINE:161		xor     ebx,ebx             
LINE:161		mov     edx,0004            
LINE:161		mov     eax,0001            
LINE:161		call    G_StartNewGame_     

LINE:162		mov     dword ptr [_demoaction],0009 

LINE:163		mov     dword ptr [_gameaction],0000 

LINE:164		mov     eax,[map]           
LINE:164		call    G_WarpToMap_        

LINE:169		mov     eax,00010000        
LINE:169		call    malloc_             
LINE:169		mov     [_demobuffer],eax   

LINE:170		mov     eax,[_demobuffer]   
LINE:170		mov     [_demo_p],eax       

LINE:172		mov     ebx,0008            
LINE:172		mov     edx,[map]           
LINE:172		mov     eax,[_demo_p]       
LINE:172		call    strncpy_            

LINE:173		mov     eax,[_demo_p]       
LINE:173		add     eax,00008h          
LINE:173		mov     [_demo_p],eax       

LINE:177		mov     eax,[_demobuffer]   
LINE:177		add     eax,00010000        
LINE:177		mov     [_demoend],eax      

LINE:180		mov     dword ptr [_demo],0001 

LINE:181		call    P_Playloop_         

LINE:184		mov     eax,[_demo_p]       
LINE:184		sub     eax,[_demobuffer]   
LINE:184		mov     ebx,eax             
LINE:184		mov     edx,[_demobuffer]   
LINE:184		mov     eax,[demoname]      
LINE:184		call    D_WriteFile_        
LINE:184		test    eax,eax             
LINE:184		jne     label0              

LINE:185		mov     eax,3CC1 "Error saving demo" 
LINE:185		push    eax                 
LINE:185		call    IO_Error_           
LINE:185		add     esp,00004h          

LINE:187:lable0		mov     eax,[_demobuffer]   
LINE:187		call    free_               

LINE:188		mov     esp,ebp             
LINE:188		pop     ebp                 
LINE:188		pop     edi                 
LINE:188		pop     esi                 
LINE:188		pop     ecx                 
LINE:188		pop     ebx                 
LINE:188		ret                         
}

VOID G_PlayDemo( SIGNED BYTE char *)
/*-04*/ SIGNED BYTE char *demoname;
{

LINE:199		push    0020                
LINE:199		call    __CHK               
LINE:199		push    ebx                 
LINE:199		push    ecx                 
LINE:199		push    edx                 
LINE:199		push    esi                 
LINE:199		push    edi                 
LINE:199		push    ebp                 
LINE:199		mov     ebp,esp             
LINE:199		sub     esp,0004            
LINE:199		mov     [demoname],eax      

LINE:201		mov     edx,[demoname]      
LINE:201		mov     eax,_startname      
LINE:201		call    strcpy_             

LINE:202		mov     dword ptr [_demoaction],0008 

LINE:203		mov     dword ptr [_gamestart],0002 

LINE:204		mov     esp,ebp             
LINE:204		pop     ebp                 
LINE:204		pop     edi                 
LINE:204		pop     esi                 
LINE:204		pop     edx                 
LINE:204		pop     ecx                 
LINE:204		pop     ebx                 
LINE:204		ret                         
}

boolean G_StartSavedGame( SIGNED BYTE char *)
/*-08*/ SIGNED BYTE char *savegame;
{

LINE:214		push    0024                
LINE:214		call    __CHK               
LINE:214		push    ebx                 
LINE:214		push    ecx                 
LINE:214		push    edx                 
LINE:214		push    esi                 
LINE:214		push    edi                 
LINE:214		push    ebp                 
LINE:214		mov     ebp,esp             
LINE:214		sub     esp,0008            
LINE:214		mov     [savegame],eax      

LINE:216		mov     dword ptr [ebp-00004h],0000 

LINE:217		mov     eax,[ebp-00004h]    
LINE:217		mov     esp,ebp             
LINE:217		pop     ebp                 
LINE:217		pop     edi                 
LINE:217		pop     esi                 
LINE:217		pop     edx                 
LINE:217		pop     ecx                 
LINE:217		pop     ebx                 
LINE:217		ret                         
}

VOID G_StartNewGame( SIGNED LONG ,skill_t ,SIGNED LONG )
/*-0c*/ SIGNED LONG episode;
/*-08*/ skill_t skill;
/*-04*/ SIGNED LONG player;
{

LINE:228		push    0020                
LINE:228		call    __CHK               
LINE:228		push    ecx                 
LINE:228		push    esi                 
LINE:228		push    edi                 
LINE:228		push    ebp                 
LINE:228		mov     ebp,esp             
LINE:228		sub     esp,000C            
LINE:228		mov     [episode],eax       
LINE:228		mov     [skill],edx         
LINE:228		mov     [player],ebx        

LINE:230		mov     eax,[skill]         
LINE:230		mov     [_startskill],eax   

LINE:231		mov     eax,[episode]       
LINE:231		mov     [_startepisode],eax 

LINE:232		mov     eax,[player]        
LINE:232		mov     [_startplayer],eax  

LINE:234		mov     dword ptr [_demoaction],0008 

LINE:235		mov     dword ptr [_gamestart],0001 

LINE:236		mov     esp,ebp             
LINE:236		pop     ebp                 
LINE:236		pop     edi                 
LINE:236		pop     esi                 
LINE:236		pop     ecx                 
LINE:236		ret                         
}

VOID G_SetupNewGame( VOID )
{
/*-0c*/ SIGNED BYTE char mapname[9];

LINE:257		push    0034                
LINE:257		call    __CHK               
LINE:257		push    ebx                 
LINE:257		push    ecx                 
LINE:257		push    edx                 
LINE:257		push    esi                 
LINE:257		push    edi                 
LINE:257		push    ebp                 
LINE:257		mov     ebp,esp             
LINE:257		sub     esp,000C            

LINE:261		mov     eax,[_startskill]   
LINE:261		mov     [_skilllevel],eax   

LINE:262		mov     eax,[_sd]           
LINE:262		mov     edx,[_startplayer]  
LINE:262		mov     [eax+0000Ch],edx    

LINE:263		mov     eax,[_startplayer]  
LINE:263		mov     [_viewplayer],eax   

LINE:264		mov     dword ptr [_viewplayerangle],0000 

LINE:265		mov     ebx,0004            
LINE:265		xor     edx,edx             
LINE:265		mov     eax,[_sd]           
LINE:265		add     eax,00010h          
LINE:265		call    memset_             

LINE:266		mov     eax,[_startplayer]  
LINE:266		call    G_InitPlayer_       

LINE:267		push    dword ptr [_startepisode] 
LINE:267		mov     eax,3CD3 "E1M%d"    
LINE:267		push    eax                 
LINE:267		lea     eax,[mapname]       
LINE:267		push    eax                 
LINE:267		call    sprintf_            
LINE:267		add     esp,0000Ch          

LINE:268		lea     eax,[mapname]       
LINE:268		call    G_WarpToMap_        

LINE:270		mov     dword ptr [_gameaction],0000 

LINE:271		mov     esp,ebp             
LINE:271		pop     ebp                 
LINE:271		pop     edi                 
LINE:271		pop     esi                 
LINE:271		pop     edx                 
LINE:271		pop     ecx                 
LINE:271		pop     ebx                 
LINE:271		ret                         
}

VOID G_SetupNetGame( VOID )
{
/*-04*/ SIGNED LONG i;

LINE:282		push    0020                
LINE:282		call    __CHK               
LINE:282		push    ebx                 
LINE:282		push    ecx                 
LINE:282		push    edx                 
LINE:282		push    esi                 
LINE:282		push    edi                 
LINE:282		push    ebp                 
LINE:282		mov     ebp,esp             
LINE:282		sub     esp,0004            

LINE:286		mov     dword ptr [_skilllevel],0004 

LINE:287		mov     eax,[_sd]           
LINE:287		mov     eax,[eax+0000Ch]    
LINE:287		mov     [_viewplayer],eax   

LINE:288		mov     dword ptr [_viewplayerangle],0000 

LINE:290		mov     dword ptr [i],0000  
LINE:290:lable2		cmp     dword ptr [i],00004h 
LINE:290		jl      label0              
LINE:290		jmp     short label1        
LINE:290:lable4		mov     eax,[i]             
LINE:290		inc     dword ptr [i]       
LINE:290		jmp     short label2        

LINE:291:lable0		mov     eax,[_sd]           
LINE:291		add     eax,[i]             
LINE:291		cmp     byte ptr [eax+00010h],000h 
LINE:291		je      label3              

LINE:292		mov     eax,[i]             
LINE:292		call    G_InitPlayer_       
LINE:292:lable3		jmp     short label4        

LINE:294:lable1		mov     eax,[_sd]           
LINE:294		add     eax,026C            
LINE:294		call    G_WarpToMap_        

LINE:295		mov     dword ptr [_gameaction],0000 

LINE:296		mov     dword ptr [_demoaction],0009 

LINE:297		mov     esp,ebp             
LINE:297		pop     ebp                 
LINE:297		pop     edi                 
LINE:297		pop     esi                 
LINE:297		pop     edx                 
LINE:297		pop     ecx                 
LINE:297		pop     ebx                 
LINE:297		ret                         
}

VOID G_SetupControls( VOID )
{

LINE:310		push    001C                
LINE:310		call    __CHK               
LINE:310		push    ebx                 
LINE:310		push    ecx                 
LINE:310		push    edx                 
LINE:310		push    esi                 
LINE:310		push    edi                 
LINE:310		push    ebp                 
LINE:310		mov     ebp,esp             
LINE:310		sub     esp,0000            

LINE:315		mov     ebx,0004            
LINE:315		xor     edx,edx             
LINE:315		mov     eax,[_sd]           
LINE:315		add     eax,00010h          
LINE:315		call    memset_             

LINE:316		xor     eax,eax             
LINE:316		call    G_InitPlayer_       

LINE:321		mov     eax,3CD9 "menumap"  
LINE:321		call    G_WarpToMap_        

LINE:326		call    M_StartControlPanel_ 

LINE:331		mov     dword ptr [_controlmenumap],0001 

LINE:332		call    P_Playloop_         

LINE:333		mov     dword ptr [_controlmenumap],0000 

LINE:334		pop     ebp                 
LINE:334		pop     edi                 
LINE:334		pop     esi                 
LINE:334		pop     edx                 
LINE:334		pop     ecx                 
LINE:334		pop     ebx                 
LINE:334		ret                         
}

VOID G_SetupDemo( VOID )
{
/*-04*/ SIGNED LONG lump;

LINE:346		push    0020                
LINE:346		call    __CHK               
LINE:346		push    ebx                 
LINE:346		push    ecx                 
LINE:346		push    edx                 
LINE:346		push    esi                 
LINE:346		push    edi                 
LINE:346		push    ebp                 
LINE:346		mov     ebp,esp             
LINE:346		sub     esp,0004            

LINE:350		mov     dword ptr [_startskill],0004 

LINE:351		mov     dword ptr [_startepisode],0001 

LINE:352		mov     dword ptr [_startplayer],0000 

LINE:353		call    G_SetupNewGame_     

LINE:357		mov     eax,_startname      
LINE:357		call    W_GetNumForName_    
LINE:357		mov     [lump],eax          

LINE:358		mov     edx,[lump]          
LINE:358		shl     edx,004h            
LINE:358		mov     eax,[_lumpinfo]     
LINE:358		add     eax,edx             
LINE:358		mov     eax,[eax]           
LINE:358		mov     [_demobuffer],eax   

LINE:359		mov     eax,[_demobuffer]   
LINE:359		mov     [_demo_p],eax       

LINE:360		mov     eax,[_demo_p]       
LINE:360		call    G_WarpToMap_        

LINE:361		mov     eax,[_demo_p]       
LINE:361		add     eax,00008h          
LINE:361		mov     [_demo_p],eax       

LINE:365		mov     eax,[lump]          
LINE:365		shl     eax,004h            
LINE:365		mov     edx,[_lumpinfo]     
LINE:365		add     eax,edx             
LINE:365		mov     edx,[_demobuffer]   
LINE:365		mov     eax,[eax+00004h]    
LINE:365		add     edx,eax             
LINE:365		mov     [_demoend],edx      

LINE:366		mov     dword ptr [_demo],0002 

LINE:369		call    P_Playloop_         

LINE:370		mov     dword ptr [_demo],0000 

LINE:371		mov     esp,ebp             
LINE:371		pop     ebp                 
LINE:371		pop     edi                 
LINE:371		pop     esi                 
LINE:371		pop     edx                 
LINE:371		pop     ecx                 
LINE:371		pop     ebx                 
LINE:371		ret                         
}

VOID G_GameLoop( VOID )
{

LINE:390		push    0024                
LINE:390		call    __CHK               
LINE:390		push    ebx                 
LINE:390		push    ecx                 
LINE:390		push    edx                 
LINE:390		push    esi                 
LINE:390		push    edi                 
LINE:390		push    ebp                 
LINE:390		mov     ebp,esp             
LINE:390		sub     esp,0004            
LINE:390		jmp     short label0        
LINE:390		nop                         
LINE:390		cmp     al,0ECh             
LINE:390		add     [eax],al            
LINE:390		inc     esi                 
LINE:390		in      al,dx               
LINE:390		add     [eax],al            
LINE:390		push    esp                 
LINE:390		in      al,dx               
LINE:390		add     [eax],al            
LINE:390		pop     esi                 
LINE:390		in      al,dx               
LINE:390		add     [eax],al            
LINE:390		pop     esi                 
LINE:390		in      al,dx               
LINE:390		add     [eax],al            
LINE:390		dec     ebp                 
LINE:390		in      al,dx               
LINE:390		add     [eax],al            

LINE:392:lable0		mov     dword ptr [_demoaction],0009 

LINE:396		cmp     dword ptr [_gamestart],00005h 
LINE:396		ja      label1              
LINE:396		mov     eax,[_gamestart]    
LINE:396		shl     eax,002h            
LINE:396		jmp     near dword ptr cs:[eax+00000EC02h] 

LINE:399		call    G_SetupControls_    
LINE:399		jmp     label2              

LINE:403		call    G_SetupNewGame_     
LINE:403		jmp     short label1        

LINE:407		call    G_SetupNewGame_     
LINE:407		jmp     short label1        

LINE:411		call    G_SetupDemo_        
LINE:411		jmp     label2              

LINE:422:lable1		cmp     dword ptr [_demoaction],00009h 
LINE:422		jne     label2              

LINE:424		mov     eax,[_gameaction]   
LINE:424		mov     [ebp-00004h],eax    
LINE:424		cmp     dword ptr [ebp-00004h],00002h 
LINE:424		jc      label3              
LINE:424		cmp     dword ptr [ebp-00004h],00002h 
LINE:424		jbe     label4              
LINE:424		cmp     dword ptr [ebp-00004h],00003h 
LINE:424		je      label5              
LINE:424		jmp     short label6        
LINE:424:lable3		cmp     dword ptr [ebp-00004h],00000h 
LINE:424		jne     label6              

LINE:427		call    P_Playloop_         
LINE:427		jmp     short label7        

LINE:430:lable4		call    G_WorldMap_         
LINE:430		jmp     short label7        

LINE:433:lable5		xor     eax,eax             
LINE:433		call    G_InitPlayer_       

LINE:434		call    G_WorldMap_         
LINE:434		jmp     short label7        

LINE:437:lable6		mov     eax,3CE1 "G_GameLoop: unknown gameaction" 
LINE:437		push    eax                 
LINE:437		call    IO_Error_           
LINE:437		add     esp,00004h          

LINE:439:lable7		call    D_FadeOut_          
LINE:439		jmp     short label1        

LINE:441:lable2		mov     esp,ebp             
LINE:441		pop     ebp                 
LINE:441		pop     edi                 
LINE:441		pop     esi                 
LINE:441		pop     edx                 
LINE:441		pop     ecx                 
LINE:441		pop     ebx                 
LINE:441		ret                         
}
