/*Module:m_menu.c*/

struct menu_s menu_t *currentMenu;
SIGNED LONG stringy;
SIGNED LONG stringx;
SIGNED LONG mouseSensitivity;
SIGNED LONG soundVolume;
newgame_e;
font_t *hudfont;
display_e;
SIGNED LONG joystickType;
huinput_t huinput;
options_e;
controls_e;
main_e;
VOID keycallback( SIGNED LONG )
*;
VOID stringcallback( SIGNED LONG )
*;
SIGNED LONG maxwidth;
SIGNED LONG validwidth;
SIGNED WORD itemOn;
SIGNED WORD whichSkull;
SIGNED WORD scrollIndex;
SIGNED WORD menuDisplayed;
SIGNED WORD skullAnimCounter;
struct menu_s menu_t MainDef;
struct menu_s menu_t NewDef;
struct menu_s menu_t OptionsDef;
struct menu_s menu_t ControlsDef;
struct menu_s menu_t DisplayDef;
menuitem_t MainMenu[5];
menuitem_t NewGameMenu[4];
menuitem_t OptionsMenu[5];
menuitem_t ControlsMenu[7];
menuitem_t DisplayMenu[8];
SIGNED BYTE char skullName[8][2];
SIGNED BYTE char joyTypeNames[10][2];
SIGNED BYTE char inputstring[80];

VOID M_DrawMainMenu( VOID )
{

LINE:347		push    001C                
LINE:347		call    __CHK               
LINE:347		push    ebx                 
LINE:347		push    ecx                 
LINE:347		push    edx                 
LINE:347		push    esi                 
LINE:347		push    edi                 
LINE:347		push    ebp                 
LINE:347		mov     ebp,esp             
LINE:347		sub     esp,0000            

LINE:349		mov     eax,3E74 "M_DOOM"   
LINE:349		call    W_GetName_          
LINE:349		mov     ebx,eax             
LINE:349		mov     edx,0002            
LINE:349		mov     eax,005E            
LINE:349		call    V_DrawPatch_        

LINE:350		pop     ebp                 
LINE:350		pop     edi                 
LINE:350		pop     esi                 
LINE:350		pop     edx                 
LINE:350		pop     ecx                 
LINE:350		pop     ebx                 
LINE:350		ret                         
}

VOID M_DrawNewGame( VOID )
{

LINE:357		push    001C                
LINE:357		call    __CHK               
LINE:357		push    ebx                 
LINE:357		push    ecx                 
LINE:357		push    edx                 
LINE:357		push    esi                 
LINE:357		push    edi                 
LINE:357		push    ebp                 
LINE:357		mov     ebp,esp             
LINE:357		sub     esp,0000            

LINE:359		mov     eax,3E7B "M_NEWG"   
LINE:359		call    W_GetName_          
LINE:359		mov     ebx,eax             
LINE:359		mov     edx,000E            
LINE:359		mov     eax,0060            
LINE:359		call    V_DrawPatch_        

LINE:360		mov     eax,3E82 "M_SKILL"  
LINE:360		call    W_GetName_          
LINE:360		mov     ebx,eax             
LINE:360		mov     edx,0026            
LINE:360		mov     eax,0036            
LINE:360		call    V_DrawPatch_        

LINE:361		pop     ebp                 
LINE:361		pop     edi                 
LINE:361		pop     esi                 
LINE:361		pop     edx                 
LINE:361		pop     ecx                 
LINE:361		pop     ebx                 
LINE:361		ret                         
}

VOID M_NewGame( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:363		push    0020                
LINE:363		call    __CHK               
LINE:363		push    ebx                 
LINE:363		push    ecx                 
LINE:363		push    edx                 
LINE:363		push    esi                 
LINE:363		push    edi                 
LINE:363		push    ebp                 
LINE:363		mov     ebp,esp             
LINE:363		sub     esp,0004            
LINE:363		mov     [choice],eax        

LINE:365		mov     eax,_NewDef         
LINE:365		call    M_SetupNextMenu_    

LINE:366		mov     esp,ebp             
LINE:366		pop     ebp                 
LINE:366		pop     edi                 
LINE:366		pop     esi                 
LINE:366		pop     edx                 
LINE:366		pop     ecx                 
LINE:366		pop     ebx                 
LINE:366		ret                         
}

VOID M_StartGame( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:373		push    0020                
LINE:373		call    __CHK               
LINE:373		push    ebx                 
LINE:373		push    ecx                 
LINE:373		push    edx                 
LINE:373		push    esi                 
LINE:373		push    edi                 
LINE:373		push    ebp                 
LINE:373		mov     ebp,esp             
LINE:373		sub     esp,0004            
LINE:373		mov     [choice],eax        

LINE:375		xor     ebx,ebx             
LINE:375		mov     edx,[choice]        
LINE:375		mov     eax,0001            
LINE:375		call    G_StartNewGame_     

LINE:376		mov     esp,ebp             
LINE:376		pop     ebp                 
LINE:376		pop     edi                 
LINE:376		pop     esi                 
LINE:376		pop     edx                 
LINE:376		pop     ecx                 
LINE:376		pop     ebx                 
LINE:376		ret                         
}

VOID M_DrawOptions( VOID )
{

LINE:385		push    001C                
LINE:385		call    __CHK               
LINE:385		push    ebx                 
LINE:385		push    ecx                 
LINE:385		push    edx                 
LINE:385		push    esi                 
LINE:385		push    edi                 
LINE:385		push    ebp                 
LINE:385		mov     ebp,esp             
LINE:385		sub     esp,0000            

LINE:387		mov     eax,3E8A "M_OPTTTL" 
LINE:387		call    W_GetName_          
LINE:387		mov     ebx,eax             
LINE:387		mov     edx,0005            
LINE:387		mov     eax,006C            
LINE:387		call    V_DrawPatch_        

LINE:388		mov     ecx,[_soundVolume]  
LINE:388		mov     ebx,0010            
LINE:388		movsx   eax,[1CA4]          
LINE:388		lea     edx,[eax+00050h]    
LINE:388		movsx   eax,[1CA2]          
LINE:388		call    M_DrawThermo_       

LINE:390		pop     ebp                 
LINE:390		pop     edi                 
LINE:390		pop     esi                 
LINE:390		pop     edx                 
LINE:390		pop     ecx                 
LINE:390		pop     ebx                 
LINE:390		ret                         
}

VOID M_ChangeVolume( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:392		push    0020                
LINE:392		call    __CHK               
LINE:392		push    ebx                 
LINE:392		push    ecx                 
LINE:392		push    edx                 
LINE:392		push    esi                 
LINE:392		push    edi                 
LINE:392		push    ebp                 
LINE:392		mov     ebp,esp             
LINE:392		sub     esp,0004            
LINE:392		mov     [choice],eax        

LINE:394		cmp     dword ptr [choice],00000h 
LINE:394		jbe     label0              
LINE:394		cmp     dword ptr [choice],00001h 
LINE:394		je      label1              
LINE:394		jmp     short label2        
LINE:394		jmp     short label2        

LINE:397:lable0		cmp     dword ptr [_soundVolume],00000h 
LINE:397		je      label3              

LINE:398		dec     dword ptr [_soundVolume] 
LINE:398:lable3		jmp     short label2        

LINE:401:lable1		cmp     dword ptr [_soundVolume],0000Fh 
LINE:401		jge     label2              

LINE:402		inc     dword ptr [_soundVolume] 

LINE:405:lable2		mov     esp,ebp             
LINE:405		pop     ebp                 
LINE:405		pop     edi                 
LINE:405		pop     esi                 
LINE:405		pop     edx                 
LINE:405		pop     ecx                 
LINE:405		pop     ebx                 
LINE:405		ret                         
}

VOID M_Options( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:407		push    0020                
LINE:407		call    __CHK               
LINE:407		push    ebx                 
LINE:407		push    ecx                 
LINE:407		push    edx                 
LINE:407		push    esi                 
LINE:407		push    edi                 
LINE:407		push    ebp                 
LINE:407		mov     ebp,esp             
LINE:407		sub     esp,0004            
LINE:407		mov     [choice],eax        

LINE:409		mov     eax,_OptionsDef     
LINE:409		call    M_SetupNextMenu_    

LINE:410		mov     esp,ebp             
LINE:410		pop     ebp                 
LINE:410		pop     edi                 
LINE:410		pop     esi                 
LINE:410		pop     edx                 
LINE:410		pop     ecx                 
LINE:410		pop     ebx                 
LINE:410		ret                         
}

VOID M_EndGame( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:417		push    0020                
LINE:417		call    __CHK               
LINE:417		push    ebx                 
LINE:417		push    ecx                 
LINE:417		push    edx                 
LINE:417		push    esi                 
LINE:417		push    edi                 
LINE:417		push    ebp                 
LINE:417		mov     ebp,esp             
LINE:417		sub     esp,0004            
LINE:417		mov     [choice],eax        

LINE:419		mov     esp,ebp             
LINE:419		pop     ebp                 
LINE:419		pop     edi                 
LINE:419		pop     esi                 
LINE:419		pop     edx                 
LINE:419		pop     ecx                 
LINE:419		pop     ebx                 
LINE:419		ret                         
}

VOID M_ReadThis( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:426		push    0020                
LINE:426		call    __CHK               
LINE:426		push    ebx                 
LINE:426		push    ecx                 
LINE:426		push    edx                 
LINE:426		push    esi                 
LINE:426		push    edi                 
LINE:426		push    ebp                 
LINE:426		mov     ebp,esp             
LINE:426		sub     esp,0004            
LINE:426		mov     [choice],eax        

LINE:428		mov     esp,ebp             
LINE:428		pop     ebp                 
LINE:428		pop     edi                 
LINE:428		pop     esi                 
LINE:428		pop     edx                 
LINE:428		pop     ecx                 
LINE:428		pop     ebx                 
LINE:428		ret                         
}

VOID M_QuitDOOM( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:435		push    0020                
LINE:435		call    __CHK               
LINE:435		push    ebx                 
LINE:435		push    ecx                 
LINE:435		push    edx                 
LINE:435		push    esi                 
LINE:435		push    edi                 
LINE:435		push    ebp                 
LINE:435		mov     ebp,esp             
LINE:435		sub     esp,0004            
LINE:435		mov     [choice],eax        

LINE:437		call    IO_Quit_            

LINE:438		mov     esp,ebp             
LINE:438		pop     ebp                 
LINE:438		pop     edi                 
LINE:438		pop     esi                 
LINE:438		pop     edx                 
LINE:438		pop     ecx                 
LINE:438		pop     ebx                 
LINE:438		ret                         
}

VOID M_DrawControls( VOID )
{

LINE:449		push    001C                
LINE:449		call    __CHK               
LINE:449		push    ebx                 
LINE:449		push    ecx                 
LINE:449		push    edx                 
LINE:449		push    esi                 
LINE:449		push    edi                 
LINE:449		push    ebp                 
LINE:449		mov     ebp,esp             
LINE:449		sub     esp,0000            

LINE:451		mov     eax,3E93 "M_CTRLS"  
LINE:451		call    W_GetName_          
LINE:451		mov     ebx,eax             
LINE:451		mov     edx,0005            
LINE:451		mov     eax,0064            
LINE:451		call    V_DrawPatch_        

LINE:453		xor     edx,edx             
LINE:453		mov     eax,_ControlsDef    
LINE:453		call    M_DrawEmptyCell_    

LINE:454		mov     edx,0001            
LINE:454		mov     eax,_ControlsDef    
LINE:454		call    M_DrawEmptyCell_    

LINE:455		mov     edx,0002            
LINE:455		mov     eax,_ControlsDef    
LINE:455		call    M_DrawEmptyCell_    

LINE:456		mov     edx,0003            
LINE:456		mov     eax,_ControlsDef    
LINE:456		call    M_DrawEmptyCell_    

LINE:458		imul    edx,[_joystickType],00Ah 
LINE:458		mov     eax,_joyTypeNames   
LINE:458		add     eax,edx             
LINE:458		call    W_GetName_          
LINE:458		mov     ebx,eax             
LINE:458		movsx   edx,[1D2C]          
LINE:458		add     edx,00053h          
LINE:458		movsx   eax,[1D2A]          
LINE:458		add     eax,00AA            
LINE:458		call    V_DrawPatch_        

LINE:460		mov     ecx,[_mouseSensitivity] 
LINE:460		mov     ebx,000A            
LINE:460		movsx   eax,[1D2C]          
LINE:460		lea     edx,[eax+00070h]    
LINE:460		movsx   eax,[1D2A]          
LINE:460		call    M_DrawThermo_       

LINE:462		pop     ebp                 
LINE:462		pop     edi                 
LINE:462		pop     esi                 
LINE:462		pop     edx                 
LINE:462		pop     ecx                 
LINE:462		pop     ebx                 
LINE:462		ret                         
}

VOID M_ChangeJoyType( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:464		push    0020                
LINE:464		call    __CHK               
LINE:464		push    ebx                 
LINE:464		push    ecx                 
LINE:464		push    edx                 
LINE:464		push    esi                 
LINE:464		push    edi                 
LINE:464		push    ebp                 
LINE:464		mov     ebp,esp             
LINE:464		sub     esp,0004            
LINE:464		mov     [choice],eax        

LINE:466		xor     byte ptr [_joystickType],001h 

LINE:467		mov     esp,ebp             
LINE:467		pop     ebp                 
LINE:467		pop     edi                 
LINE:467		pop     esi                 
LINE:467		pop     edx                 
LINE:467		pop     ecx                 
LINE:467		pop     ebx                 
LINE:467		ret                         
}

VOID M_ChangeSensitivity( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:469		push    0020                
LINE:469		call    __CHK               
LINE:469		push    ebx                 
LINE:469		push    ecx                 
LINE:469		push    edx                 
LINE:469		push    esi                 
LINE:469		push    edi                 
LINE:469		push    ebp                 
LINE:469		mov     ebp,esp             
LINE:469		sub     esp,0004            
LINE:469		mov     [choice],eax        

LINE:471		cmp     dword ptr [choice],00000h 
LINE:471		jbe     label0              
LINE:471		cmp     dword ptr [choice],00001h 
LINE:471		je      label1              
LINE:471		jmp     short label2        
LINE:471		jmp     short label2        

LINE:474:lable0		cmp     dword ptr [_mouseSensitivity],00000h 
LINE:474		je      label3              

LINE:475		dec     dword ptr [_mouseSensitivity] 
LINE:475:lable3		jmp     short label2        

LINE:478:lable1		cmp     dword ptr [_mouseSensitivity],00009h 
LINE:478		jge     label2              

LINE:479		inc     dword ptr [_mouseSensitivity] 

LINE:482:lable2		mov     esp,ebp             
LINE:482		pop     ebp                 
LINE:482		pop     edi                 
LINE:482		pop     esi                 
LINE:482		pop     edx                 
LINE:482		pop     ecx                 
LINE:482		pop     ebx                 
LINE:482		ret                         
}

VOID M_Controls( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:484		push    0020                
LINE:484		call    __CHK               
LINE:484		push    ebx                 
LINE:484		push    ecx                 
LINE:484		push    edx                 
LINE:484		push    esi                 
LINE:484		push    edi                 
LINE:484		push    ebp                 
LINE:484		mov     ebp,esp             
LINE:484		sub     esp,0004            
LINE:484		mov     [choice],eax        

LINE:486		mov     eax,_ControlsDef    
LINE:486		call    M_SetupNextMenu_    

LINE:487		mov     esp,ebp             
LINE:487		pop     ebp                 
LINE:487		pop     edi                 
LINE:487		pop     esi                 
LINE:487		pop     edx                 
LINE:487		pop     ecx                 
LINE:487		pop     ebx                 
LINE:487		ret                         
}

VOID M_DrawDisplay( VOID )
{

LINE:494		push    001C                
LINE:494		call    __CHK               
LINE:494		push    ebx                 
LINE:494		push    ecx                 
LINE:494		push    edx                 
LINE:494		push    esi                 
LINE:494		push    edi                 
LINE:494		push    ebp                 
LINE:494		mov     ebp,esp             
LINE:494		sub     esp,0000            

LINE:496		mov     eax,3E9B "M_DISOPT" 
LINE:496		call    W_GetName_          
LINE:496		mov     ebx,eax             
LINE:496		mov     edx,0002            
LINE:496		mov     eax,0034            
LINE:496		call    V_DrawPatch_        

LINE:498		mov     edx,0001            
LINE:498		mov     eax,_DisplayDef     
LINE:498		call    M_DrawEmptyCell_    

LINE:499		mov     edx,0002            
LINE:499		mov     eax,_DisplayDef     
LINE:499		call    M_DrawEmptyCell_    

LINE:500		mov     edx,0003            
LINE:500		mov     eax,_DisplayDef     
LINE:500		call    M_DrawEmptyCell_    

LINE:501		mov     edx,0004            
LINE:501		mov     eax,_DisplayDef     
LINE:501		call    M_DrawEmptyCell_    

LINE:502		mov     edx,0005            
LINE:502		mov     eax,_DisplayDef     
LINE:502		call    M_DrawEmptyCell_    

LINE:504		mov     edx,[_currentdetail] 
LINE:504		inc     edx                 
LINE:504		mov     eax,_DisplayDef     
LINE:504		call    M_DrawSelCell_      

LINE:505		mov     ecx,[_screenblocks] 
LINE:505		dec     ecx                 
LINE:505		mov     ebx,000B            
LINE:505		movsx   edx,[1DC4]          
LINE:505		add     edx,0080            
LINE:505		movsx   eax,[1DC2]          
LINE:505		call    M_DrawThermo_       

LINE:507		pop     ebp                 
LINE:507		pop     edi                 
LINE:507		pop     esi                 
LINE:507		pop     edx                 
LINE:507		pop     ecx                 
LINE:507		pop     ebx                 
LINE:507		ret                         
}

VOID M_ChangeDisplay( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:509		push    0020                
LINE:509		call    __CHK               
LINE:509		push    ebx                 
LINE:509		push    ecx                 
LINE:509		push    edx                 
LINE:509		push    esi                 
LINE:509		push    edi                 
LINE:509		push    ebp                 
LINE:509		mov     ebp,esp             
LINE:509		sub     esp,0004            
LINE:509		mov     [choice],eax        

LINE:511		mov     eax,[choice]        
LINE:511		dec     eax                 
LINE:511		call    R_SetDetail_        

LINE:512		mov     esp,ebp             
LINE:512		pop     ebp                 
LINE:512		pop     edi                 
LINE:512		pop     esi                 
LINE:512		pop     edx                 
LINE:512		pop     ecx                 
LINE:512		pop     ebx                 
LINE:512		ret                         
}

VOID M_SizeDisplay( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:514		push    0020                
LINE:514		call    __CHK               
LINE:514		push    ebx                 
LINE:514		push    ecx                 
LINE:514		push    edx                 
LINE:514		push    esi                 
LINE:514		push    edi                 
LINE:514		push    ebp                 
LINE:514		mov     ebp,esp             
LINE:514		sub     esp,0004            
LINE:514		mov     [choice],eax        

LINE:516		cmp     dword ptr [choice],00000h 
LINE:516		jbe     label0              
LINE:516		cmp     dword ptr [choice],00001h 
LINE:516		je      label1              
LINE:516		jmp     short label2        
LINE:516		jmp     short label2        

LINE:519:lable0		cmp     dword ptr [_screenblocks],00000h 
LINE:519		jle     label3              

LINE:520		call    R_SizeDown_         
LINE:520:lable3		jmp     short label2        

LINE:523:lable1		cmp     dword ptr [_screenblocks],0000Bh 
LINE:523		jge     label2              

LINE:524		call    R_SizeUp_           

LINE:527:lable2		mov     esp,ebp             
LINE:527		pop     ebp                 
LINE:527		pop     edi                 
LINE:527		pop     esi                 
LINE:527		pop     edx                 
LINE:527		pop     ecx                 
LINE:527		pop     ebx                 
LINE:527		ret                         
}

VOID M_Display( SIGNED LONG )
/*-04*/ SIGNED LONG choice;
{

LINE:529		push    0020                
LINE:529		call    __CHK               
LINE:529		push    ebx                 
LINE:529		push    ecx                 
LINE:529		push    edx                 
LINE:529		push    esi                 
LINE:529		push    edi                 
LINE:529		push    ebp                 
LINE:529		mov     ebp,esp             
LINE:529		sub     esp,0004            
LINE:529		mov     [choice],eax        

LINE:531		mov     eax,_DisplayDef     
LINE:531		call    M_SetupNextMenu_    

LINE:532		mov     esp,ebp             
LINE:532		pop     ebp                 
LINE:532		pop     edi                 
LINE:532		pop     esi                 
LINE:532		pop     edx                 
LINE:532		pop     ecx                 
LINE:532		pop     ebx                 
LINE:532		ret                         
}

VOID M_DrawThermo( SIGNED LONG ,SIGNED LONG ,SIGNED LONG ,SIGNED LONG )
/*-18*/ SIGNED LONG x;
/*-14*/ SIGNED LONG y;
/*-10*/ SIGNED LONG thermWidth;
/*-0c*/ SIGNED LONG thermDot;
{
/*-08*/ SIGNED LONG i;
/*-04*/ SIGNED LONG xx;

LINE:542		push    0028                
LINE:542		call    __CHK               
LINE:542		push    esi                 
LINE:542		push    edi                 
LINE:542		push    ebp                 
LINE:542		mov     ebp,esp             
LINE:542		sub     esp,0018            
LINE:542		mov     [x],eax             
LINE:542		mov     [y],edx             
LINE:542		mov     [thermWidth],ebx    
LINE:542		mov     [thermDot],ecx      

LINE:546		mov     eax,[x]             
LINE:546		mov     [xx],eax            

LINE:547		mov     eax,3EA4 "M_THERML" 
LINE:547		call    W_GetName_          
LINE:547		mov     ebx,eax             
LINE:547		mov     edx,[y]             
LINE:547		mov     eax,[xx]            
LINE:547		call    V_DrawPatch_        

LINE:548		add     dword ptr [xx],00008h 

LINE:549		mov     dword ptr [i],0000  
LINE:549:lable2		mov     eax,[i]             
LINE:549		cmp     eax,[thermWidth]    
LINE:549		jl      label0              
LINE:549		jmp     short label1        
LINE:549:lable3		mov     eax,[i]             
LINE:549		inc     dword ptr [i]       
LINE:549		jmp     short label2        

LINE:551:lable0		mov     eax,3EAD "M_THERMM" 
LINE:551		call    W_GetName_          
LINE:551		mov     ebx,eax             
LINE:551		mov     edx,[y]             
LINE:551		mov     eax,[xx]            
LINE:551		call    V_DrawPatch_        

LINE:552		add     dword ptr [xx],00008h 
LINE:552		jmp     short label3        

LINE:554:lable1		mov     eax,3EB6 "M_THERMR" 
LINE:554		call    W_GetName_          
LINE:554		mov     ebx,eax             
LINE:554		mov     edx,[y]             
LINE:554		mov     eax,[xx]            
LINE:554		call    V_DrawPatch_        

LINE:556		mov     eax,3EBF "M_THERMO" 
LINE:556		call    W_GetName_          
LINE:556		mov     ebx,eax             
LINE:556		mov     edx,[y]             
LINE:556		mov     eax,[thermDot]      
LINE:556		shl     eax,003h            
LINE:556		mov     ecx,[x]             
LINE:556		add     ecx,00008h          
LINE:556		add     eax,ecx             
LINE:556		call    V_DrawPatch_        

LINE:557		mov     esp,ebp             
LINE:557		pop     ebp                 
LINE:557		pop     edi                 
LINE:557		pop     esi                 
LINE:557		ret                         
}

VOID M_DrawEmptyCell( struct menu_s menu_t *,SIGNED LONG )
/*-08*/ struct menu_s menu_t *menu;
/*-04*/ SIGNED LONG item;
{

LINE:559		push    0020                
LINE:559		call    __CHK               
LINE:559		push    ebx                 
LINE:559		push    ecx                 
LINE:559		push    esi                 
LINE:559		push    edi                 
LINE:559		push    ebp                 
LINE:559		mov     ebp,esp             
LINE:559		sub     esp,0008            
LINE:559		mov     [menu],eax          
LINE:559		mov     [item],edx          

LINE:561		mov     eax,3EC8 "M_CELL1"  
LINE:561		call    W_GetName_          
LINE:561		mov     ebx,eax             
LINE:561		mov     eax,[menu]          
LINE:561		movsx   eax,[eax+00010h]    
LINE:561		mov     edx,[item]          
LINE:561		shl     edx,004h            
LINE:561		add     edx,eax             
LINE:561		dec     edx                 
LINE:561		mov     eax,[menu]          
LINE:561		movsx   eax,[eax+0000Eh]    
LINE:561		sub     eax,0000Ah          
LINE:561		call    V_DrawPatch_        

LINE:564		mov     esp,ebp             
LINE:564		pop     ebp                 
LINE:564		pop     edi                 
LINE:564		pop     esi                 
LINE:564		pop     ecx                 
LINE:564		pop     ebx                 
LINE:564		ret                         
}

VOID M_DrawSelCell( struct menu_s menu_t *,SIGNED LONG )
/*-08*/ struct menu_s menu_t *menu;
/*-04*/ SIGNED LONG item;
{

LINE:566		push    0020                
LINE:566		call    __CHK               
LINE:566		push    ebx                 
LINE:566		push    ecx                 
LINE:566		push    esi                 
LINE:566		push    edi                 
LINE:566		push    ebp                 
LINE:566		mov     ebp,esp             
LINE:566		sub     esp,0008            
LINE:566		mov     [menu],eax          
LINE:566		mov     [item],edx          

LINE:568		mov     eax,3ED0 "M_CELL2"  
LINE:568		call    W_GetName_          
LINE:568		mov     ebx,eax             
LINE:568		mov     eax,[menu]          
LINE:568		movsx   eax,[eax+00010h]    
LINE:568		mov     edx,[item]          
LINE:568		shl     edx,004h            
LINE:568		add     edx,eax             
LINE:568		dec     edx                 
LINE:568		mov     eax,[menu]          
LINE:568		movsx   eax,[eax+0000Eh]    
LINE:568		sub     eax,0000Ah          
LINE:568		call    V_DrawPatch_        

LINE:571		mov     esp,ebp             
LINE:571		pop     ebp                 
LINE:571		pop     edi                 
LINE:571		pop     esi                 
LINE:571		pop     ecx                 
LINE:571		pop     ebx                 
LINE:571		ret                         
}

VOID M_InputKey( VOID ( SIGNED LONG )
*)
/*-04*/ VOID callback( SIGNED LONG )
*;

LINE:601		push    0020                
LINE:601		call    __CHK               
LINE:601		push    ebx                 
LINE:601		push    ecx                 
LINE:601		push    edx                 
LINE:601		push    esi                 
LINE:601		push    edi                 
LINE:601		push    ebp                 
LINE:601		mov     ebp,esp             
LINE:601		sub     esp,0004            
LINE:601		mov     [callback],eax      

LINE:603		mov     dword ptr [_huinput],0000 

LINE:604		mov     eax,[callback]      
LINE:604		mov     [_keycallback],eax  

LINE:605		mov     esp,ebp             
LINE:605		pop     ebp                 
LINE:605		pop     edi                 
LINE:605		pop     esi                 
LINE:605		pop     edx                 
LINE:605		pop     ecx                 
LINE:605		pop     ebx                 
LINE:605		ret                         
}

VOID M_InputString( SIGNED LONG ,SIGNED LONG ,SIGNED LONG ,VOID ( SIGNED LONG )
*)
/*-10*/ SIGNED LONG sx;
{
/*-0c*/ SIGNED LONG sy;
/*-08*/ SIGNED LONG maxchars;
/*-04*/ VOID callback( SIGNED LONG )
*;

LINE:628		push    0020                
LINE:628		call    __CHK               
LINE:628		push    esi                 
LINE:628		push    edi                 
LINE:628		push    ebp                 
LINE:628		mov     ebp,esp             
LINE:628		sub     esp,0010            
LINE:628		mov     [sx],eax            
LINE:628		mov     [sy],edx            
LINE:628		mov     [maxchars],ebx      
LINE:628		mov     [callback],ecx      

LINE:630		mov     dword ptr [_huinput],0001 

LINE:631		mov     eax,[sx]            
LINE:631		mov     [_stringx],eax      

LINE:632		mov     eax,[sy]            
LINE:632		mov     [_stringy],eax      

LINE:633		mov     eax,[maxchars]      
LINE:633		mov     [_maxwidth],eax     

LINE:634		mov     ebx,0050            
LINE:634		xor     edx,edx             
LINE:634		mov     eax,_inputstring    
LINE:634		call    memset_             

LINE:635		mov     eax,[callback]      
LINE:635		mov     [_stringcallback],eax 

LINE:636		mov     dword ptr [_validwidth],0000 

LINE:637		mov     esp,ebp             
LINE:637		pop     ebp                 
LINE:637		pop     edi                 
LINE:637		pop     esi                 
LINE:637		ret                         
}

VOID M_DrawInput( VOID )
{
/*-04*/ SIGNED LONG x;

LINE:650		push    0020                
LINE:650		call    __CHK               
LINE:650		push    ebx                 
LINE:650		push    ecx                 
LINE:650		push    edx                 
LINE:650		push    esi                 
LINE:650		push    edi                 
LINE:650		push    ebp                 
LINE:650		mov     ebp,esp             
LINE:650		sub     esp,0004            

LINE:654		mov     ecx,[_hudfont]      
LINE:654		mov     ebx,_inputstring    
LINE:654		mov     edx,[_stringy]      
LINE:654		mov     eax,[_stringx]      
LINE:654		call    V_DrawString_       
LINE:654		mov     [x],eax             

LINE:656		test    byte ptr [_processedframe],010h 
LINE:656		je      label0              

LINE:657		mov     ecx,[_hudfont]      
LINE:657		mov     ebx,005F            
LINE:657		mov     edx,[_stringy]      
LINE:657		mov     eax,[x]             
LINE:657		call    V_DrawChar_         

LINE:658:lable0		mov     esp,ebp             
LINE:658		pop     ebp                 
LINE:658		pop     edi                 
LINE:658		pop     esi                 
LINE:658		pop     edx                 
LINE:658		pop     ecx                 
LINE:658		pop     ebx                 
LINE:658		ret                         
}

VOID M_ControlCallback( SIGNED LONG )
/*-04*/ SIGNED LONG ch;
{
SIGNED LONG mapnum;

LINE:727		push    0024                
LINE:727		call    __CHK               
LINE:727		push    ebx                 
LINE:727		push    ecx                 
LINE:727		push    edx                 
LINE:727		push    esi                 
LINE:727		push    edi                 
LINE:727		push    ebp                 
LINE:727		mov     ebp,esp             
LINE:727		sub     esp,0008            
LINE:727		mov     [ch],eax            

LINE:731		cmp     dword ptr [ch],00044h 
LINE:731		jne     label0              

LINE:732		call    IO_Quit_            

LINE:735:lable0		cmp     dword ptr [_menuDisplayed],00000h 
LINE:735		jz      label1              

LINE:737		cmp     dword ptr [ch],00050h 
LINE:737		jne     label2              

LINE:743:lable5		mov     eax,[_currentMenu]  
LINE:743		movsx   edx,[eax]           
LINE:743		movsx   eax,[_itemOn]       
LINE:743		inc     eax                 
LINE:743		dec     edx                 
LINE:743		cmp     eax,edx             
LINE:743		jle     label3              

LINE:744		mov     dword ptr [_itemOn],00000h 
LINE:744		jmp     short label4        

LINE:745:lable3		inc     dword ptr [_itemOn] 

LINE:746:lable4		mov     eax,[_currentMenu]  
LINE:746		movsx   edx,[_itemOn]       
LINE:746		shl     edx,004h            
LINE:746		mov     eax,[eax+00006h]    
LINE:746		add     eax,edx             
LINE:746		cmp     dword ptr [eax],00000h 
LINE:746		je      label5              

LINE:747		jmp     label6              

LINE:749:lable2		cmp     dword ptr [ch],00048h 
LINE:749		jne     label7              

LINE:753:lable10		cmp     dword ptr [_itemOn],00000h 
LINE:753		jne     label8              

LINE:754		mov     eax,[_currentMenu]  
LINE:754		mov     ax,[eax]            
LINE:754		dec     ax                  
LINE:754		mov     [_itemOn],ax        
LINE:754		jmp     short label9        

LINE:755:lable8		dec     dword ptr [_itemOn] 

LINE:756:lable9		mov     eax,[_currentMenu]  
LINE:756		movsx   edx,[_itemOn]       
LINE:756		shl     edx,004h            
LINE:756		mov     eax,[eax+00006h]    
LINE:756		add     eax,edx             
LINE:756		cmp     dword ptr [eax],00000h 
LINE:756		je      label10             

LINE:757		jmp     label6              

LINE:759:lable7		cmp     dword ptr [ch],0004Bh 
LINE:759		jne     label11             

LINE:761		mov     eax,[_currentMenu]  
LINE:761		movsx   edx,[_itemOn]       
LINE:761		shl     edx,004h            
LINE:761		mov     eax,[eax+00006h]    
LINE:761		add     eax,edx             
LINE:761		cmp     dword ptr [eax+0000Ch],00000h 
LINE:761		je      label12             
LINE:761		mov     eax,[_currentMenu]  
LINE:761		movsx   edx,[_itemOn]       
LINE:761		shl     edx,004h            
LINE:761		mov     eax,[eax+00006h]    
LINE:761		add     eax,edx             
LINE:761		cmp     dword ptr [eax],00002h 
LINE:761		je      label13             
LINE:761:lable12		jmp     short label14       

LINE:763:lable13		mov     eax,[_currentMenu]  
LINE:763		movsx   edx,[_itemOn]       
LINE:763		shl     edx,004h            
LINE:763		mov     ebx,edx             
LINE:763		mov     edx,[eax+00006h]    
LINE:763		add     edx,ebx             
LINE:763		xor     eax,eax             
LINE:763		call    near dword ptr [edx+0000Ch] 
LINE:763:lable14		jmp     label6              

LINE:767:lable11		cmp     dword ptr [ch],0004Dh 
LINE:767		jne     label15             

LINE:769		mov     eax,[_currentMenu]  
LINE:769		movsx   edx,[_itemOn]       
LINE:769		shl     edx,004h            
LINE:769		mov     eax,[eax+00006h]    
LINE:769		add     eax,edx             
LINE:769		cmp     dword ptr [eax+0000Ch],00000h 
LINE:769		je      label16             
LINE:769		mov     eax,[_currentMenu]  
LINE:769		movsx   edx,[_itemOn]       
LINE:769		shl     edx,004h            
LINE:769		mov     eax,[eax+00006h]    
LINE:769		add     eax,edx             
LINE:769		cmp     dword ptr [eax],00002h 
LINE:769		je      label17             
LINE:769:lable16		jmp     short label18       

LINE:771:lable17		mov     eax,[_currentMenu]  
LINE:771		movsx   edx,[_itemOn]       
LINE:771		shl     edx,004h            
LINE:771		mov     ebx,edx             
LINE:771		mov     edx,[eax+00006h]    
LINE:771		add     edx,ebx             
LINE:771		mov     eax,0001            
LINE:771		call    near dword ptr [edx+0000Ch] 
LINE:771:lable18		jmp     label6              

LINE:775:lable15		cmp     dword ptr [ch],0001Ch 
LINE:775		jnz     label19             

LINE:777		mov     eax,[_currentMenu]  
LINE:777		movsx   edx,[_itemOn]       
LINE:777		shl     edx,004h            
LINE:777		mov     eax,[eax+00006h]    
LINE:777		add     eax,edx             
LINE:777		cmp     dword ptr [eax+0000Ch],00000h 
LINE:777		jz      label20             

LINE:779		mov     eax,[_currentMenu]  
LINE:779		mov     dx,[_itemOn]        
LINE:779		mov     [eax+00012h],dx     

LINE:780		mov     eax,[_currentMenu]  
LINE:780		mov     dx,[_scrollIndex]   
LINE:780		mov     [eax+00014h],dx     

LINE:781		mov     eax,[_currentMenu]  
LINE:781		movsx   edx,[_itemOn]       
LINE:781		shl     edx,004h            
LINE:781		mov     eax,[eax+00006h]    
LINE:781		add     eax,edx             
LINE:781		cmp     dword ptr [eax],00002h 
LINE:781		jne     label21             

LINE:782		mov     eax,[_currentMenu]  
LINE:782		movsx   edx,[_itemOn]       
LINE:782		shl     edx,004h            
LINE:782		mov     ebx,edx             
LINE:782		mov     edx,[eax+00006h]    
LINE:782		add     edx,ebx             
LINE:782		mov     eax,0001            
LINE:782		call    near dword ptr [edx+0000Ch] 
LINE:782		jmp     short label20       

LINE:784:lable21		mov     eax,[_currentMenu]  
LINE:784		movsx   edx,[_itemOn]       
LINE:784		shl     edx,004h            
LINE:784		mov     ebx,edx             
LINE:784		mov     edx,[eax+00006h]    
LINE:784		add     edx,ebx             
LINE:784		movsx   eax,[_itemOn]       
LINE:784		call    near dword ptr [edx+0000Ch] 

LINE:785:lable20		jmp     label6              

LINE:788:lable19		cmp     dword ptr [ch],00001h 
LINE:788		jne     label22             

LINE:790		mov     eax,[_currentMenu]  
LINE:790		mov     dx,[_itemOn]        
LINE:790		mov     [eax+00012h],dx     

LINE:791		mov     eax,[_currentMenu]  
LINE:791		mov     dx,[_scrollIndex]   
LINE:791		mov     [eax+00014h],dx     

LINE:792		mov     eax,[_currentMenu]  
LINE:792		cmp     dword ptr [eax+00002h],00000h 
LINE:792		je      label23             

LINE:794		mov     eax,[_currentMenu]  
LINE:794		mov     eax,[eax+00002h]    
LINE:794		mov     [_currentMenu],eax  

LINE:795		mov     eax,[_currentMenu]  
LINE:795		mov     ax,[eax+00012h]     
LINE:795		mov     [_itemOn],ax        

LINE:796		mov     eax,[_currentMenu]  
LINE:796		mov     ax,[eax+00014h]     
LINE:796		mov     [_scrollIndex],ax   
LINE:796		jmp     short label24       

LINE:799:lable23		call    M_ClearMenus_       
LINE:799:lable24		jmp     short label6        

LINE:802:lable22		cmp     dword ptr [ch],0001Fh 
LINE:802		jne     label25             
LINE:802		cmp     dword ptr [4D86],00000h 
LINE:802		jne     label26             
LINE:802:lable25		jmp     short label6        

LINE:804:lable26		call    M_DrawSelf_         

LINE:805		xor     eax,eax             
LINE:805		call    D_ScreenShot_       

LINE:806:lable6		jmp     short label27       

LINE:810:lable1		cmp     dword ptr [ch],00001h 
LINE:810		jne     label27             

LINE:811		call    M_StartControlPanel_ 

LINE:828:lable27		cmp     dword ptr [ch],0000Ch 
LINE:828		jne     label28             

LINE:830		dec     dword ptr [1DEC]    

LINE:831		cmp     dword ptr [1DEC],00001h 
LINE:831		jge     label29             

LINE:832		mov     dword ptr [1DEC],0001 

LINE:833:lable29		xor     ebx,ebx             
LINE:833		mov     edx,0003            
LINE:833		mov     eax,[1DEC]          
LINE:833		call    G_StartNewGame_     

LINE:835:lable28		cmp     dword ptr [ch],0000Dh 
LINE:835		jne     label30             

LINE:837		inc     dword ptr [1DEC]    

LINE:838		cmp     dword ptr [1DEC],0000Dh 
LINE:838		jle     label31             

LINE:839		mov     dword ptr [1DEC],000D 

LINE:840:lable31		xor     ebx,ebx             
LINE:840		mov     edx,0003            
LINE:840		mov     eax,[1DEC]          
LINE:840		call    G_StartNewGame_     

LINE:842:lable30		cmp     dword ptr [ch],00002h 
LINE:842		jl      label32             
LINE:842		cmp     dword ptr [ch],0000Ah 
LINE:842		jle     label33             
LINE:842:lable32		jmp     short label34       

LINE:844:lable33		mov     eax,[ch]            
LINE:844		dec     eax                 
LINE:844		mov     [1DEC],eax          

LINE:845		xor     ebx,ebx             
LINE:845		mov     edx,0003            
LINE:845		mov     eax,[1DEC]          
LINE:845		call    G_StartNewGame_     

LINE:848:lable34		mov     eax,000103CE        
LINE:848		call    M_InputKey_         

LINE:849		mov     esp,ebp             
LINE:849		pop     ebp                 
LINE:849		pop     edi                 
LINE:849		pop     esi                 
LINE:849		pop     edx                 
LINE:849		pop     ecx                 
LINE:849		pop     ebx                 
LINE:849		ret                         
}

VOID M_StartControlPanel( VOID )
{

LINE:860		push    001C                
LINE:860		call    __CHK               
LINE:860		push    ebx                 
LINE:860		push    ecx                 
LINE:860		push    edx                 
LINE:860		push    esi                 
LINE:860		push    edi                 
LINE:860		push    ebp                 
LINE:860		mov     ebp,esp             
LINE:860		sub     esp,0000            

LINE:862		mov     dword ptr [_menuDisplayed],00001h 

LINE:863		mov     dword ptr [_currentMenu],_MainDef 

LINE:864		mov     eax,[_currentMenu]  
LINE:864		mov     ax,[eax+00012h]     
LINE:864		mov     [_itemOn],ax        

LINE:865		inc     dword ptr [_ignorekeyboard] 

LINE:866		mov     eax,000103CE        
LINE:866		call    M_InputKey_         

LINE:867		pop     ebp                 
LINE:867		pop     edi                 
LINE:867		pop     esi                 
LINE:867		pop     edx                 
LINE:867		pop     ecx                 
LINE:867		pop     ebx                 
LINE:867		ret                         
}

VOID M_DrawSelf( VOID )
{
/*-08*/ SIGNED WORD max;
/*-04*/ SIGNED WORD i;
SIGNED WORD y;
SIGNED WORD x;

LINE:888		push    0024                
LINE:888		call    __CHK               
LINE:888		push    ebx                 
LINE:888		push    ecx                 
LINE:888		push    edx                 
LINE:888		push    esi                 
LINE:888		push    edi                 
LINE:888		push    ebp                 
LINE:888		mov     ebp,esp             
LINE:888		sub     esp,0008            

LINE:893		cmp     dword ptr [_menuDisplayed],00000h 
LINE:893		jz      label0              

LINE:897		call    R_StartInstanceDrawing_ 

LINE:900		mov     eax,[_currentMenu]  
LINE:900		cmp     dword ptr [eax+0000Ah],00000h 
LINE:900		je      label1              

LINE:901		mov     eax,[_currentMenu]  
LINE:901		call    near dword ptr [eax+0000Ah] 

LINE:905:lable1		mov     eax,[_currentMenu]  
LINE:905		mov     ax,[eax+0000Eh]     
LINE:905		mov     [00017220],ax       

LINE:906		mov     eax,[_currentMenu]  
LINE:906		mov     ax,[eax+00010h]     
LINE:906		mov     [0001721E],ax       

LINE:907		mov     eax,[_currentMenu]  
LINE:907		mov     ax,[eax]            
LINE:907		mov     [max],ax            

LINE:908		mov     eax,[_currentMenu]  
LINE:908		cmp     dword ptr [eax+00016h],00000h 
LINE:908		je      label2              

LINE:909		mov     eax,[_currentMenu]  
LINE:909		mov     ax,[eax+00016h]     
LINE:909		mov     [max],ax            

LINE:911:lable2		mov     dword ptr [i],00000h 
LINE:911:lable5		mov     ax,[i]              
LINE:911		cmp     ax,[max]            
LINE:911		jl      label3              
LINE:911		jmp     short label4        
LINE:911:lable7		mov     ax,[i]              
LINE:911		inc     dword ptr [i]       
LINE:911		jmp     short label5        

LINE:913:lable3		movsx   eax,[i]             
LINE:913		movsx   edx,[_scrollIndex]  
LINE:913		add     eax,edx             
LINE:913		shl     eax,004h            
LINE:913		mov     edx,eax             
LINE:913		mov     eax,[_currentMenu]  
LINE:913		mov     eax,[eax+00006h]    
LINE:913		add     eax,edx             
LINE:913		cmp     byte ptr [eax+00002h],000h 
LINE:913		je      label6              

LINE:914		movsx   edx,[i]             
LINE:914		movsx   eax,[_scrollIndex]  
LINE:914		add     eax,edx             
LINE:914		shl     eax,004h            
LINE:914		mov     edx,eax             
LINE:914		mov     eax,[_currentMenu]  
LINE:914		mov     eax,[eax+00006h]    
LINE:914		add     eax,edx             
LINE:914		add     eax,00002h          
LINE:914		call    W_GetName_          
LINE:914		mov     ebx,eax             
LINE:914		movsx   edx,[0001721E]      
LINE:914		movsx   eax,[00017220]      
LINE:914		call    V_DrawPatch_        

LINE:915:lable6		add     dword ptr [0001721E],00010h 
LINE:915		jmp     short label7        

LINE:921:lable4		dec     dword ptr [_skullAnimCounter] 
LINE:921		cmp     dword ptr [_skullAnimCounter],00000h 
LINE:921		jne     label8              

LINE:923		xor     byte ptr [_whichSkull],001h 

LINE:924		mov     dword ptr [_skullAnimCounter],00014h 

LINE:927:lable8		movsx   eax,[_whichSkull]   
LINE:927		shl     eax,003h            
LINE:927		mov     edx,_skullName      
LINE:927		add     eax,edx             
LINE:927		call    W_GetName_          
LINE:927		mov     ebx,eax             
LINE:927		mov     eax,[_currentMenu]  
LINE:927		movsx   edx,[eax+00010h]    
LINE:927		movsx   eax,[_itemOn]       
LINE:927		shl     eax,004h            
LINE:927		sub     edx,00005h          
LINE:927		add     edx,eax             
LINE:927		movsx   eax,[00017220]      
LINE:927		sub     eax,00020h          
LINE:927		call    V_DrawPatch_        

LINE:931:lable0		mov     esp,ebp             
LINE:931		pop     ebp                 
LINE:931		pop     edi                 
LINE:931		pop     esi                 
LINE:931		pop     edx                 
LINE:931		pop     ecx                 
LINE:931		pop     ebx                 
LINE:931		ret                         
}

VOID M_CheckInput( framecmd_t *)
/*-04*/ framecmd_t *cmd;
{

LINE:946		push    0024                
LINE:946		call    __CHK               
LINE:946		push    ebx                 
LINE:946		push    ecx                 
LINE:946		push    edx                 
LINE:946		push    esi                 
LINE:946		push    edi                 
LINE:946		push    ebp                 
LINE:946		mov     ebp,esp             
LINE:946		sub     esp,0004            
LINE:946		mov     [cmd],eax           

LINE:948		cmp     dword ptr [_controlmenumap],00000h 
LINE:948		je      label0              

LINE:950		mov     eax,[cmd]           
LINE:950		mov     byte ptr [eax],00Ah 

LINE:951		mov     eax,[cmd]           
LINE:951		mov     byte ptr [eax+00001h],000h 

LINE:952		mov     eax,[cmd]           
LINE:952		mov     byte ptr [eax+00002h],03Ch 

LINE:955:lable0		mov     eax,[cmd]           
LINE:955		cmp     byte ptr [eax+00003h],000h 
LINE:955		jz      label1              

LINE:958		cmp     dword ptr [_menuDisplayed],00000h 
LINE:958		jnz     label2              

LINE:963		mov     eax,[cmd]           
LINE:963		cmp     byte ptr [eax+00003h],029h 
LINE:963		jnz     label3              

LINE:966		cmp     dword ptr [4D9A],00000h 
LINE:966		je      label4              

LINE:968		call    IO_ClearKeys_       

LINE:969		mov     dword ptr [_gameaction],0002 

LINE:971:lable4		cmp     dword ptr [4D62],00000h 
LINE:971		je      label5              

LINE:973		call    IO_ClearKeys_       

LINE:974		mov     dword ptr [_gameaction],0003 

LINE:976:lable5		cmp     dword ptr [4D7A],00000h 
LINE:976		je      label6              

LINE:978		mov     dword ptr [4D7A],0000 

LINE:979		xor     eax,eax             
LINE:979		call    D_ScreenShot_       

LINE:981:lable6		cmp     dword ptr [4D46],00000h 
LINE:981		je      label7              

LINE:983		mov     dword ptr [4D46],0000 

LINE:984		mov     eax,0001            
LINE:984		call    D_ScreenShot_       

LINE:986:lable7		cmp     dword ptr [4D5E],00000h 
LINE:986		je      label3              

LINE:987		call    R_TestSprites_      

LINE:990:lable3		mov     eax,[cmd]           
LINE:990		cmp     byte ptr [eax+00003h],001h 
LINE:990		je      label8              
LINE:990		cmp     dword ptr [_demo],00002h 
LINE:990		jne     label9              

LINE:992:lable8		call    M_StartControlPanel_ 

LINE:993		mov     eax,[cmd]           
LINE:993		mov     byte ptr [eax+00003h],000h 

LINE:996:lable9		mov     eax,[cmd]           
LINE:996		cmp     byte ptr [eax+00003h],01Eh 
LINE:996		jne     label10             

LINE:998		call    P_EnterAutoMap_     

LINE:999		mov     eax,[cmd]           
LINE:999		mov     byte ptr [eax+00003h],000h 

LINE:1000:lable10		jmp     short label1        

LINE:1008:lable2		mov     eax,[cmd]           
LINE:1008		cmp     byte ptr [eax+00003h],029h 

LINE:1014		cmp     dword ptr [_keycallback],00000h 
LINE:1014		jne     label11             

LINE:1015		mov     eax,3ED8 "M_CheckInput: no keycallback" 
LINE:1015		push    eax                 
LINE:1015		call    IO_Error_           
LINE:1015		add     esp,00004h          

LINE:1016:lable11		mov     eax,[cmd]           
LINE:1016		movsx   ax,[eax+00003h]     
LINE:1016		cbw                         
LINE:1016		call    near dword ptr [_keycallback] 

LINE:1018:lable1		mov     esp,ebp             
LINE:1018		pop     ebp                 
LINE:1018		pop     edi                 
LINE:1018		pop     esi                 
LINE:1018		pop     edx                 
LINE:1018		pop     ecx                 
LINE:1018		pop     ebx                 
LINE:1018		ret                         
}

VOID M_Startup( VOID )
{

LINE:1029		push    001C                
LINE:1029		call    __CHK               
LINE:1029		push    ebx                 
LINE:1029		push    ecx                 
LINE:1029		push    edx                 
LINE:1029		push    esi                 
LINE:1029		push    edi                 
LINE:1029		push    ebp                 
LINE:1029		mov     ebp,esp             
LINE:1029		sub     esp,0000            

LINE:1031		mov     eax,3EF5 "HUFONT"   
LINE:1031		call    W_GetName_          
LINE:1031		mov     [_hudfont],eax      

LINE:1032		mov     dword ptr [_currentMenu],_MainDef 

LINE:1033		mov     dword ptr [_menuDisplayed],00001h 

LINE:1034		mov     eax,[_currentMenu]  
LINE:1034		mov     ax,[eax+00012h]     
LINE:1034		mov     [_itemOn],ax        

LINE:1035		mov     dword ptr [_whichSkull],00000h 

LINE:1036		mov     dword ptr [_skullAnimCounter],0000Ah 

LINE:1037		mov     dword ptr [_scrollIndex],00000h 

LINE:1038		pop     ebp                 
LINE:1038		pop     edi                 
LINE:1038		pop     esi                 
LINE:1038		pop     edx                 
LINE:1038		pop     ecx                 
LINE:1038		pop     ebx                 
LINE:1038		ret                         
}

VOID M_ClearMenus( VOID )
{

LINE:1048		push    001C                
LINE:1048		call    __CHK               
LINE:1048		push    ebx                 
LINE:1048		push    ecx                 
LINE:1048		push    edx                 
LINE:1048		push    esi                 
LINE:1048		push    edi                 
LINE:1048		push    ebp                 
LINE:1048		mov     ebp,esp             
LINE:1048		sub     esp,0000            

LINE:1050		cmp     dword ptr [_menuDisplayed],00000h 
LINE:1050		je      label0              

LINE:1052		mov     dword ptr [_menuDisplayed],00000h 

LINE:1053		mov     dword ptr [_ignorekeyboard],0000 

LINE:1055:lable0		pop     ebp                 
LINE:1055		pop     edi                 
LINE:1055		pop     esi                 
LINE:1055		pop     edx                 
LINE:1055		pop     ecx                 
LINE:1055		pop     ebx                 
LINE:1055		ret                         
}

VOID M_SetupNextMenu( struct menu_s menu_t *)
/*-04*/ struct menu_s menu_t *menudef;
{

LINE:1062		push    0020                
LINE:1062		call    __CHK               
LINE:1062		push    ebx                 
LINE:1062		push    ecx                 
LINE:1062		push    edx                 
LINE:1062		push    esi                 
LINE:1062		push    edi                 
LINE:1062		push    ebp                 
LINE:1062		mov     ebp,esp             
LINE:1062		sub     esp,0004            
LINE:1062		mov     [menudef],eax       

LINE:1064		mov     eax,[menudef]       
LINE:1064		mov     [_currentMenu],eax  

LINE:1065		mov     eax,[_currentMenu]  
LINE:1065		mov     ax,[eax+00012h]     
LINE:1065		mov     [_itemOn],ax        

LINE:1066		mov     eax,[_currentMenu]  
LINE:1066		mov     ax,[eax+00014h]     
LINE:1066		mov     [_scrollIndex],ax   

LINE:1067		mov     esp,ebp             
LINE:1067		pop     ebp                 
LINE:1067		pop     edi                 
LINE:1067		pop     esi                 
LINE:1067		pop     edx                 
LINE:1067		pop     ecx                 
LINE:1067		pop     ebx                 
LINE:1067		ret                         
}
