/*Module:r_init.c*/

boolean maploaded;
SIGNED LONG numsectors;
struct sector_s sector_t *sectors;
SIGNED LONG mapheight;
SIGNED LONG numpoints;
point_t *points;
SIGNED LONG numpatches;
SIGNED LONG nummappatches;
SIGNED LONG flatstartlump;
SIGNED LONG patchstartlump;
SIGNED LONG fixed_t cos45;
SIGNED LONG fixed_t *cosines;
SIGNED LONG numlines;
line_t *lines;
SIGNED LONG basetextures;
SIGNED LONG numtextures;
SIGNED LONG numflats;
SIGNED LONG nummapflats;
SIGNED LONG *flattranslation;
SIGNED LONG maporiginy;
SIGNED LONG maporiginx;
UNSIGNED BYTE byte **flatlookup;
patch_t **patchlookup;
maptexture_t **texturelookup;
UNSIGNED BYTE byte *blockmap;
SIGNED LONG texturelookupsize;
SIGNED LONG mapwidth;
SIGNED LONG numsides;
side_t *sides;
SIGNED LONG scalelight[48][16];
SIGNED LONG fixed_t sines[10240];
SIGNED LONG fixed_t yslope[832];
UNSIGNED BYTE byte amapcolor[256];

FLOAT DOUBLE9BYTE?? round( FLOAT DOUBLE9BYTE?? )
/*20*/ FLOAT DOUBLE9BYTE?? x;
{

LINE:9		push    002C                
LINE:9		call    __CHK               
LINE:9		push    eax                 
LINE:9		push    ebx                 
LINE:9		push    ecx                 
LINE:9		push    edx                 
LINE:9		push    esi                 
LINE:9		push    edi                 
LINE:9		push    ebp                 
LINE:9		mov     ebp,esp             
LINE:9		sub     esp,000C            

LINE:11		fldq    [x]                 
LINE:11		faddq   [48E8]              
LINE:11		call    __CHP               
LINE:11		fistp   [ebp-0000Ch]        
LINE:11		fild    [ebp-0000Ch]        
LINE:11		fstpq   [ebp-00008h]        

LINE:12		fldq    [ebp-00008h]        
LINE:12		mov     esp,ebp             
LINE:12		pop     ebp                 
LINE:12		pop     edi                 
LINE:12		pop     esi                 
LINE:12		pop     edx                 
LINE:12		pop     ecx                 
LINE:12		pop     ebx                 
LINE:12		pop     eax                 
LINE:12		ret     00008h              
}

SIGNED LONG R_AddTexture( maptexture_t *)
/*-08*/ maptexture_t *texture;
{

LINE:89		push    0024                
LINE:89		call    __CHK               
LINE:89		push    ebx                 
LINE:89		push    ecx                 
LINE:89		push    edx                 
LINE:89		push    esi                 
LINE:89		push    edi                 
LINE:89		push    ebp                 
LINE:89		mov     ebp,esp             
LINE:89		sub     esp,0008            
LINE:89		mov     [texture],eax       

LINE:91		mov     eax,[_numtextures]  
LINE:91		cmp     eax,[_texturelookupsize] 
LINE:91		jne     label0              

LINE:93		add     dword ptr [_texturelookupsize],00040h 

LINE:94		mov     edx,[_texturelookupsize] 
LINE:94		shl     edx,002h            
LINE:94		mov     eax,[_texturelookup] 
LINE:94		call    realloc_            
LINE:94		mov     [_texturelookup],eax 

LINE:96:lable0		mov     edx,[_numtextures]  
LINE:96		shl     edx,002h            
LINE:96		mov     eax,[_texturelookup] 
LINE:96		add     edx,eax             
LINE:96		mov     eax,[texture]       
LINE:96		mov     [edx],eax           

LINE:97		inc     dword ptr [_numtextures] 

LINE:98		mov     eax,[_numtextures]  
LINE:98		dec     eax                 
LINE:98		mov     [ebp-00004h],eax    

LINE:99		mov     eax,[ebp-00004h]    
LINE:99		mov     esp,ebp             
LINE:99		pop     ebp                 
LINE:99		pop     edi                 
LINE:99		pop     esi                 
LINE:99		pop     edx                 
LINE:99		pop     ecx                 
LINE:99		pop     ebx                 
LINE:99		ret                         
}

VOID R_InitWorldTextures( VOID )
{
/*-18*/ SIGNED BYTE char *names;
/*-24*/ SIGNED BYTE char name[9];
/*-14*/ SIGNED LONG *maptex;
/*-10*/ SIGNED LONG j;
/*-0c*/ SIGNED LONG i;
/*-08*/ mappatch_t *patch;
/*-04*/ maptexture_t *texture;

LINE:113		push    0040                
LINE:113		call    __CHK               
LINE:113		push    ebx                 
LINE:113		push    ecx                 
LINE:113		push    edx                 
LINE:113		push    esi                 
LINE:113		push    edi                 
LINE:113		push    ebp                 
LINE:113		mov     ebp,esp             
LINE:113		sub     esp,0024            

LINE:124		mov     byte ptr [ebp-0001Ch],000h 

LINE:125		mov     eax,48F0 "PNAMES"   
LINE:125		call    W_GetName_          
LINE:125		mov     [names],eax         

LINE:126		mov     eax,[names]         
LINE:126		mov     eax,[eax]           
LINE:126		mov     [_nummappatches],eax 

LINE:127		add     dword ptr [names],00004h 

LINE:128		mov     eax,[_nummappatches] 
LINE:128		shl     eax,002h            
LINE:128		call    malloc_             
LINE:128		mov     [_patchlookup],eax  

LINE:129		mov     dword ptr [i],0000  
LINE:129:lable2		mov     eax,[i]             
LINE:129		cmp     eax,[_nummappatches] 
LINE:129		jl      label0              
LINE:129		jmp     short label1        
LINE:129:lable3		mov     eax,[i]             
LINE:129		inc     dword ptr [i]       
LINE:129		jmp     short label2        

LINE:131:lable0		mov     ebx,0008            
LINE:131		mov     edx,[i]             
LINE:131		shl     edx,003h            
LINE:131		add     edx,[names]         
LINE:131		lea     eax,[name]          
LINE:131		call    strncpy_            

LINE:132		lea     eax,[name]          
LINE:132		call    W_GetName_          
LINE:132		mov     edx,[i]             
LINE:132		shl     edx,002h            
LINE:132		mov     ebx,[_patchlookup]  
LINE:132		add     edx,ebx             
LINE:132		mov     [edx],eax           
LINE:132		jmp     short label3        

LINE:139:lable1		mov     eax,48F7 "TEXTURES" 
LINE:139		call    W_GetName_          
LINE:139		mov     [maptex],eax        

LINE:140		mov     eax,[maptex]        
LINE:140		mov     eax,[eax]           
LINE:140		mov     [_basetextures],eax 

LINE:142		mov     dword ptr [_numtextures],0000 

LINE:144		mov     eax,[_basetextures] 
LINE:144		add     eax,00040h          
LINE:144		mov     [_texturelookupsize],eax 

LINE:145		mov     eax,[_texturelookupsize] 
LINE:145		shl     eax,002h            
LINE:145		call    malloc_             
LINE:145		mov     [_texturelookup],eax 

LINE:147		mov     dword ptr [i],0000  
LINE:147:lable6		mov     eax,[i]             
LINE:147		cmp     eax,[_basetextures] 
LINE:147		jl      label4              
LINE:147		jmp     short label5        
LINE:147:lable7		mov     eax,[i]             
LINE:147		inc     dword ptr [i]       
LINE:147		jmp     short label6        

LINE:149:lable4		mov     edx,[i]             
LINE:149		shl     edx,002h            
LINE:149		add     edx,[maptex]        
LINE:149		mov     eax,[maptex]        
LINE:149		add     eax,[edx+00004h]    
LINE:149		mov     [texture],eax       

LINE:163		mov     eax,[texture]       
LINE:163		call    R_AddTexture_       
LINE:163		jmp     short label7        

LINE:166:lable5		mov     esp,ebp             
LINE:166		pop     ebp                 
LINE:166		pop     edi                 
LINE:166		pop     esi                 
LINE:166		pop     edx                 
LINE:166		pop     ecx                 
LINE:166		pop     ebx                 
LINE:166		ret                         
}

VOID R_InitWorld( VOID )
{

LINE:190		push    001C                
LINE:190		call    __CHK               
LINE:190		push    ebx                 
LINE:190		push    ecx                 
LINE:190		push    edx                 
LINE:190		push    esi                 
LINE:190		push    edi                 
LINE:190		push    ebp                 
LINE:190		mov     ebp,esp             
LINE:190		sub     esp,0000            

LINE:192		call    R_InitWorldTextures_ 

LINE:193		pop     ebp                 
LINE:193		pop     edi                 
LINE:193		pop     esi                 
LINE:193		pop     edx                 
LINE:193		pop     ecx                 
LINE:193		pop     ebx                 
LINE:193		ret                         
}

VOID R_InitTables( VOID )
{
/*-10*/ SIGNED LONG startmap;
/*-0c*/ SIGNED LONG level;
/*-14*/ SIGNED LONG j;
/*-24*/ FLOAT DOUBLE9BYTE?? value;
/*-1c*/ FLOAT DOUBLE9BYTE?? tang;
/*-08*/ SIGNED LONG intval;
/*-04*/ SIGNED LONG i;

LINE:206		push    0048                
LINE:206		call    __CHK               
LINE:206		push    ebx                 
LINE:206		push    ecx                 
LINE:206		push    edx                 
LINE:206		push    esi                 
LINE:206		push    edi                 
LINE:206		push    ebp                 
LINE:206		mov     ebp,esp             
LINE:206		sub     esp,0024            

LINE:216		mov     dword ptr [i],0000  
LINE:216:lable2		cmp     dword ptr [i],0800  
LINE:216		jl      label0              
LINE:216		jmp     label1              
LINE:216:lable3		mov     eax,[i]             
LINE:216		inc     dword ptr [i]       
LINE:216		jmp     short label2        

LINE:218:lable0		fild    [i]                 
LINE:218		faddq   [4900]              
LINE:218		fmulq   [4908]              
LINE:218		fdivq   [4910]              
LINE:218		fstpq   [tang]              

LINE:219		fldq    [tang]              
LINE:219		sub     esp,00008h          
LINE:219		fstpq   [esp]               
LINE:219		call    sin_                
LINE:219		fstpq   [value]             

LINE:220		fldq    [value]             
LINE:220		fmulq   [4918]              
LINE:220		sub     esp,00008h          
LINE:220		fstpq   [esp]               
LINE:220		call    round_              
LINE:220		call    __CHP               
LINE:220		fistp   [intval]            

LINE:221		mov     edx,[i]             
LINE:221		shl     edx,002h            
LINE:221		mov     eax,[intval]        
LINE:221		mov     [edx+000033F60h],eax 

LINE:222		mov     edx,[i]             
LINE:222		shl     edx,002h            
LINE:222		mov     eax,[intval]        
LINE:222		mov     [edx+00003BF60h],eax 

LINE:223		mov     edx,0FFF            
LINE:223		sub     edx,[i]             
LINE:223		shl     edx,002h            
LINE:223		mov     eax,[intval]        
LINE:223		mov     [edx+000033F60h],eax 

LINE:224		mov     edx,[intval]        
LINE:224		neg     edx                 
LINE:224		mov     eax,[i]             
LINE:224		shl     eax,002h            
LINE:224		mov     [eax+000037F60h],edx 

LINE:225		mov     edx,[intval]        
LINE:225		neg     edx                 
LINE:225		mov     eax,1FFF "VNA3"     
LINE:225		sub     eax,[i]             
LINE:225		shl     eax,002h            
LINE:225		mov     [eax+000033F60h],edx 
LINE:225		jmp     label3              

LINE:228:lable1		mov     dword ptr [_cosines],00035F60 

LINE:229		mov     eax,[_cosines]      
LINE:229		mov     eax,[eax+000001000h] 
LINE:229		mov     [_cos45],eax        

LINE:234		mov     dword ptr [i],0000  
LINE:234:lable6		cmp     dword ptr [i],0340  
LINE:234		jl      label4              
LINE:234		jmp     short label5        
LINE:234:lable7		mov     eax,[i]             
LINE:234		inc     dword ptr [i]       
LINE:234		jmp     short label6        

LINE:235:lable4		mov     eax,[i]             
LINE:235		shl     eax,006h            
LINE:235		mov     edx,_spanlists      
LINE:235		add     edx,eax             
LINE:235		mov     eax,[i]             
LINE:235		shl     eax,002h            
LINE:235		mov     [eax+00002BE94h],edx 
LINE:235		jmp     short label7        

LINE:238:lable5		mov     dword ptr [i],0000  
LINE:238:lable10		cmp     dword ptr [i],0460  
LINE:238		jl      label8              
LINE:238		jmp     short label9        
LINE:238:lable11		mov     eax,[i]             
LINE:238		inc     dword ptr [i]       
LINE:238		jmp     short label10       

LINE:240:lable8		mov     eax,[i]             
LINE:240		shl     eax,002h            
LINE:240		mov     dword ptr [eax+000027894h],7FFFFFFF 

LINE:241		mov     eax,[i]             
LINE:241		shl     eax,002h            
LINE:241		mov     dword ptr [eax+000028A14h],0000 
LINE:241		jmp     short label11       

LINE:247:lable9		mov     ebx,1E00            
LINE:247		xor     edx,edx             
LINE:247		mov     eax,_forwardsegs    
LINE:247		call    memset_             

LINE:248		mov     ebx,3C00 "loc: failed on allocation of %i bytes" 
LINE:248		xor     edx,edx             
LINE:248		mov     eax,_proclines      
LINE:248		call    memset_             

LINE:254		mov     dword ptr [i],0000  
LINE:254:lable14		cmp     dword ptr [i],00010h 
LINE:254		jl      label12             
LINE:254		jmp     label13             
LINE:254:lable21		mov     eax,[i]             
LINE:254		inc     dword ptr [i]       
LINE:254		jmp     short label14       

LINE:256:lable12		mov     eax,000F            
LINE:256		sub     eax,[i]             
LINE:256		add     eax,eax             
LINE:256		shl     eax,005h            
LINE:256		cwd                         
LINE:256		shl     edx,004h            
LINE:256		sbb     eax,edx             
LINE:256		sar     eax,004h            
LINE:256		mov     [startmap],eax      

LINE:257		mov     dword ptr [j],0000  
LINE:257:lable17		cmp     dword ptr [j],00030h 
LINE:257		jl      label15             
LINE:257		jmp     short label16       
LINE:257:lable20		mov     eax,[j]             
LINE:257		inc     dword ptr [j]       
LINE:257		jmp     short label17       

LINE:259:lable15		mov     eax,[j]             
LINE:259		cwd                         
LINE:259		sub     eax,edx             
LINE:259		sar     eax,1               
LINE:259		mov     edx,[startmap]      
LINE:259		sub     edx,eax             
LINE:259		mov     [level],edx         

LINE:260		cmp     dword ptr [level],00000h 
LINE:260		jge     label18             

LINE:261		mov     dword ptr [level],0000 

LINE:262:lable18		cmp     dword ptr [level],00020h 
LINE:262		jl      label19             

LINE:263		mov     dword ptr [level],001F 

LINE:264:lable19		imul    eax,[i],00C0        
LINE:264		mov     edx,[j]             
LINE:264		shl     edx,002h            
LINE:264		add     edx,eax             
LINE:264		mov     eax,[level]         
LINE:264		mov     [edx+000033360h],eax 
LINE:264		jmp     short label20       

LINE:265:lable16		jmp     short label21       

LINE:267:lable13		mov     esp,ebp             
LINE:267		pop     ebp                 
LINE:267		pop     edi                 
LINE:267		pop     esi                 
LINE:267		pop     edx                 
LINE:267		pop     ecx                 
LINE:267		pop     ebx                 
LINE:267		ret                         
}

VOID R_InitLumps( VOID )
{
/*-04*/ SIGNED LONG i;

LINE:280		push    0020                
LINE:280		call    __CHK               
LINE:280		push    ebx                 
LINE:280		push    ecx                 
LINE:280		push    edx                 
LINE:280		push    esi                 
LINE:280		push    edi                 
LINE:280		push    ebp                 
LINE:280		mov     ebp,esp             
LINE:280		sub     esp,0004            

LINE:284		mov     eax,4920 "F_START"  
LINE:284		call    W_GetNumForName_    
LINE:284		mov     [_flatstartlump],eax 

LINE:285		mov     eax,4928 "F_END"    
LINE:285		call    W_GetNumForName_    
LINE:285		mov     edx,[_flatstartlump] 
LINE:285		sub     eax,edx             
LINE:285		mov     [_numflats],eax     

LINE:286		mov     eax,[_numflats]     
LINE:286		shl     eax,002h            
LINE:286		call    malloc_             
LINE:286		mov     [_flatlookup],eax   

LINE:287		mov     dword ptr [i],0000  
LINE:287:lable2		mov     eax,[i]             
LINE:287		cmp     eax,[_numflats]     
LINE:287		jl      label0              
LINE:287		jmp     short label1        
LINE:287:lable3		mov     eax,[i]             
LINE:287		inc     dword ptr [i]       
LINE:287		jmp     short label2        

LINE:288:lable0		mov     eax,[_flatstartlump] 
LINE:288		add     eax,[i]             
LINE:288		shl     eax,004h            
LINE:288		mov     edx,[_lumpinfo]     
LINE:288		add     edx,eax             
LINE:288		mov     eax,[i]             
LINE:288		shl     eax,002h            
LINE:288		mov     ebx,[_flatlookup]   
LINE:288		add     eax,ebx             
LINE:288		mov     edx,[edx]           
LINE:288		mov     [eax],edx           
LINE:288		jmp     short label3        

LINE:290:lable1		mov     eax,492E "P_START"  
LINE:290		call    W_GetNumForName_    
LINE:290		mov     [_patchstartlump],eax 

LINE:291		mov     eax,4936 "P_END"    
LINE:291		call    W_GetNumForName_    
LINE:291		mov     edx,[_patchstartlump] 
LINE:291		sub     eax,edx             
LINE:291		mov     [_numpatches],eax   

LINE:297		mov     esp,ebp             
LINE:297		pop     ebp                 
LINE:297		pop     edi                 
LINE:297		pop     esi                 
LINE:297		pop     edx                 
LINE:297		pop     ecx                 
LINE:297		pop     ebx                 
LINE:297		ret                         
}

VOID R_LoadMapPlanes( SIGNED LONG )
/*-0c*/ SIGNED LONG maplump;
{
/*-04*/ SIGNED LONG i;
/*-08*/ SIGNED BYTE char *names;
/*-18*/ SIGNED BYTE char name[9];

LINE:326		push    0034                
LINE:326		call    __CHK               
LINE:326		push    ebx                 
LINE:326		push    ecx                 
LINE:326		push    edx                 
LINE:326		push    esi                 
LINE:326		push    edi                 
LINE:326		push    ebp                 
LINE:326		mov     ebp,esp             
LINE:326		sub     esp,0018            
LINE:326		mov     [maplump],eax       

LINE:331		mov     byte ptr [ebp-00010h],000h 

LINE:333		mov     eax,[maplump]       
LINE:333		inc     eax                 
LINE:333		call    W_GetLump_          
LINE:333		mov     [names],eax         

LINE:334		mov     eax,[names]         
LINE:334		mov     eax,[eax]           
LINE:334		mov     [_nummapflats],eax  

LINE:335		add     dword ptr [names],00004h 

LINE:336		mov     edx,[_nummapflats]  
LINE:336		shl     edx,002h            
LINE:336		mov     eax,[_playzone]     
LINE:336		call    Z_Malloc_           
LINE:336		mov     [_flattranslation],eax 

LINE:337		mov     dword ptr [i],0000  
LINE:337:lable2		mov     eax,[i]             
LINE:337		cmp     eax,[_nummapflats]  
LINE:337		jl      label0              
LINE:337		jmp     short label1        
LINE:337:lable3		mov     eax,[i]             
LINE:337		inc     dword ptr [i]       
LINE:337		jmp     short label2        

LINE:339:lable0		mov     ebx,0008            
LINE:339		mov     edx,[i]             
LINE:339		shl     edx,003h            
LINE:339		add     edx,[names]         
LINE:339		lea     eax,[name]          
LINE:339		call    strncpy_            

LINE:340		lea     eax,[name]          
LINE:340		call    W_GetNumForName_    
LINE:340		sub     eax,[_flatstartlump] 
LINE:340		mov     ebx,eax             
LINE:340		mov     eax,[i]             
LINE:340		shl     eax,002h            
LINE:340		mov     edx,[_flattranslation] 
LINE:340		add     eax,edx             
LINE:340		mov     [eax],ebx           
LINE:340		jmp     short label3        

LINE:345:lable1		mov     esp,ebp             
LINE:345		pop     ebp                 
LINE:345		pop     edi                 
LINE:345		pop     esi                 
LINE:345		pop     edx                 
LINE:345		pop     ecx                 
LINE:345		pop     ebx                 
LINE:345		ret                         
}

VOID R_LoadMapThings( SIGNED LONG )
/*-14*/ SIGNED LONG maplump;
{
/*-10*/ SIGNED LONG numthings;
/*-0c*/ mapthing_t *mapthing;
/*-08*/ mapthing_t *mapthings;
/*-04*/ SIGNED LONG i;

LINE:359		push    0030                
LINE:359		call    __CHK               
LINE:359		push    ebx                 
LINE:359		push    ecx                 
LINE:359		push    edx                 
LINE:359		push    esi                 
LINE:359		push    edi                 
LINE:359		push    ebp                 
LINE:359		mov     ebp,esp             
LINE:359		sub     esp,0014            
LINE:359		mov     [maplump],eax       

LINE:365		mov     eax,[maplump]       
LINE:365		add     eax,00005h          
LINE:365		call    W_GetLump_          
LINE:365		mov     [mapthings],eax     

LINE:366		mov     eax,[mapthings]     
LINE:366		mov     eax,[eax]           
LINE:366		mov     [numthings],eax     

LINE:367		add     dword ptr [mapthings],00004h 

LINE:369		mov     eax,[mapthings]     
LINE:369		mov     [mapthing],eax      
LINE:369		mov     dword ptr [i],0000  
LINE:369:lable2		mov     eax,[i]             
LINE:369		cmp     eax,[numthings]     
LINE:369		jl      label0              
LINE:369		jmp     short label1        
LINE:369:lable3		mov     eax,[i]             
LINE:369		inc     dword ptr [i]       
LINE:369		mov     eax,[mapthing]      
LINE:369		add     dword ptr [mapthing],0000Ch 
LINE:369		jmp     short label2        

LINE:376:lable0		mov     eax,[mapthing]      
LINE:376		call    P_InitThing_        
LINE:376		jmp     short label3        

LINE:383:lable1		mov     esp,ebp             
LINE:383		pop     ebp                 
LINE:383		pop     edi                 
LINE:383		pop     esi                 
LINE:383		pop     edx                 
LINE:383		pop     ecx                 
LINE:383		pop     ebx                 
LINE:383		ret                         
}

VOID R_LoadMapPoints( SIGNED LONG )
/*-10*/ SIGNED LONG maplump;
{
/*-0c*/ point_t *pt;
/*-08*/ mapvertex_t *mp;
/*-04*/ SIGNED LONG i;

LINE:394		push    002C                
LINE:394		call    __CHK               
LINE:394		push    ebx                 
LINE:394		push    ecx                 
LINE:394		push    edx                 
LINE:394		push    esi                 
LINE:394		push    edi                 
LINE:394		push    ebp                 
LINE:394		mov     ebp,esp             
LINE:394		sub     esp,0010            
LINE:394		mov     [maplump],eax       

LINE:400		mov     eax,[maplump]       
LINE:400		add     eax,00002h          
LINE:400		call    W_GetLump_          
LINE:400		mov     [mp],eax            

LINE:401		mov     eax,[mp]            
LINE:401		mov     eax,[eax]           
LINE:401		mov     [_numpoints],eax    

LINE:402		add     dword ptr [mp],00004h 

LINE:404		mov     edx,[_numpoints]    
LINE:404		shl     edx,003h            
LINE:404		mov     eax,[_playzone]     
LINE:404		call    Z_Malloc_           
LINE:404		mov     [_points],eax       

LINE:406		mov     eax,[_points]       
LINE:406		mov     [pt],eax            

LINE:408		mov     dword ptr [i],0000  
LINE:408:lable2		mov     eax,[i]             
LINE:408		cmp     eax,[_numpoints]    
LINE:408		jl      label0              
LINE:408		jmp     short label1        
LINE:408:lable3		mov     eax,[i]             
LINE:408		inc     dword ptr [i]       
LINE:408		jmp     short label2        

LINE:410:lable0		mov     eax,[mp]            
LINE:410		movsx   edx,[eax]           
LINE:410		mov     eax,[pt]            
LINE:410		shl     edx,010h            
LINE:410		mov     [eax],edx           

LINE:411		mov     eax,[mp]            
LINE:411		movsx   edx,[eax+00002h]    
LINE:411		mov     eax,[pt]            
LINE:411		shl     edx,010h            
LINE:411		mov     [eax+00004h],edx    

LINE:413		mov     eax,[pt]            
LINE:413		add     dword ptr [pt],00008h 

LINE:414		mov     eax,[mp]            
LINE:414		add     dword ptr [mp],00004h 
LINE:414		jmp     short label3        

LINE:416:lable1		mov     esp,ebp             
LINE:416		pop     ebp                 
LINE:416		pop     edi                 
LINE:416		pop     esi                 
LINE:416		pop     edx                 
LINE:416		pop     ecx                 
LINE:416		pop     ebx                 
LINE:416		ret                         
}

VOID R_LoadMapLines( SIGNED LONG )
/*-20*/ SIGNED LONG maplump;
{
/*-1c*/ side_t *si;
/*-18*/ mapside_t *ms;
/*-14*/ line_t *li;
/*-10*/ mapline_t *maplines;
/*-0c*/ mapline_t *ml;
/*-08*/ SIGNED LONG s;
/*-04*/ SIGNED LONG i;

LINE:429		push    0040                
LINE:429		call    __CHK               
LINE:429		push    ebx                 
LINE:429		push    ecx                 
LINE:429		push    edx                 
LINE:429		push    esi                 
LINE:429		push    edi                 
LINE:429		push    ebp                 
LINE:429		mov     ebp,esp             
LINE:429		sub     esp,0024            
LINE:429		mov     [maplump],eax       

LINE:437		mov     eax,[maplump]       
LINE:437		add     eax,00003h          
LINE:437		call    W_GetLump_          
LINE:437		mov     [maplines],eax      

LINE:438		mov     eax,[maplines]      
LINE:438		mov     eax,[eax]           
LINE:438		mov     [_numlines],eax     

LINE:439		add     dword ptr [maplines],00004h 

LINE:444		mov     dword ptr [_numsides],0000 

LINE:445		mov     eax,[maplines]      
LINE:445		mov     [ml],eax            

LINE:446		mov     dword ptr [i],0000  
LINE:446:lable2		mov     eax,[i]             
LINE:446		cmp     eax,[_numlines]     
LINE:446		jl      label0              
LINE:446		jmp     short label1        
LINE:446:lable5		mov     eax,[i]             
LINE:446		inc     dword ptr [i]       
LINE:446		mov     eax,[ml]            
LINE:446		add     dword ptr [ml],00024h 
LINE:446		jmp     short label2        

LINE:448:lable0		mov     eax,[ml]            
LINE:448		test    byte ptr [eax+00004h],004h 
LINE:448		je      label3              

LINE:449		add     dword ptr [_numsides],00002h 
LINE:449		jmp     short label4        

LINE:451:lable3		inc     dword ptr [_numsides] 
LINE:451:lable4		jmp     short label5        

LINE:457:lable1		imul    edx,[_numlines],03Ch 
LINE:457		mov     eax,[_playzone]     
LINE:457		call    Z_Malloc_           
LINE:457		mov     [_lines],eax        

LINE:458		imul    edx,[_numsides],00Ch 
LINE:458		mov     eax,[_playzone]     
LINE:458		call    Z_Malloc_           
LINE:458		mov     [_sides],eax        

LINE:460		mov     eax,[maplines]      
LINE:460		mov     [ml],eax            

LINE:461		mov     eax,[_lines]        
LINE:461		mov     [li],eax            

LINE:462		mov     eax,[_sides]        
LINE:462		mov     [si],eax            

LINE:464		mov     dword ptr [i],0000  
LINE:464:lable8		mov     eax,[i]             
LINE:464		cmp     eax,[_numlines]     
LINE:464		jl      label6              
LINE:464		jmp     label7              
LINE:464:lable15		mov     eax,[i]             
LINE:464		inc     dword ptr [i]       
LINE:464		jmp     short label8        

LINE:466:lable6		mov     eax,[ml]            
LINE:466		mov     dx,[eax]            
LINE:466		mov     eax,[li]            
LINE:466		mov     [eax],dx            

LINE:467		mov     eax,[ml]            
LINE:467		mov     dx,[eax+00002h]     
LINE:467		mov     eax,[li]            
LINE:467		mov     [eax+00002h],dx     

LINE:468		mov     eax,[ml]            
LINE:468		mov     dx,[eax+00008h]     
LINE:468		mov     eax,[li]            
LINE:468		mov     [eax+00008h],dx     

LINE:469		mov     eax,[ml]            
LINE:469		mov     dx,[eax+0000Ah]     
LINE:469		mov     eax,[li]            
LINE:469		mov     [eax+0000Ah],dx     

LINE:470		mov     eax,[ml]            
LINE:470		mov     dx,[eax+00004h]     
LINE:470		mov     eax,[li]            
LINE:470		mov     [eax+00004h],dx     

LINE:471		mov     eax,[ml]            
LINE:471		mov     dx,[eax+00006h]     
LINE:471		mov     eax,[li]            
LINE:471		mov     [eax+00006h],dx     

LINE:472		mov     eax,[i]             
LINE:472		call    R_SetLineTypeAndBox_ 

LINE:474		mov     dword ptr [s],0000  
LINE:474:lable13		mov     eax,[li]            
LINE:474		mov     ax,[eax+00004h]     
LINE:474		and     ax,00004h           
LINE:474		test    ax,ax               
LINE:474		jle     label9              
LINE:474		mov     dword ptr [ebp-00024h],0001 
LINE:474		jmp     short label10       
LINE:474:lable9		mov     dword ptr [ebp-00024h],0000 
LINE:474:lable10		mov     eax,[s]             
LINE:474		cmp     eax,[ebp-00024h]    
LINE:474		jle     label11             
LINE:474		jmp     label12             
LINE:474:lable14		mov     eax,[s]             
LINE:474		inc     dword ptr [s]       
LINE:474		mov     eax,[si]            
LINE:474		add     dword ptr [si],0000Ch 
LINE:474		jmp     short label13       

LINE:476:lable11		mov     eax,[si]            
LINE:476		sub     eax,[_sides]        
LINE:476		mov     ebx,000C            
LINE:476		cwd                         
LINE:476		idiv    bx                  
LINE:476		mov     edx,[s]             
LINE:476		shl     edx,002h            
LINE:476		add     edx,[li]            
LINE:476		mov     [edx+00030h],eax    

LINE:478		imul    eax,[s],00Ch        
LINE:478		mov     edx,[ml]            
LINE:478		add     edx,0000Ch          
LINE:478		add     edx,eax             
LINE:478		mov     [ms],edx            

LINE:479		mov     eax,[ms]            
LINE:479		mov     dx,[eax+00002h]     
LINE:479		mov     eax,[si]            
LINE:479		mov     [eax],dx            

LINE:480		mov     eax,[ms]            
LINE:480		mov     dx,[eax+00004h]     
LINE:480		mov     eax,[si]            
LINE:480		mov     [eax+00002h],dx     

LINE:481		mov     eax,[ms]            
LINE:481		mov     dx,[eax+00006h]     
LINE:481		mov     eax,[si]            
LINE:481		mov     [eax+00006h],dx     

LINE:482		mov     eax,[ms]            
LINE:482		mov     dx,[eax+00008h]     
LINE:482		mov     eax,[si]            
LINE:482		mov     [eax+00008h],dx     

LINE:483		mov     eax,[ms]            
LINE:483		mov     dx,[eax+0000Ah]     
LINE:483		mov     eax,[si]            
LINE:483		mov     [eax+0000Ah],dx     
LINE:483		jmp     label14             

LINE:486:lable12		mov     eax,[ml]            
LINE:486		add     dword ptr [ml],00024h 

LINE:487		mov     eax,[li]            
LINE:487		add     dword ptr [li],0003Ch 
LINE:487		jmp     label15             

LINE:489:lable7		mov     esp,ebp             
LINE:489		pop     ebp                 
LINE:489		pop     edi                 
LINE:489		pop     esi                 
LINE:489		pop     edx                 
LINE:489		pop     ecx                 
LINE:489		pop     ebx                 
LINE:489		ret                         
}

VOID R_LoadMapSectors( SIGNED LONG )
/*-18*/ SIGNED LONG maplump;
{
/*-14*/ struct sector_s sector_t *en;
/*-10*/ mapsector_t *me;
/*-0c*/ SIGNED LONG *mapsectors;
/*-08*/ SIGNED LONG j;
/*-04*/ SIGNED LONG i;

LINE:502		push    0034                
LINE:502		call    __CHK               
LINE:502		push    ebx                 
LINE:502		push    ecx                 
LINE:502		push    edx                 
LINE:502		push    esi                 
LINE:502		push    edi                 
LINE:502		push    ebp                 
LINE:502		mov     ebp,esp             
LINE:502		sub     esp,0018            
LINE:502		mov     [maplump],eax       

LINE:509		mov     eax,[maplump]       
LINE:509		add     eax,00004h          
LINE:509		call    W_GetLump_          
LINE:509		mov     [mapsectors],eax    

LINE:510		mov     eax,[mapsectors]    
LINE:510		mov     eax,[eax]           
LINE:510		mov     [_numsectors],eax   

LINE:512		imul    edx,[_numsectors],032h 
LINE:512		mov     eax,[_playzone]     
LINE:512		call    Z_Malloc_           
LINE:512		mov     [_sectors],eax      

LINE:513		mov     eax,[_sectors]      
LINE:513		mov     [en],eax            

LINE:515		mov     dword ptr [i],0000  
LINE:515:lable2		mov     eax,[i]             
LINE:515		cmp     eax,[_numsectors]   
LINE:515		jl      label0              
LINE:515		jmp     label1              
LINE:515:lable7		mov     eax,[i]             
LINE:515		inc     dword ptr [i]       
LINE:515		jmp     short label2        

LINE:517:lable0		mov     edx,[i]             
LINE:517		shl     edx,002h            
LINE:517		add     edx,[mapsectors]    
LINE:517		mov     eax,[mapsectors]    
LINE:517		add     eax,[edx+00004h]    
LINE:517		mov     [me],eax            

LINE:519		mov     eax,[me]            
LINE:519		movsx   edx,[eax]           
LINE:519		mov     eax,[en]            
LINE:519		shl     edx,010h            
LINE:519		mov     [eax],edx           

LINE:520		mov     eax,[me]            
LINE:520		movsx   edx,[eax+00002h]    
LINE:520		mov     eax,[en]            
LINE:520		shl     edx,010h            
LINE:520		mov     [eax+00004h],edx    

LINE:521		mov     eax,[me]            
LINE:521		movsx   eax,[eax+00004h]    
LINE:521		shl     eax,002h            
LINE:521		mov     edx,eax             
LINE:521		mov     eax,[_flattranslation] 
LINE:521		add     eax,edx             
LINE:521		mov     dx,[eax]            
LINE:521		mov     eax,[en]            
LINE:521		mov     [eax+00008h],dx     

LINE:522		mov     eax,[me]            
LINE:522		movsx   edx,[eax+00006h]    
LINE:522		shl     edx,002h            
LINE:522		mov     eax,[_flattranslation] 
LINE:522		add     eax,edx             
LINE:522		mov     dx,[eax]            
LINE:522		mov     eax,[en]            
LINE:522		mov     [eax+0000Ah],dx     

LINE:523		mov     eax,[me]            
LINE:523		mov     dx,[eax+00008h]     
LINE:523		mov     eax,[en]            
LINE:523		mov     [eax+0000Ch],dx     

LINE:524		mov     eax,[me]            
LINE:524		mov     ax,[eax+0000Ah]     
LINE:524		mov     edx,[en]            
LINE:524		mov     [edx+0000Eh],ax     

LINE:525		mov     eax,[me]            
LINE:525		mov     ax,[eax+0000Ch]     
LINE:525		mov     edx,[en]            
LINE:525		mov     [edx+00010h],ax     

LINE:526		mov     eax,[me]            
LINE:526		movsx   eax,[eax+0000Eh]    
LINE:526		mov     edx,[en]            
LINE:526		mov     [edx+00016h],eax    

LINE:527		mov     eax,[en]            
LINE:527		mov     edx,[eax+00016h]    
LINE:527		shl     edx,002h            
LINE:527		mov     eax,[_playzone]     
LINE:527		call    Z_Malloc_           
LINE:527		mov     edx,[en]            
LINE:527		mov     [edx+0001Ah],eax    

LINE:528		mov     eax,[en]            
LINE:528		mov     dword ptr [eax+0002Ah],0000 

LINE:529		mov     eax,[en]            
LINE:529		mov     dword ptr [eax+0002Eh],0000 

LINE:530		mov     dword ptr [j],0000  
LINE:530:lable5		mov     eax,[j]             
LINE:530		mov     edx,[en]            
LINE:530		cmp     eax,[edx+00016h]    
LINE:530		jl      label3              
LINE:530		jmp     short label4        
LINE:530:lable6		mov     eax,[j]             
LINE:530		inc     dword ptr [j]       
LINE:530		jmp     short label5        

LINE:531:lable3		mov     eax,[j]             
LINE:531		add     eax,eax             
LINE:531		add     eax,[me]            
LINE:531		movsx   edx,[eax+00010h]    
LINE:531		mov     ebx,[j]             
LINE:531		shl     ebx,002h            
LINE:531		mov     eax,[en]            
LINE:531		mov     eax,[eax+0001Ah]    
LINE:531		add     eax,ebx             
LINE:531		mov     [eax],edx           
LINE:531		jmp     short label6        

LINE:532:lable4		mov     eax,[en]            
LINE:532		add     dword ptr [en],00032h 
LINE:532		jmp     label7              

LINE:534:lable1		mov     esp,ebp             
LINE:534		pop     ebp                 
LINE:534		pop     edi                 
LINE:534		pop     esi                 
LINE:534		pop     edx                 
LINE:534		pop     ecx                 
LINE:534		pop     ebx                 
LINE:534		ret                         
}

VOID R_InitBlockMap( VOID )
{
/*-1c*/ SIGNED LONG bottom;
/*-18*/ SIGNED LONG top;
/*-14*/ SIGNED LONG right;
/*-10*/ SIGNED LONG left;
/*-0c*/ SIGNED LONG y;
/*-08*/ SIGNED LONG x;
/*-04*/ SIGNED LONG i;

LINE:547		push    0038                
LINE:547		call    __CHK               
LINE:547		push    ebx                 
LINE:547		push    ecx                 
LINE:547		push    edx                 
LINE:547		push    esi                 
LINE:547		push    edi                 
LINE:547		push    ebp                 
LINE:547		mov     ebp,esp             
LINE:547		sub     esp,001C            

LINE:555		mov     dword ptr [left],7FFFFFFF 

LINE:556		mov     dword ptr [right],80000000 

LINE:557		mov     dword ptr [top],80000000 

LINE:558		mov     dword ptr [bottom],7FFFFFFF 

LINE:559		mov     dword ptr [i],0000  
LINE:559:lable2		mov     eax,[i]             
LINE:559		cmp     eax,[_numpoints]    
LINE:559		jl      label0              
LINE:559		jmp     label1              
LINE:559:lable7		mov     eax,[i]             
LINE:559		inc     dword ptr [i]       
LINE:559		jmp     short label2        

LINE:561:lable0		mov     eax,[i]             
LINE:561		shl     eax,003h            
LINE:561		mov     edx,[_points]       
LINE:561		add     eax,edx             
LINE:561		mov     eax,[eax]           
LINE:561		mov     [x],eax             

LINE:562		mov     edx,[i]             
LINE:562		shl     edx,003h            
LINE:562		mov     eax,[_points]       
LINE:562		add     eax,edx             
LINE:562		mov     eax,[eax+00004h]    
LINE:562		mov     [y],eax             

LINE:563		mov     eax,[x]             
LINE:563		cmp     eax,[left]          
LINE:563		jge     label3              

LINE:564		mov     eax,[x]             
LINE:564		mov     [left],eax          

LINE:565:lable3		mov     eax,[x]             
LINE:565		cmp     eax,[right]         
LINE:565		jle     label4              

LINE:566		mov     eax,[x]             
LINE:566		mov     [right],eax         

LINE:567:lable4		mov     eax,[y]             
LINE:567		cmp     eax,[bottom]        
LINE:567		jge     label5              

LINE:568		mov     eax,[y]             
LINE:568		mov     [bottom],eax        

LINE:569:lable5		mov     eax,[y]             
LINE:569		cmp     eax,[top]           
LINE:569		jle     label6              

LINE:570		mov     eax,[y]             
LINE:570		mov     [top],eax           
LINE:570:lable6		jmp     short label7        

LINE:573:lable1		mov     eax,[left]          
LINE:573		sar     eax,014h            
LINE:573		shl     eax,014h            
LINE:573		mov     [_maporiginx],eax   

LINE:574		mov     eax,[bottom]        
LINE:574		sar     eax,014h            
LINE:574		shl     eax,014h            
LINE:574		mov     [_maporiginy],eax   

LINE:576		mov     eax,[right]         
LINE:576		sar     eax,014h            
LINE:576		shl     eax,014h            
LINE:576		mov     [right],eax         

LINE:577		mov     eax,[top]           
LINE:577		sar     eax,014h            
LINE:577		shl     eax,014h            
LINE:577		mov     [top],eax           

LINE:579		mov     eax,[right]         
LINE:579		sub     eax,[_maporiginx]   
LINE:579		sar     eax,014h            
LINE:579		inc     eax                 
LINE:579		mov     [_mapwidth],eax     

LINE:580		mov     eax,[top]           
LINE:580		sub     eax,[_maporiginy]   
LINE:580		sar     eax,014h            
LINE:580		inc     eax                 
LINE:580		mov     [_mapheight],eax    

LINE:582		mov     eax,[_mapwidth]     
LINE:582		imul    eax,[_mapheight]    
LINE:582		mov     edx,eax             
LINE:582		mov     eax,[_playzone]     
LINE:582		call    Z_Malloc_           
LINE:582		mov     [_blockmap],eax     

LINE:583		mov     eax,[_mapwidth]     
LINE:583		imul    eax,[_mapheight]    
LINE:583		mov     ebx,eax             
LINE:583		xor     edx,edx             
LINE:583		mov     eax,[_blockmap]     
LINE:583		call    memset_             

LINE:588		mov     dword ptr [i],0000  
LINE:588:lable10		cmp     dword ptr [i],00FF  
LINE:588		jl      label8              
LINE:588		jmp     short label9        
LINE:588:lable13		mov     eax,[i]             
LINE:588		inc     dword ptr [i]       
LINE:588		jmp     short label10       

LINE:589:lable8		test    dword ptr [i],0010  
LINE:589		je      label11             

LINE:590		mov     eax,[i]             
LINE:590		mov     byte ptr [eax+00003EC60h],0C8h 
LINE:590		jmp     short label12       

LINE:592:lable11		mov     eax,[i]             
LINE:592		mov     byte ptr [eax+00003EC60h],0CDh 
LINE:592:lable12		jmp     short label13       

LINE:594:lable9		mov     dword ptr [i],0000  
LINE:594:lable16		mov     eax,[i]             
LINE:594		cmp     eax,[_numlines]     
LINE:594		jl      label14             
LINE:594		jmp     short label15       
LINE:594:lable17		mov     eax,[i]             
LINE:594		inc     dword ptr [i]       
LINE:594		jmp     short label16       

LINE:595:lable14		mov     edx,0001            
LINE:595		mov     eax,[i]             
LINE:595		call    R_DrawBlockLine_    
LINE:595		jmp     short label17       

LINE:596:lable15		mov     esp,ebp             
LINE:596		pop     ebp                 
LINE:596		pop     edi                 
LINE:596		pop     esi                 
LINE:596		pop     edx                 
LINE:596		pop     ecx                 
LINE:596		pop     ebx                 
LINE:596		ret                         
}

VOID R_UnloadMap( VOID )
{
/*-08*/ maptexture_t *tex;
/*-04*/ SIGNED LONG i;

LINE:609		push    0024                
LINE:609		call    __CHK               
LINE:609		push    ebx                 
LINE:609		push    ecx                 
LINE:609		push    edx                 
LINE:609		push    esi                 
LINE:609		push    edi                 
LINE:609		push    ebp                 
LINE:609		mov     ebp,esp             
LINE:609		sub     esp,0008            

LINE:618		mov     eax,[_basetextures] 
LINE:618		mov     [i],eax             
LINE:618:lable2		mov     eax,[i]             
LINE:618		cmp     eax,[_numtextures]  
LINE:618		jl      label0              
LINE:618		jmp     short label1        
LINE:618:lable4		mov     eax,[i]             
LINE:618		inc     dword ptr [i]       
LINE:618		jmp     short label2        

LINE:620:lable0		mov     edx,[i]             
LINE:620		shl     edx,002h            
LINE:620		mov     eax,[_texturelookup] 
LINE:620		add     eax,edx             
LINE:620		mov     eax,[eax]           
LINE:620		mov     [tex],eax           

LINE:621		mov     eax,[tex]           
LINE:621		cmp     dword ptr [eax+00010h],00000h 
LINE:621		je      label3              

LINE:622		mov     eax,[tex]           
LINE:622		add     eax,00010h          
LINE:622		call    Z_CacheFree_        
LINE:622:lable3		jmp     short label4        

LINE:624:lable1		mov     eax,[_basetextures] 
LINE:624		mov     [_numtextures],eax  

LINE:629		mov     dword ptr [_nummapflats],0000 

LINE:630		mov     dword ptr [_numpoints],0000 

LINE:631		mov     dword ptr [_numlines],0000 

LINE:632		mov     dword ptr [_numsides],0000 

LINE:633		mov     dword ptr [_numsectors],0000 

LINE:635		mov     dword ptr [_maploaded],0000 

LINE:636		mov     esp,ebp             
LINE:636		pop     ebp                 
LINE:636		pop     edi                 
LINE:636		pop     esi                 
LINE:636		pop     edx                 
LINE:636		pop     ecx                 
LINE:636		pop     ebx                 
LINE:636		ret                         
}

VOID R_LoadMap( SIGNED BYTE char *)
/*-08*/ SIGNED BYTE char *name;
{
/*-04*/ SIGNED LONG maplump;

LINE:652		push    0024                
LINE:652		call    __CHK               
LINE:652		push    ebx                 
LINE:652		push    ecx                 
LINE:652		push    edx                 
LINE:652		push    esi                 
LINE:652		push    edi                 
LINE:652		push    ebp                 
LINE:652		mov     ebp,esp             
LINE:652		sub     esp,0008            
LINE:652		mov     [name],eax          

LINE:656		cmp     dword ptr [_maploaded],00000h 
LINE:656		je      label0              

LINE:657		call    R_UnloadMap_        

LINE:659:lable0		mov     eax,[name]          
LINE:659		call    W_GetNumForName_    
LINE:659		mov     [maplump],eax       

LINE:661		mov     eax,[maplump]       
LINE:661		call    R_LoadMapPlanes_    

LINE:662		mov     eax,[maplump]       
LINE:662		call    R_LoadMapPoints_    

LINE:663		mov     eax,[maplump]       
LINE:663		call    R_LoadMapLines_     

LINE:664		mov     eax,[maplump]       
LINE:664		call    R_LoadMapSectors_   

LINE:665		call    R_InitBlockMap_     

LINE:666		mov     eax,[maplump]       
LINE:666		call    R_LoadMapThings_    

LINE:668		call    P_SpawnSpecialSectors_ 

LINE:670		mov     dword ptr [_extralight],0000 

LINE:671		mov     dword ptr [_maploaded],0001 

LINE:672		mov     esp,ebp             
LINE:672		pop     ebp                 
LINE:672		pop     edi                 
LINE:672		pop     esi                 
LINE:672		pop     edx                 
LINE:672		pop     ecx                 
LINE:672		pop     ebx                 
LINE:672		ret                         
}
