(****************************************************************************

                                 TETRIS

                                                               e
     aa , b : 1994.12.5~  1994.12.23
     a ša b  : 1994.12.15~ 1994.12.23
     aw a   : Borland Pascal with Objects 7.0
     a З ŉw  : IBM PC/AT ws, VGAѡ aa
                       ADLIB CARD (OPTION)
 ****************************************************************************)

{$A+,B-,D+,E-,G+,I+,L-,N-,Q-,R-,S+,T-,V+,X+}

program TETRIS_4_YYH;

uses SHanGul, GameKbd, Adlib, Crt;

type
  Box = object
    OPointX, OPointY : integer;
    TypeOfBox        : integer;
    procedure SetOPoint(x, y : integer);
    procedure SetTypeOfBox(TOB : integer);
    procedure DrawBox(x, y : integer);
  end;

  Blocks = object(Box)
    PosX, PosY   : integer;
    TypeOfBlock,
    ShapeOfBlock : byte;
    procedure FillBlock;
    function  GetMapOfNextBlock : word;
    procedure NextShape;
    function  GetMapOfBlock   : word;
    procedure SetTypeOfBlock(TOB : byte);
    function  GetShapeOfBlock : integer;
    procedure SetBlockXY(x, y : integer);
    procedure DrawBlock;
    procedure ClearBlock;
    procedure Rotate;
    procedure MoveDown;
    procedure MoveLeft;
    procedure MoveRight;
  end;

  Board = object(Blocks)
    TLx, TLy          : integer;
    BackBlocks        : array[-3..19, 0..9] of byte;
    NextBlock         : integer;
    Score             : longint;
    SCBX, SCBY        : integer;
    LeBX, LeBY        : integer;
    NBX, NBY          : integer;
    Living            : boolean;
    LineStatus        : array[0..19] of boolean;
    NextBoardVisible  : boolean;
    MiniBlockVisible  : boolean;
    LineLeft, Level   : integer;
    procedure PutGameOver;
    procedure PutLevelUp;
    function  GetMask(x, y : integer) : word;
    procedure SetTopLeftXY(x, y : integer);
    procedure DrawBoard;
    procedure PutBlockToBoard;
    procedure NewBlock;
    procedure SetNextBlock;
    procedure LineDestruction(y : integer);
    procedure LineCheck;
    procedure RedrawLine(i : integer);
    procedure ClearLine(i : integer);
    function  LineFilled(i : integer) : boolean;
    function  GameOver   : boolean;
    function  LevelSpeed : integer;
    procedure MBlkVisible(b : boolean);
    procedure DrawNextBoard(x, y : integer);
    procedure DrawNextBlock;
    procedure DrawScoreBoard(x, y : integer);
    procedure IncreaseScore(l : longint);
    procedure DrawlevelBoard(x, y : integer);
    procedure IncreaseLevel;
  end;

  Events = object(Board)
    RotateKey, LeftKey,
    RightKey, DownKey      : byte;
    BeforeTime             : word;
    RoKP, LeKP, RiKP, DoKP : boolean;
    DownCount              : integer;
    BeforeDownTime,
    BeforeLeftTime,
    BeforeRightTime        : word;
    FirstLeft,
    FirstRight             : boolean;
    DestructionStartTime   : word;
    DestructionVisibleTime : word;
    DestructionVisible     : boolean;
    DestructionFirst       : boolean;
    GameOverFirst          : boolean;
    LevelUpFirst           : boolean;
    LevelClearing          : boolean;
    NowProcessing          : 1..4;
    constructor RegisterKey(RoK, LeK, RiK, DoK : byte);
    destructor  Done;
    procedure   NPKeyProcess;
    procedure   NPLineDestroy;
    procedure   NPLevelUp;
    procedure   NPGameOver;
    function    TimeCheck  : word;
    function    PassedTime(bt : word) : word;
    function    MovingTime(b : boolean) : integer;
    procedure   Process;
  end;

  Proc = procedure;

  Musics = object
    SongNumber : integer;
    procedure   SetSongNumber(i : integer);
    procedure   ReadSong;
    procedure   Process(p : proc);
  end;

(***************************  Methods of Box  *******************************)

procedure Box.SetOPoint(x, y : integer);
begin
  OPointX := x;
  OPointY := y
end;

procedure Box.SetTypeOfBox(TOB : integer);
begin
  TypeOfBox := TOB
end;

procedure Box.DrawBox(x, y : integer);
var
  x1, y1 : integer;
begin
  if y < 0 then exit;
  x1 := OPointX + x * 20;
  y1 := OPointY + y * 20;
  if TypeOfBox = 0 then FillBox(x1, y1, x1 + 20, y1 + 19, 0)
    else ShBar(x1, y1, x1 + 19, y1 + 19, TypeOfBox)
end;

(**************************  Methods of Blocks  *****************************)

procedure Blocks.SetTypeOfBlock(TOB : byte);
begin
  TypeOfBlock := TOB;
  ShapeOfBlock := 0
end;

function Blocks.GetMapOfBlock : word;
const
  BlockMap  : array[1..7, 0..3] of word =
            (($8E00, $6440, $0E20, $44C0), ($2E00, $4460, $0E80, $C440),
             ($4E00, $4640, $0E40, $4C40), ($C600, $4C80, $C600, $4C80),
             ($6C00, $8C40, $6C00, $8C40), ($4444, $0F00, $4444, $0F00),
             ($CC00, $CC00, $CC00, $CC00));
begin
  GetMapOfBlock := BlockMap[TypeOfBlock, ShapeOfBlock]
end;

function Blocks.GetShapeOfBlock : integer;
const
  BlockShapeMap : array[1..7] of integer = (1, 8, 6, 5, 2, 4, 13);
begin
  GetShapeOfBlock := BlockShapeMap[TypeOfBlock]
end;

procedure Blocks.SetBlockXY(x, y : integer);
begin
  PosX := x;
  PosY := y
end;

procedure Blocks.FillBlock;
var
  lx, ly : integer;
  CD     : byte;
begin
  for ly := 0 to 3 do begin
    CD := GetMapOfBlock shr ((3 - ly) shl 2);
    for lx := 0 to 3 do
      if (8 shr lx) and CD > 0 then DrawBox(PosX + lx, PosY + ly)
  end
end;

procedure Blocks.DrawBlock;
begin
  SetTypeOfBox(GetShapeOfBlock);
  FillBlock
end;

procedure Blocks.ClearBlock;
begin
  SetTypeOfBox(0);
  FillBlock
end;

procedure Blocks.NextShape;
begin
  if ShapeOfBlock = 0 then ShapeOfBlock := 3
    else dec(ShapeOfBlock)
end;

procedure Blocks.Rotate;
begin
  ClearBlock;
  NextShape;
  DrawBlock
end;

procedure Blocks.MoveDown;
begin
  ClearBlock;
  inc(PosY);
  DrawBlock
end;

procedure Blocks.MoveLeft;
begin
  ClearBlock;
  dec(PosX);
  DrawBlock
end;

procedure Blocks.MoveRight;
begin
  ClearBlock;
  inc(PosX);
  DrawBlock
end;

function Blocks.GetMapOfNextBlock : word;
var
  BSofBlock : integer;
begin
  BSofBlock := ShapeOfBlock;
  NextShape;
  GetMapOfNextBlock := GetMapOfBlock;
  ShapeOfBlock := BSofBlock
end;


(*************************  Methods of Board  *******************************)

procedure Board.SetTopLeftXY(x, y : integer);
begin
  TLx := x;
  TLy := y;
  SetOPoint(x + 6, y + 5)
end;


procedure Board.SetNextBlock;
begin
  NextBlock := Random(7) + 1
end;

procedure Board.DrawBoard;
var
  t : integer;
begin
  FillChar(BackBlocks, sizeof(BackBlocks), 0);
  SetNextBlock;
  Living           := true;
  NextBoardVisible := false;
  MiniBlockVisible := false;
  NBX              := 0;
  NBY              := 0;
  Level            := 1;
  LineLeft         := 15;
  FillBox(TLx, TLy, TLx + 210, TLy + 410, 0);
  HLine(TLx      , TLx + 210, TLy      , 15);
  VLine(TLx      , TLy      , TLy + 410, 15);
  HLine(TLx +   4, TLx + 206, TLy + 406, 15);
  VLine(TLx + 206, TLy +   4, TLy + 406, 15);
  HLine(TLx      , TLx + 210, TLy + 410,  0);
  VLine(TLx + 210, TLy      , TLy + 410,  0);
  HLine(TLx +   4, TLx + 206, TLy +   4,  8);
  VLine(TLx +   4, TLy +   4, TLy + 206,  8);
  shangul.Box(TLx + 1, TLy + 1, TLx + 210 - 1, TLy + 410 - 1, 7);
  shangul.Box(TLx + 2, TLy + 2, TLx + 210 - 2, TLy + 410 - 2, 7);
  shangul.Box(TLx + 3, TLy + 3, TLx + 210 - 3, TLy + 410 - 3, 7);
  PosY := 19;
  NewBlock
end;

procedure _GO1; external; {$L GO1}
procedure _GO2; external; {$L GO2}
procedure _LU1; external; {$L LU1}

procedure Board.PutGameOver;
begin
  PutBGIImgLoc(TLx + 26, TLy + 180, @_GO2^, LocAnd);
  PutBGIImgLoc(TLx + 26, TLy + 180, @_GO1^, LocOr)
end;

procedure Board.PutLevelUp;
begin
  PutBGIImg(TLx + 26, TLy + 180, @_LU1^)
end;


procedure Board.PutBlockToBoard;
var
  tx, ty : integer;
  t      : integer;
  w      : word;
begin
  w := GetMapOfBlock;
  for ty := 3 downto 0 do begin
    t := w and $F;
    w := w shr 4;
    for tx := 0 to 3 do
      if ((PosX + tx) in [0..9]) and ((PosY + ty + 3) in [0..22]) then
        if (8 shr tx) and t > 0 then
          BackBlocks[PosY + ty, PosX + tx] := GetShapeOfBlock
  end
end;

procedure Board.NewBlock;
begin
  Living := PosY >= 0;
  if not Living then exit;
  SetTypeOfBlock(NextBlock);
  if NextBlock = 6 then SetBlockXY(3, -4) else SetBlockXY(3, -2);
  SetNextBlock;
  DrawNextBlock;
  DrawBlock
end;

procedure Board.LineDestruction(y : integer);
begin
  move(BackBlocks[0], BackBlocks[1], y * 10)
end;

procedure Board.LineCheck;
var
  i, k : integer;
begin
  FillChar(LineStatus, SizeOf(LineStatus), ord(true));
  for i := 0 to 19 do for k := 0 to 9 do
    if BackBlocks[i, k] = 0 then LineStatus[i] := false
end;

procedure Board.RedrawLine(i : integer);
var
  x : integer;
begin
  for x := 0 to 9 do begin
    SetTypeOfBox(BackBlocks[i, x]);
    DrawBox(x, i)
  end
end;

procedure Board.ClearLine(i : integer);
var
  x1, y1 : integer;
begin
  x1 := OPointX;
  y1 := OPointY + i * 20;
  ShadeBox(x1, y1 , x1 + 200, y1 + 19, 0)
end;

function Board.LineFilled(i : integer) : boolean;
begin
  LineFilled := LineStatus[i]
end;

function Board.GetMask(x, y : integer) : word;
var
  tx, ty : byte;
  tb     : byte;
  w      : word;
begin
  w := 0;
  for ty := 0 to 3 do begin
    tb := 0;
    for tx := 0 to 3 do
      if (BackBlocks[y + ty, x + tx] > 0) or
         (not((x + tx) in [0..9])) or (not((y + ty + 3) in [0..22])) then
         tb := tb or (8 shr tx);
    w := w shl 4;
    w := w or tb
  end;
  GetMask := w
end;

function Board.GameOver : boolean;
begin
  GameOver := not Living
end;

procedure Board.DrawScoreBoard(x, y : integer);
begin
  SCBX := x;
  SCBY := y;
  ShBar(SCBX + 1, SCBY + 1, SCBX + 150 - 1, SCBY + 23 - 1, 1);
  shangul.Box(SCBX, SCBY, SCBX + 150, SCBY + 23, 0);
  BColor := 1;
  PutHan(SCBX + 15, SCBY + 3, 'Score :   0');
  Score := 0;
end;

procedure Board.IncreaseScore(l : longint);
var
  s : string;
begin
  inc(Score, l);
  str(Score, s);
  BColor := 1;
  PutHan(SCBX + 88, SCBY + 3, s);
end;

procedure Board.DrawLevelBoard(x, y : integer);
begin
  LeBX    := x;
  LeBY    := y;
  BColor := 7;
  shangul.Box(LeBX, LeBY, LeBX + 150, LeBY + 23, 0);
  ShBar(LeBX + 1, LeBY + 1, LeBX + 150 - 1, LeBY + 23 - 1, 7);
  PutHan(LeBX + 15, LeBY + 3, 'Level :   1');
end;

procedure Board.IncreaseLevel;
var
  s : string;
begin
  BColor := 7;
  inc(Level);
  Lineleft := 15;
  str(Level, s);
  PutHan(LeBX + 90, LeBY + 3, ' ' + s + ' ');
end;

procedure Board.DrawNextBoard(x, y : integer);
begin
  NBX := x;
  NBY := y;
  NextBoardVisible := true;
  shangul.Box(NBX, NBY, NBX + 100, NBY + 80, 0);
  ShBar(NBX + 1, NBY + 1, NBX + 100 - 1, NBY + 80 - 1, 0);
  Bcolor := 0;
  PutHan(NBX + 8, NBY + 4, 'NEXT BLOCK');
end;

procedure Board.MBlkVisible(b : boolean);
begin
  MiniBlockVisible := b
end;

procedure mblk1; external; {$L mblk1}
procedure mblk2; external; {$L mblk2}
procedure mblk3; external; {$L mblk3}
procedure mblk4; external; {$L mblk4}
procedure mblk5; external; {$L mblk5}
procedure mblk6; external; {$L mblk6}
procedure mblk7; external; {$L mblk7}

procedure Board.DrawNextBlock;
var
  BeforeOPointX, BeforeOPointY : integer;
  BeforeTypeOfBlock ,
  BeforeShapeOfBlock           : integer;
  BeforePosX   , BeforePosY    : integer;
  MiniBlock                    : pointer;
begin
  if NextBoardVisible then begin
    BeforeOPointX      := OPointX;
    BeforeOPointY      := OPointY;
    BeforePosX         := PosX;
    BeforePosY         := PosY;
    BeforeTypeOfBlock  := TypeOfBlock;
    BeforeShapeOfBlock := ShapeOfBlock;
    SetOPoint(NBX + 2, NBY + 8);
    SetTypeOfBlock(NextBlock);
    if TypeOfBlock = 6 then begin
      ShapeOfBlock := 1;
      SetOPoint(NBX - 8, NBY)
    end;
    if TypeOfBlock = 7 then SetOPoint(NBX + 10, NBY + 8);
    FillBox(NBX + 7, NBY + 17, NBX + 93, NBY + 75, 0);
    SetBlockXY(1, 1);
    DrawBlock;
    OPointX := BeforeOPointX;
    OPointY := BeforeOPointY;
    ShapeOfBlock := BeforeShapeOfBlock;
    SetTypeOfBlock(BeforeTypeOfBlock);
    SetBlockXY(BeforePosX, BeforePosY)
  end else if MiniBlockVisible then begin
    case NextBlock of
      1 : MiniBlock := @mblk1;
      2 : MiniBlock := @mblk2;
      3 : MiniBlock := @mblk3;
      4 : MiniBlock := @mblk4;
      5 : MiniBlock := @mblk5;
      6 : MiniBlock := @mblk6;
      7 : MiniBlock := @mblk7
    end;
    FillBox(SCBX + 157, SCBY + 2, SCBX + 190, SCBY + 25, 8);
    PutBGIImg(SCBX + 157, SCBY + 2, MiniBlock^)
  end
end;


function Board.LevelSpeed : integer;
const
  SpeedData : array[1..20] of integer =
    (50, 45, 40, 35, 33, 31, 29, 27, 25, 23,
     21, 19, 17, 15, 13, 10,  8,  5,  2,  0);
begin
  LevelSpeed := SpeedData[Level]
end;

(*************************  Methods of Events  ******************************)

constructor Events.RegisterKey(RoK, LeK, RiK, DoK : byte);
begin
  NowProcessing    := 1;
  RotateKey        := Rok;
  LeftKey          := LeK;
  RightKey         := RiK;
  DownKey          := DoK;
  BeforeTime       := TimeCheck;
  DestructionFirst := true;
  GameOverFirst    := true;
  LevelUpFirst     := true;
  LevelClearing    := true;
  RoKP := GetKeyMap(RotateKey);
  LeKP := GetKeyMap(LeftKey);
  RiKP := GetKeyMap(RightKey);
  DoKP := GetKeyMap(DownKey)
end;

destructor Events.Done;
begin
end;

function Events.TimeCheck : word; assembler;
asm
  MOV AH, 2Ch               { 1/100  }
  INT 21h
  MOV AL, DL
end;

function Events.PassedTime(bt : word) : word;
var
  tc : word;
begin
  tc := TimeCheck;
  if bt <= tc then
    PassedTime := tc - bt
  else
    PassedTime := tc + 100 - bt
end;

procedure Events.NPKeyProcess;
begin
  if GetKeyMap(RotateKey) then begin
    if not RoKP then begin
      if GetMapOfNextBlock and GetMask(PosX, PosY) = 0 then Rotate;
      RoKP := true
    end
  end else RoKP := false;

  if GetKeyMap(LeftKey) then begin
    if not LeKP then begin
      FirstLeft := true;
      BeforeLeftTime := TimeCheck;
      if GetMapOfBlock and GetMask(PosX - 1, PosY) = 0 then MoveLeft;
      LeKP := true
    end else begin
      if PassedTime(BeforeLeftTime) > MovingTime(FirstLeft) then begin
        FirstLeft := false;
        BeforeLeftTime := TimeCheck;
        if GetMapOfBlock and GetMask(PosX - 1, PosY) = 0 then MoveLeft
      end
    end
  end else LeKP := false;

  if GetKeyMap(RightKey) then begin
    if not RiKP then begin
      FirstRight := true;
      BeforeRightTime := TimeCheck;
      if GetMapOfBlock and GetMask(PosX + 1, PosY) = 0 then MoveRight;
      RiKP := true
    end else begin
      if PassedTime(BeforeRightTime) > MovingTime(FirstRight) then begin
        FirstRight := false;
        BeforeRightTime := TimeCheck;
        if GetMapOfBlock and GetMask(PosX + 1, PosY) = 0 then MoveRight
      end
    end
  end else RiKP := false;
  if GetKeyMap(DownKey) then begin
    DoKP := true;
    DownCount := 0
  end else begin
    DoKP := false;
    DownCount := LevelSpeed
  end;

  if (PassedTime(BeforeTime) > DownCount) then begin
    BeforeTime := TimeCheck;
    if DoKP and (GetMapOfBlock and GetMask(PosX, PosY + 1) = 0) then begin
      MoveDown;
      BeforeDownTime := BeforeTime
    end;
    if DoKP and (GetMapOfBlock and GetMask(PosX, PosY + 1) = 0) then begin
      MoveDown;
      BeforeDownTime := BeforeTime
    end;
    if GetMapOfBlock and GetMask(PosX, PosY + 1) = 0 then begin
      MoveDown;
      BeforeDownTime := BeforeTime
    end else
      if DoKP then begin
        if PassedTime(BeforeDownTime) > 20 then NowProcessing := 2
      end else NowProcessing := 2
  end
end;

procedure Events.NPLineDestroy;
var
  i                 : integer;
  LineStatusChanged : boolean;
  LTBD              : longint;
begin
  if DestructionFirst then begin
    LineStatusChanged := false;
    PutBlockToBoard;
    LineCheck;
    for i := 0 to 19 do if LineFilled(i) then LineStatusChanged := true;
    DestructionStartTime := TimeCheck;
    DestructionFirst := false;
    DestructionVisible := false;
    DestructionVisibleTime := DestructionStartTime
  end;

  if PassedTime(DestructionVisibleTime) > 5 then begin
    for i := 0 to 19 do begin
      if LineFilled(i) then begin
        if DestructionVisible then RedrawLine(i)
          else ClearLine(i)
      end;
    end;
    DestructionVisibleTime := TimeCheck;
    DestructionVisible := not DestructionVisible;
  end;

  if (PassedTime(DestructionStartTime) > 30) or (not LineStatusChanged) then begin
    DestructionFirst := true;
    IncreaseScore(100);
    LTBD := 0;
    for i := 0 to 19 do if LineFilled(i) then Inc(LTBD);
    IncreaseScore(sqr(LTBD * 2) * 100);
    Dec(LineLeft, LTBD);
    if LineStatusChanged then begin
      for i := 0 to 19 do if LineFilled(i) then LineDestruction(i);
      for i := 0 to 19 do RedrawLine(i)
    end;
    NewBlock;
    if GameOver then NowProcessing := 4
      else if LineLeft < 1 then NowProcessing := 3
        else NowProcessing := 1
  end
end;

procedure Events.NPLevelUp;
var
  tx, ty : integer;
  ti     : integer;
begin
  if LevelUpFirst then begin
    FillChar(BackBlocks, SizeOf(BackBlocks), 0);
    FillBox(TLx + 6, TLy + 6, TLx + 205, TLy + 405, 0);
    DestructionStartTime   := TimeCheck;
    DestructionVisibleTime := DestructionStartTime;
    DestructionVisible     := true;
    LevelUpFirst           := false;
    LevelClearing          := true;
  end;
  if PassedTime(DestructionVisibleTime) > 20 then begin
    DestructionVisibleTime := TimeCheck;
    if DestructionVisible then PutLevelUp else
      FillBox(TLx + 26, TLy + 180, TLx + 190, TLy + 220, 0);
    DestructionVisible := not DestructionVisible
  end;
  if PassedTime(DestructionStartTime) > 90 then begin
    FillBox(TLx + 26, TLy + 180, TLx + 190, TLy + 220, 0);
    LevelUpFirst := true;
    for ty := 19 - (2 + trunc(Level * 0.5)) to 19 do begin
      for tx := 0 to 9 do begin
        ti := random(4);
        if ti = 0 then BackBlocks[ty, tx] := 0 else
          BackBlocks[ty, tx] := random(8);
      end;
      RedrawLine(ty);
    end;
    IncreaseLevel;
    NowProcessing := 1
  end
end;

procedure Events.NPGameOver;
begin
  if GameOverFirst then begin
    ShadeBox(TLx + 6, TLy + 6, TLx + 205, TLy + 405, 0);
    PutGameOver;
    GameOverFirst := false
  end
end;

procedure Events.Process;
begin
  case NowProcessing of
    1 : NPKeyProcess;
    2 : NPLineDestroy;
    3 : NPLevelUp;
    4 : NPGameOver
  end
end;

function Events.MovingTime(b : boolean) : integer;
begin
  if b then MovingTime := 12 else MovingTime := 4
end;

(**************************  Methods of Musics  *****************************)

procedure Musics.SetSongNumber(i : integer);
begin
  SongNumber := i
end;

procedure Musics.ReadSong;
const
  RolName : array[0..14] of string =
    ('Aria', 'C-Polka', 'Happy', 'JingBell', 'Jingle_2', 'cocktail',
     'neup', 'white', 'sim-for' , 'Boockboy', 'night', 'Tree3',
     'noelnoel', 'santa#', 'sim-elvi');
  BnkName : array[0..14] of string =
    ('standard', 'standard', 'standard', 'standard', 'standard', 'cocktail',
     'neup', 'white', 'sim-for', 'standard', 'standard', 'standard',
     'standard', 'standard', 'sim-elvi');
begin
  LoadBank(BnkName[Songnumber] + '.bnk');
  LoadSong(RolName[SongNumber] + '.rol');
end;

procedure Musics.Process(p : Proc);
begin
  repeat
    SetSongNumber(random(15));
    ReadSong;
    PlaySong(p);
  until QuitPlay
end;

(***************************  End of Methods  *******************************)

var
  UseAdlib      : boolean;                        { ADLIB CARD aw a }
  SaveExit      : pointer;
  BL            : array[1..3] of ^Events;
  Player        : 0..3;
  MS            : Musics;
  ch            : char;
  i             : integer;


function PlayerWantMusic : boolean;
begin
  InitSound;
  if Adlib_Error <> 0 then begin
    writeln('SOUND DRIVER not installed!');
    PlayerWantMusic := false;
    exit
  end;
  PlayerWantMusic := true
end;

procedure Init;
begin
  writeln(#10#13'* Tetris for YYH *                                          by hatemogi'#10#13);
  if not IsVga then begin                         { VGAa aw wA a }
    writeln('Sorry, This program requires VGA system.');
    halt
  end;
  UseAdlib := PlayerWantMusic;                    { ADLIB aw a     }
  SetHanFont(InternalHanFont);                    {  ei i aw }
  SetEngFont(InternalEngFont);                    {  w i aw }
  InitHan(VGA640);                                { VGA 640x480x16 mode }
  SetPalette(13, 49);
  Randomize;
  FColor := 15;
  WType := Shadow or BackGround;
  Player := 1;
end;

procedure Terminate; far;
begin
  ExitProc := SaveExit;
  CloseHan;
  for i := 1 to Player do dispose(BL[i], Done);
  writeln(#10#13'Thank you for playing this game.');
  writeln('MERRY CHRISTMAS & A HAPPY NEW YEAR!');
end;


(*procedure YTitle; external; { $L YTitle}*)

procedure PutTitle;
var
  p    : pointer;
  f    : file;
  size : word;
begin
  assign(f, 'ytitle.ico');
  reset(f, 1);
  size := filesize(f);
  getmem(p, size);
  blockread(f, p^, size);
  close(f);
  PutBGIImg(54, 140, p^);
  freemem(p, size)
end;

procedure Press; external; {$L Press}

procedure FirstScreen;
begin
  PutTitle;
  PutBGIImg(160, 430, @Press^);
  repeat
    PutPixel(random(MaxX), random(MaxY), random(6) + 10);
    delay(30);
  until keypressed;
  while keypressed do readkey;
end;

procedure CTitle; external; {$L CTitle}

procedure Select;
var
  sel : integer;
begin
  FillScreen(8);
  PutBGIImg(140, 100, @CTitle^);
  BColor := 8;
  PutHan(260, 330, 'Ȃ a !!');
  BColor := 1;
  ShBar(210, 177, 450, 200, 1);
  ShBar(210, 207, 450, 230, 1);
  ShBar(210, 237, 450, 260, 1);
  ShBar(210, 267, 450, 290, 1);
  PutHan(220, 180, '1. ѥa AA sa');
  FColor := 14;
  PutHan(244, 180, 'ѥa');
  FColor := 15;
  PutHan(220, 210, '2. w { sa');
  PutHan(220, 240, '3. Aw A sa');
  PutHan(220, 270, '4. a asa');
  BColor := 8;
  FColor := 7;
  PutHan(450, 450, 'Programmed by hatemogi');
  FColor := 15;
  repeat ch := UpCase(readkey) until ch in ['1'..'4', #27, 'Q'];
  sel := ord(ch) - ord('0');
  if sel in [1..3] then Player := sel
    else
      Player := 1;
      halt
    end;
    FillScreen(8);
end;

procedure ProcGameOver;
begin
  delay(500);
  while keypressed do readkey;
  ShBar(150, 180, 500, 230, 0);
  Shade(150, 180, 500, 230, 8);
  PutBGIImg(170, 183, @Press^);
  readkey;
  QuitPlay := true;
end;

procedure KbdCmd; far;
begin
  ch := #0;
  while keypressed do ch := readkey;
  for i := 1 to Player do BL[i]^.Process;
  case Player of
    1 : if BL[1]^.GameOver then ProcGameOver;
    2 : if BL[1]^.GameOver and BL[2]^.GameOver then ProcGameOver;
    3 : if BL[1]^.GameOver and BL[2]^.GameOver and BL[3]^.GameOver then ProcGameOver;
  end;
  case ch of
    ^[ : QuitPlay := true;
  end
end;

begin
  SaveExit := ExitProc;
  ExitProc := @Terminate;
  Init;
  FirstScreen;
  repeat
    QuitPlay := false;
    Select;
    case Player of
      1 : begin
            new(BL[1], RegisterKey($4C, $4B, $4D, $50));
            BL[1]^.SetTopLeftXY(300, 40);
            BL[1]^.DrawScoreBoard(100, 300);
            BL[1]^.DrawLevelBoard(100, 330);
            BL[1]^.DrawBoard;
            BL[1]^.DrawNextBoard (120, 200);
            BL[1]^.DrawNextBlock;
          end;
      2 : begin
            WType := Shadow;
            PutHan(250, 40, 'Left Player Status');
            PutHan(246, 260, 'Right Player Status');
            WType := Shadow or Background;
            new(BL[1], RegisterKey($1F, $1E, $20, $2D));
            new(BL[2], RegisterKey($4C, $4B, $4D, $50));
            BL[1]^.SetTopLeftXY(30, 35);
            BL[1]^.DrawScoreBoard(245, 160);
            BL[1]^.DrawLevelBoard(245, 190);
            BL[1]^.DrawBoard;
            BL[1]^.DrawNextBoard(270, 65);
            BL[1]^.DrawNextBlock;
            BL[2]^.SetTopLeftXY(400, 35);
            BL[2]^.DrawScoreBoard(245, 380);
            BL[2]^.DrawLevelBoard(245, 410);
            BL[2]^.DrawBoard;
            BL[2]^.DrawNextBoard(270, 285);
            BL[2]^.DrawNextBlock;
          end;
      3 : begin
            new(BL[1], RegisterKey($1F, $1E, $20, $2D));
            new(BL[2], RegisterKey($25, $24, $26, $33));
            new(BL[3], RegisterKey($4C, $4B, $4D, $50));
            BL[1]^.SetTopLeftXY(2, 35);
            BL[1]^.DrawBoard;
            BL[1]^.DrawScoreBoard(20, 5);
            BL[1]^.DrawLevelBoard(30, 448);
            BL[1]^.MBlkVisible(true);
            BL[1]^.DrawNextBlock;
            BL[2]^.SetTopLeftXY(215, 35);
            BL[2]^.DrawBoard;
            BL[2]^.DrawScoreBoard(235, 5);
            BL[2]^.DrawLevelBoard(245, 448);
            BL[2]^.MBlkVisible(true);
            BL[2]^.DrawNextBlock;
            BL[3]^.SetTopLeftXY(428, 35);
            BL[3]^.DrawBoard;
            BL[3]^.DrawScoreBoard(442, 5);
            BL[3]^.DrawLevelBoard(452, 448);
            BL[3]^.MBlkVisible(true);
            BL[3]^.DrawNextBlock;
          end
    end;
    if UseAdlib then MS.Process(KbdCmd)
      else repeat KbdCmd until QuitPlay;
    for i := 1 to Player do dispose(BL[i], Done)
  until 1 = 2
end.
