/*

	Xmode 320 * 200 256 color Pack mode
	Program By Lee Won Hee

	80286 instruction set
*/

#ifndef __LARGE__
#    error This library will not compile in this memory model.
#endif

#define	MUSIC		 "VISION.DAT"
#define	GRAPH		 "VISION.PIC"
#define	FONT		 "VISION.FNT"

#define	MAXX			 320
#define MAXY			 200
#define MAXCOLOR		 255

#define FADE_OUT         1
#define FADE_IN          0

#define D_DEC            1
#define D_INC            0

#define _ESC 		1
#define _1 			2
#define _2 			3
#define _3 			4
#define _4 			5

#define _5 		    6
#define _6 			7
#define _7 			8
#define _8 			9
#define _9 			10
#define _0 			11
#define _MINUS 	    12
#define _EQUAL   	13
#define _BACKSP 	14
#define _Q 			16
#define _W 			17
#define _E 			18
#define _R 			19
#define _T 			20
#define _Y 			21
#define _U 			22
#define _I 			23
#define _O 			24
#define _P 			25
#define _LPAREN 	26

#define _RPAREN 	27      /* ] */
#define _A 		 	30
#define _S 			31
#define _D 			32
#define _F 			33
#define _G 			34
#define _H 			35
#define _J 			36
#define _K 			37
#define _L 			38
#define _SEMI 		39       /*  ; */
#define _QUATO 		40       /*  ' */
#define _BSLASH 	43       /*  \ */
#define _Z 			44
#define _X 			45
#define _C 			46
#define _V 			47
#define _B 			48
#define _N 			49
#define _M 			50
#define _COMMA 	    51       /*  , */
#define _DOT 		52       /*  . */
#define _SLASH 		53       /*  / */
#define _SPACE 		57
#define _F1  		59
#define _F2  		60
#define _F3  		61
#define _F4  		62
#define _F5  		63
#define _F6  		64
#define _F7  		65
#define _F8  		66
#define _F9  		67
#define _F10 		68
#define _RET 		28
#define _TAB 		15
#define _LSHIFT 	42
#define _RSHIFT 	54
#define _LCTRL 		29
#define _RCTRL 		29
#define _LALT 		56
#define _RALT 		56
#define _NHOME 		71
#define _NPGUP 		73
#define _NEND  		79
#define _NPGDN 		81
#define _NINS  		82
#define _NDEL  		83
#define _NUMLOCK 	69
#define _CAPLOCK 	58
#define _SCRLOCK 	70
#define _UP    		72
#define _DOWN  		80
#define _LEFT  		75
#define _RIGHT 		77
#define _5_    		76

typedef unsigned char Byte;
typedef unsigned int  Word;
typedef unsigned long Dword;

typedef struct {
	Word 	x_size,y_size;
	Byte 	*data;
}SPRITE;

typedef struct {
	char *vptr;
	int  l;
}VOC;

extern Byte far *MCGA, *VPAGE1, *VPAGE2;
extern char m_install;
extern int  m_right, m_left, m_x, m_y;
extern int  XS_CLIP,XE_CLIP,YS_CLIP,YE_CLIP;
extern Byte _KEY[128];
extern Word _COUNT;

void Gray(int x,int y);
void PutPixel(int x,int y,Byte color);
Byte GetPixel(int x,int y);
void DrawHline(int x,int y,int len,Byte color);
void DrawVline(int x,int y,int len,Byte color);
void Bar(int x,int y,int xx,int yy,Byte color);
void DrawBox(int x,int y,int xx,int yy,Byte color);
void DrawGlassBox(int x,int y,int xx,int yy,Byte INCR);
void Circle(int x,int y,int r,Byte color);
void PutSpriteClip(int x,int y,SPRITE *sp_ptr);
void PutShadowSpriteClip(int x,int y,SPRITE *sp_ptr);
void PutSprite(int X,int Y,SPRITE *sp_ptr);
void PutImage(int X,int Y,SPRITE *sp_ptr);
void CopyPage(char far*dest,char far*scr);
void ClearDevice(char far *dest,Byte color);
void CutSprite(int Xp,int Yp,int SXp,int SYp,unsigned Xs,unsigned Ys,
			  char far *Addr,char far *Data);
void CutTile(int X,int Y,Word Xs,Word Ys,char far *Addr,char far*Data);
void CutTile2(int Xp,int Yp,int SXp,int SYp,Word Xs,Word Ys,
			  char far *Addr,char far*Data);
void Line(int x1, int y1, int x2, int y2, Byte color);
void SetClipping(int x,int y,int xx,int yy);
void GetRgb();
void SetRgb(int MODE ,int start,int end);

#ifdef __XGAME_PRJ
int  LoadPalette(long file);
#else
int  LoadPalette(char *file);
#endif
int  SavePalette(char *file);

void SetActPage(char *page);
Byte far *GetActPage();

void SetVideoMode(int	mode);
int  GetRandom(int min,int max);
void Fade(Byte Mode,int dac1,int dac2,Byte incr,Byte stc,Byte edc);
void RotatePalette(Byte start,Byte end,Byte direct);
int  GetImage(Word x,Word y,Word xe,Word ye,SPRITE	*sp);
void ScaleSpriteClip(int x,int y, int xs, int ys,SPRITE *sp);
void ScaleSprite(int x,int y, int xs, int ys,SPRITE *sp);
void ScaleShadowSpriteClip(int x,int y, int xs, int ys,SPRITE *sp);

void SetTextStyle(int i);
void PutHan(int x,int y,Byte color,char *st);
int  GetsEng(int x,int y,int c,int bc,int num,char *st);

#ifdef __XGAME_PRJ
void ImsPlay(long offset);
#else
void ImsPlay(char *file);
#endif
void ImsOff();

int  MouseInterrupt(int x);
void MouseInfo();
void MouseMoveCursor(int x,int y);
void MouseXyRange(int left,int right,int top,int bottom);
void MouseReleased();
int  MouseCrash(int x1,int y1,int x2,int y2);
void MouseCrashPoint(int x,int y);
void MouseShowCursor(SPRITE *ms);

#ifdef __XGAME_PRJ
int  ReadPcx(long p,long size,char *data,char opt);
#else
int  ReadPcx(char *name,char *data,char opt);
#endif

/*
	VECT
*/
void SystemDelay();
void Delay(int ha);
int  Kbhit();
int  GetKey();
int  GetKey2();
int  DelayKey(int d);

/*
	VOICE
*/

int  ReadVoiceFile(long file,unsigned l,VOC *voc);
void ReadSayVoc(long file,unsigned l);
int  SayVoc(char *file,unsigned l);

/*
	INITIALIZE
*/

void Initialize(char *fnt,char *pic,char *music,char *msg);
void SystemDown(char *msg,int ret);

/*
	XMS
*/
int  XmsVersion();
int  XmsSize ();
void XmsFree (int Handle);
int  XmsPut (char *buffer,Word size);
int  XmsSee (int handle,char *buffer,Word size);
int  XmsGet (int handle,char *buffer,Word size);