;*****************************************
;
;     a 13hw A b aa១
;                       Ver 4.2
;
;                 Aba:
;                         w 
;
;  A bi Ё ee aa១
; a 13h (320x200, 256) wa.
;
;*****************************************
IDEAL
include "game13h.inc"

  extrn case_time_out : proc


UDATASEG

  clock_div_high  dw ?
  clock_div_low   dw ?
  clock_mod       dw ?
  sound_delay     dw ?

  old_int_08 procedure <>


DATASEG

  user_routine_on db FALSE


CODESEG

;*******************************
;  a ai aa.
;  in : bx -- a a.
;*******************************
macro clock_rate
  mov al, 00110110b
  out 43h, al

  mov al, bl
  out 40h, al
  mov al, bh
  out 40h, al
endm


;***********************************
;   i ai ea.
;***********************************
proc new_int_08
  push ds es ax bx cx dx
  cli

  mov ax, DGROUP
  mov ds, ax

  mov ax, [clock_div_high]
  mov bx, [clock_div_low]
  add [clock_mod], bx
  adc ax, 0
  jz @@not_old_vector

  pushf
  call [dword old_int_08]
  jmp @@user_routine

 @@not_old_vector:
  mov al, 20h
  out 20h, al

 @@user_routine:
  dec [sound_delay]
  jnz @@exit

  _if_not_zero [user_routine_on], @@exit

 @@go_user:
  mov [user_routine_on], TRUE
  sti
  call case_time_out
  cli
  mov [user_routine_on], FALSE

  mov bx, [sound_delay]
  neg bx
  cmp bx, ax
  jb @@clock_delay_ok
  mov [sound_delay], 0
  jmp @@go_user

 @@clock_delay_ok:
  add [sound_delay], ax

 @@exit:
  pop dx cx bx ax es ds
  iret
endp


;********************************
;  w ai i  ea.
;     1.119 MHz / count
; voic set_clock_rate( word divid )
;********************************
proc set_clock_rate  divid:word
  pushf
  mov bx, [divid]

  mov [clock_div_low], bx
  mov [clock_div_high], 0
  cmp bx, 1
  adc [clock_div_high], 0

  clock_rate

  popf
  ret
endp
public set_clock_rate


;******************************
;  i ai aɩea.
; void clock_install(void)
;******************************
proc clock_install
  xor bx, bx
  clock_rate

  mov [clock_div_high], 1
  mov [clock_div_low], bx
  mov [clock_mod], bx

  mov [user_routine_on], FALSE    ; init flag

  push ds es
  mov ax, 3508h
  int 21h
  mov [old_int_08.reg_ip], bx
  mov [old_int_08.reg_cs], es

  mov ax, seg new_int_08
  mov ds, ax
  mov dx, offset new_int_08
  mov ax, 2508h
  int 21h
  pop es ds

  ret
endp
public clock_install


;******************************
;  a ai aea.
; void clock_uninstall(void)
;*******************************
proc clock_uninstall
  xor bx, bx
  clock_rate

  push ds
  mov ax, 2508h
  lds dx, [dword old_int_08]
  int 21h
  pop ds

  ret
endp
public clock_uninstall


;*******************************************
;  {i x Ё delayi aa aea.
;void start_time_out( word delay )
;*******************************************
proc start_time_out  delay:word
  pushf

  mov ax, [delay]
  mov [sound_delay], ax

  popf
  ret
endp
public start_time_out


END
