;
;
; MODEX2.ASM - ModeX graphics library by James Carter
; Version 1.0b April 13th, 1994
; Copyright (c) 1994 Side F/X productions.
;
;

    .386p
    .model flat,c
    locals
    jumps
    IDEAL

;
; GLOBALS
;

global  g_setModeX:proc
global  g_setTextMode:proc
global  g_setPalette:proc
global  g_scrollInit:proc
global  g_scrollDown:proc
global  g_flipPage:proc
global  g_putPic:proc

;
; EQUATES
;

o EQU OFFSET
s EQU SHORT

NumXmodes   =   4
NumYmodes   =   5

InputStatus1=   3dah
MISC_OUTPUT =   3c2h
READ_MISC   =   3cch
SC_Index    =   3c4h
CRTC_Index  =   3d4h
Graph_Index =   3ceh
Attr_Index  =   3c0h    ;don't forget to clear flipflop & set bit 5 on index
PEL_Write   =   3c8h
PEL_Read    =   3c7h
PEL_Data    =   3c9h

;
; MACROS
;

macro crtcout index,value ; CRTC index select and port.
; don't pass ax as either index or value
   push ax
   push dx
   mov dx,3d4h   ; CRTC port
   mov al,index
   out dx,al
   inc dx
   mov al,value
   out dx,al
   pop dx
   pop ax
endm

macro scout index,value ; sequencer index select and port.
; don't pass ax as either index or value
   push ax
   push dx
   mov dx,3c4h   ; sequencer port
   mov al,index
   out dx,al
   inc dx
   mov al,value
   out dx,al
   pop dx
   pop ax
endm

macro gcout index,value ; Graphics Controller index select and port.
; don't pass ax as either index or value
   push ax
   push dx
   mov dx,3ceh   ; graphics controller port
   mov al,index
   out dx,al
   inc dx
   mov al,value
   out dx,al
   pop dx
   pop ax
endm

macro waitforrt
local @@no_rt,@@n_rt
push dx
push ax
mov dx,3dah
@@no_rt:
      in al,dx
      test al,1000b
      jnz @@no_rt
@@n_rt:
      in al,dx
      test al,1000b
      jz @@n_rt
pop ax
pop dx
endm

macro waitforblank
local n_rt
push dx
push ax
mov dx,3dah
n_rt:
      in al,dx
      test al,1000b
      jz n_rt
pop ax
pop dx
endm

macro waitfordraw
local no_rt,n_rt
push dx
push ax
mov dx,3dah
@@n_rt:
      in al,dx
      test al,1000b
      jz @@n_rt
@@no_rt:
      in al,dx
      test al,1000b
      jnz @@no_rt
pop ax
pop dx
endm

;
; DATA
;
    dataseg

LABEL X320Y200 word
    db      00      ; 0e3h    ; dot clock
    db      02      ; Number of CRTC Registers to update
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode
    dw      320     ; width
    dw      200     ; height

LABEL X320Y240 word
    db      0e3h    ; dot clock
    db      10      ; Number of CRTC Registers to update
    dw      00d06h  ; vertical total
    dw      03e07h  ; overflow (bit 8 of vertical counts)
    dw      04109h  ; cell height (2 to double-scan)
    dw      0ea10h  ; v sync start
    dw      0ac11h  ; v sync end and protect cr0-cr7
    dw      0df12h  ; vertical displayed
    dw      00014h  ; turn off dword mode
    dw      0e715h  ; v blank start
    dw      00616h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      320     ; width
    dw      240     ; height

LABEL X360Y200 word
    db      0e7h    ; dot clock
    db      08      ; Number of CRTC Registers to update
    dw      06b00h  ; horz total
    dw      05901h  ; horz displayed
    dw      05a02h  ; start horz blanking
    dw      08e03h  ; end horz blanking
    dw      05e04h  ; start h sync
    dw      08a05h  ; end h sync
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode
    dw      360     ; width
    dw      200     ; height

LABEL X360Y240 word
    db      0e7h    ; dot clock
    db      16      ; Number of CRTC Registers to update
    dw      06b00h  ; horz total
    dw      05901h  ; horz displayed
    dw      05a02h  ; start horz blanking
    dw      08e03h  ; end horz blanking
    dw      05e04h  ; start h sync
    dw      08a05h  ; end h sync
    dw      00d06h  ; vertical total
    dw      03e07h  ; overflow (bit 8 of vertical counts)
    dw      04109h  ; cell height (2 to double-scan)
    dw      0ea10h  ; v sync start
    dw      0ac11h  ; v sync end and protect cr0-cr7
    dw      0df12h  ; vertical displayed
    dw      00014h  ; turn off dword mode
    dw      0e715h  ; v blank start
    dw      00616h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      360
    dw      240

LABEL X376Y282 word
    db      0e7h
    db      18
    dw      06e00h  ; horz total
    dw      05d01h  ; horz displayed
    dw      05e02h  ; start horz blanking
    dw      09103h  ; end horz blanking
    dw      06204h  ; start h sync
    dw      08f05h  ; end h sync
    dw      06206h  ; vertical total
    dw      0f007h  ; overflow
    dw      06109h  ; cell height
    dw      0310fh  ;
    dw      03710h  ; v sync start
    dw      08911h  ; v sync end and protect cr0-cr7
    dw      03312h  ; vertical displayed
    dw      02f13h  ; offset
    dw      00014h  ; turn off dword mode
    dw      03c15h  ; v blank start
    dw      05c16h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      376
    dw      564

LABEL X320Y400 word
    db      0e3h    ; dot clock
    db      03      ; Number of CRTC Registers to update
    dw      04009h  ; cell height
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode
    dw      320     ; width
    dw      400     ; height

LABEL X320Y480 word
    db      0e3h    ; dotclock
    db      10      ; Number of CRTC Registers to update
    dw      00d06h  ; vertical total
    dw      03e07h  ; overflow (bit 8 of vertical counts)
    dw      04009h  ; cell height (2 to double-scan)
    dw      0ea10h  ; v sync start
    dw      0ac11h  ; v sync end and protect cr0-cr7
    dw      0df12h  ; vertical displayed
    dw      00014h  ; turn off dword mode
    dw      0e715h  ; v blank start
    dw      00616h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      320     ; width
    dw      480     ; height

LABEL X360Y400 word
    db      0e7h    ; dot clock
    db      09      ; Number of CRTC Registers to update
    dw      06b00h  ; horz total
    dw      05901h  ; horz displayed
    dw      05a02h  ; start horz blanking
    dw      08e03h  ; end horz blanking
    dw      05e04h  ; start h sync
    dw      08a05h  ; end h sync
    dw      04009h  ; cell height
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode
    dw      360     ; width
    dw      400     ; height


LABEL X360Y480 word
    db      0e7h
    db      17
    dw      06b00h  ; horz total
    dw      05901h  ; horz displayed
    dw      05a02h  ; start horz blanking
    dw      08e03h  ; end horz blanking
    dw      05e04h  ; start h sync
    dw      08a05h  ; end h sync
    dw      00d06h  ; vertical total
    dw      03e07h  ; overflow
    dw      04009h  ; cell height
    dw      0ea10h  ; v sync start
    dw      0ac11h  ; v sync end and protect cr0-cr7
    dw      0df12h  ; vertical displayed
    dw      02d13h  ; offset
    dw      00014h  ; turn off dword mode
    dw      0e715h  ; v blank start
    dw      00616h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      360
    dw      480

LABEL X360Y360 word
    db      0e7h
    db      15
    dw      06b00h  ; horz total
    dw      05901h  ; horz displayed
    dw      05a02h  ; start horz blanking
    dw      08e03h  ; end horz blanking
    dw      05e04h  ; start h sync
    dw      08a05h  ; end h sync
    dw      04009h  ; cell height
    dw      08810h  ; v sync start
    dw      08511h  ; v sync end and protect cr0-cr7
    dw      06712h  ; vertical displayed
    dw      02d13h  ; offset
    dw      00014h  ; turn off dword mode
    dw      06d15h  ; v blank start
    dw      0ba16h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      360
    dw      360

LABEL X376Y308 word
    db      0e7h
    db      18
    dw      06e00h  ; horz total
    dw      05d01h  ; horz displayed
    dw      05e02h  ; start horz blanking
    dw      09103h  ; end horz blanking
    dw      06204h  ; start h sync
    dw      08f05h  ; end h sync
    dw      06206h  ; vertical total
    dw      00f07h  ; overflow
    dw      04009h  ;
    dw      0310fh  ;
    dw      03710h  ; v sync start
    dw      08911h  ; v sync end and protect cr0-cr7
    dw      03312h  ; vertical displayed
    dw      02f13h  ; offset
    dw      00014h  ; turn off dword mode
    dw      03c15h  ; v blank start
    dw      05c16h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      376
    dw      308

LABEL X376Y564 word
    db      0e7h
    db      18
    dw      06e00h  ; horz total
    dw      05d01h  ; horz displayed
    dw      05e02h  ; start horz blanking
    dw      09103h  ; end horz blanking
    dw      06204h  ; start h sync
    dw      08f05h  ; end h sync
    dw      06206h  ; vertical total
    dw      0f007h  ; overflow
    dw      06009h  ;
    dw      0310fh  ;
    dw      03710h  ; v sync start
    dw      08911h  ; v sync end and protect cr0-cr7
    dw      03312h  ; vertical displayed
    dw      02f13h  ; offset
    dw      00014h  ; turn off dword mode
    dw      03c15h  ; v blank start
    dw      05c16h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      376
    dw      564
    
LABEL X256Y240 word
    db      0e3h    ; dot clock
    db      16      ; Number of CRTC Registers to update
    dw      05f00h  ; horz total
    dw      03f01h  ; horz displayed
    dw      04202h  ; start horz blanking
    dw      09f03h  ; end horz blanking
    dw      04c04h  ; start h sync
    dw      00005h  ; end h sync
    dw      00d06h  ; vertical total
    dw      03e07h  ; overflow (bit 8 of vertical counts)
    dw      04109h  ; cell height (2 to double-scan)
    dw      0ea10h  ; v sync start
    dw      0ac11h  ; v sync end and protect cr0-cr7
    dw      0df12h  ; vertical displayed
    dw      00014h  ; turn off dword mode
    dw      0e715h  ; v blank start
    dw      00616h  ; v blank end
    dw      0e317h  ; turn on byte mode
    dw      256
    dw      240
    
LABEL X256Y200 word
    db      0e3h    ; dot clock
    db      8       ; Number of CRTC Registers to update
    dw      05f00h  ; horz total
    dw      03f01h  ; horz displayed
    dw      04202h  ; start horz blanking
    dw      09f03h  ; end horz blanking
    dw      04c04h  ; start h sync
    dw      00005h  ; end h sync
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode
    dw      256
    dw      200
    
LAST_X_MODE         =     13

LABEL ModeTable word    ; Mode X tweak table
    dd      offset X320Y200
    dd      offset X320Y240
    dd      offset X360Y200
    dd      offset X360Y240
    dd      offset X376Y282
    dd      offset X320Y400
    dd      offset X320Y480
    dd      offset X360Y400
    dd      offset X360Y480
    dd      offset X360Y360
    dd      offset X376Y308
    dd      offset X376Y564
    dd      offset X256Y240
    dd      offset x256y200

VGASeg      dd  0a0000h
ModeXScanLines  dw  0
ModeXWidth      dw  0
ModeXHeight     dw  0
_Mode       dw  0
_Scrw       dw  0

s_offset        dw      0
s_width         dw      0
s_height        dw      0
s_plane         db      0
s_size          dw      0

_page0addr  dw  0h
_page1addr  dw  (320*200)/4
_page2addr  dw  ((320*200)/4)*2
_page3addr  dw  ((320*200)/4)*3

page0addr   dw  0h
page1addr   dw  (320*200)/4
page2addr   dw  ((320*200)/4)*2
page3addr   dw  ((320*200)/4)*3

page0off    dw  0
page1off    dw  0
page2off    dw  0
page3off    dw  0

visiblePtr  dw  ((320*200)/4)*3
drawPtr     dw  ((320*200)/4)

;
; CODE
;
    codeseg

proc g_setModeX DaMode:word, DaWidth:word
    pushad

    mov ax,[DaMode]
    mov cx,[DaWidth]
    call _Set_X_Mode

    popad
    ret
endp

PROC _Set_X_Mode NEAR
    pushad

    cmp     ax,LAST_X_MODE      ; have we selected a valid mode?
    jle     @@ValidMode         ; Yes !

    popad
    mov     ax,-1               ; idiot.
    ret

@@ValidMode:
    mov     [_Mode],ax
    mov     [_Scrw],cx

    mov     ax,13h              ; let the BIOS set standard 256-color
    int     10h                 ;  mode (320x200 linear)
    
    mov     dx,SC_INDEX
    mov     ax,0604h
    out     dx,ax               ; disable chain4 mode
    mov     ax,0100h
    out     dx,ax               ; synchronous reset while setting Misc
                                ;  Output for safety, even though clock
                                ;  unchanged
    movzx   ebx,[_Mode]
    add     ebx,ebx
    add     ebx,ebx
    mov     esi,[ebx + o ModeTable]
    lodsb

    or      al,al
    jz      @@DontSetDot
    mov     dx,MISC_OUTPUT
    out     dx,al               ; select the dot clock and Horiz
                                ;  scanning rate
@@DontSetDot:
    mov     dx,SC_INDEX
    mov     ax,0300h
    out     dx,ax               ; undo reset (restart sequencer)

    mov     dx,CRTC_INDEX       ; reprogram the CRT Controller
    mov     al,11h              ; VSync End reg contains register write
    out     dx,al               ; protect bit
    inc     dx                  ; CRT Controller Data register
    in      al,dx               ; get current VSync End register setting
    and     al,07fh             ; remove write protect on various
    out     dx,al               ; CRTC registers
    dec     dx                  ; CRT Controller Index
    cld
    xor     cx,cx
    lodsb
    mov     cl,al

@@SetCRTParmsLoop:
    lodsw                       ; get the next CRT Index/Data pair
    out     dx,ax               ; set the next CRT Index/Data pair
    dec     cx
    jne     @@SetCRTParmsLoop

    lodsw
    mov     [ModeXWidth],ax
    lodsw
    mov     [ModeXHeight],ax
    cmp     ax,240
    jg      @@DontDouble
    add     ax,ax
@@DontDouble:
    mov     [ModeXScanLines],ax

    mov     dx,SC_INDEX
    mov     ax,0f02h
    out     dx,ax               ; enable writes to all four planes

    xor eax,eax
                                ; now clear all display memory, 8 pixels
    mov edi,0a0000h             ; at a time
                                  ; point ES:DI to display memory
                                  ; clear to zero-value pixels
    mov     cx,8000h            ; # of words in display memory
    rep     stosw               ; clear all of display memory
    
    ;  Mode X is set, now set the required logical page width.

    mov     cx,[_Scrw]
    shr     cx,3            ;divide by 8
    mov     dx,CRTC_INDEX
    mov     al,13h
    mov     ah,cl
    out     dx,ax

    popad
    xor     ax,ax
    ret
ENDP _Set_X_Mode

proc g_setTextMode
    pushad

    mov ax,3
    int 10h

    popad
    ret
endp

proc g_setPalette startreg:dword, numcolors:dword, paloff:dword
    pushad

    mov esi,[paloff]
    mov ecx,[numcolors]
    mov eax,[startreg]

    mov dx,cx
    add cx,cx
    add cx,dx
    mov dx,03c8h
    out dx,al
    inc dx
    cld
    rep outsb

    popad
    ret
endp


    
    ; Sets logical width of screen to whats in CX
    
    ; IN: AX = desired width
    ;
    ;OUT: AX = real width
    
PROC Set_Width NEAR
    push    dx
    shr     ax,3            ; divide by 8
    mov     ah,al           ; move value into AH
    mov     dx,CRTC_INDEX   ; get the PORT
    mov     al,13h          ; and the INDEX
    out     dx,ax           ; set it
    movzx   ax,ah           ; put value back in AX
    shl     ax,3            ; mult by 8
    pop     dx
    ret
ENDP
    
    ; Sets the MSL register.  It's the number of scan lines the
    ; data is repeated before advancing to the next data line. 
    ; (Char Height in TEXT mode.)
    
    ; IN: AH = Cell height
    ;
    ;OUT: AX is destoryed
    
PROC Set_CellHeight NEAR
    push    dx
    dec     ah              ;Cell height - 1
    mov     dx,CRTC_Index
    mov     al,9
    out     dx,al
    inc     dl
    in      al,dx
    and     al,11100000b
    or      al,ah
    out     dx,al
    pop     dx
    ret
ENDP
    
    ; Latches the planes to be read from/written to
    ;
    ; NOTE: After calling this routine once, you can set the latch by
    ;       doing an OUT to PORT SC_Index + 1 with the plane mask.
    ;       This works until SC_Index is changed.
    
    ; IN: AH = plane mask - bit 0 = plane 0, 1 = 1, etc.. upto 4
    ;
    ;OUT: AL is destroyed
    
PROC Latch_Planes NEAR
    push    dx
    mov     dx,SC_Index
    mov     al,2
    out     dx,ax
    pop     dx
    ret
ENDP
    
    ; Latches a plane for READ operation (only for READ MODE #0)
    
    ; IN: AH = plane to latch for read (0-3)
    ;
    ;OUT: AL is destroyed
    
PROC  Set_Read_Plane NEAR
    push    dx
    mov     dx,Graph_Index
    mov     al,4
    out     dx,ax
    pop     dx
    ret
    ENDP
    
    ; Sets WRITE mode (0-3)
    ;
    ; WM0:  Data from BUS goes to Video Memory (all latched planes)
    ;
    ; WM1:  Data is read into 32bit latch and written from 32bit latch
    ;       BUS data has no effect.  Allows data from all 4 planes to 
    ;       be moved from one place in VGA to another.
    ;
    ; WM2 & WM3:  Look them up.
    ;
    
    ; IN: AH = WRITE mode (0-3)
    ;
    ;OUT: AL is destroyed
    
PROC Set_Write_Mode NEAR
    push    dx
    mov     dx,Graph_Index
    mov     al,5
    out     dx,al
    inc     dx
    in      al,dx
    and     al,11111100b    ;clear out write mode bits
    or      al,ah
    out     dx,al
    pop     dx
    ret
ENDP
    
    ; Sets the READ mode
    ;
    ; RM0 = Normal one. Reads data.
    ;
    ; RM1 = Weird one. Reads results of comparison.
    
    ; IN: AH = read mode (0 or 1)
    ;
    ;OUT: AX is destroyed
    
PROC Set_Read_Mode NEAR
    push    dx
    mov     dx,Graph_Index
    mov     al,5
    out     dx,al
    inc     dx
    in      al,dx
    and     al,11110111b    ;clear out write mode bits
    shl     ah,3            ;move bit to correct position
    and     ah,00001000b
    or      al,ah
    out     dx,al
    pop     dx
    ret
ENDP
    
    ; Sets starting offset - useful for panning or using multiple pages.
    ;
    
    ; IN: BX = Offset
    ;
    ;OUT: AX is destoryed
    
PROC Set_Start_Offset NEAR
    push    dx
    mov     dx,CRTC_Index
    mov     al,0ch
    mov     ah,bh       ;write the HIGH byte
    out     dx,ax
    inc     al
    mov     ah,bl       ;write the LOW byte
    out     dx,ax
    pop     dx
    ret
ENDP
    
    ; Sets the pelpan value - useful for smooth sideways panning
    ;
    ; NOTE: DO NOT USE ODD VALUES except in text mode or 16 color mode
    ;
    
    ; IN: AH = pelpan value
    ;
    ;OUT: AL is destoryed
    
PROC Set_HPP NEAR
    push    dx
    mov     dx,InputStatus1
    in      al,dx           ;dummy input
    mov     dx,Attr_Index
    mov     al,33h
    out     dx,al
    mov     al,ah
    out     dx,al
    pop     dx
    ret
ENDP
    
    ; Sets pixel pan compatibility - makes it so the HPP value does not
    ;  alter the split screen.
    
PROC Set_PPC NEAR
    push    ax dx
    mov     dx,InputStatus1
    in      al,dx           ;dummy input
    mov     dx,Attr_Index
    mov     al,30h
    out     dx,al
    inc     dx
    in      al,dx
    dec     dx
    or      al,00100000b
    out     dx,al
    pop     dx ax
    ret
ENDP
    
    ; Sets the split screen scan line
    
    ; IN: BX = Scan line to set split at
    ;
    ;OUT: None
    
PROC Set_Split NEAR
    push    dx ax
    mov     al,18h
    mov     ah,bl
    mov     dx,CRTC_Index
    out     dx,ax       ;set bits 0-7

    mov     al,09h
    out     dx,al
    inc     dx
    in      al,dx
    mov     ah,bh
    and     ah,00000010b
    shl     ah,5
    and     al,10111111b
    or      al,ah
    out     dx,al       ;set bit 9

    dec     dx
    mov     al,07h
    out     dx,al
    inc     dx
    in      al,dx
    and     al,11101111b
    mov     ah,bh
    and     ah,00000001b
    shl     ah,4
    or      al,ah
    out     dx,al       ;set bit 8
    pop     ax dx
    ret
ENDP

proc g_flipPage
    pushad

    mov bx,[drawPtr]
    call Set_Start_Offset

    mov ax,[visiblePtr]
    xchg [drawPtr],ax
    mov [visiblePtr],ax
    waitforrt

    popad
    ret
endp

tList db 8 dup(0)

proc g_scrollInit
    pushad

    xor eax,eax
    xor ebx,ebx
    mov edi,0a0000h
    add di,[drawPtr]

    xor ebx,ebx
    mov bx,[visiblePtr]
    add ebx,0a0000h

    mov ah,1111b
    call Latch_Planes

    mov edi,0a0000h
    mov cx,(320*200)/4
    mov al,4
    rep stosb

    mov edi,0a0000h+(320*200)/4
    mov cx,(320*200)/4
    mov al,9
    rep stosb

    mov edi,0a0000h+((320*200)*2)/4
    mov cx,(320*200)/4
    mov al,4
    rep stosb

    mov edi,0a0000h+((320*200)*3)/4
    mov cx,(320*200)/4
    mov al,9
    rep stosb

    popad
    ret
endp

sValue dw ((320*200)/4)
scrolledLines db 0

proc g_scrollDown
    pushad

    sub [drawPtr],80
    sub [visiblePtr],80
    inc [scrolledLines]
    cmp [scrolledLines],200
    jne @@end

@@reset:
    mov ax,[_page1addr]
    mov [drawPtr],ax
    mov ax,[_page3addr]
    mov [visiblePtr],ax
    mov [scrolledLines],0
@@end:

    popad
    ret
endp

proc g_putPic xpos:dword, ypos:dword, picptr:dword
    pushad

    mov edi,0a0000h
    add di,[drawPtr]
    mov esi,[picptr]

    movzx eax,[ModeXWidth]
    mul [ypos]
    add eax,[xpos]
    add edi,eax

    lodsw
    mov [s_width],ax
    lodsw
    mov [s_height],ax

    mov ax,[s_width]
    mov bx,[ModeXWidth]
    shr bx,2
    sub bx,ax
    mov [s_offset],bx

    mov eax,[xpos]
    and al,3
    mov [s_plane],al

    mov dx,SC_Index
    mov al,02h
    out dx,al
    inc dx
    mov al,[s_plane]

    mov cx,4
@@nextplane:
;    push dx
    push cx
    push di

    mov bl,1
    mov cl,al
    shl bl,cl
    mov al,bl
    out dx,al

    mov cx,[s_height]
@@nextrow:
    push cx

    mov cx,[s_width]
@@nextcolumn:
    rep movsb

    movzx eax,[s_offset]
    add edi,eax

    pop cx
    loop @@nextrow

    pop di

    inc [s_plane]
    cmp [s_plane],3
    jg @@resetPlane
    jmp @@noReset

@@resetPlane:
    inc di
    mov [s_plane],0

@@noReset:
    mov al,[s_plane]
    pop cx
;    pop dx
    loop @@nextplane

    popad
    ret
endp

    end
