;
; gfx.asm - draw scopes in VGA 640x480x16 mode
;

ideal
p386
model   flat,c

MAXVOICES  equ 8

; NOTE: The voice table is an undocumented feature of TinyPlay V2.11 and
;       probably won't be supported in future releases. Check out the
;       source files to know more about this table.

global  MODVoiceTable:dword
global  setgraphmode:proc
global  settextmode:proc
global  drawscopes:proc

;
; DATA
;
dataseg

label rowtab dword
I=0
rept 256
dd  80*(50*I/256)
I=I+1
endm

udataseg

newscope        dd      MAXVOICES*256 dup (?)
oldscope        dd      MAXVOICES*256 dup (?)

;
; CODE
;
codeseg

;
; setgraphmode - setup the VGA 640x480x16 graphics mode
;
setgraphmode:
        pushad
        mov     ax,0012h
        int     10h
        mov     dx,3C0h
        xor     al,al
setgraphmodel0:
        out     dx,al
        out     dx,al
        inc     al
        cmp     al,10h
        jb      setgraphmodel0
        mov     al,20h
        out     dx,al
        popad
        ret

;
; settextmode - restore the VGA 80x25x16 text mode
;
settextmode:
        pushad
        mov     ax,0003h
        int     10h
        popad
        ret

;
; drawscopes - draw the track voices sample scopes
; In:
;  EAX = number of voices
;
drawscopes:
        pushad
        lea     esi,[MODVoiceTable]
        lea     ebx,[newscope]
        push    ecx
drawscopel1:
        push    ecx
        push    esi
        mov     edi,[esi+4*MAXVOICES]
        mov     esi,[esi]
        xor     eax,eax
        xor     ecx,ecx
drawscopel0:
        cmp     esi,edi
        jb      drawscopef0
        mov     al,80h
        jmp     drawscopef1
drawscopef0:
        mov     al,[esi]
        inc     esi
        xor     al,80h
drawscopef1:
        mov     edx,[rowtab+4*eax]
        mov     [ebx],edx
        add     ebx,4
        inc     cl
        jne     drawscopel0
        pop     esi
        pop     ecx
        add     esi,4
        loop    drawscopel1
        pop     ecx

        mov     dx,3C4h
        mov     ax,0802h
        out     dx,ax
        mov     dx,3CEh
        mov     al,08h
        out     dx,al
        inc     dx

        lea     esi,[newscope]
        lea     edi,[oldscope]
        mov     ebx,0A0645h
drawscopel4:
        push    ecx
        push    esi
        push    edi
        mov     al,80h
drawscopel2:
        push    eax
        push    ecx
        push    edx
        out     dx,al

        mov     ah,0FFh
        mov     ecx,32
drawscopel3:
        mov     edx,[edi]
        cmp     edx,[esi]
        je      drawscopef3
        xor     al,al
        xchg    al,[edx+ebx]
        mov     edx,[esi]
        mov     al,ah
        xchg    al,[edx+ebx]
        mov     [edi],edx
drawscopef3:
        add     esi,4*8
        add     edi,4*8
        inc     ebx
        loop    drawscopel3

        pop     edx
        pop     ecx
        pop     eax
        sub     esi,4*256-4
        sub     edi,4*256-4
        sub     ebx,32
        shr     al,1
        jne     drawscopel2
        pop     edi
        pop     esi
        pop     ecx
        add     esi,4*256
        add     edi,4*256
        add     ebx,38
        test    ecx,1
        je      drawscopef2
        add     ebx,80*80-2*38
drawscopef2:
        loop    drawscopel4
        popad
        ret

end
