#include <stdio.h>
#include <process.h>
#include <mem.h>
#include <string.h>
#include <stdarg.h>
#include <conio.h>

#define BGCOLOR	23

void graph_mode(int mode);
void read_font(void);
void put_8x10(int x,int y, char far *buf, int color);
void put_8x10_mc(int x,int y, char far *buf, int color);
void or_image(char *src,char *dest,int lens);
void htextxy( char cho, char jung, char jong, char color);
void put_5x9(int x,int y, char far *buf, int color);
void put_5x9_mc(int x,int y, char far *buf, int color);
void textxy( char text, char color );
void gputs( int x, int y, char color, char *st);
void gprintf( int x, int y, char color, char *fmt, ...);

const char hantable[3][32] =
{
      { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
        15,16,17,18,19,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 6, 7, 8, 9,10,11,
        0, 0,12,13,14,15,16,17, 0, 0,18,19,20,21, 0, 0 },
      { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
        15,16, 0,17,18,19,20,21,22,23,24,25,26,27, 0, 0 }
};

static char cho_tb_yes[] =
{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5 };

static char cho_tb_no[] =
{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0 };

static char jong_tb[] =
{ 0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0, 2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1 };

char first[8][20][10];    /*  */
char middle[4][22][10];   /*  */
char end[4][28][10];      /*  */
char english[128][9];     /* w */

char han_mem[10];
char eng_mem[9];

int _x=0, _y=0, b, font=0;

/* aϢ a  - ̂a */
void graph_mode(int mode)
{
    _asm {
        mov ax,mode
        int 10h
    }
}

/* i  */
void read_font(void)
{
    FILE *fp;

    if ( (fp = fopen( "8x10han.fnt", "rb" )) == NULL )
    {
		printf("\n\"8x10han.fnt\" is not found!\n");
		exit(0);
	}

	fread((void *)(first) , 1600, 1, fp);   /* 1600 = 8 x 20 x 10 */
	fread((void *)(middle), 880 , 1, fp);   /*  880 = 4 x 22 x 10 */
	fread((void *)(end)   , 1120, 1, fp);   /* 1120 = 4 x 28 x 10 */
	fclose(fp);                             /* 3600 = 1600 + 880 + 1120 */

	if ( (fp = fopen( "5x9eng.fnt", "rb" )) == NULL )
	{
		printf("\n\"5x9eng.fnt\" is not found!\n");
		exit(0);
	}

	fread((void *)(english), 1152, 1, fp);  /* 1152 = 128 x 9 */
	fclose(fp);
}

void put_8x10(int x,int y, char far *buf, int color)
{
	char far *dest = (char far *) 0x0a0000000;
	unsigned int start_di;

	_asm  push    ds
	_asm  push    si

	_asm  les     di, dest
	_asm  lds     si, buf

	_asm  mov     ax, 320
	_asm  mov     bx, y
	_asm  mul     bx
	_asm  add     ax, x
	_asm  add     di, ax
	_asm  mov     start_di, di

	_asm  mov     dx, color
	_asm  mov     bx, 10
y_loop:
	_asm  mov     cx, 8
	_asm  mov     al, byte ptr [si]
x_loop:
	_asm  shl     al, 1
	_asm  jnc     lp3
	_asm  mov     es:[di], dl
lp3:
	_asm  inc     di
	_asm  loop    x_loop

	_asm  add     start_di, 320
	_asm  mov     di, start_di
	_asm  inc     si

	_asm  dec     bx
	_asm  jnz     y_loop

done:
	_asm  pop     si
	_asm  pop     ds
}

/* e  aa waaaa ˡᝡ b */
void put_8x10_mc(int x,int y, char far *buf, int color)
{
	char far *dest = (char far *) 0x0a0000000;
	unsigned int start_di;

	_asm  push    ds
	_asm  push    si

	_asm  les     di, dest
	_asm  lds     si, buf

	_asm  mov     ax, 320
	_asm  mov     bx, y
	_asm  mul     bx
	_asm  add     ax, x
	_asm  add     di, ax
	_asm  mov     start_di, di

	_asm  mov     dx, color
	_asm  mov     bx, 10
y_loop:
	_asm  mov     cx, 8
	_asm  mov     al, byte ptr [si]
x_loop:
	_asm  shl     al, 1
	_asm  jnc     lp3
	_asm  mov     es:[di], dl
lp3:
	_asm  inc     di
	_asm  loop    x_loop

	_asm  add     start_di, 320
	_asm  mov     di, start_di
	_asm  inc	  dl
	_asm  inc     si

	_asm  dec     bx
	_asm  jnz     y_loop

done:
	_asm  pop     si
	_asm  pop     ds
}

void or_image(char *src,char *dest,int lens)
{
	int i;
	for ( i=0 ; i < lens ; i++ ) dest[i] |= src[i];
}

void htextxy( char cho, char jung, char jong, char color)
{
	int t1, t2, t3;
	int h1, h2, h3;

	h1 = hantable[0][cho];
	h2 = hantable[1][jung];
	h3 = hantable[2][jong];

	t1 = h3 ? cho_tb_yes[h2] : cho_tb_no[h2];
	t2 = ((h1 == 0 || h1 == 1 || h1 == 16) ? 0 : 1) + (h3 ? 2 : 0);
	t3 = jong_tb[h2];

	if (h1)  memcpy(han_mem, first[t1][h1], 10);
	else memset(han_mem, 0, 10);

	if (h2)  or_image( middle[t2][h2], han_mem, 10);
	if (h3)  or_image( end[t3][h3], han_mem, 10);

	/* aa bi Ё x+1, y+1 aA  ea iai a
	x, yaA a ˡᝡ iai  bea. */
	put_8x10( _x+1, _y+1, han_mem, BGCOLOR );
	put_8x10_mc( _x, _y, han_mem, color );
	_x+=9;
}

void put_5x9(int x,int y, char far *buf, int color)
{
	char far *dest = (char far *) 0x0a0000000;
	unsigned int start_di;

	_asm  push    ds
	_asm  push    si

	_asm  les     di, dest
	_asm  lds     si, buf

    _asm  mov     ax, 320
	_asm  mov     bx, y
	_asm  mul     bx
	_asm  add     ax, x
    _asm  add     di, ax
	_asm  mov     start_di, di

	_asm  mov     dx, color
	_asm  mov     bx, 9
y_loop:
	_asm  mov     cx, 5
	_asm  mov     al, byte ptr [si]
x_loop:
	_asm  shl     al, 1
	_asm  jnc     lp3
	_asm  mov     es:[di], dl
lp3:
    _asm  inc     di
	_asm  loop    x_loop

	_asm  add     start_di, 320
	_asm  mov     di, start_di
	_asm  inc     si

	_asm  dec     bx
	_asm  jnz     y_loop

done:
	_asm  pop     si
	_asm  pop     ds
}

/* ˡ */
void put_5x9_mc( int x, int y, char far *buf, int color )
{
	char far *dest = (char far *) 0x0a0000000;
	unsigned int start_di;

	_asm  push    ds
	_asm  push    si

	_asm  les     di, dest
	_asm  lds     si, buf

    _asm  mov     ax, 320
	_asm  mov     bx, y
	_asm  mul     bx
	_asm  add     ax, x
    _asm  add     di, ax
	_asm  mov     start_di, di

	_asm  mov     dx, color
	_asm  mov     bx, 9
y_loop:
	_asm  mov     cx, 5
	_asm  mov     al, byte ptr [si]
x_loop:
	_asm  shl     al, 1
	_asm  jnc     lp3
	_asm  mov     es:[di], dl
lp3:
    _asm  inc     di
	_asm  loop    x_loop

	_asm  add     start_di, 320
	_asm  inc	  dl
	_asm  mov     di, start_di
	_asm  inc     si

	_asm  dec     bx
	_asm  jnz     y_loop

done:
	_asm  pop     si
	_asm  pop     ds
}

void textxy( char text, char color )
{
	memset(eng_mem, 0, 9);
	memmove(eng_mem, english[text], 9);

	put_5x9( _x+1, _y+1, eng_mem, BGCOLOR);
	put_5x9_mc( _x, _y, eng_mem, color);
	_x +=6;
}

void gputs( int x, int y, char color, char *st)
{
	unsigned char data1, data2;
	unsigned char cho, jung,jong;
	int i;
	_x=x; _y=y;

	for( i=0; i < strlen(st) ; i++ )
	{
		data1 = *(st+i);
		if ( data1 > 127 )
		{
			i++;
			data2 = *(st+i);
			cho  = (data1 & 124) >> 2;
			jung = (data1 & 3) * 8 + (data2 >> 5);
			jong = (data2 & 31);
			htextxy( cho, jung, jong, color );
		}
		else { textxy( data1, color ); }
	}
}

/* printf  b͡i aAA Ёa. */
void gprintf( int x, int y, char color, char *fmt, ...)
{
	va_list  argptr;
	char  str[255];

	va_start(argptr, fmt);
	vsprintf(str, fmt, argptr);

	gputs(x, y, color, str);
}

void main()
{
	read_font();
	graph_mode(0x13);

	gprintf( 0, 0,75,"ewaAa, e Ea.");
	gprintf( 0,18,75,"aa? a eaa? AU..");
	gprintf( 0,30,75,"b˥e include ai g qЖsa.");
	gprintf( 0,42,75,"iӡ ee ie a wAe A asa.");
	gprintf( 0,53,75,"aw wⷥ we b RPGVa.  ˡa7");
	gprintf( 0,65,75,"ā a A w bAe i wwaa ee i");
	gprintf( 0,77,75,"aa. aq Ё a eA Ae aA eia");
	gprintf( 0,89,75,"bЖe ee ea. ia aaaai { e a");
    gprintf( 0,101,75,"a ge, a wi A Ae iie  ia");
    gprintf( 0,113,75,"aaA A A Aa.");
    gprintf( 0,125,75,"ai qA aa  bЁAa.");
    gprintf( 0,137,75,"a e ewӡ~~!!");
    gprintf( 0,149,75,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    gprintf( 0,161,75,"!@#$%^&*()_+|1234567890-=\[]{};':\",./<>?");

    getch();
    
	graph_mode(3);
	exit(1);
}
