        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include vrt.inc
include gnbg.inc
include sc.inc
include grfx.inc
include v.inc

public  _l1start

;
; DATA
;
align 4
routtbl         dd      p00,p10,p20,p30,p40,p60,p70,p80,p50,p90
                dd      p00,p20,p30,p40,p60,p50,p10,p80,p70,p90
                dd      p30,p40,p50,p60,p00,p80,p10,p20,p90,p70
ROUTTBLLEN=($-routtbl)/4
routtblindex    db      0

;
; CODE
;

include l1p0.m
include l1p1.m
include l1p2.m
include l1p3.m
include l1p4.m
include l1p5.m
include l1p6.m
include l1p7.m
include l1p8.m
include l1p9.m

;
setnext:
        movzx eax,routtblindex
        inc eax
        cmp al,ROUTTBLLEN
        jb short setnextf0
        xor eax,eax
setnextf0:
        mov ebx,routtbl[eax*4]
        cmp _l1stop,0
        je short setnextf1
        mov _l1stop,0
        mov _l1on,0
        mov ebx,offset _l1start
setnextf1:
        mov _l1rout,ebx
        mov routtblindex,al
        ret

;
_l1start:
        cmp _l1on,0
        je _ret
        mov _l1rout,offset p00
        ret

code32  ends
        end

