#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "3dtools.h"
#include "mode13h.h"


void main(int argc, char *argv[])
{
    FILE *inFile;
    int tempInt, vertices, faces, count, vNum, tempA, tempB, tempC;
    char tempChar;
    float tempX, tempY, tempZ;
    unsigned long tIn, tOut, *timer;
    int shades;

    if (argc < 2)
    {
        printf("USAGE:  showasc <filename.asc> <shading>\n");
        printf("\nshading:  0 = none; 1 = lambert; 2 = gouraud\n");
        exit(1);
    }

    if (argc > 2)
        shades = atoi(argv[2]);
    else
        shades = sGouraud;

    char *tempStr = new char [80];
    char *virtScreen = new char [64000];
    obj3d *test = new obj3d(0, 0, 4096);    // de obyect

    inFile = fopen(argv[1], "rt");
    if (inFile == NULL)
    {
        printf("%s does not exist!\n", argv[1]);
        printf("USAGE:  showasc <filename.asc>\n");
        exit(3);
    }

    while (strncmp(tempStr, "Vertices", 8))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &vertices);

    printf("Object has %d vertices\n", vertices);

    while (strncmp(tempStr, "Faces", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Faces\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &faces);

    printf("Object has %d faces\n", faces);

    // fseek(inFile, 0, SEEK_SET);

    while (strncmp(tempStr, "Vertex", 6))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

    while (strncmp(tempStr, "list:", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list:\" NOT FOUND!!\n");
            exit(2);
        }
    }



    printf("\nVertex data:\n");

    tempStr = "blah blah blah";

    for (count = 0; count < vertices; count++)
    {
        while (strncmp(tempStr, "Vertex", 6))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempX);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempY);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempZ);

        printf("Vertex %d:  %8d %8d %8d\n", vNum, (int) tempX, (int) tempY, (int) tempZ);
        test->addLocalPoint((int) tempX, (int) tempY, (int) tempZ);
    }

    while (strncmp(tempStr, "Face", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("\nFound string: %s\n", tempStr);

    while (strncmp(tempStr, "list", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    printf("\nFacial data:\n");

    for (count = 0; count < faces; count++)
    {
        while (strncmp(tempStr, "Face", 4))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);

        while (fgetc(inFile) != 'A');
        fgetc(inFile);                  // get the ':' character
        fscanf(inFile, "%d", &tempA);   // get value for vertex A

        while (fgetc(inFile) != 'B');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempB);

        while (fgetc(inFile) != 'C');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempC);

        printf("Face %d:  %8d %8d %8d\n", vNum, (int) tempA, (int) tempB, (int) tempC);
        test->addLocalPoly(tempA, tempB, tempC, 1);
    }

    initSinCos();

    setMode13h(virtScreen);

    for (count = 1; count < 18; count++)
        set_dac_register(count, 20 + count, 10 + count,
            20 + count);

    for (count = 0; count < test->numPolys; count++)
    {
        test->poly[count]->shading = shades;
        test->poly[count]->facing  = fOutside;
    }

    test->setGNormals();

    test->display();

    getch();

    setActivePage(pVirtual);

    timer = (unsigned long *) 0x046c;
    tIn = *timer;
    for (count = 1; (count <= 1000) && !kbhit(); count++)
    {
        test->localRotate(-2, 4, -6);
        clearScreen(0);
        test->display();
        flipVPage();
    }

	tOut = *timer;


	if (count < 1000)
        getch();


    textMode();

    printf("%f\n", (float) ((count * 18.2) / (tOut - tIn)));

    fclose(inFile);
    delete test;
    //delete tempStr;

    exit(0);
}

