/*   Protected Mode Hangul Output - Watcom C/C++ 10.0  Ext: DOS4GW

     Compile & Link: WCL386 HAN.C

                                 1995. 6. 20          by Tranks            */

#include <string.h>
#include <stdarg.h>
#include <mem.h>
#include <io.h>
#include <dos.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <graph.h>
#include <sys/stat.h>

#define OVERWRITE       0
#define OVERLAP         1

#define SVGA640_480     0
#define SVGA800_600     1
#define SVGA1024_768    2

#define hsetcolor(color)     { __COLOR = color; }
#define hsetbkcolor(back)    { __BACK = back; }
#define hsetoutputmode(mode) { __MODE = mode; }
#define _line(x, y, x1, y1)  _moveto(x, y); _lineto(x1, y1);

typedef unsigned char  U8;
typedef unsigned short U16;
typedef unsigned int   U32;

typedef void (*handler)(short);

enum { VESA, VIDEO7, PARADISE, CIRRUS, ATI, TSENG3,
       TSENG4, OAK, TRIDENT, CHIPS, GENOA, S3 };

void _PageVESA(short);
void _PageVideo7(short);
void _PageParadise(short);
void _PageCirrus(short);
void _PageATI(short);
void _PageTseng3(short);
void _PageTseng4(short);
void _PageOak(short);
void _PageTrident(short);
void _PageChips(short);
void _PageGenoa(short);
void _PageS3(short);

handler Set_Bank[12] = { _PageVESA,   _PageVideo7, _PageParadise,
                         _PageCirrus, _PageATI,    _PageTseng3,
                         _PageTseng4, _PageOak,    _PageTrident,
                         _PageChips,  _PageGenoa,  _PageS3 };

                         // Set bank procedures in Watcom Lib.....

U8 *VRAM = (U8 *)0xA0000;

U16 __COLOR = 15, __MODE = 0, __BACK = 0, XX, YY, Size = 0;


U16 Svga_Card = TSENG4;        // Your SVGA Chip setting......


const U8 table1[3][32] = { { 0, 0, 1, 2, 3, 4, 5, 6,
                            7, 8, 9, 10,11,12,13,14,
                            15,16,17,18,19, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0 } ,

                          { 0, 0, 0, 1, 2, 3, 4, 5,
                            0, 0, 6, 7, 8, 9,10,11,
                            0, 0,12,13,14,15,16,17,
                            0,0,18,19,20,21,0, 0, } ,

                          { 0, 0, 1, 2, 3, 4, 5, 6,
                            7, 8, 9,10,11,12,13,14,
                            15,16,0,17,18,19,20,21,
                            22,23,24,25,26,27,0, 0, }} ;

const U8 table2[2][20] = {{ 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
                              1, 1, 1, 1, 1, 1, 0, 1, 1, 1 } ,

                            { 0, 2, 3, 3, 3, 3, 3, 3, 3, 3,
                              3, 3, 3, 3, 3, 3, 2, 3, 3, 3 }} ;

const U8 table3[3][22] = { { 0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0,
                               2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1 } ,

                             { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3,
                               3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0 } ,

                             { 0, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7,
                               7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5 } } ;

U32 H_FONT[2880];
U32 E_FONT[1024];

U32 *ENG  = E_FONT;
U32 *CHO  = H_FONT;
U32 *JUNG = &H_FONT[1280];
U32 *JONG = &H_FONT[1984];

U32 Image[8];

void hsettextsize(short hsize)
{
    if(hsize < 1 || hsize > 2)  return;
    Size = hsize >> 1;
}

void Set_Palette_All(U8 *buffer)
{
        int i;

        outp(0x3c8, 0);
        for(i = 0; i < 768; i++)
                outp(0x3c9, buffer[i]);
}

/*void Set_Palette(U16 color, U16 R, U16 G, U16 B)
{
        outp(0x3c8, color);

        outp(0x3c9, R);
        outp(0x3c9, G);
        outp(0x3c9, B);
}

void Fill(int color)
{
        U32 i, size = XX*YY/4, bank = 0, address = 0, *VRAM_32 = (U32 *) VRAM;

        for(i = 0; i < size; i++, address++)
        {
                if(!(address == 16384))
                {
                        setbank(bank++, Svga_Card);
                        address = 0;
                }

                VRAM_32[address] = color;
        }
} */


void Read_Font(U8 *HanFont, U8 *EngFont)
{
        FILE *fp;

        if((fp = fopen(HanFont, "rb")) == NULL)
        {
                printf("\n'%s' file NOT found", HanFont);
                exit(0);
        }
        fread(H_FONT, 11520, 1, fp);
        fclose(fp);

        if((fp = fopen(EngFont, "rb")) == NULL)
        {
                printf("\n'%s' file NOT found", EngFont);
                exit(0);
        }
        fread(E_FONT, 4096, 1, fp);
        fclose(fp);

}

void Put_Pixel(int x, int y, char color)
{
        unsigned address = y * XX + x;
        int page = address >> 16;

        Set_Bank[Svga_Card](page);
        address &= 0xffff;

        *(VRAM + address) = color;
}

void han_make(U8 data1, U8 data2)
{
        int cho, jung, jong, b1, b2, b3, i, index;

        cho  = (data1 & 124) >> 2;
        jung = ((data1 & 3) << 3) + (data2 >> 5);
        jong = (data2 & 31);

        cho  = table1[0][cho];
        jung = table1[1][jung];
        jong = table1[2][jong];

        b3 = table3[0][jung];
        if(jong) {
                b2 = table2[1][cho];
                b1 = table3[2][jung];
        } else {
                b2 = table2[0][cho];
                b1 = table3[1][jung];
        }

        b1 = ((b1 << 2) + b1) << 5;
        cho <<= 3;
        b2 = ((b2 << 3) + (b2 << 1) + b2) << 4;
        jung <<= 3;
        b3 = ((b3 << 2) + (b3 << 1) + b3) << 5;
        jong <<= 3;

        if(cho) for(i = 0; i < 8; i++)  Image[i] = CHO[b1+cho+i];
        else    for(i = 0; i < 8; i++)  Image[i] = 0x00000000;

        if(jung) for(i = 0; i < 8; i++)  Image[i] |= JUNG[b2+jung+i];
        if(jong) for(i = 0; i < 8; i++)  Image[i] |= JONG[b3+jong+i];
}

void eng_make(int code)
{
        register i, j = code << 2;

        for(i = 0; i < 4; i++)
                Image[i] = ENG[j + i];
}

void h_putfont(int x, int y, int H, int V, void *buffer, int color)
{
        U8 *buf = (U8 *)buffer, a;
        int i, j, k = 8, l, s;
        U32 address;
        U16 page;

        a = *buf++;

        for(j = 0; j < V; j++) {
        for(i = 0; i < H; i++)
        {
                address = (y + (j << Size)) * XX + x + (i << Size);
                page = address >> 16;

                Set_Bank[Svga_Card](page);

                address &= 0xffff;

                if(a & 0x80)
                {
                    if(Size)
                    {
                        for(l = 0; l < 2; l++)
                        for(s = 0; s < 2; s++)
                                VRAM[address + l * XX + s] = color;
                    }
                    else VRAM[address] = color;
                }
                else if(!__MODE)
                     if(Size)
                     {
                        for(l = 0; l < 2; l++)
                        for(s = 0; s < 2; s++)
                                VRAM[address + l * XX + s] = __BACK;
                     }
                     else VRAM[address] = __BACK;

                a <<= 1;

                if(!--k) {
                        a = *buf++;
                        k = 8;
                }
        }

                if(k != 8) {
                        a = *buf++;
                        k = 8;
                }
        }
}

void _putsxy(int x, int y, U8 *s, int color)
{
        U8 ch;

        while((ch = *s++) != 0)
        {
                if(ch & 0x80)
                {
                        han_make(ch, *s);
                        h_putfont(x, y, 16, 16, Image, color);
                        if(!Size) x += 16;
                        else      x += 32;
                        if(!*s++) break;
                }
                else {
                        eng_make(ch);
                        h_putfont(x, y, 8, 16, Image, color);
                        if(!Size) x += 8;
                        else      x += 16;
                }
        }
}


void hanput(U16 x, U16 y, U8 *format, ... )
{
        va_list arg;
        U8 buffer[128];

        va_start(arg, format);
        vsprintf(buffer, format, arg);
        _putsxy(x, y, buffer, __COLOR);
        va_end(arg);
}

void _setmode(unsigned mode)
{
        union REGS r;

        r.x.eax = mode;
        int386(0x10, &r, &r);
}

void Init_Graph(short mode)
{
        switch(mode)
        {
                case 0: 
                        _setvideomode(0x101);
                        XX = 640; YY = 480;     break;
                case 1: 
                        _setvideomode(0x103);
                        XX = 800; YY = 600;     break;
                case 2: 
                        _setvideomode(0x105);
                        XX = 1024; YY = 768;    break;
        }
}

void Close_Graph(void)
{
        union REGS r;

        r.x.eax = 0x03;
        int386(0x10, &r, &r);
}

void main(void)
{
        U16 i, c = 0;

        Read_Font("HAN.FNT", "ENG.FNT");

        hsetoutputmode(OVERLAP);
        hsettextsize(1);

        Init_Graph(SVGA640_480);

        for(i = 0; i < 380; i += 4)
        {
            _setcolor(i % 256);
            _rectangle(0, i, i, i + 100, i + 100);
        }

        for(i = 0; i < 20;  i++)
        {
            hsetcolor(c++);
            hanput(0, i * 20 + 20, "%2d: ű Graphic  ei eq", c);
        }

        for(i = 0; i < 20;  i++)
        {
            hsetcolor(c++);
            hanput(320, i * 20 + 20, "%2d: ű Graphic  ei eq", c);
        }

        _line(100, 100, 200, 200);
        _settextcolor(14);
        _outtext("This is Watcom Graphics output !!");
        getch();
        Close_Graph();
}
