#include <stdio.h>
#include <mem.h>
#include <string.h>

#define	 UC 	        char
#define  E_STEP         0x8
#define  H_STEP         0x5

#ifdef __cplusplus
extern "C" {
#endif
 void _cdecl HEPUT(int x,int y,int color,char *image,char *tar,int style,char sy);
 void _cdecl EEPUT(int x,int y,int color,char *image,char *tar,int style,char sy);
#ifdef __cplusplus
}
#endif

char english[128][9]={
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0},{32,32,32,32,32,0,32,0,0},{80,80,0,0,0,0,0,0,0},{80,80,248,80,248,80,80,0,0},
{112,168,160,112,40,168,112,0,0},{200,208,16,32,64,88,152,0,0},{32,80,80,96,168,144,104,0,0},
{16,16,32,0,0,0,0,0,0},{16,32,64,64,64,32,16,0,0},{64,32,16,16,16,32,64,0,0},{0,144,96,240,96,144,0,0,0},
{0,32,32,248,32,32,0,0,0},{0,0,0,0,0,16,16,32,0},{0,0,0,248,0,0,0,0,0},{0,0,0,0,0,32,32,0,0},
{8,16,16,32,64,64,128,0,0},{112,136,152,168,200,136,112,0,0},{32,96,32,32,32,32,112,0,0},{112,136,8,16,32,64,248,0,0},
{112,136,8,112,8,136,112,0,0},{16,48,80,144,248,16,16,0,0},{248,128,240,8,8,136,112,0,0},{112,136,128,240,136,136,112,0,0},
{248,136,16,32,32,32,32,0,0},{112,136,112,136,136,136,112,0,0},{112,136,136,120,8,8,8,0,0},{0,16,16,0,16,16,0,0,0},
{0,16,16,0,16,16,32,0,0},{16,32,64,128,64,32,16,0,0},{0,0,112,0,112,0,0,0,0},{64,32,16,8,16,32,64,0,0},
{112,136,8,48,32,0,32,0,0},{112,136,152,184,176,128,120,0,0},{32,80,136,248,136,136,136,0,0},{224,144,240,136,136,136,240,0,0},
{112,136,128,128,128,136,112,0,0},{240,136,136,136,136,136,240,0,0},{248,128,128,248,128,128,248,0,0},{248,128,128,240,128,128,128,0,0},
{112,136,128,184,136,136,112,0,0},{136,136,136,248,136,136,136,0,0},{112,32,32,32,32,32,112,0,0},{112,32,32,32,32,160,64,0,0},
{136,144,160,192,160,144,136,0,0},{128,128,128,128,128,128,248,0,0},{136,216,168,168,136,136,136,0,0},{136,200,200,168,152,152,136,0,0},
{112,136,136,136,136,136,112,0,0},{240,136,136,240,128,128,128,0,0},{112,136,136,168,168,144,104,0,0},{240,136,136,240,160,144,136,0,0},
{112,136,128,112,8,136,112,0,0},{248,32,32,32,32,32,32,0,0},{136,136,136,136,136,136,112,0,0},{136,136,136,136,136,80,32,0,0},
{136,136,168,168,168,80,80,0,0},{136,136,80,32,80,136,136,0,0},{136,136,80,32,32,32,32,0,0},{248,8,16,32,64,128,248,0,0},
{112,64,64,64,64,64,112,0,0},{128,64,64,32,16,16,8,0,0},{112,16,16,16,16,16,112,0,0},{32,80,136,0,0,0,0,0,0},
{0,0,0,0,0,0,248,0,0},{32,32,16,0,0,0,0,0,0},{0,0,104,152,136,152,104,0,0},
{128,128,176,200,136,136,240,0,0},{0,0,112,136,128,136,112,0,0},{8,8,104,152,136,136,120,0,0},
{0,0,112,152,224,136,112,0,0},{16,40,32,112,32,32,32,0,0},{0,0,104,152,136,120,8,136,112},{128,128,176,200,136,136,136,0,0},
{0,32,0,32,32,32,32,0,0},{0,32,0,32,32,32,32,160,64},{128,128,144,160,192,160,144,0,0},{64,64,64,64,64,80,32,0,0},
{0,0,208,168,168,168,168,0,0},{0,0,176,200,136,136,136,0,0},{0,0,112,136,136,136,112,0,0},{0,0,176,200,136,240,128,128,128},
{0,0,104,152,136,120,8,8,8},{0,0,176,200,128,128,128,0,0},{0,0,112,128,112,8,240,0,0},{32,32,112,32,32,32,48,0,0},
{0,0,136,136,136,152,104,0,0},{0,0,136,136,80,80,32,0,0},{0,0,136,168,168,168,80,0,0},{0,0,136,80,32,80,136,0,0},
{0,0,136,136,80,32,32,64,128},{0,0,248,16,32,64,248,0,0},{48,64,64,192,64,64,48,0,0},
{32,32,32,0,32,32,32,0,0},{96,16,16,24,16,16,96,0,0},{104,144,0,0,0,0,0,0,0},{0,32,80,80,136,248,0,0,0}};

const char hantable[3][32]={
			   { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
			    15,16,17,18,19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			   { 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 6, 7, 8, 9,10,11,
			     0, 0,12,13,14,15,16,17, 0, 0,18,19,20,21, 0, 0},
			   { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,
			    14,15,16,0,17,18,19,20,21,22,23,24,25,26,27,0,0}
			    };

	static char cho_tb_yes[]={
	       0,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5
	       };

	static char cho_tb_no[]={
	       0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0
	       };

	static char jong_tb[]={
	       0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1
	       };

	/* font Array type */
    UC first   [  8][20][10];     /* han font [cho  sung] */
    UC mid     [  4][22][10];     /* han font [jung sung] */
    UC endtable[  4][28][10];     /* han font [jong sung] */

//    UC english [128][9];           /* English  font  array */

	unsigned char han_mem[10];            /* Hangul  memory type */


		 /*  ### void       List ### */

void read_font(UC *hanfile,UC xl)
{
    FILE *fp;

   fp = fopen(hanfile,"rb");
   if (fp == NULL) {
      printf(" Font Error   Error Code [ %s file not found\n]",&hanfile);
      exit(0);
   }
   if(xl==1) fseek(fp,10,SEEK_SET);
   fread(first   , 1600, 1, fp);   /* 1600 = 8 x 20 x 10 */
   fread(mid     , 880 , 1, fp);   /*  880 = 4 x 22 x 10 */
   fread(endtable, 1120, 1, fp);   /* 1120 = 4 x 28 x 10 */

   fclose(fp);
}

void hanxy(int x,int y,int color,UC *megs,UC *WHE,UC style)
{
    int i,_x = x;
    UC fchar, schar;
    UC cho, jung, jong;
    UC sy=10;

    if(y>190) sy=200-y;
   for ( i=0; i<strlen(megs); i++)
    {
	 fchar = *( megs + i);
	 if (fchar > 127) {
			   i++;
			   schar = *( megs + i);
			   cho  = (fchar & 124) >> 2;
			   jung = (fchar & 3) * 8 + (schar >> 5);
			   jong = (schar & 31);

			   Hput( cho, jung, jong);

			   HEPUT(_x,y,color,han_mem,WHE,style,sy);
	       _x+=9;
			  }
	  else {
		EEPUT(_x,y,color,english[fchar],WHE,style,sy-1);
		_x+=6;
	   }
     }
}


void Hput(UC cho,UC jung,UC jong)
{
  int t1,t2,t3;
  unsigned h1,h2,h3;

  memset ( han_mem, 0, 10);

  h1 = hantable[0][cho ];
  h2 = hantable[1][jung];
  h3 = hantable[2][jong];

  t1 = h3 ? cho_tb_yes[h2] : cho_tb_no[h2];
  t2 = ((h1 == 0 || h1 == 1 || h1 == 16) ? 0 : 1) + ( h3 ? 2 : 0);
  t3 = jong_tb[h2];

  if (h1) memcpy(han_mem, first[t1][h1], 10);
  else memset(han_mem, 0,10);
  if (h2) Oimage( mid[t2][h2], han_mem, 10);
  if (h3) Oimage( endtable[t3][h3], han_mem, 10);
}

int Oimage(UC *src,UC *dest,int lens)
{
   int i;
   for( i = 0; i < lens; i++) dest[i] |= src[i];
   return 0;
}
