/*
		SPRITE expression!
		------------------
						1995.7.
						hong won dae
		Thank you. <Christopher Lampton>
*/
int SIN_TABLE[91] = {
	0,1143,2287,3429,4571,5711,6850,7986,9120,10252,11380,12504,
	13625,14742,15854,16961,18064,19160,20251,21336,22414,23486,
	24550,25606,26655,27696,28729,29752,30767,31772,32768,33753,
	34728,35693,36647,37589,38521,39440,40347,41243,42125,42995,
	43852,44695,45525,46340,47142,47929,48702,49460,50203,50931,
	51643,52339,53019,53683,54331,54963,55577,56175,56755,57319,
	57864,58393,58903,59395,59870,60326,60763,61183,61583,61965,
	62328,62672,62997,63302,63589,63856,64103,64331,64540,64729,
	64898,65047,65176,65286,65376,65446,65496,65526,65536};
int  Y_TABLE[201] =
{ 0,320,640,960,1280,1600,1920,2240,2560,2880,3200,3520,3840,4160,
 4480,4800,5120,5440,5760,6080,6400,6720,7040,7360,7680,8000,8320,
 8640,8960,9280,9600,9920,10240,10560,10880,11200,11520,11840,12160,
 12480,12800,13120,13440,13760,14080,14400,14720,15040,15360,15680,
 16000,16320,16640,16960,17280,17600,17920,18240,18560,18880,19200,
 19520,19840,20160,20480,20800,21120,21440,21760,22080,22400,22720,
 23040,23360,23680,24000,24320,24640,24960,25280,25600,25920,26240,
 26560,26880,27200,27520,27840,28160,28480,28800,29120,29440,29760,
 30080,30400,30720,31040,31360,31680,32000,32320,32640,32960,33280,
 33600,33920,34240,34560,34880,35200,35520,35840,36160,36480,36800,
 37120,37440,37760,38080,38400,38720,39040,39360,39680,40000,40320,
 40640,40960,41280,41600,41920,42240,42560,42880,43200,43520,43840,
 44160,44480,44800,45120,45440,45760,46080,46400,46720,47040,47360,
 47680,48000,48320,48640,48960,49280,49600,49920,50240,50560,50880,
 51200,51520,51840,52160,52480,52800,53120,53440,53760,54080,54400,
 54720,55040,55360,55680,56000,56320,56640,56960,57280,57600,57920,
 58240,58560,58880,59200,59520,59840,60160,60480,60800,61120,61440,
 61760,62080,62400,62720,63040,63360,63680};

unsigned int sinout(int rote)
{
 if (rote <= 90) return (SIN_TABLE[rote]);
 if (rote <=180) return (SIN_TABLE[180 - rote]);
 if (rote <=270) return (-SIN_TABLE[rote - 180]);
 if (rote <=360) return (-SIN_TABLE[360 - rote]);
 return 0;
}

unsigned int cosout(int rote)
{
 if (rote <= 90) return (SIN_TABLE[90 - rote]);
 if (rote <=180) return (-SIN_TABLE[rote - 90]);
 if (rote <=270) return (-SIN_TABLE[270 - rote]);
 if (rote <=360) return (SIN_TABLE[rote - 270]);
 return 0;
}

void ZoomSpr(int x,int y,int sx,int sy,int zper,char *img,char *target)
{
 unsigned int iy, ix,scx=x,scy=y;
 int yerror = 0, xerror;
 unsigned int bitptr = 0, old_bitptr;
 for (iy=0; iy<sy; iy++) {
   yerror+=zper;
   while (yerror>100) {
     yerror-=100;
     old_bitptr=bitptr;
     xerror = 0;
     for (ix=0; ix<sx; ix++) {
       xerror+=zper;
       while(xerror>100) {
	 xerror-=100;
	 if (img[bitptr] != 0 && scx <320 && scy<200)  target[Y_TABLE[scy]+scx]=img[bitptr];
	 scx++;
       }
	 bitptr++;
     }
	 scx=x;scy++;
	 bitptr=old_bitptr;
   }
   bitptr+=sx;
 }
}
void ZoomImg(int x,int y,int sx,int sy,int zper,char *img,char *target)
{
 unsigned int iy, ix,scx=x,scy=y;
 int yerror = 0, xerror;
 unsigned int bitptr = 0, old_bitptr;
 for (iy=0; iy<sy; iy++) {
   yerror+=zper;
   while (yerror>100) {
     yerror-=100;
     old_bitptr=bitptr;
     xerror = 0;
     for (ix=0; ix<sx; ix++) {
       xerror+=zper;
       while(xerror>100) {
	 xerror-=100;
	 if (scx <320 && scy<200)  target[Y_TABLE[scy]+scx]=img[bitptr];
	 scx++;
       }
	 bitptr++;
     }
	 scx=x;scy++;
	 bitptr=old_bitptr;
   }
   bitptr+=sx;
 }
}

void RotSpr(int x,int y,int sx,int sy,int rote,char *img,char *target)
{
  int sine,cose;
  unsigned int newx,oldx,oldy,newy,ix,iy;
  unsigned int bitptr = 0,scr;

 sine=sinout(rote);
 cose=cosout(rote);
 for (iy=0; iy<sy; iy++) {
   oldy = iy;
   for (ix=0; ix<sx; ix++) {
       if (img[bitptr] != 0) {
       oldx = ix;
       newx =(oldx * cose - oldy * sine) >> 16;
       newy =(oldx * sine + oldy * cose) >> 16;
       newy+=y;
       newx+=x;
       if (newy <200 && newx <320)
	 target[Y_TABLE[newy]+newx]=img[bitptr];
     }
     bitptr++;
   }
 }
}

void RotSpr_XY(int x,int y,int sx,int sy,int rotex,int rotey,char *img,char *target)
{
  int sine,cose,sine2,cose2;
  unsigned int oldx,oldy,newx,newy,ix,iy;
  unsigned int bitptr = 0,scr;

 sine=sinout(rotex);
 cose=cosout(rotex);
 sine2=sinout(rotey);
 cose2=cosout(rotey);

 for (iy=0; iy<sy; iy++) {
   oldy = iy;
   for (ix=0; ix<sx; ix++) {
     if (img[bitptr] != 0) {
       oldx = ix;
       newx =(oldx * cose - oldy * sine) >> 16;
       newy =(oldx * sine2 + oldy * cose2) >> 16;
       newx+=x-(x/sx);
       newy+=y;

       if ( newx < 320 && newy < 200 )
	 target[Y_TABLE[newy]+newx]=img[bitptr];
     }
     bitptr++;
   }
 }
}

void ZoomSpr_Rot(int x,int y,int sx,int sy,int zper,int rote,char *img,char *target)
{
 int iy, ix,scx=x,scy=y;
 int yerror = 0, xerror;
 unsigned int bitptr = 0, old_bitptr;
 for (iy=0; iy<sy; iy++) {
   yerror+=zper;
   while (yerror>100) {
     yerror-=100;
     old_bitptr=bitptr;
     xerror = 0;
     for (ix=0; ix<sx; ix++) {
       xerror+=zper;
       while(xerror>100) {
	 xerror-=100;
	 if (img[bitptr] != 0 && scx>=0 && scx <320 && scy>=0 && scy<200)  target[Y_TABLE[scy]+scx]=img[bitptr];
	 scx++;
       }
	 bitptr++;
     }
	 scx=x;scy++;
	 bitptr=old_bitptr;
   }
   bitptr+=sx;
 }
}
