/*


	XGAME LIBRARY V1.4

	Program by LEE WON HEE


*/

#ifndef __LARGE__
        #error XGAME LIBRARY run in the large model.
#endif

#ifndef __XGAMELIB_VH
#define __XGAMELIB_VH

#define _ESC 		1

#define _1 			2
#define _2 			3
#define _3 			4
#define _4 			5
#define _5 		    6
#define _6 			7
#define _7 			8
#define _8 			9
#define _9 			10
#define _0 			11
#define _MINUS 	    12
#define _EQUAL   	13
#define _BACKSP 	14
#define _Q 			16
#define _W 			17
#define _E 			18
#define _R 			19
#define _T 			20
#define _Y 			21
#define _U 			22
#define _I 			23
#define _O 			24
#define _P 			25
#define _LPAREN 	26

#define _RPAREN 	27      /* ] */
#define _A 		 	30
#define _S 			31
#define _D 			32
#define _F 			33
#define _G 			34
#define _H 			35
#define _J 			36
#define _K 			37
#define _L 			38
#define _SEMI 		39       /*  ; */
#define _QUATO 		40       /*  ' */
#define _BSLASH 	43       /*  \ */
#define _Z 			44
#define _X 			45
#define _C 			46
#define _V 			47
#define _B 			48
#define _N 			49
#define _M 			50

#define _COMMA 	    51       /*  , */
#define _DOT 		52       /*  . */
#define _SLASH 		53       /*  / */
#define _SPACE 		57
#define _F1  		59
#define _F2  		60
#define _F3  		61
#define _F4  		62
#define _F5  		63
#define _F6  		64
#define _F7  		65
#define _F8  		66
#define _F9  		67
#define _F10 		68
#define _RET 		28
#define _TAB 		15
#define _LSHIFT 	42
#define _RSHIFT 	54
#define _LCTRL 		29
#define _RCTRL 		29
#define _LALT 		56
#define _RALT 		56
#define _NHOME 		71
#define _NPGUP 		73
#define _NEND  		79
#define _NPGDN 		81
#define _NINS  		82
#define _NDEL  		83
#define _NUMLOCK 	69
#define _CAPLOCK 	58
#define _SCRLOCK 	70
#define _UP    		72
#define _DOWN  		80
#define _LEFT  		75
#define _RIGHT 		77
#define _5_    		76

/* XGAME */

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char Byte;
typedef unsigned int  Word;

typedef struct {
	int  	x_size,y_size;
	Byte 	*data;
}SPRITE;

typedef struct {
	char *vptr;
	int  l;
}VOC;

extern char *MUSIC_FILE;
extern char *GRAPH_FILE;
extern char *FONT_FILE;
extern Byte _exit_flag;

void NullProcess();
void ExitProcess(void (*func)());
void SystemDown(int ret,char *fmt, ...);
void Initialize(char *fnt,char *pic,char *music,char *msg);
int  ReadVoiceFile(long file,Word l,VOC *voc);

#ifdef __XGAME_PRJ
	void SayVoc(long file,Word  l);
#else
	void SayVoc(char *data,Word  l);
#endif

/* XMODE */

#define	MAXX			 320
#define MAXY			 200
#define MAXCOLOR		 255

extern Byte far *MCGA;
extern Byte far *ACT_PAGE;

extern int XS_CLIP;	   /* Clipping data */
extern int YS_CLIP;
extern int XE_CLIP;
extern int YE_CLIP;

extern Byte R[256],G[256],B[256];

char *GetFarAddr(int x,int y);
void WaitVsync();
void WaitVsync2();
void Fade(int x,int y,int Ct1);
void SetPalette(char far*palette);
void PutPixel(int x,int y,Byte color);
Byte GetPixel(int x,int y);
void DrawHline(int x,int y,int len,Byte color);
void DrawVline(int x,int y,int len,Byte color);
void Circle(int x,int y,int r,Byte color);
void Bar(int x,int y,int xx,int yy,Byte color);
void DrawBox(int x,int y,int xx,int yy,Byte color);
void PutSpriteClip(int x,int y,SPRITE *sp);
void PutImageClip(int x,int y,SPRITE *sp);
void PutSprite(int X,int Y,SPRITE *sp_ptr);
void PutImage(int X,int Y,SPRITE *sp_ptr);
void CopyPage(Byte far*dest,Byte far*scr);
void ClearDevice(Byte far*dest,Byte color);
void CopyWindowSprite(int Xp,int Yp,int SXp,int SYp,Word Xs,Word Ys,
			  Byte far*Addr,Byte far*Data);
void CopyWindowImage(int X,int Y,Word Xs,Word Ys,
						Byte far*Addr,Byte far*Data);
void CopyWindowImage2(int Xp,int Yp,int SXp,int SYp,Word Xs,Word Ys,
			  Byte far*Addr,Byte far*Data);
void SetClipping(int x,int y,int xx,int yy);
void GetRgb();
void SetRgb(int MODE ,int start,int end);

#ifdef __XGAME_PRJ
        int  LoadPalette(long pp);
#else
        int  LoadPalette(char *file);
#endif

int  SavePalette(char *file);
void SetActPage(Byte *page);
Byte far *GetActPage();
void SetVideoMode(int	mode);
int  GetRandom(int min,int max);
void RotatePalette(Byte start,Byte end,Byte direct);
int  GetImage(Word x,Word y,Word xe,Word ye,SPRITE	*sp);
void Free(SPRITE	*sp);
void ScaleSpriteClip(int x,int y, int x_s, int y_s,SPRITE *sp);
void ScaleSprite(int x,int y, int x_s, int y_s,SPRITE *sp);
void ScaleImage(int x,int y, int x_s, int y_s,SPRITE *sp);

/* XMS */

struct movestruct {
	unsigned long  Length;
	unsigned short SourceHandle;
	unsigned long  SourceOffset;
	unsigned short DestHandle;
	unsigned long  DestOffset;
};

int  XmsMove2 (void);
int  _Call (char Func);
int  InitXms();
int  XmsSize ();
int  XmsVersion();
int  XmsAlloc (int Size);
int  XmsFree0 (int Handle);
void far *XmsLock (int Handle);
int  XmsUnLock (int Handle);
void XmsFree (int Handle);

int  XmsMove (Word SourceHandle,Word DestHandle, char *SourceOffset,char *DestOffset,
unsigned long  Length);

int  XmsMove2 ();
int  XmsPut (char *buffer,unsigned size);
int  XmsSee (int handle,char *buffer,unsigned size);
int  XmsGet (int handle,char *buffer,unsigned size);
void GetXmsImage(Byte far *page,int  *screen);
void PutXmsImage(Byte far *page,int  *screen,int opt);


/* PIC */
#ifdef __XGAME_PRJ
	int  ReadPcx(long p,char opt);
#else
	int  ReadPcx(char *name,int opt);
#endif

void WriteRawImage(SPRITE *w,char *file);
#ifndef _XGAME_PRJ
	int  GetRawImage(SPRITE *w,char *file);
	void PutRawImage(int x,int y,SPRITE *w,char *file);
#else
	int  GetRawImage(SPRITE *w,long ptr);
	void PutRawImage(int x,int y,SPRITE *w,long ptr);
#endif

/* MOUSE */
extern int  m_right, m_left, m_x, m_y;
extern char m_install;

void PutMaxSpriteClip(int x,int y,SPRITE *sp_ptr);
int  MouseInterrupt(int x);
int  MouseInit();
void MouseInfo();
void MouseMoveCursor(int x,int y);
void MouseXyRange(int left,int right,int top,int bottom);
void MouseReleased();
int  MouseCrash(int x1,int y1,int x2,int y2);
void MouseShowCursor(SPRITE *ms);
void MouseInitialize();

/* KEY */

extern Byte _KEY[128];
extern Byte _KBHIT;
extern Word _COUNT;

void SetNewKbd();
void SetOldKbd();
void SetNewTime();
void SetOldTime();
void SystemDelay();
void Delay(int ha);
void SetVect();
void CloseVect();
int  Kbhit();
int  GetKey();
int  GetKey2();
void DelayKey(int d);

/* IMS */
void TimeOut();
void ImsOff();
#ifdef __XGAME_PRJ
	void ImsPlay(long offset);
#else
	void ImsPlay(char *file);
#endif

/* HAN */
void SetTextStyle(int i);
int  PutHan(int x,int y,Byte color,char *st);
void PrintfHan(int x,int y,Byte c,char *fmt, ...);

#ifdef __ENG_INPUT
	int GetsEng(int x,int y,int c,int bc,int num,char *st);
#endif
int  InitHan(char *file);

int  FlicNextFrame(char *des,char *sec);
void FlicEnd();
int  FlicPlay(int x,int y,char *fname);
void RepeatFlic();

#ifdef __cplusplus
}
#endif


#endif
