/*
   AT ¸w 101 ǡa aE ša s 3 aE ša A 

   aa : kbd3.h

   AT 101 ǡa aE ša s 3 ǡa ae i

   Aa šae aaaa šate 16 a.

   +--+ +--+--+--+--+ +--+--+--+--+ +--+--+--+--+  +--+--+--+
   |64| |58|59|5A|5B| |5C|5D|5E|5F| |60|61|62|63|  |6E|76|77|  ##  ##  ##
   +--+ +--+--+--+--+ +--+--+--+--+ +--+--+--+--+  +--+--+--+

   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+  +--+--+--+  +--+--+--+--+
   |29| 2| 3| 4| 5| 6| 7| 8| 9| A| B| C| D|75| E|  |7B|7F|6F|  |60|61|62|63|
   +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+  +--+--+--+  +--+--+--+--+
   | F |10|11|12|13|14|15|16|17|18|19|1A|1B|    |  |79|7A|7E|  |47|48|49|  |
   +---+--+--+--+--+--+--+--+--+--+--+--+--+    |  +--+--+--+  +--+--+--+37|
   | 1D |1E|1F|20|21|22|23|24|25|26|27|28|  1C  |              |4B|4C|4D|  |
   +----+--+--+--+--+--+--+--+--+--+--+--+--+---+     +--+     +--+--+--+--+
   | 2A  |2C|2D|2E|2F|30|31|32|33|34|35|  36    |     |78|     |4F|50|51|  |
   +-----+--+--+--+--+--+--+--+--+--+--+--+--+--+  +--+--+--+  +--+--+--+4E|
   | 38| 71|  |         39         |  | 72 | 3A |  |56|55|7D|  | 52  |53|  |
   +---+---+  +--------------------+  +----+----+  +--+--+--+  +-----+--+--+
*/

#ifndef _KEYBOARD_HEADER_
#define _KEYBOARD_HEADER_

#define _NUMLOCK 0x01   /* Number Lock               */
#define _1       0x02   /*  1 ǡ                   */
#define _2       0x03   /*  2                        */
#define _3       0x04   /*  3                        */
#define _4       0x05   /*  4                        */
#define _5       0x06   /*  5                        */
#define _6       0x07   /*  6                        */
#define _7       0x08   /*  7                        */
#define _8       0x09   /*  8                        */
#define _9       0x0A   /*  9                        */
#define _0       0x0B   /*  0                        */
#define _MINUS   0x0C   /*  - ǡ                   */
#define _EQUAL   0x0D   /*  = ǡ                   */
#define _BACKSP  0x0E   /*  back space ǡ          */
#define _TAB     0x0F   /* Tab key                   */

#define _Q       0x10   /*  Q                        */
#define _W       0x11   /*  W                        */
#define _E       0x12   /*  E                        */
#define _R       0x13   /*  R                        */
#define _T       0x14   /*  T                        */
#define _Y       0x15   /*  Y                        */
#define _U       0x16   /*  U                        */
#define _I       0x17   /*  I                        */
#define _O       0x18   /*  O                        */
#define _P       0x19   /*  P                        */
#define _LPAREN  0x1A   /*  [                        */
#define _RPAREN  0x1B   /*  ]                        */
#define _RET     0x1C   /* Return or Enter key       */
#define _CAPLOCK 0x1D   /* Caps lock                 */
#define _A       0x1E   /*  A                        */
#define _S       0x1F   /*  S                        */

#define _D       0x20   /*  D                        */
#define _F       0x21   /*  F                        */
#define _G       0x22   /*  G                        */
#define _H       0x23   /*  H                        */
#define _J       0x24   /*  J                        */
#define _K       0x25   /*  K                        */
#define _L       0x26   /*  L                        */
#define _SEMI    0x27   /*  ;                        */
#define _QUATO   0x28   /*  '                        */
#define _BQUATO  0x29   /*  `  key                   */
#define _LSHIFT  0x2A   /* Left Shift Key            */
#define _Z       0x2C   /*  Z                        */
#define _X       0x2D   /*  X                        */
#define _C       0x2E   /*  C                        */
#define _V       0x2F   /*  V                        */

#define _B       0x30   /*  B                        */
#define _N       0x31   /*  N                        */
#define _M       0x32   /*  M                        */
#define _COMMA   0x33   /*  ,                        */
#define _DOT     0x34   /*  .                        */
#define _SLASH   0x35   /*  / key                    */
#define _RSHIFT  0x36   /* Right Shift Key           */
#define _LCTRL   0x38   /* Left Control key          */
#define _SPACE   0x39   /*  space barkey             */
#define _RCTRL   0x3A   /* Right Control key         */

#define _N_SLASH 0x45   /* Number Keypad Grey / key  */
#define _N_MULTI 0x46   /* Number Keypad Grey * key  */

#define _N7      0x47   /* Number Keypad 7           */
#define _N8      0x48   /* Number Keypad 8           */
#define _N9      0x49   /* Number Keypad 9           */

#define _N4      0x4B   /* Number Keypad 4           */
#define _N5      0x4C   /* Number Keypad 5           */
#define _N6      0x4D   /* Number Keypad 6           */
#define _N_RET   0x4E   /* Number Keypad Grey Enter  */
#define _N1      0x4F   /* Number Keypad 1           */

#define _N2      0x50   /* Number Keypad 2           */
#define _N3      0x51   /* Number Keypad 3           */
#define _N0      0x52   /* Number Keypad 0           */
#define _N_DOT   0x53   /* Number Keypad .           */
#define _N_MINUS 0x54   /* Number Keypad Grey - key  */
#define _DWARR   0x55   /* Down Arrow                */
#define _LFARR   0x56   /* Left Arrow                */

#define _F1      0x58   /*  Function  1 key          */
#define _F2      0x59   /*  Function  2              */
#define _F3      0x5A   /*  Function  3              */
#define _F4      0x5B   /*  Function  4              */
#define _F5      0x5C   /*  Function  5              */
#define _F6      0x5D   /*  Function  6              */
#define _F7      0x5E   /*  Function  7              */
#define _F8      0x5F   /*  Function  8              */

#define _F9      0x60   /*  Function  9              */
#define _F10     0x61   /*  Function 10              */
#define _F11     0x62   /*  Function 11              */
#define _F12     0x63   /*  Function 12              */
#define _ESC     0x64   /*  ESC ǡ                 */

#define _PRTSCR  0x6E   /* Print Screen              */
#define _PGUP    0x6F   /* Page Up                   */

#define _LALT    0x71   /* Left  Alternate key       */
#define _RALT    0x72   /* Right Alternate key       */
#define _RSLASH  0x75   /*  \  key                   */
#define _SCRLOCK 0x76   /* Scroll Lock               */
#define _PAUSE   0x77   /* Pause                     */
#define _UPARR   0x78   /* Up Arrow                  */
#define _DEL     0x79   /* Delete                    */
#define _END     0x7A   /* End                       */
#define _INS     0x7B   /* Inserte                   */
#define _RGARR   0x7D   /* Right Arrow               */
#define _PGDW    0x7E   /* Page Down                 */
#define _HOME    0x7F   /* Home                      */

#define KBDWAIT     for ( _KBHIT=0 ; !_KBHIT ; ) ;
#define isPush(X)   (_KS[(X)])

extern unsigned char _KS[128] ;
extern unsigned char _KE[128] ;
extern unsigned char _KBHIT   ;

void setNewKBDInt(void) ;
void restoreKBDInt(void) ;

#endif
