 ; Video Output Engine   ;
 ; programmed by NOERROR ;

  .model large
  .286

  .code


;  include palette.inc


  width equ 320
  height equ 200


  oldmode dw 3
  hoffset dw height dup(?)
  mwidth dw height+16 dup(width)


  public _init_video


_init_video :
  ; Get video mode
  mov  ah,15
  int  10h
  mov  byte ptr oldmode,al
  ; Get video offset
  mov  cx,height
  mov  bx,0
  mov  ax,0
  getoffset :
  mov  word ptr hoffset+bx,ax
  add  ax,width
  add  bx,2
  loop getoffset
  ; Set 320x200x256 mode
  mov  ax,13h
  int  10h
  ; Clear video screen
  push es di
  mov  ax,0a000h
  mov  es,ax
  mov  di,0
  mov  ax,0000h
  mov  cx,64000/2
  rep  stosw
  pop  di es
  ; Set palette
;  push ds si
;  mov  ax,cs
;  mov  ds,ax
;  lea  si,palette
;  mov  dx,3c8h
;  mov  al,0
;  out  dx,al
;  mov  dx,3c9h
;  mov  cx,768
;  _pal :
;  lodsb
;  out  dx,al
;  loop _pal
;  pop  si ds
  ; Set mouse handler
  call _mouseon
  retf


  public _init_text


_init_text :
  call _mouseoff
  mov  ax,oldmode
  int  10h
  retf


  mouse_x dw 0
  mouse_y dw 0
  mouse_b db 0
  mouse_shape dw 1000000000000000b
              dw 1100000000000000b
              dw 1110000000000000b
              dw 1111000000000000b
              dw 1111100000000000b
              dw 1111110000000000b
              dw 1111110000000000b
              dw 1111111000000000b
              dw 0001111000000000b,0,0,0,0,0,0,0
              dw 1000000000000000b
              dw 1100000000000000b
              dw 1010000000000000b
              dw 1001000000000000b
              dw 1000100000000000b
              dw 1000010000000000b
              dw 1000010000000000b
              dw 1111001000000000b
              dw 0001111000000000b,0,0,0,0,0,0,0
  mouse_backg db 16*16 dup (?)
  mouse_c1 db 0   ; outline
  mouse_c2 db 7   ; inside
  oldvect dw 0,0,0


_mouseon :
  ; limited limits of mouse moving
  mov  ax,7
  mov  cx,0
  mov  dx,(width-1)*2
  int  33h
  mov  ax,8
  mov  cx,0
  mov  dx,(height-1)
  int  33h

  ; clearing position-arg
  mov  ax,3
  int  33h
  mov  mouse_b,bl
  mov  ax,1

  push cs
  call near ptr handle

  ; setup mouse handler
  push es
  mov  ax,cs
  mov  es,ax
  lea  dx,dword ptr handle
  mov  cx,00011111b
  mov  ax,20
  int  33h
  mov  ax,es
  mov  oldvect  ,ax ; segment
  mov  oldvect+2,dx ; offset
  mov  oldvect+4,cx ; mask
  pop  es
  ret


_mouseoff :
  push es
  les  dx,dword ptr oldvect
  mov  cx,oldvect+4
  mov  ax,20
  int  33h
  pop  es
  ret

copy16byte macro
  rept 8
  movsw
  endm
  endm

  sbpl dw 16

mov_dx_clip macro
  local skip
  mov  cx,width
  sub  cx,cs:[mouse_x]
  cmp  cx,16
  jna  skip
  mov  cx,16
  skip :
  mov  dx,8000h
  ror  dx,cl
  mov  ax,16
  sub  ax,cx
  mov  sbpl,ax
  endm

mov_cx_clip macro
  local skip
  mov  cx,200
  sub  cx,cs:[mouse_y]
  cmp  cx,16
  jna  skip
  mov  cx,16
  skip :
  endm

handle :
  ; ax-button,cx-width,dx-height

  ; get position
  test ax,00000110b
  jz   passb1
  xor  cs:[mouse_b],1
  passb1 :
  test ax,00011000b
  jz   passb2
  xor  cs:[mouse_b],2
  passb2 :
  test al,00000001b
  jnz  continue
  retf

  ; putbackground
  continue :
  push es di
  push ds si
  push cx dx
  mov  ax,0a000h
  mov  ds,ax
  mov  bx,cs:[mouse_y]
  mov  si,cs:[mouse_x]
  shl  bx,1
  add  si,word ptr hoffset+bx
  mov  ax,cs
  mov  es,ax
  lea  di,mouse_backg
  lea  bx,mouse_shape
  mov_dx_clip
  mov_cx_clip
  mov  ax,8000h
  putmu :  ; put mouse underbackground
  test ax,word ptr es:[bx]
  jz   pmuskip
  push ax
  mov  al,es:[di]
  mov  ds:[si],al
  pop  ax
  pmuskip : ; put mouse underbackground skip
  inc  di
  inc  si
  ror  ax,1
  test ax,dx
  je   putmu
  mov  ax,8000h
  add  si,width-16
  add  si,sbpl
  add  di,sbpl
  add  bx,2
  loop putmu

  ; restore position
  mov  di,cs:[mouse_y]
  shl  di,1
  add  di,offset mwidth
  mov  cx,16
  mov  ax,width
  rep  stosw

  ; save position
  pop  dx cx
  shr  cx,1
  mov  cs:[mouse_x],cx
  mov  cs:[mouse_y],dx

  mov  di,dx
  shl  di,1
  add  di,offset mwidth
  mov  ax,cx
  mov  cx,16
  rep  stosw

  ; get background
  mov  si,cs:[mouse_x]
  mov  bx,cs:[mouse_y]
  shl  bx,1
  add  si,word ptr cs:[hoffset+bx]
  lea  di,mouse_backg
  mov_cx_clip
  mov  dx,0
  nlbs : ; next line background saving
  copy16byte
  add  dx,width
  add  si,width-16
  loop nlbs
  ; put cursor
  sub  si,dx
  lea  di,mouse_shape
  mov  bx,word ptr cs:[mouse_c1]
  mov_dx_clip
  mov_cx_clip
  mov  ax,8000h
  putmc : ; put mouse cursor
  test ax,cs:[di]
  jz   pmcskip
  test ax,cs:[di+16*2]
  jz   pmc2
  mov  ds:[si],bl
  jmp  pmcskip
  pmc2 : ; put mouse color 2
  mov  ds:[si],bh
  pmcskip : ; put mouse color skip
  inc  si
  ror  ax,1
  test ax,dx
  je   putmc
  mov  ax,8000h
  add  si,width-16
  add  si,sbpl
  add  di,2
  loop putmc
  pop  si ds
  pop  di es
  finish :
  retf


  public _mouse_x,_mouse_y,_mouse_b

_mouse_x :
  mov  ax,mouse_x
  retf
_mouse_y :
  mov  ax,mouse_y
  retf
_mouse_b :
  mov  al,mouse_b
  retf



  public _mouse_shape

_mouse_shape :
  push bp
  mov  bp,sp
  cli
  push es di
  push ds si
  mov  ax,0a000h
  mov  es,ax
  mov  bx,cs:[mouse_y]
  mov  di,cs:[mouse_x]
  shl  bx,1
  add  di,word ptr hoffset+bx
  lea  si,mouse_backg
  lea  bx,mouse_shape
  mov  cx,16
  mov  ax,8000h
  putmus :  ; put mouse underbackground (shape)
  test ax,cs:[bx]
  jz   pmusskip
  mov  dl,cs:[si]
  mov  es:[di],dl
  pmusskip : ; put mouse underbackground (shape) skip
  inc  di
  inc  si
  ror  ax,1
  jnc  putmus
  add  bx,2
  add  di,width-16
  loop putmus
  sub  di,width*16
  lea  si,mouse_backg
  mov  cx,16
  nlbss : ; next line background saving (shape)
  copy16byte
  add  di,width-16
  loop nlbss
  mov  ax,cs
  mov  es,ax
  lea  di,mouse_shape
  lds  si,dword ptr [bp+6]
  mov  cx,16*2*2/2
  rep  movsw
  pop  si ds
  pop  di es
  mov  al,byte ptr [bp+10]
  mov  ah,byte ptr [bp+12]
  mov  word ptr mouse_c1,ax
  mov  ax,1
  mov  cx,word ptr cs:[mouse_x]
  mov  dx,word ptr cs:[mouse_y]
  shl  cx,1
  push cs
  call near ptr handle
  sti
  pop  bp
  retf


address  macro
  mov  bx,0a000h
  mov  es,bx
  mov  bx,word ptr [bp+8]
  shl  bx,1
  mov  di,word ptr hoffset+bx
  add  di,word ptr [bp+6]
  endm


  public _pixel


_pixel :
  push bp
  mov  bp,sp
  cli
  mov  cx,[bp+6]
  sub  cx,mouse_x
  cmp  cx,16
  jae  skip
  mov  bx,[bp+8]
  sub  bx,mouse_y
  cmp  bx,16
  jae  skip
  mov  ax,8000h
  shr  ax,cl
  shl  bx,1
  mov  dx,mouse_shape+bx
  test dx,ax
  jz   skip
  mov  al,[bp+10]
  shl  bx,3
  add  bx,cx
  mov  mouse_backg+bx,al
  sti
  pop  bp
  retf
  skip :
  push  es di
  address
  mov  al,byte ptr [bp+10]
  mov  byte ptr es:di,al
  pop  di es
  sti
  pop  bp
  retf


  public _getpixel


_getpixel :
  push bp
  mov  bp,sp
  cli
  mov  cx,[bp+6]
  sub  cx,mouse_x
  cmp  cx,16
  jae  gskip
  mov  bx,[bp+8]
  sub  bx,mouse_y
  cmp  bx,16
  jae  gskip
  mov  ax,8000h
  shr  ax,cl
  shl  bx,1
  mov  dx,mouse_shape+bx
  test dx,ax
  jz   gskip
  shl  bx,3
  add  bx,cx
  mov  al,mouse_backg+bx
  sti
  pop  bp
  retf
  gskip : ; get pixel skip
  push  es di
  address
  mov  al,byte ptr es:di
  pop  di es
  sti
  pop  bp
  retf



rep_movsw macro
         local byte,word
         shr  cx,1
         jnc  byte
         movsb
         byte :
         rep movsw
         endm


  ;
@putimage :
  push bx dx
  mov  dx,cs:[mouse_y]
  shl  dx,1
  sub  bx,dx
  mov  dx,bx
  mov  bx,word ptr cs:[mouse_shape+bx]
  shl  dx,3
  add  dx,ax
  add  dx,offset mouse_backg
  push cx
  mov  cx,ax
  rol  bx,cl
  pop  cx
  xchg bx,dx
  plp :
  test dx,8000h
  jne  pskip
  movsb
  jmp  pend
  pskip :
  lodsb
  mov  cs:[bx],al
  inc  di
  pend :
  inc  bx
  rol  dx,1
  loop plp
  pop  dx bx
  ret


  public _putimage


_putimage :
  push bp
  mov  bp,sp
  push es di
  push ds si
  address
  lds  si,[bp+10]
; mov  bx,word ptr [bp+8]
; shl  bx,1                 ; bx = y *2
  mov  ax,word ptr [bp+16]
  shl  ax,1
  add  ax,bx
  mov  word ptr [bp+16],ax  ; (y+ys) * 2
  cli
  imagelp :
  mov  cx,word ptr [bp+14]  ; cx = xs
  ; check skip
  cmp  cs:[mwidth+bx],width
  je   normal

  mov  dx,word ptr [bp+6]   ; dx = x
  sub  dx,cs:[mwidth+bx]
  cmp  dx,16
  jge  normal

  neg  dx
  cmp  dx,cx
  jge  normal

  ; cross
  cmp  dx,0
  jg   pt2

  pt0 :
  add  dx,16
  cmp  cx,dx
  jg   pt1
  mov  ax,16
  sub  ax,dx
  call near ptr @putimage
  jmp  back

  pt1 :
  mov  cx,dx
  mov  ax,16
  sub  ax,cx
  call near ptr @putimage
  mov  cx,word ptr [bp+14]
  sub  cx,dx
  rep_movsw
  jmp  back

  pt2 :
  mov  cx,dx
  rep_movsw
  mov  cx,word ptr [bp+14]
  sub  cx,dx
  cmp  cx,16
  jle  pt3
  push cx
  mov  ax,0
  mov  cx,16
  call near ptr @putimage
  pop  cx
  sub  cx,16
  rep_movsw
  jmp  back

  pt3 :
  mov  ax,0
  call near ptr @putimage
  jmp  back

  normal :
  rep_movsw

  back :
  add  di,width
  sub  di,word ptr [bp+14]
  add  bx,2
  cmp  bx,[bp+16]
  je   exit
  jmp  imagelp
  exit :
  sti
  pop  si ds
  pop  di es
  pop  bp
  retf


  public _setpalette


_setpalette :
  push bp
  mov  bp,sp
  push ds si
  lds  si,dword ptr [bp+6]
  mov  dx,3c8h
  mov  al,0
  out  dx,al
  mov  dx,3c9h
  mov  cx,768/2
  pl : ; palette loop
  lodsw
  out  dx,al
  mov  al,ah
  out  dx,al
  loop pl
  pop  si ds
  pop  bp
  retf


  end


  .NOERROR/GARGOYLE