// DirectStepView.cpp : implementation of the CDirectStepView class
//

#include "stdafx.h"
#include "DirectStep.h"

#include "DirectStepDoc.h"
#include "DirectStepView.h"


#include "ddutil.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDirectStepView

IMPLEMENT_DYNCREATE(CDirectStepView, CView)

BEGIN_MESSAGE_MAP(CDirectStepView, CView)
	//{{AFX_MSG_MAP(CDirectStepView)
	ON_WM_DESTROY()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_TIMER()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirectStepView construction/destruction

CDirectStepView::CDirectStepView()
{
	bDirectDrawActive = FALSE;	
	if( InitDirectDraw() == TRUE ) bDirectDrawActive = TRUE;	
}

CDirectStepView::~CDirectStepView()
{
}

BOOL CDirectStepView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CDirectStepView drawing

void CDirectStepView::OnDraw(CDC* pDC)
{
	CDirectStepDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);	
}

/////////////////////////////////////////////////////////////////////////////
// CDirectStepView diagnostics

#ifdef _DEBUG
void CDirectStepView::AssertValid() const
{
	CView::AssertValid();
}

void CDirectStepView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDirectStepDoc* CDirectStepView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDirectStepDoc)));
	return (CDirectStepDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDirectStepView message handlers
BOOL CDirectStepView::InitDirectDraw()
{
	DDSURFACEDESC ddsd;
	DDSCAPS	ddscaps;
	HRESULT hr;

	hr = DirectDrawCreate( NULL, &lpDD, NULL );
	if( hr != DD_OK ) goto error;

	// Get Exclusive Mode
	hr = lpDD->SetCooperativeLevel( AfxGetMainWnd()->m_hWnd,
									DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
	if( hr != DD_OK ) goto error;
	
	// Set Video Mode To 640x480x(8bit)
	hr = lpDD->SetDisplayMode( 640, 480, 8 );
	if( hr != DD_OK ) goto error;

	// Create two surface
	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
						  DDSCAPS_FLIP |
						  DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	hr = lpDD->CreateSurface( &ddsd, &lpDDSurface1, NULL );
	if( hr != DD_OK ) goto error;

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSurface1->GetAttachedSurface( &ddscaps, &lpDDSurface2 );
	if( hr != DD_OK ) goto error;

	lpDDPal = DDLoadPalette( lpDD, "test.bmp" );
	if( lpDDPal == NULL ) goto error;

	hr = lpDDSurface1->SetPalette( lpDDPal );
	if( hr != DD_OK ) goto error;
		
	hr = DDReLoadBitmap( lpDDSurface2, "test.bmp" );
	if( hr != DD_OK ) goto error;

	if( !SetTimer( 0, 250, NULL ) ) goto error;
	return TRUE;
error:
	TRACE("Fail On InitDirectDraw\n");
	EndDirectDraw();
	::MessageBox( m_hWnd, "DirectDraw ʱȭ еǾ!", "", MB_OK );
	AfxGetMainWnd()->DestroyWindow();

	return FALSE;
}

void CDirectStepView::DirectDrawProc()
{		
	HDC hdc;
	static BYTE phase = 0;
	char szFrontMsg[] = "Front Display Buffer (F12 to quit)";
	char szBackMsg[] =  "Back Display Buffer  (F12 to quit)";
		
	if( bWindowsActive != TRUE ) return;
	if( lpDDSurface2->GetDC(&hdc) == DD_OK ){
		::SetBkColor( hdc, RGB( 0, 0, 255 ) );
		::SetTextColor( hdc, RGB( 255, 255, 0 ) );
		if( phase ){
			::TextOut( hdc, 0, 0, szFrontMsg, lstrlen( szBackMsg ));
			phase = 0;
		} else {
			::TextOut( hdc, 0, 0, szBackMsg, lstrlen( szBackMsg ));
			phase = 1;
		}
		lpDDSurface2->ReleaseDC( hdc );
	}
	while(1){
		HRESULT hr;
		hr = lpDDSurface1->Flip( NULL, 0 );
		if( hr == DD_OK ) break;
		if( hr == DDERR_SURFACELOST ){
			hr = lpDDSurface1->Restore();
			if( hr != DD_OK ) break;
			hr = DDReLoadBitmap( lpDDSurface1, "test.bmp" );
			if( hr != DD_OK ) break;			
		}
		if( hr != DDERR_WASSTILLDRAWING ){
			break;
		}
	}
}

void CDirectStepView::EndDirectDraw()
{
	if( lpDD != NULL ){
		if( lpDDSurface1 != NULL ){
			lpDDSurface1->Release();
			lpDDSurface1 = NULL;
		}
		if( lpDDOffSurface1 != NULL ){
			lpDDOffSurface1->Release();
			lpDDOffSurface1 = NULL;
		}
		if( lpDDOffSurface2 != NULL ){
			lpDDOffSurface2->Release();
			lpDDOffSurface2 = NULL;
		}
		if( lpDDPal != NULL ){
			lpDDPal->Release();
			lpDDPal = NULL;
		}
		lpDD->RestoreDisplayMode();
		lpDD->Release();
		lpDD = NULL;
	}
}

int CDirectStepView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if( InitDirectDraw() == TRUE ) bDirectDrawActive = TRUE;
	
	return 0;
}

void CDirectStepView::OnDestroy() 
{
	CView::OnDestroy();	
	EndDirectDraw();
}

void CDirectStepView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);	
	bWindowsActive = TRUE;
}

void CDirectStepView::OnKillFocus(CWnd* pNewWnd) 
{
	CView::OnKillFocus(pNewWnd);
	bWindowsActive = FALSE;		
}

void CDirectStepView::OnTimer(UINT nIDEvent) 
{
	switch( nIDEvent ){
		case 0	: DirectDrawProc();
				  break;
		default : break;
	}
	CView::OnTimer(nIDEvent);
}
