// DragonView.cpp 
//

#include "stdafx.h"
#include "Dragon.h"

#include "DragonDoc.h"
#include "DragonView.h"

#include "ddutil.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDragonView

IMPLEMENT_DYNCREATE(CDragonView, CView)

BEGIN_MESSAGE_MAP(CDragonView, CView)
	//{{AFX_MSG_MAP(CDragonView)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDragonView construction/destruction

CDragonView::CDragonView()
{
	lpDD = NULL;
	lpDDSurface1 = NULL;
	lpDDSurface2 = NULL;
	lpDDOffSurface1 = NULL;
	lpDDOffSurface2 = NULL;	
	lpDDPal = NULL;

	TRACE( "Create View\n" );	
	bWindowsActive = TRUE;
	bDirectDrawActive = FALSE;
}

CDragonView::~CDragonView()
{
	EndDirectDraw();
}

BOOL CDragonView::PreCreateWindow(CREATESTRUCT& cs)
{		
	cs.style = WS_VISIBLE | WS_CHILD;

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CDragonView drawing

void CDragonView::OnDraw(CDC* pDC)
{
	CDragonDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDragonView diagnostics

#ifdef _DEBUG
void CDragonView::AssertValid() const
{
	CView::AssertValid();
}

void CDragonView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDragonDoc* CDragonView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDragonDoc)));
	return (CDragonDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDragonView message handlers
BOOL CDragonView::InitDirectDraw()
{
	DDSURFACEDESC ddsd;
	DDSCAPS	ddscaps;
	HRESULT hr;
///////// Common Part
	hr = DirectDrawCreate( NULL, &lpDD, NULL );
	if( hr != DD_OK ) goto error;

	// Get Exclusive Mode
	hr = lpDD->SetCooperativeLevel( AfxGetMainWnd()->m_hWnd,
									DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
	if( hr != DD_OK ) goto error;
	
	// Set Video Mode To 640x480x(8bit)
	hr = lpDD->SetDisplayMode( 640, 480, 8 );
	if( hr != DD_OK ) goto error;

	// Create two surface
	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
						  DDSCAPS_FLIP |
						  DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	hr = lpDD->CreateSurface( &ddsd, &lpDDSurface1, NULL );
	if( hr != DD_OK ) goto error;

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSurface1->GetAttachedSurface( &ddscaps, &lpDDSurface2 );
	if( hr != DD_OK ) goto error;
///////////////////////// End Of Common Part ////////////////////////
///////////////////////// DirectDraw Offscreen Surface //////////////
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = 480;
	ddsd.dwWidth  = 640;
	hr = lpDD->CreateSurface( &ddsd, &lpDDOffSurface1, NULL );
	if( hr != DD_OK ){ TRACE("Fail1\n"); goto error; }
	hr = lpDD->CreateSurface( &ddsd, &lpDDOffSurface2, NULL );
	if( hr != DD_OK ){ TRACE("Fail2\n"); goto error; }

	lpDDPal = DDLoadPalette( lpDD, "IDB_BITMAP2" );
	if( lpDDPal ) lpDDSurface1->SetPalette( lpDDPal );

	if( !InitSurface() ) goto error;

	if( !SetTimer( 0, 100, NULL ) ) goto error;
	bDirectDrawActive = TRUE;

	return TRUE;
error:
	TRACE("Fail On InitDirectDraw\n");
	EndDirectDraw();
	::MessageBox( m_hWnd, "DirectDraw ʱȭ еǾ!", "", MB_OK );
	AfxGetMainWnd()->DestroyWindow();
	return FALSE;
}

BOOL CDragonView::InitSurface()
{
	HBITMAP hbm;

	hbm = (HBITMAP)LoadImage( GetModuleHandle( NULL ), "IDB_BITMAP2", IMAGE_BITMAP,
		0, 0, LR_CREATEDIBSECTION );
	if( hbm == NULL ) return FALSE;
	DDCopyBitmap( lpDDOffSurface1, hbm, 0, 0, 640, 480 );
	DDCopyBitmap( lpDDOffSurface2, hbm, 0, 480, 640, 480 );
	DeleteObject( hbm );

	return TRUE;
}

HRESULT CDragonView::restoreAll()
{
	HRESULT hr;

	hr = lpDDSurface1->Restore();
	if( hr == DD_OK ){
		hr = lpDDOffSurface1->Restore();
		if( hr == DD_OK ){
			hr = lpDDOffSurface2->Restore();
			if( hr == DD_OK ){
				InitSurface();
			}
		}
	}
	return hr ;
}

void CDragonView::DirectDrawProc()
{		
	RECT rcRect;
	LPDIRECTDRAWSURFACE pdds;
	HRESULT hr;

	static BYTE phase = 0;
		
	if( bWindowsActive != TRUE ) return;
	rcRect.left = 0;
	rcRect.top = 0;
	rcRect.right = 640;
	rcRect.bottom = 480;
	
	if( phase ){
		pdds = lpDDOffSurface2;
		phase = 0;
	} else {
		pdds = lpDDOffSurface1;
		phase = 1;
	}
		
	while(1){
		hr = lpDDSurface2->BltFast( 0, 0, pdds, &rcRect, FALSE );
		if( hr == DD_OK ) break;
		if( hr == DDERR_SURFACELOST ){
			hr = restoreAll();
			if( hr != DD_OK ) break;
		}
		if( hr != DDERR_WASSTILLDRAWING ){
			break;
		}
	}
	while( 1 ){
		hr = lpDDSurface1->Flip( NULL, 0 );
		if( hr == DD_OK ) break;
		if( hr == DDERR_SURFACELOST ){
			hr = restoreAll();
			if( hr != DD_OK ) break;
		}
		if( hr != DDERR_WASSTILLDRAWING ) break;
	}
}

void CDragonView::EndDirectDraw()
{
	if( lpDD != NULL ){
		if( lpDDSurface1 != NULL ){
			lpDDSurface1->Release();
			lpDDSurface1 = NULL;
		}
		if( lpDDPal != NULL ){
			lpDDPal->Release();
			lpDDPal = NULL;
		}
		lpDD->RestoreDisplayMode();
		lpDD->Release();
		lpDD = NULL;
	}
}

void CDragonView::OnDestroy() 
{
	CView::OnDestroy();
	if( bDirectDrawActive == TRUE ) EndDirectDraw();	
}

void CDragonView::OnTimer(UINT nIDEvent) 
{	
	if( bDirectDrawActive != TRUE ) return;
	switch ( nIDEvent ){
		case 0 : DirectDrawProc(); break;
		default: break;
	}
	CView::OnTimer(nIDEvent);
}

void CDragonView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{		
	if( bDirectDrawActive != TRUE ) InitDirectDraw();
	CView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

