// DragonView.h : interface of the CDragonView class
//
/////////////////////////////////////////////////////////////////////////////

class CDragonView : public CView
{
protected: // create from serialization only
	CDragonView();
	DECLARE_DYNCREATE(CDragonView)

// Attributes
public:
	CDragonDoc* GetDocument();

// Operations
public:
	BOOL bWindowsActive;
	BOOL bDirectDrawActive;

// DirectDraw Sessions
public:
//  DirectDraw Variables
	LPDIRECTDRAW		lpDD;			 
		// Direct Draw Pointer
	LPDIRECTDRAWSURFACE	lpDDSurface1;	 
		// First Draw Surface
	LPDIRECTDRAWSURFACE lpDDSurface2;	 
		// Second Draw Surface	
	LPDIRECTDRAWSURFACE lpDDOffSurface1; 
		// First DirectDraw Offscreen Surface First
	LPDIRECTDRAWSURFACE lpDDOffSurface2; 
		// Second DirectDraw Offscreen Surface
	LPDIRECTDRAWPALETTE lpDDPal;		
		// Direct Draw Palette

	BOOL InitDirectDraw();
	HRESULT restoreAll();
	BOOL InitSurface();
	void DirectDrawProc();
	void EndDirectDraw();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDragonView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDragonView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CDragonView)
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in DragonView.cpp
inline CDragonDoc* CDragonView::GetDocument()
   { return (CDragonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
