#include<stdio.h>
// 		** FILE LIST **
// 		***************
typedef struct double_file_node {
		char name[13];
		char attr;
		unsigned time;
		unsigned date;
		long size;
		char select;
		struct double_file_node *next;
		struct double_file_node *prev;
	} F_LIST;

typedef struct {
	  int	  dirnum;
	  int     filenum;
	  int     select;
	  long    filesize;
	  long    selsize;
	  char    colors;
	  char    _FATTR;
	  char    SNAME[13];
	  char    SATTR;
	  char    fchar[50];
} FILE_TYPE;

typedef struct c_node{
	char *CFILES;
	unsigned char COLOR;
	struct c_node *next;
} COLORSYS;


 F_LIST    *head;
 F_LIST    *tail;
 F_LIST    *nowp;
 F_LIST    *start_list;

 COLORSYS   *COLORSYSTEM;
 FILE_TYPE  F_SYSTEM;
 char	    LFLINE[6][7]={{2,1,1,1,1,0,50},{1,41,80,1,1,0,39},{1,28,55,1,1,0,26},
			  {1,21,41,61,1,0,19},{1,18,35,52,67,0,12},{1,14,27,40,53,66,12}
			  };

void Free_List(void)
{
  F_LIST *node1=head,*node2;
  while(node1 != NULL) {
    node2=node1->next;
    free(node1);
    node1=node2;
  }
}

void SETDRIVE(char *DD,int n)
{
 F_LIST *temp;
 temp=(F_LIST *)malloc(sizeof(F_LIST));
 if (temp == NULL) return;
 temp->attr = 8;
 temp->date = n;
 strcpy(temp->name,DD);
 temp->select=0;
 temp->prev=tail;
 tail->next=temp;
 temp->next=NULL;
 tail=temp;
}


char DRIVE_SET(void)
{
  unsigned char DAB;
  int old,ct;
  char DDR[5]="[X:]\0";
  char dnum=0;
  outportb(0x70,0x10);
  DAB=inportb(0x71);
  if(DAB & 0x0F) {
     DDR[1]='A';
     if ((DAB & 0x0f) == 0x1 || (DAB & 0x0f) == 0x2) SETDRIVE(DDR,12); else
     if ((DAB & 0x0f) == 0x4 || (DAB & 0x0f) == 0x3) SETDRIVE(DDR,13); else
     if ((DAB & 0x0f) > 4) SETDRIVE(DDR,16);
     dnum++;
  }
  if(DAB & 0xF0) {
    DDR[1]='B';
    if ((DAB & 0xF0) >> 4 == 1 || ((DAB & 0xF0)>> 4)==2) SETDRIVE(DDR,12); else
    if (((DAB & 0xF0) >> 4) == 3 || ((DAB & 0xF0)>> 4)==4) SETDRIVE(DDR,13); else
    if (((DAB & 0xF0) >> 4) > 4) SETDRIVE(DDR,16);
    dnum++;
  }
  old=get_drive();
  for(ct=2;ct<26;ct++) {
   set_drive(ct);
   if(ct == get_drive()) {
     dnum++;
     DDR[1]='A'+ct;
     SETDRIVE(DDR,14);
   }
  }
 set_drive(old);
 return dnum;
}

int INS_FILE(char *ff_name,char ff_attr,
	       long ff_fsize,int ff_ftime,int ff_fdate,int _ms)
{
 F_LIST *temp,*ptr=head,*last;
 temp=(F_LIST *)malloc(sizeof(F_LIST));
 if (temp == NULL) return 0;
 strcpy(temp->name,ff_name);
 temp->attr=ff_attr;
 temp->size=ff_fsize;
 temp->time=ff_ftime;
 temp->date=ff_fdate;
 temp->select=0;

 if(head==NULL) {
   temp->next=NULL;
   temp->prev=NULL;
   head=temp;
   tail=temp;
   return 1;
 }
 if(_ms)
  while(ptr) {
    if(strcmp(ptr->name,temp->name)==0) return 0;
    ptr=ptr->next;
   }
   temp->prev=tail;
   temp->next=NULL;
   tail->next=temp;
   tail=temp;
  return 1;
}

void MakeDirList(FILE_TYPE *FF)
{
 struct ffblk ffblk;
 int done;
 FF->dirnum=0;
 done=findfirst("*.*",&ffblk,0xFF);
 while (!done)
 {
   if(strcmp(ffblk.ff_name,".") !=0 && (ffblk.ff_attrib & 16)) {
     if (INS_FILE(ffblk.ff_name,16,ffblk.ff_fsize,ffblk.ff_ftime,ffblk.ff_fdate,0))
     FF->dirnum++;
   }
    done = findnext(&ffblk);
 }
}

void MakeFileList(char *s_option,FILE_TYPE *FF,int _ms)
{
 struct ffblk ffblk;
 int done;
 done=findfirst(s_option,&ffblk,FF->_FATTR);
 while (!done) {
   if(!(ffblk.ff_attrib & 16) && !(ffblk.ff_attrib & 8)) {
	if(INS_FILE(ffblk.ff_name,ffblk.ff_attrib,
	       ffblk.ff_fsize,ffblk.ff_ftime,ffblk.ff_fdate,_ms)){
	 FF->filenum++;
	 FF->filesize+=ffblk.ff_fsize;
	}
   }
    done = findnext(&ffblk);
 }
}
int pers(long A,long B)
{
  float x;
  x=((float)A/(float)B) * 100;
  return (int)x;
}

void FILE_INFORM(void)
{
 struct dfree free;
 int drive,perx;
 long avail,tots;

 drive = getdisk();
 getdfree(drive+1, &free);
 if (free.df_sclus == 0xFFFF)
 {
    printf("Error in getdfree() call\n");
    exit(1);
 }
 avail=(long) free.df_avail * (long) free.df_bsec * (long) free.df_sclus;
 tots =(long) free.df_total * (long) free.df_bsec * (long) free.df_sclus;
 perx=pers(avail,tots);
 line(1,80,24,_XL,14,8,' ');
 gotoxy(2,SYSTEM._BOOM+1);
 printf("%4d",F_SYSTEM.dirnum);
 printf("%10d",F_SYSTEM.filenum);
 printf("%17lu",F_SYSTEM.filesize);
 if (tots>9999999L) {
  tots /= 1000000;
  printf("         %10ld(%d%%)Byte Free (%ldM)",avail,perx,tots);
 } else {
  tots = tots / 1000;
  printf("         %10ld(%d%%)Byte Free (%ldKB)",avail,perx,tots);
 }
 putxy1(7,24,15,8,"Dir");
 putxy1(17,24,15,8,"File");
 putxy1(34,24,15,8,"Byte");
}

void MULTI_SEARCH(char *opp)
{
 int i,st=0,sn=0;
 char foption[13];
 F_SYSTEM.filenum=0;
 F_SYSTEM.filesize=0;
 F_SYSTEM.select=0;
 F_SYSTEM.selsize=0;
 if(head) Free_List();
 head=NULL;
 tail=NULL;

 MakeDirList(&F_SYSTEM);

 for (i=0;i<strlen(opp);i++) {
  if(opp[i]==';' && i<strlen(opp)) {
    strncpy(foption,opp+st,i-st);
    foption[i-st]='\0';
    MakeFileList(foption,&F_SYSTEM,sn);
    st=i+1;
    sn=1;
  }
 }
 if (opp[i] !=';') {
    strncpy(foption,opp+st,i-st);
    foption[i-st]='\0';
    MakeFileList(foption,&F_SYSTEM,sn);
    st=i+1;
 }
}

void F_SYSTEM_ON(void)
{
  char xx;
  MULTI_SEARCH(F_SYSTEM.fchar);
  xx=DRIVE_SET();
  FILE_INFORM();
  SYSTEM.max_file=F_SYSTEM.dirnum+F_SYSTEM.filenum+xx;
}

void START_FILE(char *dir,char attr)
{
  int countt=0,maxt;
  F_LIST *temp=head,*reseac;
  SYSTEM.pos_file=0;
  SYSTEM.pos_y=0;
  nowp=head;
  start_list=head;
  while(temp) {
      if(strcmp(dir,temp->name) == 0 && temp->attr==attr) {
	nowp=temp;
	SYSTEM.pos_file=countt;
	maxt=countt % (SYSTEM.line_size*BMY);
	SYSTEM.pos_y=maxt;
	//SYSTEM.top_file=countt-maxt;
	reseac=temp;
	while(maxt--) reseac=reseac->prev;
	start_list=reseac;
      }
      countt++;
      temp=temp->next;
  }
}
	/*=====================FILE EXPRESS~!=========================*/
	char ADD_COLOR(char *extx,unsigned char ccc)
	{
	  COLORSYS *temp,*mm=COLORSYSTEM;
	  temp=(COLORSYS *)malloc(sizeof(COLORSYS));
	  if(temp == NULL) return 0;
	  temp->CFILES=strdup(extx);
	  temp->COLOR=ccc;
	  temp->next=mm;
	  COLORSYSTEM=temp;
	  return 1;
	}
	void DISPOSE_COLOR(void)
	{
	  COLORSYS *temp=COLORSYSTEM,*temp2;
	  while(temp) {
	     temp2=temp->next;
	     free(temp);
	     temp=temp2;
	  }
	}

	int IS_COLOR(char *extt)
	{
	  COLORSYS *temp=COLORSYSTEM;
	  while(temp) {
	   if(strcmp(temp->CFILES,extt) == 0) return (int)temp->COLOR;
	   temp=temp->next;
	  }
	  return 7;
	}

	void Default_color(void)
	{
	 ADD_COLOR("EXE",10);
	 ADD_COLOR("COM",11);
	 ADD_COLOR("BAT",14);
	 ADD_COLOR("C",9);
	 ADD_COLOR("H",1);
	 ADD_COLOR("OBJ",1);
	 ADD_COLOR("PAS",9);
	 ADD_COLOR("TXT",9);
	 ADD_COLOR("DOC",9);
	 ADD_COLOR("HWP",9);
	 ADD_COLOR("CAP",9);
	 ADD_COLOR("PCX",6);
	 ADD_COLOR("GIF",6);
	 ADD_COLOR("JPG",6);
	 ADD_COLOR("TIF",9);
	 ADD_COLOR("BAK",8);
	 ADD_COLOR("$$$",8);
	 ADD_COLOR("SWP",8);
	 ADD_COLOR("ARJ",13);
	 ADD_COLOR("LZH",13);
	 ADD_COLOR("ZIP",13);
	 ADD_COLOR("RAR",13);
	}

	char *fnext(char *x)
	{
	 char *file="   ";
	 strnset(file,32,4);
	 fnsplit(x,NULL,NULL,NULL,file);
	 return strcpy(file ,file+1);
	}

	char *FILEX(F_LIST *x)
	{
	  char *cmpli="              ";
	  char file[9];
	  char file2[5];
	  if(x->attr & 16 || x->attr & 8) return ("%s",x->name);
	  fnsplit(x->name,NULL,NULL,file,file2);
	  strnset(cmpli,' ',14);
	  strcpy(cmpli,file);
	  cmpli[strlen(file)]=' ';
	  strncpy(cmpli+9,file2+1,strlen(file2)+1);
	  return cmpli;
	}

#define invert_bar(a)		(a << 4)
#define _SEL_BAR		7
	void SELE2SC(F_LIST *LC,int y,char _invert)
	{
	 int MC=12,LFF=LFLINE[SYSTEM.line_size-1][y / BMY];
	 char tc=7;
	 MOUSE_HIDDEN();
	 if(LC->attr != 16) MC=IS_COLOR(fnext(LC->name));
	 if(_invert) {
	   MC=invert_bar(MC);
	   tc=0;
	 }
	 if (LC->select) putcxy(LFF+8,(y % BMY)+4,tc << 1,MC >> 4,_SEL_BAR);
		    else putcxy(LFF+8,(y % BMY)+4,tc << 1,MC >> 4,32);
	 MOUSE_ACHIVE();
	}

	void FILE2SC(F_LIST *LC,int y,char _invert)
	{
	 int MC=12,LFF=LFLINE[SYSTEM.line_size-1][y / BMY];
	 int _CULS=(y %BMY) + 4;
	 char tc=7,bc=SYB2,tc2=7;
	 char *fcc="             ";

	 MOUSE_HIDDEN();
	 if(LC->attr != 16  && LC->attr != 8) MC=IS_COLOR(fnext(LC->name));
	 if(LC->attr == 8) MC=6;
	 line(LFF,LFF+11,_CULS,_XL,0,MC>>4,NONL);
	 if(LC->attr & 1 || LC->attr & 4) tc2=15;
	 if(LC->attr & 2) tc2=12;
	 if(_invert) {
	   MC=invert_bar(MC);
	   tc=0;bc=MC >> 4;tc2=0;
	   line(LFF,LFLINE[SYSTEM.line_size-1][6]+LFF-1,_CULS,_XL,MC,0,NONL);
	   putxy1(6,MBY,0,SYSTEM._TCBOOM,"                       ");
	   if(LC->attr == 16) {
	      putxy(8,MBY,14,SYSTEM._TCBOOM,"Directory");
	      Put_Datex(24,MBY,15,SYSTEM._TCBOOM,LC->date);
	   } else if(LC->attr == 8) {
	     putxy(8,MBY,14,SYSTEM._TCBOOM,"Drive     ");
	   } else {
	    putxy(7+11-strlen(UL2ST(LC->size)),25,15,SYSTEM._TCBOOM,UL2ST(LC->size));
	    Put_Attr(19,MBY,15,SYSTEM._TCBOOM,LC->attr);
	    Put_Datex(24,MBY,15,SYSTEM._TCBOOM,LC->date);
	   }
	 } else
	 line(LFF+12,LFLINE[SYSTEM.line_size-1][6]+LFF-1,_CULS,_XL,0,SYB2,NONL);
	 strcpy(fcc,FILEX(LC));
	 if(SYSTEM.AUTO_LINE & 2 && LC->attr != 8) putxy(LFF,_CULS,MC & 0xf,MC >> 4,strlwr(FILEX(LC)));
	 else putxy(LFF,_CULS,MC & 0xf,MC >> 4,FILEX(LC));
	 if(LC->attr == 8) putxy(LFF+5,_CULS,tc2,bc,MESSAGE(LC->date,0));
	 if (LC->select) putcxy(LFF+8,_CULS,tc << 1,bc,_SEL_BAR);
	 if(SYSTEM.line_size == 4) {
	   if(LC->attr & 16)
	    putxy(LFF+12+(SYSTEM.line_size & 1),_CULS,MC & 0xf,bc,"[ Dir ]");
	     else if(LC->attr != 8) Put_4(LFF+13,_CULS,tc2,bc,LC->size);
	    } else if(SYSTEM.line_size < 4) {
	   if(LC->attr & 16) {
	    if(strcmp(LC->name,"..") != 0)
	    putxy(LFF+13+(SYSTEM.line_size & 1),_CULS,MC & 0xf,bc,"[ SubDir ]");
	    else
	    putxy(LFF+13+(SYSTEM.line_size & 1),_CULS,MC & 0xf,bc,"[ Up-Dir ]");
	   } else if(LC->attr != 8)  {
	   putxy(LFF+13+10-strlen(UL2ST(LC->size))+(SYSTEM.line_size & 1),
	   _CULS,tc2,bc,UL2ST(LC->size));
	   }
	 }
	 if(SYSTEM.line_size < 3 && LC->attr != 8) {
	   Put_Datex(LFF+24+(SYSTEM.line_size & 1),_CULS,tc,bc,LC->date);
	   Put_Timex(LFF+33+(SYSTEM.line_size & 1),_CULS,tc,bc,LC->time,SYSTEM.line_size-1);
	  }
	 if(SYSTEM.line_size == 1 && LC->attr != 8) Put_Attr(LFF+44,_CULS,tc2,bc,LC->attr);
	 MOUSE_ACHIVE();
	}

	void FILE2SC4M(void)
	{
	 int i,max=SYSTEM.line_size*BMY;
	 F_LIST *sts=start_list;
	 for(i=0;i<max;i++) {
	   if (sts){
	     FILE2SC(sts,i,0);
	     sts=sts->next;
	  } else return;
	 }
	}

	void SELE2SC4M(void)
	{
	 int i,max=SYSTEM.line_size*BMY;
	 F_LIST *sts=start_list;
	 for(i=0;i<max;i++) {
	   if (sts){
	     SELE2SC(sts,i,0);
	     sts=sts->next;
	  } else return;
	 }
	}
	int SEL2FIND(char *fn)
	{
	 F_LIST *sts=nowp;
	 int cnt=SYSTEM.pos_file;
	 while(sts) {
	  if(strncmp(sts->name,fn,SYSTEM.FSN)==0) {
	   strcpy(F_SYSTEM.SNAME,sts->name);
	   F_SYSTEM.SATTR=sts->attr;
	   SYSTEM.FSN++;
	   return cnt;
	  }
	  cnt++;
	 }
	 sts=head;
	 cnt=0;
	 while(sts) {
	  if(strcmp(sts->name,fn)==0) {
	   strncmp(F_SYSTEM.SNAME,sts->name,SYSTEM.FSN);
	   F_SYSTEM.SATTR=sts->attr;
	   SYSTEM.FSN++;
	    return cnt;
	  }
	  cnt++;
	 }
	 return -1;
	}

char *UNDERPATH(void)
{
 char paths[MAXDIR],pa;
 char *repath="             ";
 getcwd(paths, MAXPATH);
 pa=strlen(paths);
 while(paths[pa] != '\\') {
  pa--;
 }
 return strcpy(repath,paths+pa+1);
}

void TIME_BAR(void)
{
 struct  time t;
 struct  dosdate_t d;
 char AMPM[2]="Am";
 char *MONSP[7]={"SUN","MON","TUE","WED","THU","FRI","SAT"};

 static char i;
 static struct  dosdate_t d_b;

  _dos_getdate(&d);
  gettime(&t);
  if (d.year != d_b.year || d.month!= d_b.month || d.day != d_b.day) {
    _dos_getdate(&d_b);
    gotoxy(34,MBY);
    textcolor(15+_BLINK(SYSTEM._TCBOOM));
    textbackground(SYSTEM._TCBOOM);
    cprintf("%02d-%02d-%02d(%s)",d.year % 100,d.month,d.day,MONSP[d.dayofweek]);
  }
  if (t.ti_sec == i) return;
  gotoxy(48,MBY);
  textcolor(15+_BLINK(SYSTEM._TCBOOM));
  textbackground(SYSTEM._TCBOOM);
  if(t.ti_hour>12) {
    t.ti_hour-=12;
    strcpy(AMPM,"Pm");
  }
  cprintf("%02d:%02d:%02d",t.ti_hour,t.ti_min,t.ti_sec);
  i=t.ti_sec;
}


void LF_BOOM_SYS(void)
{
  char *MONSP[7]={"SUN","MON","TUE","WED","THU","FRI","SAT"};
  struct dosdate_t d;
  _dos_getdate(&d);

  d.year =d.year % 100;
  gotoxy(34,MBY);
  textcolor(15+_BLINK(SYSTEM._TCBOOM));
  textbackground(SYSTEM._TCBOOM);

  cprintf("%02d-%02d-%02d(%s)",d.year,d.month,d.day,MONSP[d.dayofweek]);
  putcxy(47,MBY,8,SYSTEM._TCBOOM,179);
  putcxy(56,MBY,8,SYSTEM._TCBOOM,179);
  TIME_BAR();
}