extern int  Y_TABLE[201];

char CheckCrush(short sx1,short sy1,short dx1,short dy1,short sx2,short sy2,short dx2,short dy2)
{
    if (min((sx2+sx1),(dx2+dx1)) > max((sx1),(dx1)))
	if(min((sy2+sy1),(dy2+dy1)) > max((sy1),(dy1))) return 1 ;
    return 0 ;
}

short RELOCATE(short x)
{
  short a,b=0;
  a=x-160;
  if (a !=0) b = a >> 3;
  return (x-b-5);
}

short RELOCATEY(short x)
{
  short a,b=0;
  a=x-120;
  if (a !=0) b = a >> 2;
  return (x-b);
}

int PLUSVAL(int x)
{
  if (x<1) return x*(-1);
  return x;
}

void SHADOW(int x,int y,int sx,int sy,int zper,char *img,char *target)
{
 unsigned int iy, ix,scx=x,scy=y;
 int yerror = 0, xerror;
 unsigned int bitptr = 0, old_bitptr;
 for (iy=0; iy<sy; iy++) {
   yerror+=zper;
   while (yerror>100) {
     yerror-=100;
     old_bitptr=bitptr;
     xerror = 0;
     for (ix=0; ix<sx; ix++) {
       xerror+=zper;
       while(xerror>100) {
	 xerror-=100;
	 if (img[bitptr] != 0 && scx < 320 && scy < 200)
	  target[Y_TABLE[scy]+scx]=DARK_PAL[target[Y_TABLE[scy]+scx]];
	 scx++;
       }
	 bitptr++;
     }
	 scx=x;scy++;
	 if (scy > 199) return;
	 bitptr=old_bitptr;
   }
   bitptr+=sx;
 }
}

void WAV_SET()
{
  shoteff = MODLoadSample("RESOURCE.999",1);
  expleff = MODLoadSample("RESOURCE.999",2);
  pain    = MODLoadSample("RESOURCE.999",3);
  big_shot   = MODLoadSample("RESOURCE.999",4);
  add_option = MODLoadSample("RESOURCE.999",5);
  w_mgun     = MODLoadSample("RESOURCE.999",6);
  w_laser    = MODLoadSample("RESOURCE.999",7);
  warring    = MODLoadSample("RESOURCE.999",8);
  fire_wav   = MODLoadSample("RESOURCE.999",9);
  aha_wav    = MODLoadSample("RESOURCE.999",10);
}

void WAV_OUT(char num)
{
  if (_SOUNDCARD) return;
  switch(num){
      case W_EXPLO:
	   MODPlaySample(5,expleff);
	   break;
      case W_SHOOT:
	   MODPlaySample(6,shoteff);
	   break;
      case W_PAIN:
	   MODPlaySample(4,pain);
	   break;
      case  W_BIGBIM:
	   MODPlaySample(4,big_shot);
	   break;
      case W_ADD_OPTION:
	   MODPlaySample(4,add_option);
	   break;
      case MGUN:
	   MODPlaySample(7,w_mgun);
	   break;
      case LASER:
	   MODPlaySample(6,w_laser);
	   break;
      case W_WAR:
	   MODPlaySample(4,warring);
	   break;
      case FIRE_W:
	    MODPlaySample(7,fire_wav);
	  break;
      case KILLED:
	    MODPlaySample(7,aha_wav);
	  break;

  }
}

void MUSIC_OUT(char *fn,char mnum)
{
 if (_SOUNDCARD) return;
 music = MODLoadModule(fn,mnum);
 MODPlayModule(music, 8, 22222, Port, IRQ, DRQ, PM_TIMER);
}

void PLAYER_BASIC()
{
 FORCE.LIFE=500;
 FORCE.FILM=0;
  FORCE.SHOT2=0;
 FORCE.LC=0;
 FORCE.RC=0;
 FORCE.WH=0;
 FORCE.STATE=0;   // It's LEVEL..
 FORCE.CNT=0;
 FORCE.CNT2=0;
 FORCE.OP_S=0;
 FORCE.OP_LIVE=0;
 FORCE.SCORE=0;
 FORCE.MISS=1;
 FORCE.WARR=0;
 G_MAIN.T_MIS=0;
 G_MAIN.MY_SPEED=2;
 G_MAIN.CLOUD_NUM=0;
}

void SET_PAGES(char STG)
{
 FORCE.x=150;
 FORCE.y=160;
 switch(STG) {
  case 0:
	 free(G_MAP);free(T_PAGE);
	 break;
  case 1:
	  G_MAP=(BYTE *)malloc(64000);
	  T_PAGE=(BYTE *)malloc(64000);
	  PLAYER_BASIC();
	  MUSIC_OUT("RESOURCE.999",2);
	  Clearmem(0,G_MAP);
	  SET_ROL_BACK("RESOURCE.000",1000,46,G_MAP,0);
	  BOSSDIE=0;
	  break;
  case 2:
	  G_MAP=(BYTE *)malloc(64000);
	  T_PAGE=(BYTE *)malloc(64000);
	  MUSIC_OUT("RESOURCE.999",3);
	  Clearmem(0,G_MAP);
	  SET_ROL_BACK("RESOURCE.002",0,1,G_MAP,1);
	  BOSSDIE=0;
	  break;
 }
}

void WAV_FREE()
{
 MODFreeSample(expleff);
 MODFreeSample(expleff);
 MODFreeSample(pain);
 MODFreeSample(big_shot);
 MODFreeSample(add_option);
}

void SET_PLAYER(char *fn)
{
 PLAYER_BASIC();
 IMAGE_MANAGER(fn,1,&PLAYERS[0].x,&PLAYERS[0].y,&PLAYERS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,2,&PLAYERS[2].x,&PLAYERS[2].y,&PLAYERS[2].spr,UNPACK);
 IMAGE_MANAGER(fn,3,&PLAYERS[1].x,&PLAYERS[1].y,&PLAYERS[1].spr,UNPACK);
}

void SET_MYSHOT(char *fn)
{
 IMAGE_MANAGER(fn,4,&MY_SHOT[0].x,&MY_SHOT[0].y,&MY_SHOT[0].spr,UNPACK);
 IMAGE_MANAGER(fn,5,&MY_SHOT[1].x,&MY_SHOT[1].y,&MY_SHOT[1].spr,UNPACK);
 IMAGE_MANAGER(fn,6,&MY_SHOT[2].x,&MY_SHOT[2].y,&MY_SHOT[2].spr,UNPACK);

 IMAGE_MANAGER(fn,8,&MY_SHOT[3].x,&MY_SHOT[3].y,&MY_SHOT[3].spr,UNPACK);
 IMAGE_MANAGER(fn,9,&MY_SHOT[4].x,&MY_SHOT[4].y,&MY_SHOT[4].spr,UNPACK);
 IMAGE_MANAGER(fn,10,&MY_SHOT[5].x,&MY_SHOT[5].y,&MY_SHOT[5].spr,UNPACK);
 IMAGE_MANAGER(fn,32,&MY_SHOT[6].x,&MY_SHOT[6].y,&MY_SHOT[6].spr,UNPACK);
 IMAGE_MANAGER(fn,33,&MY_SHOT[7].x,&MY_SHOT[7].y,&MY_SHOT[7].spr,UNPACK);
 IMAGE_MANAGER(fn,34,&MY_SHOT[8].x,&MY_SHOT[8].y,&MY_SHOT[8].spr,UNPACK);
 IMAGE_MANAGER(fn,7,&MY_SHOT[9].x,&MY_SHOT[9].y,&MY_SHOT[9].spr,UNPACK);
 IMAGE_MANAGER(fn,69,&MY_SHOT[10].x,&MY_SHOT[10].y,&MY_SHOT[10].spr,UNPACK);
 IMAGE_MANAGER(fn,31,&ATTEND.x,&ATTEND.y,&ATTEND.spr,UNPACK);
}

void SET_STAGE2(char *fn)
{
 IMAGE_MANAGER(fn,75,&GR_EN[0].x,&GR_EN[0].y,&GR_EN[0].spr,UNPACK);
 IMAGE_MANAGER(fn,70,&GR_EN[1].x,&GR_EN[1].y,&GR_EN[1].spr,UNPACK);
 IMAGE_MANAGER(fn,71,&GR_EN[2].x,&GR_EN[2].y,&GR_EN[2].spr,UNPACK);
 IMAGE_MANAGER(fn,72,&GR_EN[3].x,&GR_EN[3].y,&GR_EN[3].spr,UNPACK);
 IMAGE_MANAGER(fn,73,&GR_EN[4].x,&GR_EN[4].y,&GR_EN[4].spr,UNPACK);
 IMAGE_MANAGER(fn,74,&GR_EN[5].x,&GR_EN[5].y,&GR_EN[5].spr,UNPACK);
}

void SET_PHENOMENON(char *fn)
{
 IMAGE_MANAGER(fn,18,&SMOGSPR[0].x,&SMOGSPR[0].y,&SMOGSPR[0].spr,UNPACK);
 IMAGE_MANAGER(fn,17,&SMOGSPR[1].x,&SMOGSPR[1].y,&SMOGSPR[1].spr,UNPACK);
 IMAGE_MANAGER(fn,16,&SMOGSPR[2].x,&SMOGSPR[2].y,&SMOGSPR[2].spr,UNPACK);
 IMAGE_MANAGER(fn,15,&SMOGSPR[3].x,&SMOGSPR[3].y,&SMOGSPR[3].spr,UNPACK);
 IMAGE_MANAGER(fn,14,&SMOGSPR[4].x,&SMOGSPR[4].y,&SMOGSPR[4].spr,UNPACK);
 IMAGE_MANAGER(fn,13,&SMOGSPR[5].x,&SMOGSPR[5].y,&SMOGSPR[5].spr,UNPACK);
 IMAGE_MANAGER(fn,12,&SMOGSPR[6].x,&SMOGSPR[6].y,&SMOGSPR[6].spr,UNPACK);

 IMAGE_MANAGER(fn,19,&EXPLOS[0].x,&EXPLOS[0].y,&EXPLOS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,20,&EXPLOS[1].x,&EXPLOS[1].y,&EXPLOS[1].spr,UNPACK);
 IMAGE_MANAGER(fn,21,&EXPLOS[2].x,&EXPLOS[2].y,&EXPLOS[2].spr,UNPACK);
 IMAGE_MANAGER(fn,22,&EXPLOS[3].x,&EXPLOS[3].y,&EXPLOS[3].spr,UNPACK);

 IMAGE_MANAGER(fn,23,&PIECES[0].x,&PIECES[0].y,&PIECES[0].spr,UNPACK);
 IMAGE_MANAGER(fn,24,&PIECES[1].x,&PIECES[1].y,&PIECES[1].spr,UNPACK);
 IMAGE_MANAGER(fn,25,&PIECES[2].x,&PIECES[2].y,&PIECES[2].spr,UNPACK);
 IMAGE_MANAGER(fn,26,&PIECES[3].x,&PIECES[3].y,&PIECES[3].spr,UNPACK);
 IMAGE_MANAGER(fn,27,&PIECES[4].x,&PIECES[4].y,&PIECES[4].spr,UNPACK);

 IMAGE_MANAGER(fn,28,&CLOUDS[0].x,&CLOUDS[0].y,&CLOUDS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,29,&CLOUDS[1].x,&CLOUDS[1].y,&CLOUDS[1].spr,UNPACK);
 IMAGE_MANAGER(fn,30,&CLOUDS[2].x,&CLOUDS[2].y,&CLOUDS[2].spr,UNPACK);
}

void SET_ENEMYS(char *fn)
{
 IMAGE_MANAGER(fn,35,&E_SHOT[0].x,&E_SHOT[0].y,&E_SHOT[0].spr,UNPACK);
 IMAGE_MANAGER(fn,36,&E_SHOT[1].x,&E_SHOT[1].y,&E_SHOT[1].spr,UNPACK);
 IMAGE_MANAGER(fn,37,&E_SHOT[2].x,&E_SHOT[2].y,&E_SHOT[2].spr,UNPACK);
 IMAGE_MANAGER(fn,45,&E_SHOT[3].x,&E_SHOT[3].y,&E_SHOT[3].spr,UNPACK);
 IMAGE_MANAGER(fn,76,&E_SHOT[4].x,&E_SHOT[4].y,&E_SHOT[4].spr,UNPACK);
 IMAGE_MANAGER(fn,77,&E_SHOT[5].x,&E_SHOT[5].y,&E_SHOT[5].spr,UNPACK);

 IMAGE_MANAGER(fn,38,&ENEMYS[0].x,&ENEMYS[0].y,&ENEMYS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,44,&ENEMYS[1].x,&ENEMYS[1].y,&ENEMYS[1].spr,UNPACK);
 IMAGE_MANAGER(fn,39,&ENEMYS[2].x,&ENEMYS[2].y,&ENEMYS[2].spr,UNPACK);
 IMAGE_MANAGER(fn,40,&ENEMYS[3].x,&ENEMYS[3].y,&ENEMYS[3].spr,UNPACK);
 IMAGE_MANAGER(fn,43,&ENEMYS[4].x,&ENEMYS[4].y,&ENEMYS[4].spr,UNPACK);
 IMAGE_MANAGER(fn,47,&ENEMYS[5].x,&ENEMYS[5].y,&ENEMYS[5].spr,UNPACK);

 IMAGE_MANAGER(fn,42,&ENEMYS[6].x,&ENEMYS[6].y,&ENEMYS[6].spr,UNPACK);
 IMAGE_MANAGER(fn,63,&ENEMYS[7].x,&ENEMYS[7].y,&ENEMYS[7].spr,UNPACK);
 IMAGE_MANAGER(fn,41,&ENEMYS[8].x,&ENEMYS[8].y,&ENEMYS[8].spr,UNPACK);
 IMAGE_MANAGER(fn,64,&ENEMYS[9].x,&ENEMYS[9].y,&ENEMYS[9].spr,UNPACK);
 IMAGE_MANAGER(fn,67,&ENEMYS[10].x,&ENEMYS[10].y,&ENEMYS[10].spr,UNPACK);
 IMAGE_MANAGER(fn,68,&BOSSSPR[0].x,&BOSSSPR[0].y,&BOSSSPR[0].spr,UNPACK);
}

void SET_ITEMS(char *fn)
{
 IMAGE_MANAGER(fn,48,&ITEMS[0].x,&ITEMS[0].y,&ITEMS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,49,&ITEMS[1].x,&ITEMS[1].y,&ITEMS[1].spr,UNPACK);
 IMAGE_MANAGER(fn,50,&ITEMS[2].x,&ITEMS[2].y,&ITEMS[2].spr,UNPACK);
 IMAGE_MANAGER(fn,51,&ITEMS[3].x,&ITEMS[3].y,&ITEMS[3].spr,UNPACK);
 IMAGE_MANAGER(fn,52,&ITEMS[4].x,&ITEMS[4].y,&ITEMS[4].spr,UNPACK);
 IMAGE_MANAGER(fn,83,&ITEMS[5].x,&ITEMS[5].y,&ITEMS[5].spr,UNPACK);
}

void SET_NUMS(char *fn)
{
 IMAGE_MANAGER(fn,53,&NUMS[0].x,&NUMS[0].y,&NUMS[0].spr,UNPACK);
 IMAGE_MANAGER(fn,54,&NUMS[1].x,&NUMS[1].y,&NUMS[1].spr,UNPACK);
 IMAGE_MANAGER(fn,55,&NUMS[2].x,&NUMS[2].y,&NUMS[2].spr,UNPACK);
 IMAGE_MANAGER(fn,56,&NUMS[3].x,&NUMS[3].y,&NUMS[3].spr,UNPACK);
 IMAGE_MANAGER(fn,57,&NUMS[4].x,&NUMS[4].y,&NUMS[4].spr,UNPACK);
 IMAGE_MANAGER(fn,58,&NUMS[5].x,&NUMS[5].y,&NUMS[5].spr,UNPACK);
 IMAGE_MANAGER(fn,59,&NUMS[6].x,&NUMS[6].y,&NUMS[6].spr,UNPACK);
 IMAGE_MANAGER(fn,60,&NUMS[7].x,&NUMS[7].y,&NUMS[7].spr,UNPACK);
 IMAGE_MANAGER(fn,61,&NUMS[8].x,&NUMS[8].y,&NUMS[8].spr,UNPACK);
 IMAGE_MANAGER(fn,62,&NUMS[9].x,&NUMS[9].y,&NUMS[9].spr,UNPACK);
}

char DEL_character(NODE **headx)
{
  NODE *this=*headx,*prev=NULL;
  while(this != NULL) {
    if(this->LIFE<=0){
      if(*headx==this) *headx=this->next;
      else prev->next=this->next;
      free(this);
      return 1;
    }
  prev=this;
  this=this->next;
  }
return 0;
}

void DEL_char(NODE **headx)
{
  NODE *this=*headx,*prev=NULL;
  while(this != NULL) {
      if(*headx==this) *headx=this->next;
      else prev->next=this->next;
      free(this);
      return;
  }
}

void E_SHOTING(int x1,int y1,int x2,int y2,short *xadd,short *yadd)
{
   float x,y,z;

   x = x1-x2;
   y = y1-y2;

   z=sqrt(x*x+y*y);
   if(z==0) {
       *xadd = 0;
       *yadd = 0;
       return;
   }
   *xadd = x*8/z;
   *yadd = y*8/z;
}

void MAKE_SMOG(NODE **headx,short x,short y)
{
 NODE *newchr;
 if(y>199) return;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SMOG;
 newchr->LIFE=1;
 newchr->ENEMY=0;
 newchr->FILM=6;
 newchr->COUNT=0;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_ESHOT(NODE **headx,short x,short y,char LF,char FL)
{
 NODE *newchr;
 short a,b;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=ESHOT2;
 newchr->LIFE=LF;
 newchr->ENEMY=1;
 newchr->FILM=FL;
 newchr->STATE=0;
 E_SHOTING(x,y,FORCE.x,FORCE.y,&a,&b);
 newchr->COUNT=a;
 newchr->COUNT2=b;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_CLOUD(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=CLOUD;
 newchr->LIFE=1;
 newchr->ENEMY=0;
 newchr->FILM=getrandom(0,2);
 newchr->COUNT=getrandom(2,7);
 newchr->x=x;
 newchr->y=-20;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_PIECE(NODE **headx,short x,short y)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=PIECE+getrandom(0,1);
 newchr->LIFE=getrandom(5,30);
 newchr->ENEMY=0;
 newchr->FILM=getrandom(0,4);
 newchr->COUNT=getrandom(-7,7);
 newchr->COUNT2=getrandom(-5,8);
 newchr->STATE=0;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_ITEM(NODE **headx,short x,short y,char WHAT)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=ITEM;
 newchr->LIFE=1;
 newchr->ENEMY=0;
 newchr->FILM=WHAT;
 newchr->COUNT=1;
 newchr->COUNT2=1;
 newchr->STATE=10;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}
void MAKE_BOSS1(NODE **headx)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=BOSS1;
 newchr->LIFE=5500;
 newchr->ENEMY=1;
 newchr->FILM=0;
 newchr->COUNT=1;
 newchr->COUNT2=1;
 newchr->STATE=1;
 newchr->x=160-(BOSSSPR[0].x >> 1);
 newchr->y=-BOSSSPR[0].y;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_ALL_SHOT(NODE **headx,short LX,short LY,short ADDX,short ADDY,char POWER,char FILM,char ISENEMY)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=ESHOT;
 newchr->LIFE=POWER;
 newchr->ENEMY=ISENEMY;
 newchr->FILM=FILM;
 newchr->STATE=0;
 newchr->x=LX;
 newchr->y=LY;
 newchr->COUNT=-ADDX;
 newchr->COUNT2=-ADDY;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_ALL_SHOT2(NODE **headx,short LX,short LY,short ADDX,short ADDY,char POWER,char FILM,char ISENEMY,char ENTYPE)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=ENTYPE;
 newchr->LIFE=POWER;
 newchr->ENEMY=ISENEMY;
 newchr->FILM=FILM;
 newchr->STATE=getrandom(20,60);
 newchr->x=LX;
 newchr->y=LY;
 newchr->COUNT=-ADDX;
 newchr->COUNT2=-ADDY;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_SOMA(NODE **headx,char go_lr,short x,short y)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SOMA;
 newchr->LIFE=10;
 newchr->ENEMY=1;
 newchr->FILM=1;
 newchr->STATE=0;
 newchr->COUNT2=40;
 newchr->x=x;
 newchr->y=y;
 switch(go_lr) {
    case 0:newchr->COUNT=-3;
	   break;
    case 1:newchr->COUNT=3;
	   break;
 }
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_SOMA2(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SOMA2;
 newchr->LIFE=15;
 newchr->ENEMY=1;
 newchr->FILM=2;
 newchr->STATE=0;
 newchr->COUNT2=40;
 newchr->x=x;
 newchr->y=-20;
 if(x>FORCE.x) newchr->COUNT=-2; else
 if(x<FORCE.x+PLAYERS[0].x) newchr->COUNT=2;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_ROBO(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=ROBO;
 newchr->LIFE=200;
 newchr->ENEMY=1;
 newchr->FILM=4;
 newchr->STATE=0;
 newchr->x=x;
 newchr->y=-20;
 newchr->COUNT=0;
 newchr->COUNT2=0;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_SOMA3(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SOMA3;
 newchr->LIFE=30;
 newchr->ENEMY=1;
 newchr->FILM=3;
 newchr->STATE=0;
 newchr->COUNT2=0;
 newchr->x=x;
 newchr->y=-20;
 newchr->COUNT=0;
 newchr->next=*headx;
 *headx=newchr;
}
void MAKE_SOMA4(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SOMA4;
 newchr->LIFE=67;
 newchr->ENEMY=1;
 newchr->FILM=10;
 newchr->STATE=0;
 newchr->COUNT=4;
 newchr->COUNT2=30;
 newchr->x=x;
 newchr->y=-20;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_SOMA5(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=SOMA5;
 newchr->LIFE=35;
 newchr->ENEMY=1;
 newchr->FILM=10;
 newchr->STATE=0;
 newchr->COUNT=getrandom(0,2);
 newchr->COUNT2=0;
 newchr->x=x;
 newchr->y=-20;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_SOMA6(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 if (x>=160) newchr->NAME=SOMA6L; else newchr->NAME=SOMA6R;
 newchr->LIFE=60;
 newchr->ENEMY=1;
 newchr->FILM=0;
 newchr->STATE=0;
 newchr->COUNT=4;
 newchr->COUNT2=10;
 newchr->x=x;
 newchr->y=-20;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_TANK(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=TANK;
 newchr->LIFE=100;
 newchr->ENEMY=1;
 newchr->FILM=1;
 newchr->STATE=1;
 newchr->COUNT2=270;
 newchr->x=x;
 newchr->y=-20;
 newchr->COUNT=0;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_GRA(NODE **headx,short x)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=GR_ENA;
 newchr->LIFE=55;
 newchr->ENEMY=0;
 newchr->FILM=0;
 newchr->STATE=0;
 newchr->COUNT=30;
 newchr->COUNT2=getrandom(25,50);
 newchr->x=x;
 newchr->y=-20;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_OPTION(NODE **headx,short x,short y,char lr,short CT,char OS)
{

  //  CT ==> fire delay
  //  OS ==> OPTION fire is...
 NODE *newchr;
 if(y>199) return;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=lr;
 newchr->LIFE=350;
 newchr->ENEMY=2;
 newchr->STATE=OS;
 newchr->FILM=0;
 newchr->COUNT=0;
 newchr->COUNT2=CT;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}

void MAKE_EXPLOS(NODE **headx,NODE *killme,short x,short y)
{
 NODE *newchr;
 char i;
 for(i=0;i<10;i++)MAKE_PIECE(&e_header,x,y);
 WAV_OUT(W_EXPLO);
 killme->LIFE=0;
 if(y>199) return;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=EXPLO;
 newchr->LIFE=1;
 newchr->ENEMY=0;
 newchr->FILM=0;
 newchr->COUNT=0;
 newchr->x=x;
 newchr->y=y;
 newchr->next=*headx;
 *headx=newchr;
}

void LOWENG(short x,short y,short now,short low)
{
 if(now<=low && now > 0) if (getrandom(0,5)==1) MAKE_SMOG(&e_header,x,y);
}
char IS_BREAK(NODE *me,NODE *it,char B_ES)
	// B_ES  0 = It's ENEMY
	// B_ES  1 = It's BULLET
	// B_ES  2 = BOSS
{
  char ress=0;
  int sx,sy,rets;
  while(it != NULL) {
    if(it->LIFE > 0){
     switch(it->NAME) {
      case M_SHOT:
		  sx=MY_SHOT[it->FILM].x;
		  sy=MY_SHOT[it->FILM].y;
		  break;
      case ATTENDL : case ATTENDR :
		  sx=ATTEND.x;
		  sy=ATTEND.y;
		  break;
     }
     if (B_ES==0){
      if(CheckCrush(it->x,it->y,me->x,me->y,sx,sy,ENEMYS[me->FILM].x,ENEMYS[me->FILM].y))
      {
	if(it->NAME != M_SHOT) {
	   rets=me->LIFE;
	   me->LIFE-=it->LIFE; it->LIFE -=rets;MAKE_SMOG(&e_header,it->x,it->y);
	   if(it->LIFE<=0) {
	      MAKE_EXPLOS(&e_header,it,it->x,it->y);
	      if(it->NAME==ATTENDL) FORCE.OP_LIVE--;
	      else if(it->NAME==ATTENDR) FORCE.OP_LIVE-=2;
	   }
	}
	 else  { rets=me->LIFE;me->LIFE -= it->LIFE;it->LIFE-=rets;}
	  MAKE_SMOG(&e_header,it->x,it->y);
	}
      } else if (B_ES==2){
      if(CheckCrush(it->x,it->y,me->x,me->y,sx,sy,BOSSSPR[me->FILM].x,BOSSSPR[me->FILM].y))
      {
	if(it->NAME != M_SHOT) {
	   rets=me->LIFE;
	   ress=1;
	   me->LIFE-=it->LIFE; it->LIFE -=rets;MAKE_SMOG(&e_header,it->x,it->y);
	   if(it->LIFE<=0) {
	      MAKE_EXPLOS(&e_header,it,it->x,it->y);
	      if(it->NAME==ATTENDL) FORCE.OP_LIVE--;
	      else if(it->NAME==ATTENDR) FORCE.OP_LIVE-=2;
	   }
	}
	 else  { rets=me->LIFE;me->LIFE -= it->LIFE;it->LIFE-=rets;}
	  MAKE_SMOG(&e_header,it->x,it->y);
	}
      } else if (B_ES ==1){
      if(CheckCrush(me->x,me->y,it->x,it->y,E_SHOT[me->FILM].x,E_SHOT[me->FILM].y,sx,sy))
      {
	  if(it->NAME !=M_SHOT) {
	     MAKE_SMOG(&e_header,it->x,it->y);
	     it->LIFE-=me->LIFE;
	     me->LIFE=0;
	   if(it->LIFE<=0) {
	      MAKE_EXPLOS(&e_header,it,it->x,it->y);
	      if(it->NAME==ATTENDL) FORCE.OP_LIVE--;
	      else if(it->NAME==ATTENDR) FORCE.OP_LIVE-=2;
	   }

	  }
	}
      }
    }
  it=it->next;
  }
  if(B_ES==0){
  if(CheckCrush(me->x,me->y,FORCE.x,FORCE.y,ENEMYS[me->FILM].x,ENEMYS[me->FILM].y,PLAYERS[0].x,PLAYERS[0].y))
  {
   me->LIFE -= 20; FORCE.LIFE-=50;
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y+10);
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y+20);
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y);
   //MAKE_EXPLOS(&e_header,,FORCE.x,FORCE.y);
  }} else  if(B_ES!=0) {
  if(CheckCrush(me->x,me->y,FORCE.x+2,FORCE.y,E_SHOT[me->FILM].x,E_SHOT[me->FILM].y,PLAYERS[0].x-2,PLAYERS[0].y))
  {
   FORCE.LIFE-=me->LIFE;me->LIFE = 0;
   if(FORCE.LIFE>0) WAV_OUT(W_PAIN);
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y+10);
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y+20);
   MAKE_SMOG(&e_header,FORCE.x-5,FORCE.y);
   //MAKE_EXPLOS(&e_header,,FORCE.x,FORCE.y);
  }}
  return ress;
}

void ALIVE_OPTION(short CT,char OS)
{
  if((FORCE.OP_LIVE & 1) == 0) {
    WAV_OUT(W_ADD_OPTION);
    MAKE_OPTION(&sh_header,0-ATTEND.x,FORCE.y,ATTENDL,CT,OS);
    FORCE.OP_LIVE++;
  }
  if((FORCE.OP_LIVE & 2) == 0) {
    WAV_OUT(W_ADD_OPTION);
    MAKE_OPTION(&sh_header,319+ATTEND.x,FORCE.y,ATTENDR,CT,OS);
    FORCE.OP_LIVE+=2;
  }
}

void SHOTING(NODE **headx,char num,char film,char LIFE,short x,short y,short sz,short sz2)
{
 NODE *newchr;
 if((newchr=(NODE *)malloc(sizeof(NODE))) == NULL) return;
 newchr->NAME=M_SHOT;
 newchr->ENEMY=2;
 newchr->LIFE=LIFE;
 newchr->STATE=num;
 newchr->FILM=film;
 switch(num){
	case 0 :case 10: case 20: case 21: case 22: case 100:
		newchr->x=x+(sz >>1)-(MY_SHOT[film].x >> 1);
		newchr->y=y;
		break;
	case 1 :case 11: case 101:
		newchr->x=x-MY_SHOT[film].x;
		newchr->y=y;
		break;
	case 2 : case 12: case 102:
		newchr->x=x+sz;
		newchr->y=y;
		break;
	case 3 : case 13:
		newchr->x=x-(MY_SHOT[film].x << 1);
		newchr->y=y+3;
		break;
	case 4 : case 14:
		newchr->x=x+sz+MY_SHOT[film].x;
		newchr->y=y+3;
		break;
	case 5 :
		newchr->x=(x-MY_SHOT[film].x)-(MY_SHOT[film].x << 1);
		newchr->y=y+6;
		break;
	case 6 :
		newchr->x=x+sz+(MY_SHOT[film].x << 1);
		newchr->y=y+6;
		break;
	case 15:
		newchr->x=x-MY_SHOT[film].x;
		newchr->y=y+sz2;
		break;
	case 16:
		newchr->x=x+sz;
		newchr->y=y+sz2;
		break;

	case 200:
		newchr->x=x;
		newchr->y=y;
		newchr->COUNT=5;
		break;
 }
 newchr->next=*headx;
 *headx=newchr;
}

void SEARCH_ENEMY(NODE **headx)
{
  NODE *this=*headx;
  while(this != NULL) {
    if(this->LIFE>0 && this->ENEMY == 1 && this->NAME>49) {
      if(this->NAME>=100) {
       LARX=this->x+(BOSSSPR[0].x >> 1);
       LARY=this->y+(BOSSSPR[0].y >> 1);
      } else
      if(this->NAME>=50) {
      LARX=this->x+(ENEMYS[this->FILM].x >> 1);
      LARY=this->y+(ENEMYS[this->FILM].y >> 1);
      }
      if (LARX>319) LARX=318; else if(LARX<0) LARX=0;
      if (LARY>199) LARX=198; else if(LARY<0) LARY=0;
      this->LIFE-=10;
      MAKE_SMOG(&e_header,LARX,LARY);
      return;
    }
  this=this->next;
  }
  LARY=-1;LARX=-1;
}

void PLAYER_ACTIVE()
{
  char i;
  FORCE.WH=0;FORCE.FILM=0;
   LOWENG(FORCE.x+getrandom(0,PLAYERS[0].x),FORCE.y+getrandom(0,PLAYERS[0].y),
   FORCE.LIFE,160);
   if (FORCE.LIFE < 160) {
    if (FORCE.WARR>0) FORCE.WARR--; else {
     WAV_OUT(W_WAR);
     FORCE.WARR=160;
    }
   }
  if(Scan[_ESC]) FORCE.LIFE=0;
  if(Scan[_LEFT]) {
     if(FORCE.x > 0) FORCE.x-=G_MAIN.MY_SPEED+LOWSP;
     FORCE.WH=1;
  }
  if(Scan[_UP] && FORCE.y > 0) {
	FORCE.y-=G_MAIN.MY_SPEED+LOWSP;
  }
  if(Scan[_RIGHT]) {
     if(FORCE.x+PLAYERS[0].x < 320)FORCE.x+=G_MAIN.MY_SPEED+LOWSP;
     FORCE.WH=2;
  }
  if(Scan[_DOWN] && FORCE.y+PLAYERS[0].y < 200){
       FORCE.y+=G_MAIN.MY_SPEED+LOWSP;
  }
  if(Scan[_CTRL]) {
  if(FORCE.SHOT2 == 1) {
    if(FORCE.CNT2==0) {
     SHOTING(&sh_header,200,10,20,FORCE.x-16,FORCE.y+10,0,0);
     SHOTING(&sh_header,200,10,20,FORCE.x+PLAYERS[0].x-15,FORCE.y+10,0,0);
     FORCE.CNT2=60;
     WAV_OUT(MGUN);
    }
    } else {
  if(FORCE.CNT2==0) {
   SEARCH_ENEMY(&e_header);
   if(LARX >= 0 && LARY >= 0) {
      linedraw(FORCE.x+4,FORCE.y,LARX,LARY,32,T_PAGE);
      linedraw(FORCE.x+5,FORCE.y,LARX,LARY,11,T_PAGE);
      linedraw(FORCE.x+6,FORCE.y,LARX,LARY,92,T_PAGE);
      FORCE.CNT2=15;
      WAV_OUT(FIRE_W);
    }
   }
  }
  }
  if (Scan[_LSHT] || Scan[_RSHT]) {
   if (FORCE.SHOT2==1) FORCE.SHOT2=2; else FORCE.SHOT2=1;
  }

  if(Scan[_ALT]) {
    FORCE.OP_S=1;
    if(FORCE.CNT==0) {
      if (FORCE.STATE<20) WAV_OUT(W_SHOOT); else WAV_OUT(LASER);
      switch (FORCE.STATE) {
		case 0:SHOTING(&sh_header,0,0,7,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
		       FORCE.CNT=7;
		       break;
		case 1:for(i=0;i<3;i++)
			SHOTING(&sh_header,i,0,10,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
		       FORCE.CNT=10;
		       break;
		case 2:for(i=0;i<5;i++)
			SHOTING(&sh_header,i,0,10,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
		       FORCE.CNT=11;
		       break;
		case 3:for(i=0;i<7;i++)
			SHOTING(&sh_header,i,0,10,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
		       FORCE.CNT=11;
		       break;

		case 10:SHOTING(&sh_header,10,1,8,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			FORCE.CNT=8;
			break;
		case 11:for(i=10;i<13;i++)
			 SHOTING(&sh_header,i,1,15,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			FORCE.CNT=12;
			break;
		case 12:for(i=10;i<15;i++)
			 SHOTING(&sh_header,i,1,15,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			FORCE.CNT=12;
			break;
		case 13:for(i=11;i<15;i++)
			 SHOTING(&sh_header,i,1,20,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			 SHOTING(&sh_header,15,2,5,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			 SHOTING(&sh_header,16,2,5,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
			FORCE.CNT=12;
			break;
		case 20: case 21: case 22:
		SHOTING(&sh_header,FORCE.STATE,(FORCE.STATE & 3)+3,FORCE.STATE << 1,FORCE.x,FORCE.y,PLAYERS[0].x,PLAYERS[0].y);
		FORCE.CNT=16;
		break;
      }
    }
   }

  if(FORCE.WH==0) FORCE.FILM=0; else
  {
    if(FORCE.RC<10 || FORCE.LC<10 ) FORCE.FILM=1;
    if(FORCE.RC>=10 || FORCE.LC>=10 ) FORCE.FILM=2;
  }
  if(FORCE.WH!=1 && FORCE.LC>0) FORCE.LC--; else
  if(FORCE.WH==2 && FORCE.LC == 0) FORCE.RC++;
  if(FORCE.WH!=2 && FORCE.RC>0) FORCE.RC--; else
  if(FORCE.WH==1 && FORCE.RC == 0) FORCE.LC++;
  if(FORCE.LC>20) FORCE.LC=20;
  if(FORCE.RC>20) FORCE.RC=20;
  if(FORCE.CNT>0) FORCE.CNT--;
  if(FORCE.CNT2>0) FORCE.CNT2--;
}

void ENEMY_ACTIVE(NODE *this)
{
 char temp;
 while(this != NULL) {
   if(this->LIFE !=0){
   switch(this->NAME) {
       case ESHOT2:
		IS_BREAK(this,sh_header,1);
		if(this->STATE==3) {
		  this->x-=this->COUNT+LOWSP;
		  this->y-=this->COUNT2+LOWSP;
		  if(this->x>319 || this->x<0 || this->y>199 || this->y<0)
				this->LIFE=0;
		  this->STATE=0;
		} else this->STATE++;
		break;
       case ESHOT3:
		IS_BREAK(this,sh_header,1);
		if(this->STATE>0) this->STATE--;
		else {
		  this->LIFE=0;
		  WAV_OUT(W_EXPLO);
		  for(temp=0;temp<8;temp++)
		    MAKE_ALL_SHOT(&e_header,this->x,
			 this->y,MIS8X[temp],MIS8Y[temp],10,4,1);
		}
		this->x-=this->COUNT;
		this->y-=this->COUNT2;
		break;

       case ESHOT:
		IS_BREAK(this,sh_header,1);
		if (this->FILM == 4) this->FILM=5; else
		if (this->FILM == 5) this->FILM=4;
		  this->x-=this->COUNT+LOWSP;
		  this->y-=this->COUNT2+LOWSP;
		  if(this->x>319 || this->x<0 || this->y>199 || this->y<0)
				this->LIFE=0;
		break;

       case SMOG:
		 if(this->COUNT>2) {
		   this->FILM--;
		   this->x-=3+LOWSP;
		   this->y+=5+LOWSP;
		   if(this->FILM<0) this->LIFE=0;
		   if(this->y>199) this->LIFE=0;
		   this->COUNT=0;
		 }
		 this->COUNT++;
		 break;
       case EXPLO:
		 if(this->COUNT>3) {
		   this->FILM++;
		   this->y+=5+LOWSP;
		   if(this->FILM>3) this->LIFE=0;
		   if(this->y>199) this->LIFE=0;
		   this->COUNT=0;
		 }
		 this->COUNT++;
		 break;
       case PIECE: case PIECE1:
		  if(this->LIFE-- >0)
		  {
		    this->x+=this->COUNT+LOWSP;
		    this->y+=this->COUNT2+LOWSP;
		  }
		  break;
       case ITEM:
		 if(this->x >319 || this->x+ITEMS[this->FILM].x < 1 || this-> y > 199)
				this->LIFE=0;
		 if((this->x<2 || this->x+ITEMS[this->FILM].x>318)&& this->STATE !=0) {
		   this->COUNT *=-1;
		   this->STATE--;
		 }
		 if((this->y<2 || this->y+ITEMS[this->FILM].y>198)&& this->STATE !=0) {
		   this->COUNT2 *=-1;
		   this->STATE--;
		 }

		 this->x+=this->COUNT;
		 this->y+=this->COUNT2;

		 if (CheckCrush(this->x,this->y,FORCE.x,FORCE.y,ITEMS[this->FILM].x,ITEMS[this->FILM].x,PLAYERS[0].x,PLAYERS[0].y))
		    switch(this->FILM)
		    {
		       case ITEM_OP1:
				     ALIVE_OPTION(20,1);
				     this->LIFE=0;
				     break;
		       case ITEM_OP2:
				     ALIVE_OPTION(20,2);
				     this->LIFE=0;
				     break;
		       case ITEM_SHOT1:
				       if(FORCE.STATE<3) FORCE.STATE++;
				       else if(FORCE.STATE>3) FORCE.STATE=0;
				       this->LIFE=0;
				       break;
		       case ITEM_SHOT2:
				       if(FORCE.STATE<13 && FORCE.STATE>9) FORCE.STATE++;
				       else if(FORCE.STATE<10 || FORCE.STATE>13) FORCE.STATE=10;
				       this->LIFE=0;
				       break;
		       case ITEM_SHOT3:
				       if(FORCE.STATE<22 && FORCE.STATE>19) FORCE.STATE++;
				       else if (FORCE.STATE<20)FORCE.STATE=20;
				       this->LIFE=0;
				       break;
		       case ITEM_ENEGE:
				       if(FORCE.LIFE<450) FORCE.LIFE+=50;
				       else FORCE.LIFE=500;
				       this->LIFE=0;
		    }

		 break;

       case CLOUD:
		  if(this->y>199) this->LIFE=0;
		  this->y+=this->COUNT+LOWSP;
		 break;
       case SOMA :
		  IS_BREAK(this,sh_header,0);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=200;
		  }
		   else
		   {
		     this->y+=1+LOWSP;
		     if(this->y>50) this->x+=this->COUNT+LOWSP;
		     if(this->x >319 || this->x+ENEMYS[this->FILM].x < 1)
				this->LIFE=0;
		     if(getrandom(0,100)==0 && this->STATE == 0) {
				WAV_OUT(W_SHOOT);
				MAKE_ESHOT(&e_header,this->x+5,this->y+ENEMYS[this->FILM].y,10,4);
				this->STATE=1;
				}
		   }
		  break;
       case SOMA2 :
		  IS_BREAK(this,sh_header,0);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=300;
		  }
		   else
		   {
		     if(this->x >319 || this->x+ENEMYS[this->FILM].x < 1 || this-> y > 199)
				this->LIFE=0;
		     if (this->y <= 20) this->y+=1+LOWSP;
		     if (this->y == 20) {
			 WAV_OUT(LASER);
			 MAKE_ALL_SHOT(&e_header,this->x+5,this->y+ENEMYS[this->FILM].y,0,5,40,2,1);
		     }
		     if (this->y > 20) {
		       this->y+=4+LOWSP;
		       this->x+=this->COUNT+LOWSP;
		     }
		   }
		   break;
       case SOMA3 :
		  if(this->ENEMY) IS_BREAK(this,sh_header,0);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=400;
		  }
		   else
		   {
		     if(this->x >319 || this->x+ENEMYS[this->FILM].x < 1 || this-> y > 199)
				this->LIFE=0;
		     if (this->y < 30 || this->COUNT>50) this->y+=2+LOWSP;
		     if (this->y == 30) {
		       WAV_OUT(MGUN);
		       MAKE_ALL_SHOT(&e_header,getrandom(this->x,this->x+ENEMYS[this->FILM].x),this->y+ENEMYS[this->FILM].y,getrandom(-3,3),9,8,1,1);
		       this->COUNT++;
		     }
		   }
		   break;
       case TANK :
		  temp=this->FILM;
		  if(this->STATE== 1) this->FILM=8; else this->FILM=9;
		  IS_BREAK(this,sh_header,0);
		  LOWENG(this->x+getrandom(0,ENEMYS[this->FILM].x),this->y+getrandom(0,ENEMYS[this->FILM].y),
		  this->LIFE,40);
		  this->FILM=temp;
		  if(this->LIFE <= 0) {
		   MAKE_EXPLOS(&e_header,this,this->x,this->y);
		   WAV_OUT(W_EN_PAIN);
		   WAV_OUT(AHA_W);
		   FORCE.SCORE+=100;
		  } else {
		     if(this->x >319 || this->x+ENEMYS[9].x < 1 || this->y>199)
				this->LIFE=0;

		       if(FORCE.x<this->x) this->STATE=2; else
		       if(FORCE.x>this->x+ENEMYS[temp].x) this->STATE=3; else this->STATE=1;

		       if(this->y<30)  this->y+=1+LOWSP;
		       if(this->FILM  == 0) this->x-=1+LOWSP;
		       if(this->FILM  == 1) this->x+=1+LOWSP;
		       //if(this->FILM  == 2) this->y++;
		       if(this->COUNT>10){
			  this->COUNT=0;
			  this->FILM=getrandom(0,3);
		       }
		       this->COUNT++;

		       this->COUNT2++;
		       if(this->COUNT2 > 300) {
			 switch(this->STATE) {
			   case 1 :
				   WAV_OUT(W_BIGBIM);
				   MAKE_ALL_SHOT2(&e_header,
				   this->x-(E_SHOT[3].x >> 1),
				   this->y+ENEMYS[8].y-10,0,3+LOWSP,50,3,1,ESHOT3);
				   break;
			   case 2 :
				   WAV_OUT(W_BIGBIM);
				   MAKE_ALL_SHOT2(&e_header,
				   this->x+5,
				   this->y+ENEMYS[9].y-10,-3-LOWSP,2+LOWSP,50,3,1,ESHOT3);
				   break;
			   case 3 :
				   WAV_OUT(W_BIGBIM);
				   MAKE_ALL_SHOT2(&e_header,
				   this->x+ENEMYS[9].x,
				   this->y+ENEMYS[9].y-10,3+LOWSP,2+LOWSP,50,3,1,ESHOT3);
				   break;
			 }
			 this->COUNT2=0;
		       }
		  }
		  break;
       case ROBO :
		  IS_BREAK(this,sh_header,0);
		  LOWENG(this->x+getrandom(0,ENEMYS[this->FILM].x),this->y+getrandom(0,ENEMYS[this->FILM].y),
		  this->LIFE,40);
		  if(this->LIFE <= 0) {
		   MAKE_EXPLOS(&e_header,this,this->x,this->y);
		   WAV_OUT(W_EN_PAIN);
		   WAV_OUT(AHA_W);
		   MAKE_ITEM(&e_header,this->x+7,this->y+8,getrandom(0,5));
		   FORCE.SCORE+=500;
		  }
		   else
		   {
		     if(this->x >319 || this->x+ENEMYS[this->FILM].x < 1 || this-> y > 199)
				this->LIFE=0;
		     if(this->STATE==0) {
		       if(this->x>160-(ENEMYS[this->FILM].x >> 1)) this->x-=1+LOWSP; else
		       if(this->x<160-(ENEMYS[this->FILM].x >> 1)) this->x+=1+LOWSP;
		       //this->STATE++;
		     }
		     if(this->y < 50 && this->STATE == 0 ) this->y+=1+LOWSP;
		     if(this->y == 50 && this->STATE == 0 ) this->STATE++;
		     if(this->STATE <10 && this->STATE > 0) {
		     this->COUNT++;
		     if(this->STATE % 2 != 0)
		     {
		       if(this->COUNT % 10== 0)
			{
			  switch(this->COUNT2) {
			     case 0:
			      WAV_OUT(W_SHOOT);
			      MAKE_ALL_SHOT(&e_header,this->x,this->y+ENEMYS[this->FILM].y,-3,2+LOWSP,20,1,1);
			      MAKE_ALL_SHOT(&e_header,this->x+ENEMYS[this->FILM].x,this->y+ENEMYS[this->FILM].y,3,2+LOWSP,20,1,1);
			      MAKE_ALL_SHOT(&e_header,this->x+(ENEMYS[this->FILM].x>>1)-3,this->y+ENEMYS[this->FILM].y,0,3+LOWSP,20,1,1);
			      break;
			     case 1:
			      WAV_OUT(W_SHOOT);
			      MAKE_ALL_SHOT(&e_header,this->x,this->y+ENEMYS[this->FILM].y,0,2+LOWSP,20,1,1);
			      MAKE_ALL_SHOT(&e_header,this->x+ENEMYS[this->FILM].x,this->y+ENEMYS[this->FILM].y,0,2+LOWSP,20,1,1);
			      break;
			  }
			}
		      if(this->COUNT > 40) {this->COUNT=0;this->STATE++;this->COUNT2=this->COUNT2 ^ 1;}
		     }
		     if(this->STATE % 2 == 0 && this->COUNT==50) {this->COUNT=0;this->STATE++;}
		    } else if(this->STATE == 10)
		    {
		     this->COUNT=getrandom(0,2);
		     if(this->COUNT != 1) this->FILM=5;
		     this->STATE++;
		    } else if(this->STATE > 10) {
		      switch(this->COUNT) {
			 case 0:this->x-=3+LOWSP;
				this->y-=1+LOWSP;
				break;
			 case 1:this->y+=5+LOWSP;
				break;
			 case 2:this->x+=3+LOWSP;
				this->y-=1+LOWSP;
				break;
		      }
		    }
		   }
		   break;

       case SOMA4 :
		  IS_BREAK(this,sh_header,0);
		  LOWENG(this->x+getrandom(0,ENEMYS[this->FILM].x),this->y+getrandom(0,ENEMYS[this->FILM].y),
		  this->LIFE,30);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=200;
		  }
		   else
		   {
		    this->y+=2;
		    if (this->COUNT2>0) this->COUNT2--;
		    if(this->COUNT2==0) {
		    for(temp=0;temp<8;temp++)
		    MAKE_ALL_SHOT(&e_header,this->x+(ENEMYS[this->FILM].x >> 1),
			 this->y+(ENEMYS[this->FILM].y >> 1),MIS8X[temp],
			 MIS8Y[temp],45,3,1);
		    WAV_OUT(MGUN);
		    this->COUNT2=50;
		    }
		   if(this->y>199) this->LIFE=0;
		  }
		  break;
       case SOMA5 :
		  IS_BREAK(this,sh_header,0);
		  LOWENG(this->x+getrandom(0,ENEMYS[this->FILM].x),this->y+getrandom(0,ENEMYS[this->FILM].y),
		  this->LIFE,20);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=150;
		  } else {
		    this->y++;
		    if (this->COUNT==0) this->x--; else
		    if (this->COUNT==2) this->x++;
		    if (this->COUNT2>0) this->COUNT2--;
		    if(this->COUNT2==0) {
		    MAKE_ALL_SHOT(&e_header,this->x+5,
			 this->y+ENEMYS[this->FILM].y,0,
			 4,20,2,1);
		    MAKE_ALL_SHOT(&e_header,this->x+ENEMYS[this->FILM].x-5,
			 this->y+ENEMYS[this->FILM].y,0,
			 4,20,2,1);
		    WAV_OUT(W_BIGBIM);
		    this->COUNT2=40;
		    this->y-=3;
		    }
		   if(this->y>199) this->LIFE=0;
		  }
		  break;
	case SOMA6L: case SOMA6R:
		  IS_BREAK(this,sh_header,0);
		  LOWENG(this->x+getrandom(0,ENEMYS[this->FILM].x),this->y+getrandom(0,ENEMYS[this->FILM].y),
		  this->LIFE,20);
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=100;
		  } else {
		   if(this->STATE == 0) {
		     this->y+=2;
		    if (this->COUNT == 0) {
		    MAKE_ALL_SHOT(&e_header,this->x+5,
			 this->y+ENEMYS[this->FILM].y,0,
			 3,20,4,1);
		    MAKE_ALL_SHOT(&e_header,this->x+ENEMYS[this->FILM].x-5,
			 this->y+ENEMYS[this->FILM].y,0,
			 3,20,4,1);
		     this->COUNT=SOMA6SR;
		     this->COUNT2++;
		    }
		    this->COUNT--;
		   } else {
		     if (this->STATE == SOMA6L) this->x-=3; else
		     if (this->STATE == SOMA6R) this->x+=3;
		     this->y-=4;
		     this->COUNT--;
		     if(this->COUNT==0) this->STATE=0;
		   }
		   if (this->COUNT2>7) {
		     this->COUNT2=0;
		     this->STATE = this->NAME;
		     this->COUNT=12;
		   }
		  }
		  break;
	case GR_ENA:
		  if(this->FILM>0) {
		     IS_BREAK(this,sh_header,0);
		     clip_img(this->x,this->y,GR_EN[5].x,GR_EN[5].y,GR_EN[5].spr,G_MAP,0);
		  }
		  if(this->LIFE <= 0) {
		     MAKE_EXPLOS(&e_header,this,this->x,this->y);
		     WAV_OUT(W_EN_PAIN);
		     WAV_OUT(AHA_W);
		     FORCE.SCORE+=400;
		  }
		   else
		   {
		   if (this->FILM<4) {
		     if(this->COUNT2>0) this->COUNT2--;
		     if(this->COUNT2==0) {
		       this->FILM++;
		       this->COUNT2=5;
		       if(this->FILM>0) this->ENEMY=1;
		      }
		   } else {
		     if(this->COUNT>0) this->COUNT--;
		     if(this->COUNT==0) {
		       this->COUNT=20;
		       MAKE_ESHOT(&e_header,this->x+5,this->y+6,10,0);
		      }
		   }
		   if(this->y>199) this->LIFE=0;
		   this->y++;
		  }
		  break;
	case BOSS1:
		  IS_BREAK(this,sh_header,2);
		  if(this->LIFE <= 0) {
		   BOSSDIE=1;
		   for(temp=0;temp<30;temp++){
		      MAKE_EXPLOS(&e_header,this,this->x+getrandom(0,BOSSSPR[this->FILM].x),
		      this->y+getrandom(0,BOSSSPR[this->FILM].y));
		      WAV_OUT(W_EN_PAIN);
		   }
		   FORCE.SCORE+=2500;
		  } else{
		   if(this->y<20) this->y++;
		  LOWENG(this->x+getrandom(0,BOSSSPR[this->FILM].x),this->y+getrandom(0,BOSSSPR[this->FILM].y),
		  this->LIFE,200);

		   if(this->COUNT==0) {
		     this->STATE=getrandom(1,4);
		     switch(this->STATE) {
			 case 1:
				this->COUNT=100;
				this->COUNT2=5;
				break;
			 case 2:
				this->COUNT=100;
				this->COUNT2=10;
				break;
			 case 3:
				this->COUNT=20;
				break;
			 case 4:
				this->COUNT=20;
				break;
		     }
		   }
		   temp=getrandom(0,200);
		   if(temp<50 && this->x > 0 ) this->x--; else
		   if(temp>150 && BOSSSPR[0].x+this->x<319) this->x++;
		   if(this->STATE==1) {
		     this->COUNT2--;
		     if(this->COUNT2==0) {
		      this->COUNT2=5;
		      MAKE_ALL_SHOT(&e_header,this->x,this->y+BOSSSPR[0].y-5,0,3+LOWSP,20,1,1);
		      MAKE_ALL_SHOT(&e_header,this->x+BOSSSPR[0].x-10,this->y+BOSSSPR[0].y-5,0,3+LOWSP,20,1,1);
		     }
		   }
		   if(this->STATE==2) {
		     this->COUNT2--;
		     if(this->COUNT2==0) {
		      this->COUNT2=10;
		      MAKE_ALL_SHOT(&e_header,this->x+(BOSSSPR[0].x >> 1)-5,this->y+BOSSSPR[0].y-7,getrandom(-10,10),4,60,3,1);
		     }
		   }
		   if(this->STATE==3) {
		      MAKE_ALL_SHOT(&e_header,this->x+(BOSSSPR[0].x >> 2)+6,this->y+BOSSSPR[0].y-5,getrandom(-1,1),2,20,4,1);
		      MAKE_ALL_SHOT(&e_header,this->x+(BOSSSPR[0].x >> 1)+34,this->y+BOSSSPR[0].y-5,getrandom(-1,1),2,20,4,1);
		   }

		   this->COUNT--;
		  }
		  break;
   }
   }
 this=this->next;
 }
}

void SHOT_ACTIVE(NODE *this)
{

  while(this != NULL) {
   switch(this->NAME)
   {
    case M_SHOT:
    if (this->y + MY_SHOT[this->FILM].y <= 1 || this->y > 199 || this->x+MY_SHOT[this->FILM].x<0 || this->x>319)
		this->LIFE=0; else
    {
      switch(this->STATE) {
		case 0 : case 10: case 20: case 21: case 22: case 100:
			this->y-=5+LOWSP;
			break;
		case 1: case 2: case 3: case 4: case 5: case 6:
			this->y-=6+LOWSP;
			break;

		case 11:
			this->y-=7+LOWSP;
			this->x-=2+LOWSP;
			break;
		case 12 :this->y-=7+LOWSP;
			this->x+=2+LOWSP;
			break;
		case 13 :
			this->y-=7+LOWSP;
			this->x-=5+LOWSP;
			break;
		case 101:
			this->y-=6+LOWSP;
			this->x-=6+LOWSP;
			break;
	       case 102:
			this->y-=6+LOWSP;
			this->x+=6+LOWSP;
			break;
		case 14 :
			this->y-=7+LOWSP;
			this->x+=5+LOWSP;
			break;
		case 15:
			this->y+=8+LOWSP;
			this->x-=2+LOWSP;
			break;
		case 16 :this->y+=8+LOWSP;
			this->x+=2+LOWSP;
			break;

		case 200:
			 if(this->COUNT>0) {
			   this->y+=2;
			   this->COUNT--;
			 } else this->y-=4+LOWSP;
			 break;
      }
    }
    break;
    case ATTENDL:if(this->LIFE !=0){
		 if(this->x+ATTEND.x>FORCE.x-10) this->x-=2+LOWSP; else
		 if(this->x+ATTEND.x<FORCE.x-10) this->x+=3+LOWSP;
		 if(this->y>FORCE.y-10) this->y-=2+LOWSP; else
		 if(this->y<FORCE.y-10) this->y+=3+LOWSP;
		 if(FORCE.OP_S) this->COUNT++;
		 if(this->COUNT>=this->COUNT2) {
		 this->COUNT=0;FORCE.OP_S=0;
		 switch(this->STATE) {
			case 1:
			       SHOTING(&sh_header,100,6,18,this->x,this->y,ATTEND.x,ATTEND.y);
			       this->y+=5;
			       break;
			case 2:
			       SHOTING(&sh_header,101,8,9,this->x,this->y-ATTEND.y,ATTEND.x,ATTEND.y);
			       this->y+=5;
			       break;
		 }}}
		 break;
    case ATTENDR:if(this->LIFE !=0){
		 if(this->x>FORCE.x+PLAYERS[0].x+10) this->x-=3; else
		 if(this->x<FORCE.x+PLAYERS[0].x+10) this->x+=2;
		 if(this->y>FORCE.y-10) this->y-=2; else
		 if(this->y<FORCE.y-10) this->y+=3;
		 if(FORCE.OP_S) this->COUNT++;
		 if(this->COUNT>=this->COUNT2) {
		 this->COUNT=0;FORCE.OP_S=0;
		 switch(this->STATE) {
			case 1:
			       SHOTING(&sh_header,100,6,18,this->x,this->y,ATTEND.x,ATTEND.y);
			       this->y+=5;
			       break;
			case 2:
			       SHOTING(&sh_header,102,7,9,this->x,this->y-ATTEND.y,ATTEND.x,ATTEND.y);
			       this->y+=5;
			       break;
		 }}}
		 break;

    }
    this=this->next;
  }
}


void SHOW_OUR(NODE *this)
{
  while(this != NULL) {
    if(this->LIFE != 0)
    switch(this->NAME) {
      case M_SHOT:
      clip_spr(this->x,this->y,MY_SHOT[this->FILM].x,MY_SHOT[this->FILM].y,MY_SHOT[this->FILM].spr,T_PAGE,0);
      break;
      case ATTENDL: case ATTENDR:
       SHADOW(RELOCATE(this->x+(ENEMYS[this->FILM].x >> 1)),
	RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ATTEND.x,ATTEND.y,SHADOWZ,ATTEND.spr,T_PAGE);
       clip_spr(this->x,this->y,ATTEND.x,ATTEND.y,ATTEND.spr,T_PAGE,0);
      break;
    }
    this=this->next;
  }
  if(FORCE.WH == 2) {
   SHADOW(RELOCATE(FORCE.x+(PLAYERS[0].x >> 1)),
   RELOCATEY(FORCE.y+(PLAYERS[0].y >> 1)),PLAYERS[FORCE.FILM].x,PLAYERS[FORCE.FILM].y,SHADOWZ,PLAYERS[FORCE.FILM].spr,T_PAGE);
   Spr_mirror(FORCE.x,FORCE.y,PLAYERS[FORCE.FILM].x,PLAYERS[FORCE.FILM].y,PLAYERS[FORCE.FILM].spr,T_PAGE);
   }
   else {
    SHADOW(RELOCATE(FORCE.x+(PLAYERS[0].x >> 1)),
    RELOCATEY(FORCE.y+(PLAYERS[0].y >> 1)),PLAYERS[FORCE.FILM].x,PLAYERS[FORCE.FILM].y,SHADOWZ,PLAYERS[FORCE.FILM].spr,T_PAGE);
    Spr_normal(FORCE.x,FORCE.y,PLAYERS[FORCE.FILM].x,PLAYERS[FORCE.FILM].y,PLAYERS[FORCE.FILM].spr,T_PAGE);
   }
}
void SHOW_ENEMY(NODE *this)
{
  while(this != NULL) {
    if(this->LIFE != 0)
      switch(this->NAME)
	 {
	  case ESHOT: case ESHOT2: case ESHOT3:
	       clip_spr(this->x,this->y,E_SHOT[this->FILM].x,E_SHOT[this->FILM].y,E_SHOT[this->FILM].spr,T_PAGE,0);
	       break;
	  case SOMA: case SOMA2: case SOMA3: case SOMA4: case SOMA5: case SOMA6L: case SOMA6R:
	       SHADOW(RELOCATE(this->x+(ENEMYS[this->FILM].x >> 1)),
	       RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,
	       SHADOWZ,ENEMYS[this->FILM].spr,T_PAGE);
	       clip_spr(this->x,this->y,ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,ENEMYS[this->FILM].spr,T_PAGE,0);
	       break;
	  case BOSS1:
	       //SHADOW(RELOCATE(this->x+(BOSSSPR[0].x >> 1)),this->y+12,BOSSSPR[0].x,BOSSSPR[0].y,SHADOWZ,BOSSSPR[0].spr,T_PAGE);
	       clip_spr(this->x,this->y,BOSSSPR[0].x,BOSSSPR[0].y,BOSSSPR[0].spr,T_PAGE,0);
	       break;
	  case GR_ENA:
	       clip_spr(this->x,this->y,GR_EN[this->FILM].x,GR_EN[this->FILM].y,GR_EN[this->FILM].spr,T_PAGE,0);
	       break;

	  case TANK:
	       switch(this->STATE) {
		  case 1:
			 SHADOW(RELOCATE(this->x+(ENEMYS[8].x >> 1)),
			 RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[8].x,ENEMYS[8].y,
			 SHADOWZ,ENEMYS[8].spr,T_PAGE);
			 clip_spr(this->x,this->y,ENEMYS[8].x,ENEMYS[8].y,ENEMYS[8].spr,T_PAGE,0);
			 break;
		  case 2:
			 SHADOW(RELOCATE(this->x+(ENEMYS[9].x >> 1)),
			 RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[9].x,ENEMYS[9].y,
			 SHADOWZ,ENEMYS[9].spr,T_PAGE);
			 clip_spr(this->x,this->y,ENEMYS[9].x,ENEMYS[9].y,ENEMYS[9].spr,T_PAGE,0);
			 break;
		  case 3:
			 SHADOW(RELOCATE(this->x+(ENEMYS[9].x >> 1)),
			 RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[9].x,ENEMYS[9].y,
			 SHADOWZ,ENEMYS[9].spr,T_PAGE);
			 clip_spr(this->x,this->y,ENEMYS[9].x,ENEMYS[9].y,ENEMYS[9].spr,T_PAGE,1);
			 break;
	       }
	       break;
	  case ROBO:
	       if(this->STATE >10 && this->COUNT ==0){
	       SHADOW(RELOCATE(this->x+(ENEMYS[this->FILM].x >> 1)),
	       RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,
	       SHADOWZ,ENEMYS[this->FILM].spr,T_PAGE);
		clip_spr(this->x,this->y,ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,ENEMYS[this->FILM].spr,T_PAGE,1);
	       }
	       else {
	       SHADOW(RELOCATE(this->x+(ENEMYS[this->FILM].x >> 1)),
	       RELOCATEY(this->y+(ENEMYS[this->FILM].y >> 1)),ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,
	       SHADOWZ,ENEMYS[this->FILM].spr,T_PAGE);
	       clip_spr(this->x,this->y,ENEMYS[this->FILM].x,ENEMYS[this->FILM].y,ENEMYS[this->FILM].spr,T_PAGE,0);
	       }
	       break;
	  case EXPLO:
	       clip_spr(this->x,this->y,EXPLOS[this->FILM].x,EXPLOS[this->FILM].y,EXPLOS[this->FILM].spr,T_PAGE,0);
	       break;
	  case ITEM:
	       clip_spr(this->x,this->y,ITEMS[this->FILM].x,ITEMS[this->FILM].y,ITEMS[this->FILM].spr,T_PAGE,0);
	       break;
	  case PIECE: case PIECE1:
	       clip_spr(this->x,this->y,PIECES[this->FILM].x,PIECES[this->FILM].y,PIECES[this->FILM].spr,T_PAGE,0);
	       break;
	 }
    this=this->next;
  }
}
void SHOW_PHEN(NODE *this)
{
  while(this != NULL) {
    if(this->LIFE != 0)
      switch(this->NAME)
	 {
	  case SMOG:
	       clip_spr(this->x,this->y,SMOGSPR[this->FILM].x,SMOGSPR[this->FILM].y,SMOGSPR[this->FILM].spr,T_PAGE,0);
	       break;
	  case CLOUD:
	       clip_spr(this->x,this->y,CLOUDS[this->FILM].x,CLOUDS[this->FILM].y,CLOUDS[this->FILM].spr,T_PAGE,0);
	 }
    this=this->next;
  }
}
void TEMP()
{
if(Scan[_F1]==1) FORCE.STATE=1;
if(Scan[_F2]==1) FORCE.STATE=2;
if(Scan[_F3]==1) FORCE.STATE=3;
if(Scan[_F4]==1) FORCE.STATE=10;
if(Scan[_F5]==1) FORCE.STATE=11;
if(Scan[_F6]==1) FORCE.STATE=12;
if(Scan[_F7]==1) FORCE.STATE=13;
if(Scan[_F8]==1) FORCE.STATE=20;
if(Scan[_F9]==1) FORCE.STATE=21;
if(Scan[_F10]==1) FORCE.STATE=22;
if(Scan[_ENTER]==1) {
 if(FORCE.OP_LIVE != 3) ALIVE_OPTION(20,1);
 }
//if(Scan[_TAB]==1){
//  if(FORCE.OP_LIVE != 3) ALIVE_OPTION(10,2);
// }
if(Scan[_TAB]==1){
   BOSSDIE=1;
 }

}

void POWER_VIEW(char *tar)
{
 int i;
 Hline(210,194,310,255,tar);
 Hline(210,198,310,255,tar);
 Vline(209,194,199,255,tar);
 Vline(310,194,199,255,tar);
 for(i=210;i<(FORCE.LIFE/5)+210;i++) Vline(i,195,198,12,tar);
 hanxy(70,160,getrandom(0,255),"KYUNG SAN UNIV. HONG WON DAE",tar,0);
 hanxy(70,180,getrandom(0,255),"SOFTWARE DISPLAY DEMO VERSION",tar,0);
}

void SCORE_VIEW(char *tar)
{
 char *score,i,max;
 itoa(FORCE.SCORE,score,10);
 max=strlen(score);
 for(i=0;i<max;i++) Spr_normal(i*12+(10-max)*12,5,NUMS[score[i]-48].x,NUMS[score[i]-48].y,NUMS[score[i]-48].spr,tar);
}

void PALSS()
{
 return;
 if (pal_x>3) {
 color_rol(161,168,pal,2);
 setnpal(161,168,pal);
 pal_x=0;} else pal_x++;
}

int OBJ_MANAGER(char *xxx,short lx,short ly)
{
  int i,i2;
  STAGE_NOW(G_MAP,lx);
  FORCE.OP_LIVE=0;
  while(1){
  BK_SCROLL(0,G_MAP);
  Nm2sm(G_MAP,T_PAGE);
  PLAYER_ACTIVE();
  ENEMY_ACTIVE(e_header);
  SHOT_ACTIVE(sh_header);
  SHOW_ENEMY(e_header);
  SHOW_OUR(sh_header);
  SHOW_PHEN(e_header);
  POWER_VIEW(T_PAGE);
  SCORE_VIEW(T_PAGE);

  if (lx==1) PALSS();
  waitvga();
  if(BK.abs_size<65) {
   fade_in(0,256,temp_pal,pal);
   setnpal (0,256,temp_pal);
   }
  Mov2Scr(T_PAGE);

  TEMP();
  DEL_character(&sh_header);
  DEL_character(&e_header);
  if(getrandom(0,100)==1)
  switch(getrandom(0,8)){
     case 0: MAKE_SOMA(&e_header,0,320-ENEMYS[0].x,-20);
	     MAKE_SOMA(&e_header,0,320-ENEMYS[0].x,-40);
	     MAKE_SOMA(&e_header,0,320-ENEMYS[0].x,-60);
	     MAKE_SOMA(&e_header,0,320-ENEMYS[0].x,-80);
	  break;
     case 1: MAKE_SOMA(&e_header,1,0,-20);
	     MAKE_SOMA(&e_header,1,0,-40);
	     MAKE_SOMA(&e_header,1,0,-60);
	     MAKE_SOMA(&e_header,1,0,-80);
	  break;
     case 2:
	  if (BK.abs_size<6300)
	   MAKE_SOMA2(&e_header,getrandom(20,300));
	  break;
     case 3:
	  if (BK.abs_size<6300)
	   MAKE_ROBO(&e_header,getrandom(20,300));
	  break;
     case 4: if (BK.abs_size<6300)
	  MAKE_SOMA3(&e_header,getrandom(20,300));
	  break;
   case 5: if (BK.abs_size<6300)
	  MAKE_TANK(&e_header,getrandom(20,300));
	  break;
   case 6: if (BK.abs_size<6300)
	  MAKE_SOMA4(&e_header,getrandom(20,300));
	  break;
   case 7: if (BK.abs_size<6300)
	 MAKE_SOMA5(&e_header,getrandom(20,300));
	 if(lx==2) MAKE_SOMA6(&e_header,getrandom(20,300));
	  break;
   case 8:if(lx==2)
	  MAKE_GRA(&e_header,getrandom(20,300));
	  break;
  }
  if (BK.abs_size==6300){
      MAKE_BOSS1(&e_header);
      }
  if(getrandom(0,70)==1)MAKE_CLOUD(&e_header,getrandom(-10,318));
  if (BOSSDIE == 1) {
   palmove(pal,temp_pal);
   for(i=0;i<80;i++){
    PLAYER_ACTIVE();
    ENEMY_ACTIVE(e_header);
    SHOT_ACTIVE(sh_header);
    Nm2sm(G_MAP,T_PAGE);
    SHOW_ENEMY(e_header);
    SHOW_OUR(sh_header);
    SHOW_PHEN(e_header);
    if (i>16) {fade_out(0,256,temp_pal);setnpal (0,256,temp_pal);}
    waitvga();
    Mov2Scr(T_PAGE);
    DEL_character(&e_header);
    DEL_character(&sh_header);
   }
   MODStopModule();
   return 2;
  }
  if(FORCE.LIFE<=0){
   WAV_OUT(KILLED);
   for(i=0;i<100;i++){
   for(i2=0;i2<10;i2++)MAKE_PIECE(&e_header,FORCE.x,FORCE.y);
   ENEMY_ACTIVE(e_header);
   Nm2sm(G_MAP,T_PAGE);
   SHOW_ENEMY(e_header);
   if (i>34) {fade_out(0,256,temp_pal);setnpal (0,256,temp_pal);}
   waitvga();
   Mov2Scr(T_PAGE);
   DEL_character(&e_header);
   DEL_character(&sh_header);
   waitMSec(5);
   }
   MODStopModule();
   return 0;
   }
  }
}
