/*
   *********  PULLDOWN MENU STRUCTURE for LF & TEXTLIB.LIB  ********
   *  Reference Book:                                              *
   *    [C PRORAMMER'S the imitate PCTOOLS    :    KIM SUK ZOO]    *
   *                                                               *
   *                              Recoding By Hong won dae         *
   *                                               1995.11.        *
   *****************************************************************
*/
#define _PBC	      3
#define _PTC	      15
#define _PSTC	      11
#define _PIBC	      1
#define _PITC         15
#define _MBC          5
#define _MTC	      15
#define _MIBC	      0
#define _MITC	      7
#define _HBC	      1
#define _HTC          14

#define BYTE		unsigned char
typedef struct {
		 BYTE  P_MAX;
		 BYTE  P_NOW;
		 BYTE  MAX_SIZE;
		 BYTE  LX,LY;
		 int   *P_NAME;		// FOR MESSAGE function..
		 char  **P_SHORTKEY;
		 int   *P_HELP;        	// FOR MESSAGE function..
} POPMENU;
typedef struct {
		BYTE MAXMENU;
		BYTE NOWMENU;
		BYTE  LY;
		char *LX;
		char **NAME;
		POPMENU *SUB_MENU;
} MENU_TYPE;

void Make_PopMenu(POPMENU *PM,int max_menu,int x,int y,
     int menu_size,int *menu,char **shortkey,int *help,
					   int static_y)
{
  PM->P_MAX=max_menu;
  PM->P_NOW=static_y;
  PM->MAX_SIZE=menu_size;
  PM->LX=x;PM->LY=y;
  PM->P_NAME=menu;
  PM->P_SHORTKEY=shortkey;
  PM->P_HELP=help;
}

void Make_Menu(MENU_TYPE *MENU,BYTE MX,BYTE NM,BYTE LY,
		       char *LX,char **NAME,POPMENU *SUB)
{
  MENU->MAXMENU=MX;
  MENU->NOWMENU=NM;
  MENU->LY=LY;
  MENU->LX=LX;
  MENU->NAME=NAME;
  MENU->SUB_MENU=SUB;
}

int PopMenu_Manager(POPMENU *POP,int HAN,int HELP_BAR,MENU_TYPE *MNT)
{
 int i;
 int SC_X,exitcode=0;		// HL -> HELP ARRAY
 int key=-1;
 if (POP->LX+POP->MAX_SIZE+2 > 80) SC_X=80-(POP->MAX_SIZE+2);
			     else SC_X=POP->LX;

 MOUSE_HIDDEN();
 shadow_box(SC_X-1,POP->LY,SC_X+POP->MAX_SIZE+3,
		POP->LY+POP->P_MAX+1,15,_PBC,YF0);
 draw_box(SC_X,POP->LY,SC_X+POP->MAX_SIZE+2,
		POP->LY+POP->P_MAX+1,15,_PBC,NF1);

 for (i=0;i<POP->P_MAX;i++) {
  if (POP->P_NAME[i] == -1)
     line(SC_X+1,SC_X+POP->MAX_SIZE+1,POP->LY+1+i,_XL,0,_PBC,ONEL);
  else {
      putxy1(SC_X+2,i+POP->LY+1,_PTC,_PBC,MESSAGE(POP->P_NAME[i],HAN));
      putxy1(SC_X+POP->MAX_SIZE-length(POP->P_SHORTKEY[i])+2,
		     POP->LY+1+i,_PSTC,_PBC,POP->P_SHORTKEY[i]);
  }
 }
/*
	***********************************************
		EXITCODE :
			 1: ENTER
			-1: ESC
			-2: LEFT
			-3: RIGHT
	***********************************************
*/
 MOUSE_ACHIVE();
 while (!exitcode)
 {
   TIME_BAR();
   if(key==-1) {
	 MOUSE_HIDDEN();
	 line(1,80,HELP_BAR,_XL,_HTC,_HBC,' ');
	 putxy1(1,HELP_BAR,_HTC,_HBC,MESSAGE(POP->P_HELP[POP->P_NOW],HAN));
	 ch_background(SC_X+1,POP->MAX_SIZE+1,POP->LY+POP->P_NOW+1,_PIBC);
	 ch_textcolor(SC_X+1,length(MESSAGE(POP->P_NAME[POP->P_NOW],HAN))
		  +2,POP->LY+POP->P_NOW+1,_PITC);
	 MOUSE_ACHIVE();
	 MOUSE_CLR();
   }
   if (MOUSE_BUTTON()==2) exitcode =-1;
   key=KEY_CLICK();
   if(key) exitcode=SHORT_KEY_CLICK(key);//MENU_PROCESSER();
   switch(key) {
	 case _home_: case _end_: case _up_: case _down_:
	 MOUSE_HIDDEN();
	 ch_background(SC_X+1,POP->MAX_SIZE+1,POP->LY+POP->P_NOW+1,_PBC);
	 ch_textcolor(SC_X+1,length(MESSAGE(POP->P_NAME[POP->P_NOW],HAN))
				  +2,POP->LY+POP->P_NOW+1,_PTC);
	 MOUSE_ACHIVE();
	 break;
   }
   switch(key) {
	  case _enter_: case 0xe0:
			exitcode = POP->P_NAME[POP->P_NOW];
			break;
	case _esc_: exitcode = -1;
		    break;
       case _home_:
		   if(POP->P_NOW > 0) {
		   POP->P_NOW=0;
		   key=-1;
		   }
		   break;
       case _left_:
		   exitcode=-2;
		   break;
      case _right_:
		   exitcode=-3;
		   break;
	case _end_:
		   if(POP->P_NOW < POP->P_MAX-1) {
		   POP->P_NOW=POP->P_MAX-1;
		   key=-1;
		   }
		   break;

	case _up_ :
		   if(POP->P_NOW > 0) {
		     POP->P_NOW--;
		     if (POP->P_NAME[POP->P_NOW] == -1) POP->P_NOW--;
		   } else POP->P_NOW=POP->P_MAX-1;
		   key=-1;
		   break;
      case _down_ :
		   if(POP->P_NOW < POP->P_MAX-1) {
		     POP->P_NOW++;
		     if (POP->P_NAME[POP->P_NOW] == -1) POP->P_NOW++;
		   } else POP->P_NOW=0;
		   key=-1;
		   break;
   }
   if (MOUSE_CLICK_AREA(SC_X,POP->LY,SC_X+POP->MAX_SIZE,
   POP->LY+POP->P_MAX-1,1) && POP->P_NAME[MOUSE_VTAB() - POP->LY] != -1)
   {
      MOUSE_HIDDEN();
      ch_background(SC_X+1,POP->MAX_SIZE+1,POP->LY+POP->P_NOW+1,_PBC);
      ch_textcolor(SC_X+1,length(MESSAGE(POP->P_NAME[POP->P_NOW],HAN))
					+2,POP->LY+POP->P_NOW+1,_PTC);
      MOUSE_ACHIVE();
      if (MOUSE_VTAB() - POP->LY==POP->P_NOW) exitcode = POP->P_NAME[POP->P_NOW];
      POP->P_NOW=MOUSE_VTAB() - POP->LY;
      key=-1;
  }
  if (MOUSE_CLICK_AREA(MNT->LX[0]-1,MNT->LY-1,
		       MNT->LX[MNT->MAXMENU],MNT->LY-1,1)) {
     for(i=0;i<MNT->MAXMENU;i++)
      if(MOUSE_HTAB()+2>MNT->LX[i] && MOUSE_HTAB()+1 <MNT->LX[i+1]
       && MNT->NOWMENU != i) exitcode=-(i+5);
  }
 }
 return exitcode;
}

//---------------------          CUT LINE       ---------------------------

/*=========================================================================
	LF MENU FUNCTION
  =========================================================================
typedef struct {
		BYTE MAXMENU;
		BYTE NOWMENU;
		BYTE  LY;
		char *LX;
		char **NAME;
		POPMENU *SUB_MENU;
} MENU_TYPE;

*/
int PullDown_Manager(MENU_TYPE *PDM,int HAN,int HELP_BAR)
{
  int i;
  int exitcode=0;
  int key=-2;
  char *sc;

  MOUSE_HIDDEN();
  ch_background(76,9,25,8);
  line(1,80,PDM->LY,_XL,_MTC,_MBC,' ');
  for(i=0;i<PDM->MAXMENU;i++)
      putxy2(PDM->LX[i],PDM->LY,_MTC,_MBC,PDM->NAME[i]);
  sc = malloc(SCR_MALLOC);
  gettimage(sc);
  MOUSE_CLR();
  MOUSE_ACHIVE();
  while(exitcode == 0) {
   if(key < -1) {
     MOUSE_HIDDEN();
     ch_background(PDM->LX[PDM->NOWMENU],PDM->LX[PDM->NOWMENU+1]
		  -PDM->LX[PDM->NOWMENU],PDM->LY,_MIBC);
     ch_textcolor(PDM->LX[PDM->NOWMENU]+2,PDM->LX[PDM->NOWMENU+1]
		  -PDM->LX[PDM->NOWMENU]-1,PDM->LY,_MITC);
     MOUSE_ACHIVE();
   }
   key=PopMenu_Manager(&PDM->SUB_MENU[PDM->NOWMENU],HAN,HELP_BAR,PDM);
   if (key>894 && key<901) key=MENU_PROCESSER(key); else
   if (key>-2) exitcode=key;
   if (key<-1) {
      MOUSE_HIDDEN();
      puttimage(sc);
      MOUSE_ACHIVE();
   if(key < -4 && PDM->NOWMENU != -(key+5)) {
    PDM->NOWMENU=-(key+5);
   }
   }

   switch(key) {
	case -2:
		if (PDM->NOWMENU >0) PDM->NOWMENU--;
		else PDM->NOWMENU=PDM->MAXMENU-1;
		break;
	case -3:
		if (PDM->NOWMENU < PDM->MAXMENU-1) PDM->NOWMENU++;
		else PDM->NOWMENU=0;
		break;
	case -10: case -11: case -12: case -13: case -14: case -15:
		if(PDM->NOWMENU != 15+key) PDM->NOWMENU=15+key;
		break;
   }
  }
  MOUSE_HIDDEN();
  puttimage(sc);
  LF_TITLE(&SYSTEM);
  ch_background(76,9,25,7);
  MOUSE_ACHIVE();
  free(sc);
  return exitcode;
}

