#include<stdio.h>
#include<conio.h>
#include<string.h>
#include<dos.h>

#define 	BSP		0x3CD	//Back Select Port

char *CHIPS_NAME[]={"Unknow","TSENG LABS","ATI","AHEAD",
		    "Chips and Technologies","OAK","GENOA",
		    "Headland Video Seven","Trident","Everex",
		    "CIRRUS","Paradise","VESA"};


int TSENG_LABS_CHIP(void)  // ET4000 , ET3000
{
  int i,j;
  j=inp(BSP);
  outp(BSP,0xAA);
  i=inp(BSP);
  if(i != 0xAA) return 0;
  outp(BSP,0x55);
  i=inp(BSP);
  if(i != 0x55) return 0;
  outp(BSP,j);
  return 1;
}


int ATI_CHIP(void)
{
 char *sysMEM;

 sysMEM=(char *)0xC0000031L;
 if(!_fstrncmp("761295520",sysMEM,9)) return 1;
 return 0;
}


int AHEAD_CHIP(void)
{
 char *sysMEM;

 sysMEM=(char *)0xC0000025L;
 if(!_fstrncmp("AHEAD",sysMEM,5)) return 1;
 return 0;
}


int CHIPS_AND_TECH_CHIP(void)
/*
  Chips and Technologies return val.
	  0 - none..
	  1 - 82C451
	  2 - 82C452
	  3 - 82C453
	  4 - 82C454
	  5 - 82C455
	  6 - 82C456
*/
{
  unsigned char temp;

  outp(0x46e8,inp(0x46e8) | 0x10);	// VGA setup Mode ON
  outp(0x103,inp(0x103) | 0x80);	// extend register en.
  temp=inp(0x104);                      // ID register read.
  outp(0x46e8,inp(0x46e8) & 0xEF);	// VGA setup Mode OFF

  if(temp !=0xA5) return 0;
  outp(0x3C6,0x00);
  temp=inp(0x3C7);
  return temp;
}


int OAK_CHIP(void)
{
  unsigned char old,news;

  old=inp(0x3DF);
  outp(0x3DF,0x55);
  news=inp(0x3DF);
  if(news != 0x55) return 0;
  outp(0x3DF,0xAA);
  news=inp(0x3DF);
  if(news != 0xAA) return 0;
  outp(0x3DF,old);
  return 1;
}


int GENOA_CHIP(void)
/*
	GENOA return code.
	0 : none.
	1 : It's Genoa
	2 : Genoa 6400 , 6600
	3 : Genoa 6200 , 6300
	4 : Genoa 6100
	5 : Genoa 5300 , 5400
	6 : Genoa 5100 , 5200
*/
{
  short seg,off;
  unsigned char far *sysMEM;

  off = *(unsigned short far *)0xC0000037L;
  seg = *(unsigned short far *)0xC0000039L;
  sysMEM=(unsigned char far *)MK_FP(seg,off);
  if(*sysMEM != 0x77 || *(sysMEM+2) != 0x99 || *(sysMEM+3) != 0x66) return 0;
  if(*(sysMEM+1) == 0x11) return 2;
  if(*(sysMEM+1) == 0x00) return 3;
  if(*(sysMEM+1) == 0x22) return 4;
  if(*(sysMEM+1) == 0x55) return 5;
  if(*(sysMEM+1) == 0x33) return 6;
  return 1;
}


int VIDEO_SEVEN_CHIP(void)
/*
  Headland Video Seven return val.
  0 : none.
  1 : Video 7
  2 : VESA VGA
  3 : V7VGA with VRAM
  4 : V7VGA version 5
  5 : 1024i
*/
{
  unsigned char oldv,newv,temp,val;
  outp(0x3c4,0x0c);
  oldv=inp(0x3c5);
  outp(0x3c4,0x0c);
  outp(0x3c5,0x55);

  outp(0x3c4,0x0c);
  newv=inp(0x3c5);
  temp=newv ^ 0xEA;

  outp(0x3c4,0x0c);
  outp(0x3c5,oldv);
  outp(0x3c4,0x1f);
  val=inp(0x3c5);
  if(val != temp) return 0;
  outp(0x3c4,6);
  outp(0x3c5,0xEA);
  outp(0x3c4,0x8E);
  val=inp(0x3c5);
  if((val < 0xFF) & (val >= 0x80)) return 2;
  if((val < 0x7F) & (val >= 0x70)) return 3;
  if((val < 0x5A) & (val >= 0x50)) return 4;
  if((val < 0x4A) & (val >= 0x40)) return 5;
  return 1;
}


int TRIDENT_CHIP(void)
{
  unsigned char newv,oldv;

  outp(0x3c4,0x0e);
  oldv=inp(0x3c5);
  outp(0x3c5,2);
  newv=inp(0x3c5) & 0x0f;
  outp(0x3c5,oldv);
  if(newv != 2) return 0;
  outp(0x3c4,0x0b);
  newv=inp(0x3c5);
  if(newv==1) return 2;
  if(newv==2) return 3;
  return 1;
}


int EVEREX_CHIP(void)
{
 union REGS r;

 r.h.ah = 0x70;
 int386(0x10,&r,&r);
 if(r.h.al==0x70) return 1;
 return 0;
}


int CIRRUS_CHIP(void)
{
  unsigned char oldv,newv;
  outp(0x3c4,0x1206);
  oldv=inp(0x3c5);
  outp(0x3d4,0x27);
  newv=inp(0x3c5);
  if (newv == 0x8a || newv >> 2 == 0x23 || newv == 0x24 || newv == 0x25)
  return 1; else return 0;
}


int PARADISE_CHIP(void)
{
 char *sysMEM;

 sysMEM=(char *)0xC000007D;
 if(!_fstrncmp("VGA=",sysMEM,4)) return 1;
 return 0;
}


int VESA_CHIP(void)
{
 union REGS r;

 r.h.ah = 0x4F;
 r.h.al = 0;
 int386(0x10,&r,&r);
 if(r.h.ah==0x4F) return 1;
 return 0;
}

int GETVGA(void)
{
 if(TSENG_LABS_CHIP()) return 1;
  if(ATI_CHIP()) return 2;
  if(AHEAD_CHIP()) return 3;
  if(CHIPS_AND_TECH_CHIP()) return 4;
  if(OAK_CHIP()) return 5;
  if(GENOA_CHIP()) return 6;
  if(VIDEO_SEVEN_CHIP()) return 7;
  if(TRIDENT_CHIP()) return 8;
  if(EVEREX_CHIP()) return 9;
  if(CIRRUS_CHIP())  return 10;
  if(PARADISE_CHIP()) return 11;
  if(VESA_CHIP()) return 12;
  return 0;
}


