#ifndef _DPMISERV_
#define _DPMISERV_

/* Structures for issuing real mode interrupts with DPMI */
struct _RMWORDREGS {
    unsigned short ax, bx, cx, dx, si, di, cflag;
    };
struct _RMBYTEREGS {
    unsigned char   al, ah, bl, bh, cl, ch, dl, dh;
    };
typedef union {
    struct  _RMWORDREGS x;
    struct  _RMBYTEREGS h;
    } RMREGS;
typedef struct {
    unsigned short  es;
    unsigned short  cs;
    unsigned short  ss;
    unsigned short  ds;
    } RMSREGS;

/*
DPMI routines for gettin' into innards of protected mode. Useful
for interfacing to real-mode stuff
*/

void DPMI_allocRealSeg(int size,int *sel,int *r_seg);
void DPMI_freeRealSeg(unsigned sel);
int DPMI_int86(int intno, RMREGS *in, RMREGS *out);
int DPMI_int86x(int intno, RMREGS *in, RMREGS *out, RMSREGS *sregs);
int DPMI_allocSelector(void);
long DPMI_mapPhysicalToLinear(long physAddr,long limit);
void DPMI_setSelectorBase(int sel,long linAddr);
void DPMI_setSelectorLimit(int sel,long limit);

#endif
