/////////////////////////////////////////////////////////////////////////////
//                                PCX 256 color                            //
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "pcx.h"

typedef struct
{
    char Id;
    char Version;
    char Encoding;
    char Bitsperpixel;
    short x1, y1, x2, y2;
    short HRes;
    short VRes;
    unsigned char Colormap[16][3];
    char Reserved;
    char NPlanes;
    short LineBytes;
    short PaletteInfo;
    char Filler[58];
} PCXHEADER;

typedef struct
{
    unsigned char id;
    unsigned char triple[768];
}
PCXTAIL;

int pcx::load(char *fn)
{
    int ret;
    FILE *fp;
    fp = fopen(fn, "rb");
    if(fp == NULL) return -1;         // open error !!
    ret = load(fp);
    fclose(fp);
    return ret;
}

// return -1; invalid PCX !! 0; memory allocation error
int pcx::load(FILE *dummy)
{
    unsigned count;
    int data, i;
    unsigned x, y;
    unsigned ix = 0, iy = 0, flag = 0;

    PCXHEADER PCXheader;
    PCXTAIL PCXtail;

    fseek(dummy, -769L, SEEK_END);
    fread(&PCXtail, sizeof(PCXTAIL), 1, dummy);
    if(PCXtail.id != 0x0C) return -1;             // Not !!!

    for(count = 0; count < 256; count++)
    {
        PCXtail.triple[count * 3] >>= 2;
        PCXtail.triple[count * 3 + 1] >>= 2;
        PCXtail.triple[count * 3 + 2] >>= 2;
    }
    memcpy(palette, PCXtail.triple, 768);

    fseek(dummy, 0, SEEK_SET);
    fread(&PCXheader, sizeof(PCXHEADER), 1, dummy);
    if(PCXheader.Id != 0x0A) return -1;         // Not PCX !!!
    if(PCXheader.NPlanes == 4) return -1;       // Not allowed

    xw = x = PCXheader.x2 - PCXheader.x1 + 1;
    yw = y = PCXheader.y2 - PCXheader.y1 + 1;

    if(picture != NULL) free(picture);
    picture = (unsigned char *) malloc(x*y);
    if(picture == NULL) return 0;

    if(PCXheader.Encoding)
    {
        while((data = getc(dummy)) != EOF)
        {
            if((data & 0xc0) == 0xc0)
            {
                count = data & 0x3f;
                data = getc(dummy);
            }
            else count = 1;
            while(count--)
            {
                if(iy >= y) break;

                *(picture+flag++) = data;
                ix++;

                if(ix >= x)
                {
                    ix = 0;
                    iy++;
                }
            }
            if(iy >= y) break;
        }
    }
    else
    {
        while((data = getc(dummy)) != EOF) *(picture+flag++) = data;
    }
    return 1;
}
