/*
   MPU 401 Midi Interface Program
   UART MODE ( 32kbps ) Communication
*/

#include <conio.h>
#include "ds_types.h"

#define MPU401_RESET       0xff    /* MPU 401 ī   */
#define MPU401_UART_MODE   0x3f    /* MPU 401 UART MODE  */

#define DATA               0x0     /* MPU 401 Ÿ  */
#define STATUS             0x1     /* MPU 401     */
#define COMMAND            0x1     /* MPU 401 ɾ  */

#define DATA_READY         0x40    /* Data Set Ready Status */
#define DATA_AVAIL         0x80    /* Data Avaiable Bit Mask */
#define MPU_ACK            0xFE    /*  Ȯ  */

#define MAX_CNT            8192

/*
   MPU 401   .

   ·͸ о Ʈ 6 0 ɶ ٸĿ ɾ
   , ɾ Ŀ ACK  ȮϿ  ³ Ѵ.

   Է°
      cmd : MPU 401 ɾ

   ϰ
       0  : ۼ
     (-1) : Ÿ ƿ ( ð  . )
     (-2) : ۿ ( ȣ  ACK  ƴϴ. )
*/
static int sendMPU401Command(BYTE cmd)
{
    int i;

    for ( i=0; i<MAX_CNT && (inp(MPU401MIDI.BasePort+STATUS)&DATA_READY); i++ );

    if (i>=MAX_CNT)
        return(-1); /* Ÿ ƿ  */

    outp(MPU401MIDI.BasePort+COMMAND,cmd); /* ɾ  */

    for ( i=0; i<MAX_CNT &&  (inp(MPU401MIDI.BasePort+STATUS)&DATA_AVAIL); i++ );

    if (i>=30000)
        return(-1); /* Ÿ ƿ  */

    if (inp(MPU401MIDI.BasePort+DATA)!=MPU_ACK)
        return(-2); /*   */

    return(0);
}

/*
   MPU 401  Ÿ .

   ·͸ о Ʈ 6 0 ɶ ٸĿ Ÿ
   .

   Է°
      data : MPU 401 Ÿ

   ϰ
       0  : ۼ
     (-1) : Ÿ ƿ ( ð  . )
*/
static int sendMPU401Data(BYTE data)
{
    int i;

    for ( i=0; i<MAX_CNT  && (inp(MPU401MIDI.BasePort+STATUS)&DATA_READY); i++ );

    if (i>=MAX_CNT)
        return(-1); /* Ÿ ƿ  */

    outp(MPU401MIDI.BasePort+DATA,data); /* Ÿ  */
    return(0);
}

/*
   MPU 401  ̵ ޼ .

   ̵ ޼ 2Ʈ Ǵ 3Ʈ  ǹǷ 2 Ʈ ޼
   ۽ÿ sendMidiData(message,data,(-1)) , 3 Ʈ ޼ ۽
   sendMidiData(message,data1,data2)μ θ.

   Է°
      message : ̵ ޼
      data1   : ̵ ޼ Ÿ 1
      data2   : ̵ ޼ Ÿ 2 (  쿡 -1 )

   ϰ
       0  : ۼ
     (-1) : Ÿ ƿ ( ð  . )
*/
static int sendMidiData(int message,int data1,int data2)
{
   if (sendMPU401Data(message)!=0) return(-1);
   if (sendMPU401Data(data1)!=0) return(-1);
   if (data2>=0) if (sendMPU401Data(data2)!=0) return(-1);
   return(0);
}

/*
   MPU 401 ʱȭϰ UART   Ѵ.

   ϰ
     TRUE  : ʱȭ 
     FALSE : ʱȭ 
*/
static BOOL MPU401Reset( WORD Port )
{
    MPU401MIDI.BasePort = Port;

    if (sendMPU401Command(MPU401_RESET)!=0)
        if (sendMPU401Command(MPU401_RESET)!=0)
            return FALSE;

    if (sendMPU401Command(MPU401_UART_MODE)!=0)
        return FALSE;

    return TRUE;
}

/*
   MPU 401 ÿ տ   ƿ	؞

   MPU 401 ÿ 	ѷܤ廡 320h,330h 2 	񳪷	 廡
   	MPU 401  wɶ , 	y 廡 MPU 401
   áǴ᷶°ͷ.

   尪
     TRUE  : MPU 401 ÿ尡 á Ǵ
     FALSE : MPU 401 ÿ
*/
static BOOL MPU401Detect(void)
{
    int i;
    WORD Port[] = { 0x220, 0x230, 0x240, 0x250,
                    0x300, 0x320, 0x332, 0x334, 0x336, 0x340, 0x360, 0xffff };

    for ( i=0 ;;  i++ )
    {
        if ( Port[i] == 0xffff )
            break;

        if ( MPU401Reset( Port[i] ) )
            return TRUE;
    }

    return FALSE;
}

/*
   MPU 401 ʱȭϰ UART   Ѵ.

   ϰ
     TRUE  : ʱȭ 
     FALSE : ʱȭ 
*/
static BOOL MPU401Init(void)
{
    return MPU401Reset( MPU401MIDI.BasePort );
}

/*  ä  Off */
static void MPU401Exit( void )
{
    int channel;

    for ( channel=0; channel<16; channel++ )
        sendMidiData(0xB0+channel,0x78,0);
}


/* ̵ ޼ 3  */
static void MPU401Send3(BYTE m1,BYTE m2,BYTE m3)
{
    sendMidiData(m1,m2,m3);
}

/* ̵ ޼ 2  */
static void MPU401Send2(BYTE m1,BYTE m2)
{
    sendMidiData(m1,m2,(-1));
}

/* ̵ ޼ 1  */
static void MPU401SendSysex(BYTE *buff, int len)
{
    int i;

    for (i=0; i<len; i++)
        sendMPU401Data(buff[i]);
}


/* ̵ ޼        */
static void MPU401SetVolume(BYTE vol)
{
    int channel;
    int volume;

    volume=((int)vol*127)/100;
    if (volume>127)
        volume=127;

    for ( channel=0; channel<16; channel++ )
    {
        sendMidiData(0xB0+channel, 0x78, volume);
    }
}


MIDIDRIVER MPU401MIDI = {
    0x330,
    "MPU-401",

    MPU401Detect,

    MPU401Init,
    MPU401Exit,

    MPU401SetVolume,

    MPU401Send2,
    MPU401Send3,

    MPU401SendSysex,
};

