/*
	ϵ  ̵ȭ  α׷ MIDIker.c (wd40)

	ϵ  sendMIDI.c Ͽ MPU-401 ̵ , YM3812,
	YMF262, ǽýĿ ְ ϴ.

	̵ȭ 1.0 

	̵  Ʈ
	MThd l3 l2 l1 l0  v1 v0 tn1    tn0  tQ1      tQ0
		 |-   -| || |Ʈ|  |ڴƽ|

	̵ ޼ Ʈ
	MTrk l3 l2 l1 l0 timeStamp {message Ǵ midiData} .....
		 |-   -| |----      ݺ        ----|
	MTrk l3 l2 l1 l0 timeStamp {message Ǵ midiData} .....
	MTrk l3 l2 l1 l0 timeStamp {message Ǵ midiData} .....
				   .
				   .
				   .
	timeStamp  ̰   7 Bit Encoding MIDI LEGNTH FORMATμ
	  ޼  Ÿ̹ Ÿ
	Ÿ 7 Ʈɰ ֻ Ʈ 1  ģ 
	example)

	message Ǵ midiData : ޼ Ǵ ̵ Ÿ
	޼ ֻ Ʈ 1 μ MIDI,Meta,Exclusive 3 
	midiData ֻ Ʈ 0ΰμ ٷ ̵ ޼  Ÿ

	8n - En (n=0-F) : ̵ ޼
	8n key#  velocity  : ̵ Note Off Message
	9n key#  velocity  : ̵ Note On  Message
	An key#  velocity  : ̵ Key Pressure Setting Message
	Bn ctrl# data      : ̵ Ʈ Message
		7    volume    : ̵ ä   Message (ְ ۵ɶ )
		78H     0      : ̵ ä Sound All Off Message (ְ   )
	Cn prog#           : ̵ ä Ǳ  Message
	Dn velocity        : ̵ ä Pressure Pre Setting Message
	En dat1  data2     : ̵   Message
	F0 data .. data F7 : ̵ System Exclusive Message*

	FF : Meta(System) Message
	 : FF sysMessage MidiLength { sysData ... }
	   sysMessage  0-128  ̸ ̵𿡼 Ǵ°  .
		  51H : temp change  (FF 51 04 t3 t2 t1 t0)
		  2FH : end of Track (FF 2F 00)
		  ׿:   ( Ʈ̸ Ǳ̸ Ÿ .. )

	F0 : MIDI System Exclusive Message
	 : F0 MidiLength { sysData ... }
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <malloc.h>
#include <dos.h>
#include <conio.h>

#include "ds_timer.h"

#define MAX_TRACK 32 /*   ѷ  */

#define MIDI_NOTE_OFF      0x80
#define MIDI_NOTE_ON       0x90
#define MIDI_KEY_VELO      0xA0
#define MIDI_CONTROL_CHG   0xB0
#define MIDI_PROGRAM_CHG   0xC0
#define MIDI_CHANNEL_VELO  0xD0
#define MIDI_VENDOR_UNIQ   0xE0
#define MIDI_EXCLUSIVE     0xF0

#define META_MESSAGE       0xFF
#define META_END_OF_TRACK  0x2F
#define META_CHANGE_TEMPO  0x51

typedef struct
{
    BYTE *ptr; /* Ʈ   */
    BYTE message; /*  ޼ */
    BYTE status; /* Ʈ  */
	long size;             /* Ʈ  */
	long timeStamp;        /* Ʈ  Ÿ */
} MIDI_TRACK; /* ̵ 1 Ʈ Ʈ */

typedef struct
{
    BYTE *ptr;
    WORD tickPerQNote;   /* 1/4ڴ Ÿ̸ ƽ */
    long uSecPerQNote;   /* 1/4ڴ ɸ ð micro Second */
    long currentTime;    /*  ð */
    long willPlayTime;   /*   ð */
    int  willPlayTrack;  /*   Ʈ ȣ */
    long timer0Divisor;  /* 8254 Ÿ̸ ä 0 ְ */
    WORD numOfTrack;     /*  Ʈ  */
    BYTE allTrackEnd;    /*  Ʈ  1 */
} MIDI_PLAY; /* ̵  Ʈ */


static MIDI_PLAY    MP;
static MIDI_TRACK   MT[MAX_TRACK];

static int   MainVolume=100;         // ̵  

static BOOL  isActive=FALSE;         // ̵    , 1=, 0=IDLE
static DWORD MidiFlag=0;             // loop flags

static MIDIDRIVER  *MIDI=NULL;
static int MidiCardDriver = NONE;

extern long currentDivisor ; /*  Ÿ̸ ͷƮ ְ */
/*
   4 ڰ ´° ˻Ѵ. ̵ Ʈ ν "MThd", "MTrk" ˻
   ϱؼ δ.
   Է
	 name1,name2 : ˻ ڿ
   ϰ
	 (-1) : ġ 
	   1  : ġ
*/
static int is4CharCmp(BYTE *name1, BYTE *name2)
{
	int i;

	for ( i=0; i<4; i++ )
	{
		if (*(name1++) != *(name2++))
			return(-1);
	}
	return(1);
}

/*
   , Ʈ ĵ 4 Ʈ   4 Ʈ ´.
   Է
	 ptr : Ÿ 
*/
static long get4ByteLong(BYTE *ptr)
{
	long ret;

	ret = *(ptr++);
	ret = (ret<<8) | *(ptr++);
	ret = (ret<<8) | *(ptr++);
	ret = (ret<<8) | *(ptr++);

	return(ret);
}

/*
   , Ʈ ĵ 2 Ʈ   2 Ʈ  ´.
   Է
	 ptr : Ÿ 
*/
static WORD get2ByteInt(BYTE *ptr)
{
    WORD ret;

	ret = *(ptr++);
	ret = (ret<<8) | *(ptr++);

	return(ret);
}

/*
   ̵    7Ʈ  Ϲ ڷ ٲ۴.

   Է
	 ptr :  Ÿ  
*/
static long getMidiLength(BYTE **ptr)
{
	long ret;
    BYTE *tmpPtr;
	int i;

	tmpPtr = *ptr;
	ret = (*tmpPtr)&0x7f;
	for ( i=1; (*tmpPtr++)&0x80; i++ )
	{
		ret = (ret<<7) | ((*tmpPtr)&0x7f); // 7Ʈ  ȯ
	}
	*ptr = tmpPtr; //  ȯ
	return(ret);
}

/*
    ؾ Ʈ  ð Ѵ. timeStamp   
   ؾ Ʈ̴.

   Է
	 MT : ̵ Ʈ Ʈó
	 MP : ̵  Ʈó
*/
static void calcWillPlayTrack(MIDI_TRACK MT[], MIDI_PLAY *MP)
{
	int i,willPlayTrack;
	long willPlayTime;

	willPlayTrack = 0; // ó Ʈ 0  Ʈ Ѵ.
	willPlayTime  = MT[0].timeStamp;
	MP->allTrackEnd=1;

	// timeStamp   Ʈ ãƳ.
	for ( i=0; i<MP->numOfTrack; i++ )
	{
		if (MT[i].status != META_END_OF_TRACK)
		{
			if (willPlayTime>MT[i].timeStamp)
			{
				willPlayTrack=i;
				willPlayTime=MT[i].timeStamp;
			}
			MP->allTrackEnd=0; // ؾ Ʈ ִ.
		}
	}

	MP->willPlayTrack = willPlayTrack; //  Ʈ 
	MP->willPlayTime = willPlayTime;   //  Ÿ̹ 
}

/*
   8254 Ÿ̸ ä 0 ְ 
   Է
	 divisor : Ÿ̸ ä 0 ְ ( 0-65536L)
*/
static void setTimer0(long divisor)
{
    setTimer(divisor);
	MP.timer0Divisor=currentDivisor;
}

/*
    Ǽӵ 
   Է
	 divisor : 8254 Ÿ̸ ä 0  ְ
*/
static void setRelativeMusicTempo(long divisor)
{
	currentDivisor=divisor;
    divisor=((long)divisor*100)/100;
	setTimer0(divisor);
}

/*
   ̵  Ѵ.

   Է
	 uSpecPerQNote : 1/4ڴ ҿǴ ũ (1000000 1)
*/
static void setMidiTempo(long uSecPerQNote)
{
	long divisor;

	uSecPerQNote /= 1000L; // иʷ ٲ۴.
	if (uSecPerQNote==0L)
		divisor = 65536L;
	else
		divisor = (1194*uSecPerQNote)/MP.tickPerQNote;

	setRelativeMusicTempo(divisor);
}


/*
   Ʈ Ҵ ޼ Ѵ.

   Է
	 message : ޼
	 T : Ʈ Ʈó
*/
static void sendMessage(BYTE message, MIDI_TRACK *T)
{
	long length,i;
    BYTE subMessage,m2,m3;

	if (message<0xF0)
		T->message = message; // ̵޼ 

	if (message==META_MESSAGE)
	{
		subMessage = *(T->ptr++); // Ÿ ޼  ´.
		length = getMidiLength(&T->ptr); // ޼  
		// Ʈ  Ÿ ޼   ޼ Ѱ 
		switch(subMessage)
		{
			case META_END_OF_TRACK :
				T->message = T->status = META_END_OF_TRACK;
				break;

			case META_CHANGE_TEMPO :
				MP.uSecPerQNote = get4ByteLong(T->ptr)>>8;
				setMidiTempo(MP.uSecPerQNote);
				break;
		}
		T->ptr += length;
		return;
	}

	switch(message&0xF0) // ̵ ޼ 
	{
		case MIDI_NOTE_ON: /* 3 Ʈ ̵ ޼ */
		case MIDI_CONTROL_CHG:
            m2 = *(T->ptr++) ; m3 = *(T->ptr++);
            MIDI->Send3Midi(message,m2,m3 * MainVolume/100);
            break;

        case MIDI_NOTE_OFF:
		case MIDI_KEY_VELO:
		case MIDI_VENDOR_UNIQ:
			m2 = *(T->ptr++) ; m3 = *(T->ptr++);
            MIDI->Send3Midi(message,m2,m3);
			break;

		case MIDI_PROGRAM_CHG: /* 2 Ʈ ̵ ޼ */
		case MIDI_CHANNEL_VELO:
            MIDI->Send2Midi(message,*(T->ptr++));
			break;

		case MIDI_EXCLUSIVE:
			length = getMidiLength(&T->ptr);
            MIDI->SendSysex(T->ptr, length);
            T->ptr += length;
            break;
	}
}


/*
   ̵ Ʈ Ѵ.

   Է
	 MT : ̵ Ʈ Ʈó
	 MP : ̵  Ʈó
*/
static void playTrack(MIDI_TRACK MT[], MIDI_PLAY *MP)
{
    BYTE message;
	int playTrack;

	playTrack = MP->willPlayTrack; // ؾ Ʈȣ 

	message = *(MT[playTrack].ptr); // ޼ 

	// ޼  Ʈ 1̸ ο ޼̰, ƴϸ  ޼
	//	  شϴ Ÿ ̴.
	if (!(message&0x80))
		sendMessage(MT[playTrack].message,&MT[playTrack]);
	else
	{
		MT[playTrack].ptr++;
		sendMessage(message,&MT[playTrack]);
	}

	// Ʈ   Ʈ  Ÿ̹ Ѵ Ƽ ָ Ų.
	if (MT[playTrack].status==META_END_OF_TRACK)
		MT[playTrack].timeStamp=0x7FFFFFFFL;
	else
		MT[playTrack].timeStamp += getMidiLength(&MT[playTrack].ptr);

	//  ؾ Ʈ ȣ 
	calcWillPlayTrack(MT,MP);
}


/*
   ̵ Ÿ ͷ  ̵Ʈ 

   Է
	 midiPtr : ̵ȭ Ÿ 
   
	 MT : ̵ Ʈ Ʈ
	 MP : ̵  Ʈ
	 numOfTrack   :  Ʈ 
   ϰ
	 ( 1) :  
	 (-1) : ̵ ȭ ƴ
	 (-2) : ̵ Ʈ ƴ
*/
static int setUpMidiTrack(BYTE *midiPtr,MIDI_TRACK MT[], MIDI_PLAY *MP)
{
	long trackSize;
    WORD  trackNum,track;
    BYTE *trackPtr;

	// ̵ ȭΰ ν ˻
	if (is4CharCmp(midiPtr,"MThd")<0)
		return(-1);

	MP->ptr = midiPtr; // ̵ȭ   
	trackSize=get4ByteLong(midiPtr+4); // ش Ʈ  
	trackNum = get2ByteInt(midiPtr+10); // Ʈ  

    if (trackNum>MAX_TRACK)
        trackNum=MAX_TRACK; // Ʈ 16 ū 16 

	MP->numOfTrack = trackNum; // Ʈ  
	MP->tickPerQNote = get2ByteInt(midiPtr+12); // 1/4ڴ Ÿ̸ƽ 

	midiPtr += (4+4+trackSize); // ù° Ʈ 
	for ( track=0; track<trackNum; track++ )
	{
		trackPtr = midiPtr;

		// Ʈ νڰ ´ ˻
		if (is4CharCmp(trackPtr,"MTrk")<0)
			return(-2);

		MT[track].ptr  = trackPtr + 8; // Ʈ ޼ 
		trackSize = MT[track].size = get4ByteLong(trackPtr+4);
		midiPtr += (4+4+trackSize); //  Ʈ  

		// ʱ Ʈ ¿ ޼ ̵ Ʈ  
		MT[track].status = MT[track].message = MIDI_NOTE_ON;

		// Ʈ  Ÿ̹ 
		MT[track].timeStamp = getMidiLength(&MT[track].ptr);
	}
	MP->currentTime = 0; // ֿ  ð 0
	MP->uSecPerQNote = 500000L; // ӵ ð ȵȰ Ʈ
	MP->allTrackEnd  = 0; //  Ʈ   
	MP->timer0Divisor = 65536L; // Ÿ̸ ְ 65536
	calcWillPlayTrack(MT,MP); //  Ʈ ð 
	return(1);
}

void MidiUpdate(void)
{
    if (isActive)
	{
		//  ð ֵ ð ū  
		while (MP.currentTime>=MP.willPlayTime)
			playTrack(&MT[0],&MP);

		if (MP.allTrackEnd) //  Ʈ ְ .
		{
            if (MidiFlag == 1)
				setUpMidiTrack(MP.ptr,&MT[0],&MP);
			else
                MidiStop();
		}
		MP.currentTime++; //  ð ϳ 
	}
}

int MidiIsActive(void)
{
    return isActive;
}


/*
	̵ȭ ָ .
*/
void MidiStop(void)
{
    if ( MIDI == NULL )
        return;

    if (isActive)
	{
        MIDI->SetVolume(0);

        isActive = FALSE; // ̵  ÷ 0
        MidiFlag = 0;
	}
}


void MidiRelease(SONG *song)
{
    if ( MIDI == NULL )
        return;

    if (song!=NULL)
	{
        if (song->ptr!=NULL)
		{
            free(song->ptr);
            song->ptr = NULL;
		}

		free(song);
		song=NULL;
	}
}

SONG *MidiLoadFP( FILE *fp , long length )
{
	SONG *song;

    if (MidiCardDriver == NONE)
        return NULL;

	if ((song=(SONG *)calloc(1, sizeof(SONG)))==NULL)
		return NULL;

    song->length = length;
    song->ptr = malloc( song->length );
    if (song->ptr == NULL)
	{
		free(song);
		return NULL;
	}
    fread(song->ptr, 1, song->length, fp); // ̵ ȭ б

    return song;
}

SONG *MidiLoad(char *fn)
{
	FILE *fp;
	SONG *song;
    long length;

	fp=fopen(fn,"rb");
	if (fp==NULL)
		return NULL;

    length = filelength(fileno(fp));
	fseek(fp,0,SEEK_SET);
    song = MidiLoadFP( fp, length );

    fclose(fp);

	return song;
}

void MidiPlay( SONG *song, DWORD flags )
{
    BYTE *midiPtr;

    if ( MIDI == NULL )
        return;

    if (isActive)
        MidiStop(); // ̵ȭ ̸ Ų.

    midiPtr = song->ptr;

	// ̵ Ʈ ʱȭ
	if (setUpMidiTrack(midiPtr,&MT[0],&MP)<0)
		return;

    isActive = TRUE; // ̵  ÷ 
    MidiFlag = flags;
}

/*
   ̵   Ѵ.

   Է
	 volume : Ҹũ  100  ̸, Ŭ ũ.
*/
void MidiSetVolume(int volume)
{
    if (MIDI == NULL)
        return;

    _disable();            // ޼ ۵ ͷƮ Ȱɸ ͷƮ 
    MainVolume = volume;   //   
    MIDI->SetVolume(volume);
	_enable();
}


BYTE MidiGetVolume( void )
{
    return MainVolume;
}

int detectMidiDriver( void )
{
    if ( AWE32MIDI.Detect() )
    {
        MIDI = &AWE32MIDI;
        return AWE32;
    }

    if ( MPU401MIDI.Detect() )
    {
        MIDI = &MPU401MIDI;
        return MPU401;
    }

    MIDI = &NOMIDI;
    return NONE;
}

BOOL InitMidiDriver( WORD BasePort, int MidiCard )
{
    switch ( MidiCard )
    {
        case NONE:
            MIDI = &NOMIDI;
            return TRUE;

        case AUTO:
            MidiCard = detectMidiDriver();
            if ( MidiCard == NONE )
                return TRUE;

            break;

        case AWE32:
            MIDI = &AWE32MIDI;
            MIDI->BasePort = BasePort;
            break;

        case MPU401:
            MIDI = &MPU401MIDI;
            MIDI->BasePort = BasePort;
            break;
    }

    if ( !MIDI->Init() )
        return FALSE;

    MidiSetVolume( 100 );

    TimerInstall();

    MidiCardDriver = MidiCard;

    return TRUE;
}

void CloseMidiDriver( void )
{
    TimerUnInstall();

    MidiStop();
    MIDI->Exit();
}

char *GetMidiDriverName( void )
{
    return MIDI->DriverName;
}

WORD GetMidiBasePort( void )
{
    return MIDI->BasePort;
}

#pragma aux timerProcess "_*" parm caller [];
int timerProcess(void)
{
    MidiUpdate();

    return 1;
}


