////////////////////////////////////////////////////////////////////////////
//
//  Sound Blaster AWE32 Low level Access Driver version 1.0a
//
//                            1996, 5    HITEL : lufang3s
//
/////////////////////////////////////////////////////////////////////////////

#include "awe32.h"
#include "ds_types.h"

static BOOL AWE32Detect( void )
{
    int i;
    WORD Port[]={ 0x610, 0x620, 0x630, 0x640, 0x650, 0x660, 0x680, 0xffff };

    for (i=0;; i++)
    {
        if ( Port[i] == 0xffff )
            break;

        if ( !awe32Detect( Port[i]) )
        {
            AWE32MIDI.BasePort = Port[i];
            return TRUE;
        }
    }

    return FALSE;
}

static BOOL AWE32Init( void )
{
    if ( awe32Detect( AWE32MIDI.BasePort ) )
        return FALSE;

    if ( awe32InitHardware() )
        return FALSE;

    awe32SoundPad.SPad1 = awe32SPad1Obj;
    awe32SoundPad.SPad2 = awe32SPad2Obj;
    awe32SoundPad.SPad3 = awe32SPad3Obj;
    awe32SoundPad.SPad4 = awe32SPad4Obj;
    awe32SoundPad.SPad5 = awe32SPad5Obj;
    awe32SoundPad.SPad6 = awe32SPad6Obj;
    awe32SoundPad.SPad7 = awe32SPad7Obj;

    awe32InitMIDI();
    awe32InitNRPN();

    awe32Reverb( 4 );
    awe32Chorus( 2 );

    return TRUE;
}

static void AWE32Exit( void )
{
    awe32Terminate();
}


static void AWE32SetVolume( WORD vol )
{
    int channel;
    int volume;

    for ( channel = 0; channel < 16; channel ++ )
    {
        volume = ( ( int ) vol * 127) / 100;
        if ( volume > 127 )
            volume = 127;

        awe32Controller( channel, 0x78, volume );
    }
}


/* ̵ ޼ 2  */
static void AWE32Send2( BYTE m1, BYTE m2 )
{
    switch ( m1 >> 4 )
    {
        case 0xc:
            awe32ProgramChange( ( WORD ) (m1 & 15), m2 );
            break;

        case 0xd:
            awe32ChannelPressure( ( WORD ) (m1 & 15), m2 );
            break;
    }
}

/* ̵ ޼ 3  */
static void AWE32Send3( BYTE m1, BYTE m2, BYTE m3 )
{
    switch ( m1 >> 4 )
    {
        case 0x8:
            awe32NoteOff( ( WORD ) (m1 & 15), m2, m3 );
            break;

        case 0x9:
            awe32NoteOn( ( WORD ) (m1 & 15), m2, m3 );
            break;

        case 0xa:
            awe32PolyKeyPressure( ( WORD ) (m1 & 15), m2, m3 );
            break;

        case 0xb:
            awe32Controller( ( WORD ) (m1 & 15), m2, m3 );
            break;

        default:
            awe32PitchBend( (WORD) (m1 & 15), m2, m3 );
            break;
    }
}

static void AWE32SendSysex( BYTE *buf, int len )
{
    awe32Sysex( 0, buf, len );
}

MIDIDRIVER AWE32MIDI = {
    0x620,
    "AWE 32",
    
    AWE32Detect,

    AWE32Init,
    AWE32Exit,

    AWE32SetVolume,

    AWE32Send2,
    AWE32Send3,
    AWE32SendSysex,
};

