#include <dos.h>

#include "ds_timer.h"
static BOOL isActive = FALSE;

void TimerInstall(void)
{
    void far *newfunc;
    union REGS regi;
    struct SREGS sregi;

    if ( isActive )
        return;

    isActive = TRUE;

    setTimer(32767);

    regi.x.eax = 0x3508;
    sregi.ds = sregi.es = 0;
    int386x(0x21,&regi,&regi,&sregi);
    oldInterrupt08Selector = sregi.es;
    oldInterrupt08Offset = regi.x.ebx;

    regi.x.eax = 0x2508;
    newfunc = (void far *)newTimerInterrupt;
    regi.x.edx = FP_OFF(newfunc);
    sregi.ds = FP_SEG(newfunc);
    sregi.es = 0;
    int386x(0x21,&regi,&regi,&sregi);

    timerStartProcess(10);
}

void TimerUninstall(void)
{
    union REGS regi;
    struct SREGS sregi;

    if ( isActive )
    {
        isActive = FALSE;

        regi.x.eax = 0x2508;
        regi.x.edx = oldInterrupt08Offset;
        sregi.ds = oldInterrupt08Selector;
        sregi.es = 0;
        int386x(0x21,&regi,&regi,&sregi);

        setTimer(65536);
    }
}

