#ifndef __SOUND_TYPE_H__
#define __SOUND_TYPE_H__

#ifndef __MAIN__

#include <stdio.h>

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;

#define BOOL  int
#define TRUE  1
#define FALSE 0

// ̵ Ÿ ü
typedef struct {
    DWORD length;            //  
    BYTE  *ptr;              //  
} SONG;

#endif

// ̵ ī ̺ 
typedef struct {
    WORD  BasePort;      // / ּ
    BYTE  *DriverName;   // ̺ ̸

    // Auto Detected
    BOOL (*Detect)( void );

    // ̺ ʱȭ
    BOOL (*Init)( void );

    // ̺ 볡...
    void (*Exit)( void );

    //  
    void (*SetVolume)( WORD );

    // 2Ʈ ޽ 
    void (*Send2Midi)( BYTE, BYTE );

    // 3Ʈ ޽ 
    void (*Send3Midi)( BYTE, BYTE, BYTE );

    // ͽŬú ޽ 
    void (*SendSysex)( BYTE *, int );
} MIDIDRIVER;

extern MIDIDRIVER NOMIDI;     // ̵ī尡 °
extern MIDIDRIVER AWE32MIDI;  //  AWE32( 32Pnp  ) ̺
extern MIDIDRIVER MPU401MIDI; // ǥع̵( MPU-401 ) ̺

#ifdef __cplusplus
extern "C" {
#endif

extern MIDIDRIVER  *MIDI;

SONG  *MidiLoadFP( FILE *fp , long length );
SONG  *MidiLoad(char *fn);

void  MidiRelease(SONG *song);

void  MidiPlay( SONG *song, DWORD flags );
void  MidiStop( void );

int   MidiIsActive( void );

BYTE  MidiGetVolume( void );
void  MidiSetVolume( BYTE volume );

#ifdef __cplusplus
}
#endif

#ifndef __MAIN__

// ̵ī
#define NONE   0
#define AUTO   1
#define AWE32  2  //  32/AWE32
#define MPU401 3  // MPU401 ȣȯ

#endif

#endif
