#define __MAIN__

#include "music.h"
#include "ds_types.h"

MUSIC::~MUSIC()
{
    this->Release();
}


BOOL MUSIC::Load( char *MidiFileName )
{
    song = MidiLoad( MidiFileName );

    if ( song == NULL )
        return FALSE;
    else
        return TRUE;
}

BOOL MUSIC::Load( FILE *MidiFP, long MidiLength )
{
    song = MidiLoadFP( MidiFP, MidiLength );

    if ( song == NULL )
        return FALSE;
    else
        return TRUE;
}


void MUSIC::Release( void )
{
    this->Stop();

    MidiRelease( song );
}


BYTE MUSIC::GetVolume( void )
{
    return MidiGetVolume();
}

void MUSIC::SetVolume( BYTE volume )
{
    MidiSetVolume( volume );
}

BOOL MUSIC::IsActive( void )
{
    return MidiIsActive();
}

void MUSIC::Play( DWORD flags )
{
    MidiPlay( song, flags );
}

void MUSIC::Stop( void )
{
    MidiStop();
}

