; -------------------------------------------------------------------
; Timmer Interrupt for WATCOM C/C++ V1.1 (use DOS/4GW)
; assembler : tasm 3.1
; option : /ml /m2 /q /t
; -------------------------------------------------------------------
.386p
.model flat,c

.data
public timerActive
public currentDivisor
public oldInterrupt08Offset
public oldInterrupt08Selector

oldInterrupt08Offset    dd      0
oldInterrupt08Selector  dw      0
currentDivisor	        dd      0
currentTimerTick        dd      0
timerDelay              dd      0
timerActive             dd      0

.data?
.code
extrn timerProcess:proc                         ; user function.
; -------------------------------------------------------------------
; c prototype : void setTimer(int divisor);
; -------------------------------------------------------------------
public setTimer
setTimer proc divisor:dword
		push    ebx
		push    eax

        mov     eax, [divisor]
        cmp     eax, 65536
        jbe     settimer00
        mov     eax, 65536

settimer00:
		cmp     eax, 0
        jg      settimer01
        mov     eax, 65536

settimer01:
		mov     ebx, eax
		mov     [currentDivisor], eax
        mov     al, 36h
        out     43h, al
        mov     eax, ebx
        out     40h, al
        xchg    ah, al
        out     40h, al

		pop     eax
		pop     ebx
		ret
setTimer endp

; -------------------------------------------------------------------
; c prototype : void timerStartProcess(int delay);
; -------------------------------------------------------------------
public timerStartProcess
timerStartProcess proc delay:dword
		push    eax

		mov     eax, [delay]
		mov     [timerDelay], eax

		pop     eax
		ret
timerStartProcess endp

; -------------------------------------------------------------------
; c prototype : void __interrupt newTimerInterrupt(void);
; -------------------------------------------------------------------
public newTimerInterrupt
newTimerInterrupt:
		push    ds
		push    es
		push    eax
		push    ebx

		cli
		mov     ax, DGROUP
		mov     es, ax
		mov     ds, ax
		mov     eax, es:[currentTimerTick]
		add     eax, es:[currentDivisor]
		mov     es:[currentTimerTick], eax
		dec     dword ptr es:[timerDelay]
		jnz     newtimerinterrupt03
		cmp     dword ptr es:[timerActive], 0
        jnz     newtimerinterrupt03

newtimerinterrupt01:
		inc     es:[timerActive]
		sti
		call    timerProcess                    ; return value eax=new dealy
		cli
		dec     es:[timerActive]
		mov     ebx, es:[timerDelay]
		neg     ebx
		cmp     ebx, eax
		jb      newtimerinterrupt02
		mov     dword ptr es:[timerDelay], 0
		jmp     newtimerinterrupt01

newtimerinterrupt02:
		add     es:[timerDelay], eax

newtimerinterrupt03:
		cmp     dword ptr es:[currentTimerTick], 65536
		jb      newtimerinterrupt04
		sub     dword ptr es:[currentTimerTick], 65536
		pop     ebx
		pop     eax
		pop     es
		pop     ds
		jmp     fword ptr cs:oldInterrupt08Offset; call original interrupt(18.2)

newtimerinterrupt04:
		mov     al, 20h
		out     20h, al
		sti
		pop     ebx
		pop     eax
		pop     es
		pop     ds
		iretd

end
