//theme : Let's draw in 3D
//author : lee jong whan
//date   : 1996.7.5.Friday
//compiler : Turbo C++ 3.0
//file type : a.cpp
//borland graphic interface : egavga.bgi ( must be located in the
// 			      current directory


//header files
#include <math.h>
#include <alloc.h>
#include <stdio.h>
#include <graphics.h>
#include <bios.h>
#include <conio.h>

//3d engine primitive functions
void  coeff(float rho, float theta, float phi);
void  viewing(float xw, float yw, float zw, float *xe, float *ye, float *ze);
void  projection(float xe, float ye, float ze, float *pX, float *pY);

//3d engine global variables
//3d matrix (4X4)
float  v11, v12, v13, v21, v22, v23, v32, v33, v43;

// ( REAL WORLD PLANE)  (PROJECT PLANE) (EYE PLANE)
//                   |---> Produce 2-D screen co-ordinates
//d:distance between real world plane and project plane
//c1:screen's central point's x
//c2:screen's central point's y
float  d,c1, c2;

//rho,theta,phi : view point's spherical co-ordinates
//rho : distance
//theta : degrees from x axis   0 ~ 2*M_PI  (in radian)
//phi   : degrees from z axis   0 ~ M_PI    (in radian)
void  coeff(float rho, float theta, float phi)
{
    float th, ph, costh, sinth, cosph, sinph, rad;

    rad = atan(1.0) / 45.0;  /* 1 radian */
    th = theta * rad;
    ph = phi * rad;
    costh = cos(th);   sinth = sin(th);
    cosph = cos(ph);   sinph = sin(ph);
    v11 = -sinth;   v12 = -cosph*costh;   v13 = -sinph*costh;
    v21 = costh;    v22 = -cosph*sinth;   v23 = -sinph*sinth;
		    v32 = sinph;          v33 = -cosph;
					  v43 = rho;
}

//x,y,z : view point's co-ordinates
void  coeff2(float x,float y,float z)
{
    float rho,theta,phi;
    float th, ph, costh, sinth, cosph, sinph, rad;

    rho=sqrt(x*x+y*y+z*z);
    theta=acos(x/sqrt(x*x+y*y));
    phi=acos(z/sqrt(x*x+y*y+z*z));

    rad = atan(1.0) / 45.0;  /* 1 radian */
    th = theta * rad;
    ph = phi * rad;
    costh = cos(th);   sinth = sin(th);
    cosph = cos(ph);   sinph = sin(ph);
    v11 = -sinth;   v12 = -cosph*costh;   v13 = -sinph*costh;
    v21 = costh;    v22 = -cosph*sinth;   v23 = -sinph*sinth;
		    v32 = sinph;          v33 = -cosph;
					  v43 = rho;
}

//REAL WORLD CO-ORDINATES-> EYE'S CO-ORDINATES
void  viewing(float xw, float yw, float zw, float *xe, float *ye, float *ze)
{
	*xe = v11*xw + v21*yw;
	*ye = v12*xw + v22*yw + v32*zw;
	*ze = v13*xw + v23*yw + v33*zw + v43;
}

//EYE'S CO-ORDINATES -> PROJECT PLANE (we can see it in the Screen)
void  projection(float xe, float ye, float ze, float *pX, float *pY)
{									 /* Perspective Projection */
	*pX = d*xe/ze + c1;
	*pY = d*ye/ze + c2;
}


//3d graphic functions
void  moveto_3d(float xw, float yw, float zw)
{
	float  xe, ye, ze, XX, YY;
	viewing(xw, yw, zw, &xe, &ye, &ze);
	projection(xe, ye, ze, &XX, &YY);
    moveto(XX, YY);
}

void  lineto_3d(float xw, float yw, float zw)
{
	float  xe, ye, ze, XX, YY;
	viewing(xw, yw, zw, &xe, &ye, &ze);
	projection(xe, ye, ze, &XX, &YY);
    lineto(XX, YY);
}

void  putpixel_3d(float xw, float yw, float zw,int color=WHITE)
{
	float  xe, ye, ze, XX, YY;
	viewing(xw, yw, zw, &xe, &ye, &ze);
	projection(xe, ye, ze, &XX, &YY);
	putpixel(XX, YY,color);
}

void line_3d(int x1,int y1,int z1,int x2,int y2,int z2)
{
    moveto_3d(x1,y1,z1);
    lineto_3d(x2,y2,z2);
}

//Super Vga Graphics
void opengraph(void)
{
	 int card=VGA,mode=VGAMED;
	 initgraph(&card,&mode,"");
	 d=50;
	 c1=640/2;
	 c2=350/2;
}

//page flipping animation
void change_screen(void)
{
	static int i;
	if (i++%2==0)
	{setactivepage(0);setvisualpage(1);}
	else
	{setactivepage(1);setvisualpage(0);}
	setfillstyle(SOLID_FILL,BLACK);
	bar(0,0,639,349);

}
void change_screen2(void)
{
	static int i;
	if (i++%2==0)
	{setactivepage(0);setvisualpage(1);}
	else
	{setactivepage(1);setvisualpage(0);}

}




//various examples
void show_0(void)
{
	 float i;
	 opengraph();
	 setcolor(WHITE);
	 circle(100,100,50);
	 for (i=1;i<19;i+=0.1)
	 {
	 change_screen();
	 coeff(i,i*2,i*3);
	 moveto_3d(20,0,25);
	 lineto_3d(-20,0,25);
	 lineto_3d(0,20,25);
	 lineto_3d(20,0,25);
	 line_3d(0,0,0,-20,0,25);
	 line_3d(0,0,0,0,20,25);
	 line_3d(0,0,0,20,0,25);
	 if (bioskey(1)) break;
	 }
	 getch();
    closegraph();
}

void show_1(void)
{
	 float i;
	 opengraph();
	 for (i=0;i<=360;i+=1)
	 {
	 change_screen();
	 coeff(40-i/360*12,i,i/360*20+10);
	 moveto_3d(10,0,25);
	 lineto_3d(-10,0,25);
	 lineto_3d(0,20*sqrt(2),25);
	 lineto_3d(10,0,25);
	 line_3d(9,9,0,-10,0,25);
	 line_3d(9,9,0,0,20*sqrt(2),25);
	 line_3d(9,9,0,10,0,25);
	 line_3d(9,9,0,0,0,0);
	 if (bioskey(1)) break;
	 }
	 getch();
    closegraph();
}

void show_2(void)
{
	float rho,theta,phi;
	float x,y,z;
	 opengraph();
	 rho=48;


	 for (phi=0;phi<=M_PI;phi+=0.01)
	 for (theta=0;theta<=2*M_PI;theta+=0.01)

	 {
	 coeff(50,30,50);

	 x=rho*sin(theta)*cos(phi);
	 y=rho*sin(theta)*sin(phi);
	 z=rho*cos(theta);
	 putpixel_3d(x,y,z,WHITE);
	 if (bioskey(1)) break;

	 }
	 getch();
    closegraph();
}
void show_3(void)
{
	float x,y,z;
	int i;

	 opengraph();
	for (i=0;i<90;i++)
	{
	coeff(3,i,i);
	change_screen();
	 for (z=-2;z<=2;z+=0.4)
	 for (x=-2;x<=2;x+=0.4)
	 for (y=-2;y<=2;y+=0.4)
	 {


	 putpixel_3d(x,y,z);


	 }
	 if (bioskey(1)) break;
	 }

	 getch();
    closegraph();
}

//super module
void main(void)
{
	clrscr();
	puts("The 3d primitive show");
	puts("coded by lee jong whan");
	puts("e-mail : leejw51@hitel.kol.co.kr");

	getch();
	show_0();
	show_1();
	show_2();
	show_3();
	clrscr();
	puts("Thanks");
}
