
// g3d3ds.h
//
// Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

#ifndef __G3D3DS_H__
#define __G3D3DS_H__

#include "stdgfx.h"
#include "g3dfile.h"

// 3DS Chunk Types
#define CHUNK_PRIMARY          0x4D4D   // 3DS File ID
  #define CHUNK_RGBF           0x0010   // RGB Color in float
  #define CHUNK_RGBB           0x0011   // RGB Color in Byte
  // Main Chunks
  #define CHUNK_OBJECT_MESH    0x3D3D   // Object Mesh Data
    // Mesh Chunks
    #define CHUNK_BGCOLOR      0x1200   // Background Color
    #define CHUNK_AMBIENTCOLOR 0x2100   // Ambient Color
    #define CHUNK_OBJECTBLOCK  0x4000   // Object Block
      // Object Description
      #define CHUNK_TRIANGLE   0x4100   // Triangle Data
        // Triangle Description
        #define CHUNK_VERTICES 0x4110   // Vertices for this Triangle
        #define CHUNK_FACELIST 0x4120   // Face List
        #define CHUNK_FACE_MAT 0x4130   // Face Material
        #define CHUNK_MAPLIST  0x4140   // Map List
        #define CHUNK_SMOOLIST 0x4150   // Smooth List
        #define CHUNK_TRMATRIX 0x4160   // Triangle Matrix
        
      #define CHUNK_LIGHT      0x4600   // Light
        // Light Description
        #define CHUNK_SPOTLIGHT 0x4610  // Spot Light
              
      #define CHUNK_CAMERA     0x4700   // Camera
      
  #define CHUNK_MATERIAL       0xAFFF   // Material
    // Material Description
    #define CHUNK_MATNAME      0xA000   // Material Name
    #define CHUNK_AMBIENT      0xA010   // Ambient 
    #define CHUNK_DIFFUSE      0xA020   // Diffuse 
    #define CHUNK_SPECULAR     0xA030   // Specular
    #define CHUNK_TEXTURE      0xA200   // Texture
    #define CHUNK_BUMPMAP      0xA230   // Bump Mapping
    #define CHUNK_MAPFILE      0xA300   // Texture File    
     
  #define CHUNK_KEYFRAMER      0xB000   // Key Framer
    // Key Framer Description
    #define CHUNK_FRAMES       0xB008   // Chunk Frame

struct CHUNK3DS
  {
    SHORT ID;
    LONG  NextOffset;  
  }; // End of CHUNK3DS

class G3D3DSTOOL : public G3DFILETOOL
  {
    protected :
      float *u_list;
      float *v_list;
    
      // 3DS File Reader
      VOID SkipToNextChunk ( FILEHANDLE f, CHUNK3DS *Chunk );
      BOOLEAN Read3DSChunk ( FILEHANDLE f, CHUNK3DS *Chunk );
      BOOLEAN Read3DSTriVertices ( FILEHANDLE f, G3DPOLYHEDRON* Object,
                                   LONG Fp );
      BOOLEAN Read3DSTriFaceList ( FILEHANDLE f, G3DPOLYHEDRON* Object,
                                   LONG Fp );
      BOOLEAN Read3DSTriMapList ( FILEHANDLE f, G3DPOLYHEDRON* Object,
                                  LONG Fp );
      BOOLEAN Read3DSTriObjectChunks ( FILEHANDLE f, G3DPOLYHEDRON* Object,
                                       LONG Fp );
      BOOLEAN Read3DSObjectChunks ( FILEHANDLE f, LINKEDLIST<G3DOBJECT*> *ObjectList,
                                    LONG Fp );
      BOOLEAN Read3DSMeshChunks ( FILEHANDLE f, LINKEDLIST<G3DOBJECT*> *ObjectList, LONG Fp );
      BOOLEAN Read3DSMainChunks ( FILEHANDLE f, LINKEDLIST<G3DOBJECT*> *ObjectList, LONG Fp );
      
    public :
      G3D3DSTOOL ();
      virtual ~G3D3DSTOOL ();      
      
      virtual BOOLEAN Load ( FILEHANDLE f, LINKEDLIST<G3DOBJECT*> *ObjectList,
                             BOOLEAN ClockWise, double Scale );     
      virtual BOOLEAN Save ( FILEHANDLE f, LINKEDLIST<G3DOBJECT*> *ObjectList,
                             BOOLEAN ClockWise, double Scale );
  }; // End of G3D3DSTOOL

#endif


