
// g3dlight.cpp
//
// Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "g3dlight.h"

G3DLIGHT::G3DLIGHT () : G3DOBJECT ()
  {
    ShadeTable = NULL;
    MinIntensity = (float)0;
    MaxIntensity = (float)0;
    ScaleFactor = (float)0;
    Moved = Rotated = FALSE;
  } // End of Constructor for G3DLIGHT

G3DLIGHT::~G3DLIGHT ()
  {
  } // End of Destructor for G3DLIGHT

VOID G3DLIGHT::SetPosition ( float x, float y, float z )
  {
    G3DOBJECT::SetPosition ( (float)0, (float)0, (float)0 );
    Move ( x, y, z );
  } // End of SetPosition for G3DLIGHT

VOID G3DLIGHT::SetShadeTable ( COLORTABLE *NewShadeTable )
  {
    ShadeTable = NewShadeTable;
    if (ShadeTable!=NULL)
      {
        MinIntensity = (float)0;
        MaxIntensity = (float)ShadeTable->GetNumLevels()*65536;
        ScaleFactor = (float)ShadeTable->GetNumLevels ()*65536;  
      } // End if
  } // End of SetShadeTable for G3DLIGHT

float G3DLIGHT::ComputeIntensity ( FLPVECTOR3D *Point, FLPVECTOR3D *Normal )
  {
    FLPVECTOR3D Dir;
    float DotProduct;

    FLPVectorSub ( &FLPWorldPosition, Point, &Dir );
    FLPVectorNormalize ( &Dir );

    DotProduct = FLPVectorDot ( &Dir, Normal );
    if (DotProduct<0)
      return MinIntensity;

    float Intensity;

    Intensity = ScaleFactor*DotProduct;
    if (Intensity<MinIntensity)
      return MinIntensity;
    else if (Intensity>MaxIntensity)
      return MaxIntensity;
    return Intensity;  
  } // End of ComputeIntensity for G3DLIGHT


