
// lg3drasm.cpp
//
// Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "lg3dras.h"

LONG  _LeftX;
LONG  _LeftY;
LONG  _LeftU;
LONG  _LeftV;
LONG  _LeftI;
LONG  _LeftZ;
LONG  _LeftH;
  
LONG  _RightX;
LONG  _RightY;
LONG  _RightU;
LONG  _RightV;
LONG  _RightI;
LONG  _RightZ;
LONG  _RightH;
  
LONG  _LeftDx;
LONG  _LeftDy;
LONG  _LeftDu;
LONG  _LeftDv;
LONG  _LeftDI;
LONG  _LeftDz;
LONG  _LeftDh;
  
LONG  _RightDx;
LONG  _RightDy;
LONG  _RightDu;
LONG  _RightDv;
LONG  _RightDI;
LONG  _RightDz;
LONG  _RightDh;
    
BYTE*  _DestBuffer;
BYTE*  _TextureBuffer;
LONG   _AddDest;
BYTE*  _ShadeBuffer;
BYTE*  _BlendBuffer;
BYTE*  _HazeBuffer;
float* _DivTable;

LONG  Color;
LONG  LoopCount;
LONG  VMinX;
LONG  VMaxX;
LONG  VMinY;
LONG  VMaxY;
LONG  TempLen;
LONG  TempVal;
  
// Inner Loop Delta
LONG  InDeltaDI;
LONG  InDeltaDu;
LONG  InDeltaDv;
LONG  InDeltaDh;

SHORT InLoopCount;

float DummyFloat;

// VOID _SetViewPortData ( LONG MinX, LONG MinY, LONG MaxX, LONG MaxY )
//
// EAX = MinX, EDX = MinY, EBX = MaxX, ECX = MaxY

VOID _SetViewPortData ( LONG MinX, LONG MinY, 
    			  	    LONG MaxX, LONG MaxY )
{
_asm {
  pushad
  mov  EAX, MinX
  mov  EDX, MinY
  mov  EBX, MaxX
  mov  ECX, MaxY
  mov  VMinX, EAX
  mov  VMinY, EDX
  mov  VMaxX, EBX
  mov  VMaxY, ECX
  popad
} // End asm
} // End of _SetViewPortData


// VOID _DrawSolidNoHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidNoHorz ( LONG nColor, LONG nLoopCount, 
	  			        LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
    
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidNoHorz :
    cmp  ECX, 0
    jne  DrawSolidNoHorzClip

 ; DrawSolidNoHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
      cmp  ECX, 0
      jle  NextRowSolidNoHorzNoClip 

      mov  EAX, Color         ; U
      mov  EDX, ECX           ; V
    
      shr  ECX, 2             ; U
      and  EDX, 3             ; V
      rep  stosd
      mov  ECX, EDX
      rep  stosb

      NextRowSolidNoHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoHorz
      jmp  EndLoopOutSolidNoHorz

  DrawSolidNoHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoHorz
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightSolidNoHorz :
        cmp  ECX, VMaxX
        jle  StartSolidNoHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoHorz :
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidNoHorz

      add  EDI, EAX           

      mov  EAX, Color         
      mov  EDX, ECX           
    
      shr  ECX, 2             
      and  EDX, 3             
      rep  stosd
      mov  ECX, EDX
      rep  stosb
    
      NextRowSolidNoHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoHorz

  EndLoopOutSolidNoHorz :

  popad
} // End asm
} // End of _DrawSolidNoHorz


// VOID _DrawSolidGrdHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidGrdHorz ( LONG nColor, LONG nLoopCount, LONG SkipRow, 
						 LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
    
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidGrdHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdHorzClip

;  DrawSolidGrdHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, _LeftI    ; U
      mov  EAX, EBX        ; U     EAX is the Left I
      add  EBX, _LeftDI   ; V
      mov  _LeftI, EBX    ; V
      
      mov  EBX, _RightI   ; U
      mov  EDX, EBX        ; U     EDX is the Right I
      add  EBX, _RightDI  ; V
      mov  _RightI, EBX   ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdHorzNoClip

      mov  EBX, EAX        ; EBX is the Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EBP, EBX
      mov  EAX, Color        
      mov  EDX, InDeltaDI 
      push ESI
      mov  ESI, _ShadeBuffer
      
        InLoopSolidGrdHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, EDX
          mov  AH, [EBX+ESI]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidGrdHorz

      pop  ESI

      NextRowSolidGrdHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidGrdHorz
      jmp  EndLoopOutSolidGrdHorz

  DrawSolidGrdHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, _LeftI    ; U
      mov  EAX, EBX        ; U   EAX is the Left I
      add  EBX, _LeftDI   ; V
      mov  _LeftI, EBX    ; V
      
      mov  EBX, _RightI   ; U
      mov  EDX, EBX        ; U   EDX is the Right I
      add  EBX, _RightDI  ; V
      mov  _RightI, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidGrdHorz

      mov  EBX, EAX        ; EAX is Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, EBX
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, InDeltaDI 
      push ESI
      mov  ESI, _ShadeBuffer
      
        InLoopClippedSolidGrdHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          mov  AH, [EBX+ESI]
          add  EBP, EDX
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidGrdHorz
    
      pop  ESI
      NextRowSolidGrdHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidGrdHorz

  EndLoopOutSolidGrdHorz :

  popad
} // End asm
} // End of _DrawSolidGrdHorz


// VOID _DrawTextureNoHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureNoHorz ( LONG nColor, LONG nLoopCount, 
						  LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureNoHorz :
    cmp  ECX, 0
    jne  DrawTextureNoHorzClip

;  DrawTextureNoHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      sar  ECX, 8
      mov  EDX, _LeftV
      sar  EDX, 8
      mov  ESI, _TextureBuffer
      mov  EBX, 0

        InLoopTextureNoHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  [EDI], AL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureNoHorz

      pop  ESI

      NextRowTextureNoHorzNoClip :

      mov  EAX, _LeftU
      mov  EBX, _LeftV
      add  EAX, _LeftDu
      add  EBX, _LeftDv
      mov  _LeftU, EAX
      mov  _LeftV, EBX

      mov  EAX, _RightU
      mov  EBX, _RightV
      add  EAX, _RightDu
      add  EBX, _RightDv
      mov  _RightU, EAX
      mov  _RightV, EBX

      dec  ESI
      jnz  LoopOutTextureNoHorz
      jmp  EndLoopOutTextureNoHorz

  DrawTextureNoHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop
      mov  TempLen, EBX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  ESI, _TextureBuffer
      mov  EBX, 0

        InLoopClippedTextureNoHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  [EDI], AL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureNoHorz

      pop  ESI

      NextRowTextureNoHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoHorz

  EndLoopOutTextureNoHorz :

  popad
} // End asm
} // End of _DrawTextureNoHorz


// VOID _DrawTextureFlatHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureFlatHorz ( LONG nColor, LONG nLoopCount, 
						    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureFlatHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatHorzClip

;  DrawTextureFlatHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      mov  EDX, _LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      
        InLoopTextureFlatHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [ESI+EAX]
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureFlatHorz
    
      pop  ESI

      NextRowTextureFlatHorzNoClip : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutTextureFlatHorz
      jmp  EndLoopOutTextureFlatHorz

  DrawTextureFlatHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      
        InLoopClippedTextureFlatHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [ESI+EAX]
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureFlatHorz
    
      pop  ESI

      NextRowTextureFlatHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatHorz

  EndLoopOutTextureFlatHorz :

  popad
} // End asm
} // End of _DrawTextureFlatHorz


// VOID _DrawTextureGrdHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureGrdHorz ( LONG nColor, LONG nLoopCount, 
						   LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped

  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureGrdHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdHorzClip

;  DrawTextureGrdHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI
      
      mov  ECX, _LeftU
      mov  EDX, _LeftV
      mov  ESI, _LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
      
        InLoopTextureGrdHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  BL, [EAX]
          add  ESI, InDeltaDI
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureGrdHorz
   
      pop  ESI

      NextRowTextureGrdHorzNoClip :
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        dec  ESI
      jnz  LoopOutTextureGrdHorz
      jmp  EndLoopOutTextureGrdHorz

  DrawTextureGrdHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, _LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

        InLoopClippedTextureGrdHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  BL, [EAX]
          add  ESI, InDeltaDI
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureGrdHorz
    
      pop  ESI

      NextRowTextureGrdHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX
   
        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdHorz

  EndLoopOutTextureGrdHorz :

  popad
} // End asm
} // End of _DrawTextureGrdHorz


//***************************************************
//
//  Transparent Routines
//
//***************************************************

// VOID _DrawSolidNoTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidNoTransHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped

  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoTransHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidNoTransHorz :
    cmp  ECX, 0
    jne  DrawSolidNoTransHorzClip

;  DrawSolidNoTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
      cmp  ECX, 0
      jle  NextRowSolidNoTransHorzNoClip 

      mov  EAX, Color         
      and  EAX, 0000FF00h
      mov  EBP, _BlendBuffer
      
        InLoopSolidNoTransHorz :
          mov  AL, [EDI]
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          loop InLoopSolidNoTransHorz
          
      NextRowSolidNoTransHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoTransHorz
      jmp  EndLoopOutSolidNoTransHorz

  DrawSolidNoTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoTransHorz
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightSolidNoTransHorz :
        cmp  ECX, VMaxX
        jle  StartSolidNoTransHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoTransHorz :
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidNoTransHorz

      add  EDI, EAX           

      mov  EAX, Color         
      and  EAX, 0000FF00h
      mov  EBP, _BlendBuffer
      
        InLoopClippedSolidNoTransHorz :
          mov  AL, [EDI]
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          loop InLoopClippedSolidNoTransHorz
          
      NextRowSolidNoTransHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoTransHorz

  EndLoopOutSolidNoTransHorz :

  popad
} // End asm
} // End of _DrawSolidNoTransHorz


// VOID _DrawSolidGrdTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidGrdTransHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdTransHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidGrdTransHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdTransHorzClip

;  DrawSolidGrdTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, _LeftI    ; U
      mov  EAX, EBX        ; U     EAX is the Left I
      add  EBX, _LeftDI   ; V
      mov  _LeftI, EBX    ; V
      
      mov  EBX, _RightI   ; U
      mov  EDX, EBX        ; U     EDX is the Right I
      add  EBX, _RightDI  ; V
      mov  _RightI, EBX   ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdTransHorzNoClip

      mov  EBX, EAX        ; EBX is the Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EBP, EBX
      mov  EAX, Color        
      mov  EDX, _BlendBuffer 
      push ESI
      mov  ESI, _ShadeBuffer
      
        InLoopSolidGrdTransHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  BH, [EBX+ESI]
          mov  BL, [EDI]
          mov  AH, [EDX+EBX]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidGrdTransHorz

      pop  ESI

      NextRowSolidGrdTransHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidGrdTransHorz
      jmp  EndLoopOutSolidGrdTransHorz

  DrawSolidGrdTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdTransHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdTransHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, _LeftI    ; U
      mov  EAX, EBX        ; U   EAX is the Left I
      add  EBX, _LeftDI   ; V
      mov  _LeftI, EBX    ; V
      
      mov  EBX, _RightI   ; U
      mov  EDX, EBX        ; U   EDX is the Right I
      add  EBX, _RightDI  ; V
      mov  _RightI, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidGrdTransHorz

      mov  EBX, EAX        ; EAX is Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, EBX
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, _BlendBuffer
      push ESI
      mov  ESI, _ShadeBuffer
      
        InLoopClippedSolidGrdTransHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  BH, [EBX+ESI]
          mov  BL, [EDI]
          mov  AH, [EDX+EBX]
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidGrdTransHorz
    
      pop  ESI
      NextRowSolidGrdTransHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidGrdTransHorz

  EndLoopOutSolidGrdTransHorz :

  popad
} // End asm
} // End of _DrawSolidGrdTransHorz


// VOID _DrawTextureNoTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureNoTransHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  														
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoTransHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureNoTransHorz :
    cmp  ECX, 0
    jne  DrawTextureNoTransHorzClip

;  DrawTextureNoTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      sar  ECX, 8
      mov  EDX, _LeftV
      sar  EDX, 8
      mov  ESI, _TextureBuffer
      mov  EBX, 0
      mov  EAX, 0
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer

        InLoopTextureNoTransHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EDI]
          mov  AH, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureNoTransHorz

      pop  ESI

      NextRowTextureNoTransHorzNoClip :

      mov  EAX, _LeftU
      mov  EBX, _LeftV
      add  EAX, _LeftDu
      add  EBX, _LeftDv
      mov  _LeftU, EAX
      mov  _LeftV, EBX

      mov  EAX, _RightU
      mov  EBX, _RightV
      add  EAX, _RightDu
      add  EBX, _RightDv
      mov  _RightU, EAX
      mov  _RightV, EBX

      dec  ESI
      jnz  LoopOutTextureNoTransHorz
      jmp  EndLoopOutTextureNoTransHorz

  DrawTextureNoTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoTransHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoTransHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoTransHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoTransHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop
      mov  TempLen, EBX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  ESI, _TextureBuffer
      mov  EBX, 0
      mov  EAX, 0
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer

        InLoopClippedTextureNoTransHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EDI]
          mov  AH, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureNoTransHorz

      pop  ESI

      NextRowTextureNoTransHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoTransHorz

  EndLoopOutTextureNoTransHorz :

  popad
} // End asm
} // End of _DrawTextureNoTransHorz


// VOID _DrawTextureFlatTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureFlatTransHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
    
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatTransHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureFlatTransHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatTransHorzClip

;  DrawTextureFlatTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      mov  EDX, _LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer
      
        InLoopTextureFlatTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [EDI]
          mov  BH, [ESI+EAX]
          and  EBX, 0FFFFh
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureFlatTransHorz
    
      pop  ESI

      NextRowTextureFlatTransHorzNoClip : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutTextureFlatTransHorz
      jmp  EndLoopOutTextureFlatTransHorz

  DrawTextureFlatTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatTransHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatTransHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatTransHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer
      
        InLoopClippedTextureFlatTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [EDI]
          mov  BH, [ESI+EAX]
          and  EBX, 0FFFFh
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureFlatTransHorz
    
      pop  ESI

      NextRowTextureFlatTransHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatTransHorz

  EndLoopOutTextureFlatTransHorz :

  popad
} // End asm
} // End of _DrawTextureFlatTransHorz


// VOID _DrawTextureGrdTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureGrdTransHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )  
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdTransHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureGrdTransHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdTransHorzClip

;  DrawTextureGrdTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      mov  EDX, _LeftV
      mov  ESI, _LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer
     
        InLoopTextureGrdTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  BL, [EDI]
          mov  BH, [EAX]
          and  EBX, 0FFFFh
          add  ESI, InDeltaDI
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureGrdTransHorz
   
      pop  ESI

      NextRowTextureGrdTransHorzNoClip :
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        dec  ESI
      jnz  LoopOutTextureGrdTransHorz
      jmp  EndLoopOutTextureGrdTransHorz

  DrawTextureGrdTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdTransHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdTransHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdTransHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdTransHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, _LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX
      mov  InLoopCount, BP
      mov  EBP, _BlendBuffer

        InLoopClippedTextureGrdTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  BL, [EDI]
          mov  BH, [EAX]
          and  EBX, 0FFFFh
          add  ESI, InDeltaDI
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureGrdTransHorz
    
      pop  ESI

      NextRowTextureGrdTransHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX
   
        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdTransHorz

  EndLoopOutTextureGrdTransHorz :

  popad
} // End asm
} // End of _DrawTextureGrdTransHorz


//***************************************************
//
//  Hazing Routines
//
//***************************************************

// VOID _DrawSolidNoHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidNoHazeHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
    
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoHazeHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDh
    imul  EBX
    add  _LeftH, EAX

    mov  EAX, _RightDh
    imul  EBX
    add  _RightH, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidNoHazeHorz :
    cmp  ECX, 0
    jne  DrawSolidNoHazeHorzClip

;  DrawSolidNoHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, _LeftH    ; U
      mov  EAX, EBX        ; U   EAX is the Left Haze
      add  EBX, _LeftDh   ; V
      mov  _LeftH, EBX    ; V
      
      mov  EBX, _RightH   ; U
      mov  EDX, EBX        ; U   EDX is the Right Haze
      add  EBX, _RightDh  ; V
      mov  _RightH, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidNoHazeHorzNoClip
      
      mov  EBX, EAX        ; EBX is the Left Haze
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EBP, _LeftH
      mov  EAX, Color        
      mov  EDX, InDeltaDh
      push ESI
      mov  ESI, _HazeBuffer
      
        InLoopSolidNoHazeHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, EDX
          mov  AH, [EBX+ESI]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidNoHazeHorz

      pop  ESI

      NextRowSolidNoHazeHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoHazeHorz
      jmp  EndLoopOutSolidNoHazeHorz

  DrawSolidNoHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidNoHazeHorz :
          cmp  ECX, VMaxX
          jle  StartSolidNoHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoHazeHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, _LeftH    ; U
      mov  EAX, EBX        ; U   EAX is the Left Haze
      add  EBX, _LeftDh   ; V
      mov  _LeftH, EBX    ; V
      
      mov  EBX, _RightH   ; U
      mov  EDX, EBX        ; U   EDX is the Right Haze
      add  EBX, _RightDh  ; V
      mov  _RightH, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidNoHazeHorz

      mov  EBX, EAX        ; EAX is Left Haze
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, _LeftH
      mov  EAX, InDeltaDh
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, InDeltaDh 
      push ESI
      mov  ESI, _HazeBuffer
      
        InLoopClippedSolidNoHazeHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          mov  AH, [EBX+ESI]
          add  EBP, EDX
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidNoHazeHorz
    
      pop  ESI
      NextRowSolidNoHazeHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoHazeHorz

  EndLoopOutSolidNoHazeHorz :

  popad
} // End asm
} // End of _DrawSolidNoHazeHorz


// VOID _DrawSolidGrdHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawSolidGrdHazeHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )  
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdHazeHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _LeftDh
    imul  EBX
    add  _LeftH, EAX

    mov  EAX, _RightDh
    imul  EBX
    add  _RightH, EAX

    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedSolidGrdHazeHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdHazeHorzClip

;  DrawSolidGrdHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdHazeHorzNoClip

      mov  EAX, _LeftI    ; U     EAX is the Left I
      mov  EDX, _RightI   ; U     EDX is the Right I      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EBP, _LeftI
      sar  EBP, 8
      mov  EAX, Color        
      mov  EDX, _HazeBuffer
      push ESI
      mov  ESI, _ShadeBuffer
      mov  InLoopCount, CX
      mov  ECX, _LeftH
      sar  ECX, 8
      
        InLoopSolidGrdHazeHorz :
          mov  EBX, EBP
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  AH, [EBX+ESI]
          mov  EBX, ECX
          mov  BL, AH
          add  ECX, InDeltaDh
          mov  AH, [EBX+EDX]
          mov  [EDI], AH
          inc  EDI
          dec  InLoopCount
          jnz  InLoopSolidGrdHazeHorz

      pop  ESI

      NextRowSolidGrdHazeHorzNoClip :
        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
        jnz  LoopOutSolidGrdHazeHorz
      jmp  EndLoopOutSolidGrdHazeHorz

  DrawSolidGrdHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdHazeHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdHazeHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidGrdHazeHorz

      add  EDI, EAX
      
      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftI    ; U     EAX is the Left I
      mov  EDX, _RightI   ; U     EDX is the Right I      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze            
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      mov  InLoopCount, CX
      
      ; Add Delta for Skipped pixel
      mov  EBP, _LeftI
      sar  EBP, 8
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  ECX, _LeftH
      sar  ECX, 8
      mov  EAX, InDeltaDh
      imul TempLen 
      add  ECX, EAX
      
      mov  EAX, Color        
      mov  EDX, _HazeBuffer
      push ESI
      mov  ESI, _ShadeBuffer
      
        InLoopClippedSolidGrdHazeHorz :
          mov  EBX, EBP
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  AH, [EBX+ESI]
          mov  EBX, ECX
          mov  BL, AH
          add  ECX, InDeltaDh
          mov  AH, [EBX+EDX]
          mov  [EDI], AH
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedSolidGrdHazeHorz
    
      pop  ESI
      
      NextRowSolidGrdHazeHorz : 
        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutClippedSolidGrdHazeHorz

  EndLoopOutSolidGrdHazeHorz :

  popad
} // End asm
} // End of _DrawSolidGrdHazeHorz

// VOID _DrawTextureNoHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureNoHazeHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )  
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoHazeHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _LeftDh
    imul  EBX
    add  _LeftH, EAX

    mov  EAX, _RightDh
    imul  EBX
    add  _RightH, EAX
    
    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureNoHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureNoHazeHorzClip

;  DrawTextureNoHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, _LeftH
      sar  EAX, 8
      mov  ECX, _LeftU
      sar  ECX, 8
      mov  EDX, _LeftV
      sar  EDX, 8
      mov  ESI, _TextureBuffer
      mov  InLoopCount, BP
      mov  EBP, _HazeBuffer
      mov  EBX, 0

        InLoopTextureNoHazeHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  BL, [EBX+ESI]
          mov  BH, AH
          add  EAX, InDeltaDh          
          mov  BL, [EBX+EBP]
          add  EDX, InDeltaDv
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureNoHazeHorz

      pop  ESI

      NextRowTextureNoHazeHorzNoClip :

      mov  EAX, _LeftU
      mov  EBX, _LeftV
      add  EAX, _LeftDu
      add  EBX, _LeftDv
      mov  _LeftU, EAX
      mov  _LeftV, EBX

      mov  EAX, _RightU
      mov  EBX, _RightV
      add  EAX, _RightDu
      add  EBX, _RightDv
      mov  _RightU, EAX
      mov  _RightV, EBX

      mov  EAX, _LeftH
      mov  EBX, _RightH
      add  EAX, _LeftDh
      add  EBX, _RightDh
      mov  _LeftH, EAX
      mov  _RightH, EBX

      dec  ESI
      jnz  LoopOutTextureNoHazeHorz
      jmp  EndLoopOutTextureNoHazeHorz

  DrawTextureNoHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoHazeHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoHazeHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoHazeHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoHazeHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, TempLen
      mov  TempLen, EBX

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  InLoopCount, CX

      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBX, _LeftH
      sar  EBX, 8
      add  EBX, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, EBX
      mov  EBP, _HazeBuffer      
      mov  ESI, _TextureBuffer
      mov  EBX, 0

        InLoopClippedTextureNoHazeHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  BL, [EBX+ESI]
          mov  BH, AH
          add  EAX, InDeltaDh          
          mov  BL, [EBX+EBP]
          add  EDX, InDeltaDv
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureNoHazeHorz

      pop  ESI

      NextRowTextureNoHazeHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoHazeHorz

  EndLoopOutTextureNoHazeHorz :

  popad
} // End asm
} // End of _DrawTextureNoHazeHorz


// VOID _DrawTextureFlatHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureFlatHazeHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )  
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatHazeHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _LeftDh
    imul  EBX
    add  _LeftH, EAX

    mov  EAX, _RightDh
    imul  EBX
    add  _RightH, EAX
    
    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureFlatHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatHazeHorzClip

 ; DrawTextureFlatHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      mov  EDX, _LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, _LeftH
      sar  EBP, 8
      
        InLoopTextureFlatHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  EBX, EBP
          mov  BL, [ESI+EAX]
          add  EBX, _HazeBuffer
          add  EBP, InDeltaDh
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureFlatHazeHorz
    
      pop  ESI

      NextRowTextureFlatHazeHorzNoClip : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutTextureFlatHazeHorz
      jmp  EndLoopOutTextureFlatHazeHorz

  DrawTextureFlatHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatHazeHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatHazeHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatHazeHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftH    ; U     EAX is the Left Haze
      mov  EDX, _RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  InLoopCount, BP
      
      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBP, _LeftH
      sar  EBP, 8
      add  EBP, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, _LeftI
      sar  EAX, 8
      mov  ESI, _ShadeBuffer
      
        InLoopClippedTextureFlatHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  EBX, EBP
          mov  BL, [ESI+EAX]
          add  EBX, _HazeBuffer
          add  EBP, InDeltaDh
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureFlatHazeHorz
    
      pop  ESI

      NextRowTextureFlatHazeHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatHazeHorz

  EndLoopOutTextureFlatHazeHorz :

  popad
} // End asm
} // End of _DrawTextureFlatHazeHorz


// VOID _DrawTextureGrdHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
//
// EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

VOID _DrawTextureGrdHazeHorz ( LONG nColor, LONG nLoopCount, 
              					    LONG SkipRow, LONG SideClipped )
{
_asm {
  pushad

  mov EAX, nColor
  mov EDX, nLoopCount
  mov EBX, SkipRow
  mov ECX, SideClipped
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdHazeHorz 

    mov  EAX, _LeftDx
    imul  EBX
    add  _LeftX, EAX

    mov  EAX, _RightDx
    imul  EBX
    add  _RightX, EAX

    mov  EAX, _LeftDu
    imul  EBX
    add  _LeftU, EAX

    mov  EAX, _RightDu
    imul  EBX
    add  _RightU, EAX

    mov  EAX, _LeftDv
    imul  EBX
    add  _LeftV, EAX

    mov  EAX, _RightDv
    imul  EBX
    add  _RightV, EAX

    mov  EAX, _LeftDI
    imul  EBX
    add  _LeftI, EAX

    mov  EAX, _RightDI
    imul  EBX
    add  _RightI, EAX

    mov  EAX, _LeftDh
    imul  EBX
    add  _LeftH, EAX

    mov  EAX, _RightDh
    imul  EBX
    add  _RightH, EAX
    
    mov  EAX, _AddDest
    imul  EBX
    add  _DestBuffer, EAX

  CheckClippedTextureGrdHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdHazeHorzClip

;  DrawTextureGrdHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      sub  ECX, EAX           ; U

      mov  _DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftH    ; U
      mov  EDX, _RightH   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, _LeftU
      mov  EDX, _LeftV
      mov  ESI, _LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
      mov  InLoopCount, BP
      mov  EBP, _LeftH
      sar  EBP, 8
     
        InLoopTextureGrdHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  EBX, EBP
          mov  BL, [EAX]
          add  EBX, _HazeBuffer
          add  EBP, InDeltaDh
          add  ESI, InDeltaDI
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureGrdHazeHorz
   
      pop  ESI

      NextRowTextureGrdHazeHorzNoClip :
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX

        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutTextureGrdHazeHorz
      jmp  EndLoopOutTextureGrdHazeHorz

  DrawTextureGrdHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdHazeHorz :
      mov  EBX, _LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, _LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  _LeftX, EBX    ; V

      mov  EDX, _RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, _RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  _RightX, EDX   ; V

      mov  EBX, _DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, _AddDest     ; V
      mov  _DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdHazeHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdHazeHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdHazeHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, _DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, _LeftI    ; U
      mov  EDX, _RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, _LeftH    ; U
      mov  EDX, _RightH   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, _LeftU    
      mov  EDX, _RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, _LeftV    
      mov  EDX, _RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  InLoopCount, BP
      
      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBP, _LeftH
      sar  EBP, 8
      add  EBP, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, _LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, _LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, _LeftV
      sar  EDX, 8
      add  EDX, EAX
       
        InLoopClippedTextureGrdHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, _TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, _ShadeBuffer
          mov  EBX, EBP
          mov  BL, [EAX]
          add  EBX, _HazeBuffer
          add  EBP, InDeltaDh
          add  ESI, InDeltaDI
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureGrdHazeHorz
    
      pop  ESI

      NextRowTextureGrdHazeHorz : 
        mov  EAX, _LeftU
        mov  EBX, _LeftV
        add  EAX, _LeftDu
        add  EBX, _LeftDv
        mov  _LeftU, EAX
        mov  _LeftV, EBX
   
        mov  EAX, _RightU
        mov  EBX, _RightV
        add  EAX, _RightDu
        add  EBX, _RightDv
        mov  _RightU, EAX
        mov  _RightV, EBX

        mov  EAX, _LeftI
        mov  EBX, _RightI
        add  EAX, _LeftDI
        add  EBX, _RightDI
        mov  _LeftI, EAX
        mov  _RightI, EBX

        mov  EAX, _LeftH
        mov  EBX, _RightH
        add  EAX, _LeftDh
        add  EBX, _RightDh
        mov  _LeftH, EAX
        mov  _RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdHazeHorz

  EndLoopOutTextureGrdHazeHorz :

  popad
} // End asm
} // End of _DrawTextureGrdHazeHorz

