#include    "lsp.h"
#include    "video.h"
#include    <stdlib.h>
#include    <string.h>
#include    <stdio.h>
#include    <conio.h>

static  LSP    *node;
static  LSP    *temp;

LSP    *height[SCREEN_YSIZE];

void    InitLsp()
{
    node=new LSP [MAX];
    temp=node;
    for(int i=0; i<SCREEN_YSIZE; i++) {
        LSP     *empty=AllocNode();
        empty->length=SCREEN_XSIZE;
        empty->address=(char*)0xa0000;
        empty->next=NULL;
        height[i]=empty;
    }
}

void    ExitLsp()
{
    delete node;
}

LSP    *AllocNode()
{
    return temp++;
}

void    ResetLsp()
{
    temp=node;

    for(int i=0; i<SCREEN_YSIZE; i++) {
        LSP     *empty=AllocNode();
        empty->length=SCREEN_XSIZE;
        empty->address=(char*)0xa0000;
        height[i]=empty;
    }
}

// aaaaA e a ១  񷡜ae  ai  
// 巁 Aaa bA Eae a.
void    AddLsp(int x, int y, int short length, char *address)
{
    LSP    *search = height[y];
    LSP    *insert=AllocNode();
    int     loop=0;

    // E iϷ ១ & ዡA ( a 0  a )
    // ( x==0 )  w E ae aa 0A qa A Ea.
    // i iϷ qA ១
    if (x<=0) {
        address -= x ;
        length += x ;
        x=0;
        height[y]=insert;
    }

    // e iϷ ១
    if (x+length >= SCREEN_XSIZE) {
        length = SCREEN_XSIZE - x ;
    }

    int short x2=x+length;

    // E ዡ១
    // iaaaa bw ᷁ ai i aa searchAA
    //  ea.
    while(1) {
        loop += search->length ;
        if ( loop >= x ) break ;
        search = search->next ;
    }

    // ai ai  ea ( e  )
    insert->length = length;
    insert->address = address;

    // ai  Ei  a ( E  i )
    // aa q search->length-=loop-x i Ё១e A ab a
    // ͡ eA Aa i a. (w aa e w)
    int short reserve=search->length-(loop-x);

    // ab aw ab i ១ 
    if(x2>=SCREEN_XSIZE) {
        search->length = reserve;
        search->next = insert;
        return;
    }

    // | ai Ё a
    //  eiЁe i xi  aqai inserta a A
    // Aa iq
    LSP     *save = search;

    //  a q
    while(loop<=x2) {
        search = search->next ;
        loop += search->length ;
    }

    //  i 
    LSP     *insert2=AllocNode();
    insert2->length = loop - x2;
    insert2->address = search->address + search->length - insert2->length;
    insert2->next = search -> next;

    //  eiЁ ៩w aaaa bw '' a  a q
    // A w aa abA ei i eea.
    save->length = reserve;
    save->next = insert;
    insert->next = insert2;
}

void    PutImage(int x, int y, char *address, int xs, int ys)
{
    int     loop, y2;

    if (x+xs<0 || x>=SCREEN_XSIZE)
        return;
    if (y<0) {
        address += -y*xs;
        ys+=y;
        y = 0;
    }
    if (y+ys>=SCREEN_YSIZE)
        y2=SCREEN_YSIZE;
    else
        y2 = y+ys;

    for (loop=y; loop<y2; loop++, address+=xs)
        AddLsp(x, loop, xs, address);
}

void    PutSprite(int x, int y, char *address)
{
    int     length, loop;
    int     putbyte;
    int     tmp2;
    char    index;

    if (x>=SCREEN_XSIZE)
        return;
    if (y>=SCREEN_YSIZE)
        return;
    length=*(int short*)address + y;
    address+=2;
    if (length>SCREEN_YSIZE)
        length = SCREEN_YSIZE;
    for (loop=y; loop<length; loop++) {
        index = *address++;
        if (loop<0) {
            while (index--) {
                putbyte =*(int short*)(address+2);
                address+=4+putbyte;
            }
        } else {
            tmp2 = x;
            putbyte = 0;
            while (index--) {
                tmp2+=*(int short*)address + putbyte;
                putbyte =*(int short*)(address+2);
                address+=4;
                if (tmp2+putbyte>=0 && tmp2<SCREEN_XSIZE && putbyte > 0)
                    AddLsp(tmp2, loop, putbyte, address);
                address+=putbyte;
            }
        }
    }
}

void    DebugLsp(int y)
{
    LSP     *source = height[y];

    for (int x=0; x<SCREEN_XSIZE; source=source->next) {
        printf("%3d ",source->length);
        x+=source->length;
    }
    printf("\n");
}

/*
void    main()
{
    InitLsp();
    DebugLsp(0);
    AddLsp(0,0,640,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,50,(char*)0xa0000);
    AddLsp(10,0,10,(char*)0xa0000);
    AddLsp(0,0,10,(char*)0xa0000);
    AddLsp(400,0,20,(char*)0xa0000);
    DebugLsp(0);
    //ResetLsp();
    //DebugLsp(0);
    ExitLsp();
}
*/
