#include <stdio.h>
#include <dos.h>
typedef unsigned char BYTE;
typedef unsigned int  WORD;

union REGS reg;

const BYTE table[3][32] = {
       {  0, 0, 1, 2, 3, 4, 5, 6,
          7, 8, 9,10,11,12,13,14,
         15,16,17,18,19, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0 },

       {  0, 0, 0, 1, 2, 3, 4, 5,
          0, 0, 6, 7, 8, 9,10,11,
          0, 0,12,13,14,15,16,17,
          0, 0,18,19,20,21, 0, 0 },

       {  0, 0, 1, 2, 3, 4, 5, 6,
          7, 8, 9,10,11,12,13,14,
         15,16, 0,17,18,19,20,21,
         22,23,24,25,26,27, 0, 0 }};

const BYTE fsttable[2][20]=
    {   { 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
          1, 1, 1, 1, 1, 1, 0, 1, 1, 1 },

        { 0, 2, 3, 3, 3, 3, 3, 3, 3, 3,
          3, 3, 3, 3, 3, 3, 2, 3, 3, 3 }  };

const BYTE midtable[3][22]=
    {   { 0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0,
          2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1 },

        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3,
          3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0 },

        { 0, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7,
          7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5 }   };

BYTE HF1[8][20][16];
BYTE HF2[4][22][16];
BYTE HF3[4][28][16];

BYTE EF[256][16];

BYTE han_bitmap[16];
BYTE eng_bitmap[16];


void read_font()
{
    FILE *fp;

    fp = fopen("HAN8x16.FNT", "rb");
    fread(HF1, 2560, 1, fp);
    fread(HF2, 1408, 1, fp);
    fread(HF3, 1792, 1, fp);
    fclose(fp);

    fp = fopen("ENGLISH.FNT", "rb");
    fread(EF, 4096, 1, fp);
    fclose(fp);
}

void or_img( BYTE *src, BYTE *dest )
{   int i;
	for ( i = 0; i < 16; i++ ) dest[i] |= src[i];
}

void outline_img( BYTE *dest )
{   int i;
    char temp1[16], temp2[16];

    memcpy( temp1, dest, 16 );
    memcpy( temp2, dest, 16 );

       for ( i = 0; i < 16; i++ )
       {
           temp1[i] |= temp2[i] >> 1;
           temp1[i] |= temp2[i] << 1;
       }
       for ( i = 0; i < 15; i++ ) temp1[i+1] |= temp2[i];
       for ( i = 1; i < 16; i++ ) temp1[i-1] |= temp2[i];
       for ( i = 0; i < 15; i++ ) temp1[i  ] ^= temp2[i];
    memcpy( dest, temp1, 16 );
}

void put_font( int x, int y, BYTE *fnt, BYTE color, int f )
{
    int i, k, m = 0, n = 0;
    unsigned char dat = 0x80;

    for ( i = y; i < y + 16; i++ )
    {	for ( k = x; k < x + 8; k++ )
        {
            if ((fnt[m] & (dat >> n)) == (dat >> n)) pset( k,i,color ); 
            if ( (++n) == 8 ) { n = 0; m += 1; }
        }
        if ( f == 0 ) color += 1;
    }
}

void houttextxy(int x, int y, char *s, BYTE color )
{
    BYTE data1, data2;
    BYTE first, mid, last;
    int i, b1, b2, b3;

    for ( i = 0; i < strlen(s); i++ )
    {
        data1 = *( s + i );

        memset( han_bitmap, 0, 16 );
        memset( eng_bitmap, 0, 16 );

        if ( data1 > 127 )
        {
            data2 = *( s + (++i) );

            first = ( data1 & 124 ) >> 2;
            mid   = ( data1 & 3   ) * 8 + (data2 >> 5);

            last  = ( data2 & 31  );

            first = table[0][first];
            mid   = table[1][mid];
            last  = table[2][last];

            b3    = midtable[0][mid];

            if (!last)
            {
                b2 = fsttable[0][first];
                b1 = midtable[1][mid];
            }
            else
            {
                b2 = fsttable[1][first];
                b1 = midtable[2][mid];
            }
            if (first) or_img(HF1[b1][first], han_bitmap);
            if (mid  ) or_img(HF2[b2][mid  ], han_bitmap);
            if (last ) or_img(HF3[b3][last ], han_bitmap);

            put_font( x, y, han_bitmap, color, 0 );
            outline_img( han_bitmap );
            put_font( x, y, han_bitmap, 0, 1 );
            x += 8;
        }
        else
        {
            memmove( &eng_bitmap, &EF[ data1 ], 16 );
            put_font( x, y, eng_bitmap, color, 0 );
            outline_img( eng_bitmap );
            put_font( x, y, eng_bitmap, 0, 1 );
            x += 8;
        }
    }
}
void printnumber(int x, int y, int num, BYTE color)
{   char str[10];
	itoa(num,str,10);
	houttextxy(x,y,str,color);
}
