;************************
;  Background Cloud Maker
;          for XEXEX Fake
;   by Cyber Punker/NENIO
;************************



;***************************
MakeCloud       Proc    Near


;*********************************
; Background Cloud's Vellocity Cal

	mov     bl, DetailKey
	mov     DetailPass, bl

	mov     cl, CloudXCoordy        ; X Coordinate = CL
	mov     bx, CloudYCoordy        ; Y Coordinate = BX

;-------------------------
;Adding Time Based Control
	xor     ax, ax
	mov     al, SpeedCntPass

VelCalQS_MC:
	add     cl, al
	cmp     cl, CloudPicWidth
	jb      YVelloCal_MC
	sub     cl, CloudPicWidth

YVelloCal_MC:
	shl     ax, 1
	add     bx, ax
	cmp     bx, CloudPicDepth
	jb      CalDone_MC
	sub     bx, CloudPicDepth

CalDone_MC:
	mov     CloudXCoordy, cl
	mov     CloudYCoordy, bx


;****************************************
; X Start Position Cal Routine

	mov     si, offset XLength      ; si = XLength's offset
	mov     di, offset StartPxl     ; di = StartPxl's offset
	mov     XCalOffset, offset XStartCal
	mov     cx, 96

; X Coordinate Cal Loop
MC4:
	mov     al, [si]                ; al = XLength
	mov     bl, 00111111b
	and     bl, al                  ; bl = Mod
	shr     al, 6                   ; al = Quotient
	mov     bh, CloudXCoordy        ; bh = CloudXCoordy
	mul     bh                      ; ax = Quo * X
	cmp     bl, 0
	je      MC1

; remainder's cal
	mov     dx, ax                  ; dx = Quo * X
	mov     al, bl                  ; al = Mod
	mul     bh
	shr     ax, 6
	add     al, dl                  ; al = Remainder Added

MC1:

; link with StartPxl
	xor     bh, bh
	mov     bl, [di]                ; bl = StartPxl
	add     ax, bx                  ; ax = StartPxl + X Coordy
	mov     dl, [si]                ; dl = XLength
	cmp     ax, dx
	jb      MC2
	sub     ax, dx
MC2:
	mov     bx, XCalOffset
	mov     [bx], al
	inc     bx
	mov     XCalOffset, bx
	inc     si
	inc     di
	loop    MC4

; X Start Position Cal Routine End
;----------------------------------------


;****************************************
; Cloud X Line Draw Prepare

; Address Initial
MC3:
					; [DS:BX] = Cloud Pic Address
	mov     di, offset VScreen      ; [ES:DI] = VScreen's Address
	mov     VScreenOffset, di       ; VScreenOffset = offset VScreen
	xor     edx, edx
	mov     si, offset PixelPos    ; SI = offset PixelPos
	mov     XLengthOffset, offset XLength
					; XLengOffset = offset XLength
	mov     XCalOffset, offset XStartCal
					; XCalOffset = offset XStartCal
	mov     bx, offset ClouDept
	mov     DeptOffset, bx          ; DeptOffset = offset ClouDept

	mov     cx, 96
	cmp     DetailPass, 0
	je      MC12
	shr     cx, 1


;****************************************
; Fill Upper Cloud
;****************************************

;****************************************
; Assosiation ClouDept(BX) with Y Coordy
MC12:
	push    cx
	mov     ax, [bx]                ; AX = ClouDept
	mov     dx, CloudYCoordy        ; DX = CloudYCoordy
	add     ax, dx
	cmp     ax, CloudPicDepth
	jb      MC7
	sub     ax, CloudPicDepth

; Y Cal Done
MC7:
	mov     dx, CloudPicWidth
	mul     dx
	mov     dx, offset CloudAddress
	add     dx, ax

; Make Each Line
MC5:
; Line Process Prepare
	mov     bx, XCalOffset
	mov     ah, [bx]                ; AH = XStartCal
	mov     bx, XLengthOffset
	mov     al, [bx]                ; AL = XLength
	sub     al, ah                  ; AL = AL - AH
	mov     bl, 00000011b
	and     bl, al
	mov     ModCounter, bl

	mov     bx, dx
	xor     dh, dh
	mov     dl, ah

	shr     al, 2
	cmp     al, 0
	je      MC_ModPart
	mov     cl, al                  ; CL = Line's Half Counter

;***************************************; DS:SI = Address PixelPos
; Line's Half Process                   ; ES:DI = Address VScreen
					; GS:BX = Address Cloud Pic
MC8:
	mov     eax, [esi][edx]
	add     dl, 4
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	shr     eax, 16
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	loop    MC8

MC_ModPart:
	mov     cl, ModCounter
	cmp     cl, 0
	je      MC_ModQ1

MC_ModL1:
	mov     al, [esi][edx]
	inc     dl
	xlatb   [bx]
	mov	es:[di], al
	inc	di
	loop    MC_ModL1

;****************************************
; Line's The Other Process
MC_ModQ1:
	mov     dx, bx
	mov     bx, XCalOffset
	mov     cl, [bx]                ; CL = Line's The Other Counter

	mov     bl, 00000011b
	and     bl, cl
	mov     ModCounter, bl

	mov     bx, dx
	xor     dx, dx

	shr     cl, 2
	cmp     cl, 0
	je      MC_ModPart2

MC9:
	mov     eax, [esi][edx]
	add     dl, 4
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	shr     eax, 16
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	loop    MC9


MC_ModPart2:
	mov     cl, ModCounter
	cmp     cl, 0
	je      MC15

MC_ModL2:
	mov     al, [esi][edx]
	inc     dl
	xlatb   [bx]
	mov	es:[di], al
	inc	di
	loop    MC_ModL2

; Line's 1 Block Complete
;----------------------------------------

;****************************************
; Fill 320 Dot
MC15:
	push    si
	mov     bx, XLengthOffset
	mov     cl, [bx]
	mov     bx, cx                  ; BX = XLength's Doubler
	mov     dx, VScreenOffset       ; DX = VScreenOffset

MC11:

; Byte Process
	cmp     bx, 160
	jae     MC10
	test    bx, 11b
	jz      MC_DW1
	test    bx, 1
	jz      MC_W1

	mov     si, dx
	rep     movsb [di], es:[si]

	cmp     bx, (160 / 2)
	jae     MC_W2P
	jmp     MC_W1P

; Word Process
MC_W1:
	shr     bx, 1
MC_W1P:
	mov     si, dx
	mov     cx, bx
	rep     movsw [di], es:[si]
	cmp     bx, (160 / 4)
	jae     MC_DW2P
	jmp     MC_DW1P

; DWord Process
MC_DW1:
	shr     bl, 2
MC_DW1P:
	mov     si, dx
	mov     cx, bx
	rep     movsd [di], es:[si]
	shl     bx, 1
	cmp     bx, (160 / 16)
	jae     MC_DW2P
	jmp     MC_DW1P


; test over 160
MC10:
	test    bx, 11b
	jz      MC_DW2
	test    bx, 1
	jz      MC_W2


; byte process

	mov     cx, 320
	sub     cx, bx
	mov     si, dx
	rep     movsb [di], es:[si]
	jmp     MC13

MC_W2:
	shr     bx, 1
MC_W2P:
	mov     cx, (320 / 2)
	sub     cx, bx
	mov     si, dx
	rep     movsw [di], es:[si]
	jmp     MC13

MC_DW2:
	shr     bx, 2
MC_DW2P:
	mov     cx, (320 / 4)
	sub     cx, bx
	mov     si, dx
	rep     movsd [di], es:[si]
	jmp     MC13

; One Line Draw Complete
;---------------------------------------

;***************************************
; Increase Counters

MC13:
	cmp     DetailPass, 0
	je      DetailHighUp_MC
	mov     si, dx
	mov     cx, (320 / 4)
	rep     movsd [di], es:[si]

	pop     si
	pop     cx
	dec     cx
	jz      MC14

	mov     bx, XLengthOffset
	xor     dh, dh
	mov     dl, [bx]
	add     si, dx                  ; Add SI ( = PixelPos's offset )
	inc     bx
	mov     dl, [bx]
	add     si, dx                  ; Add SI ( = PixelPos's offset )
	inc     bx
	mov     XLengthOffset, bx       ; Increased XLengthOffset

	add     XCalOffset, word ptr 2  ; Increased XCalOffset
	add     VScreenOffset, word ptr 640
					; Increased VScreenOffset
	mov     bx, DeptOffset
	add     bx, 4
	mov     DeptOffset, bx          ; Increased DeptOffset

	jmp     MC12

DetailHighUp_MC:
	pop     si
	pop     cx
	dec     cx
	jz      UpperEnd_MC

	mov     bx, XLengthOffset
	xor     dh, dh
	mov     dl, [bx]
	add     si, dx                  ; Add SI ( = PixelPos's offset )
	inc     bx
	mov     XLengthOffset, bx       ; Increased XLengthOffset

	inc     word ptr XCalOffset     ; Increased XCalOffset
	add     VScreenOffset, word ptr 320
					; Increased VScreenOffset
	mov     bx, DeptOffset
	add     bx, 2
	mov     DeptOffset, bx          ; Increased DeptOffset

	jmp     MC12


; Upper Cloud End
;----------------------------------------

MC14:

	mov     bx, XLengthOffset
	xor     dh, dh
	mov     dl, [bx]
	add     si, dx                  ; Add SI ( = PixelPos's offset )
	inc     bx
	mov     XLengthOffset, bx       ; Increased XLengthOffset

	inc     word ptr XCalOffset     ; Increased XCalOffset
	add     VScreenOffset, word ptr 320
					; Increased VScreenOffset
	mov     bx, DeptOffset
	add     bx,2
	mov     DeptOffset, bx          ; Increased DeptOffset


UpperEnd_MC:
;****************************************
; Fill Lower Cloud
;****************************************

; Address Initial

	mov     di, ((offset VScreen) + ((96 + 8) * 320))
					; [ES:DI] = Lower VScreen's Address
	mov     VScreenOffset, di       ; VScreenOffset = offset VScreen

	mov     dx, CloudPicDepth
	sub     dx, CloudYCoordy
	cmp     dx, CloudPicDepth
	jb      MC200
	sub     dx, CloudPicDepth
MC200:
	mov     InvertYCoordy, dx
	mov     bx, DeptOffset
	mov     cx, 96
	cmp     DetailPass, 0
	je      MC112
	shr     cx, 1


;****************************************
; Assosiation ClouDept(BX) with Y Coordy
MC112:
	push    cx
	mov     ax, [bx]                ; AX = ClouDept
	mov     dx, InvertYCoordy       ; DX = CloudYCoordy
	add     ax, dx
	cmp     ax, CloudPicDepth
	jb      MC107
	sub     ax, CloudPicDepth

; Y Cal Done
MC107:
	mov     dx, CloudPicWidth
	mul     dx
	mov     dx, offset CloudAddress
	add     dx, ax

; Make Each Line
MC105:
; Line Process Prepare
	mov     bx, XCalOffset
	mov     ah, [bx]                ; AH = XStartCal
	mov     bx, XLengthOffset
	mov     al, [bx]                ; AL = XLength
	sub     al, ah                  ; AL = AL - AH

	mov     bl, 00000011b
	and     bl, al
	mov     ModCounter, bl

	mov     bx, dx
	xor     dh, dh
	mov     dl, ah

	shr     al, 2
	cmp     al, 0
	je      MC_ModPartD
	mov     cl, al                  ; CL = Line's Half Counter

;***************************************; DS:SI = Address PixelPos
; Line's Half Process                   ; ES:DI = Address VScreen
					; GS:BX = Address Cloud Pic
MC108:
	mov     eax, [esi][edx]
	add     dl, 4
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	shr     eax, 16
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	loop    MC108

MC_ModPartD:
	mov     cl, ModCounter
	cmp     cl, 0
	je      MC_ModQ1D

MC_ModL1D:
	mov     al, [esi][edx]
	inc     dl
	xlatb   [bx]
	mov	es:[di], al
	inc	di
	loop    MC_ModL1D



;****************************************
; Line's The Other Process
MC_ModQ1D:
	mov     dx, bx
	mov     bx, XCalOffset
	mov     cl, [bx]                ; CL = Line's The Other Counter

	mov     bl, 00000011b
	and     bl, cl
	mov     ModCounter, bl

	mov     bx, dx
	xor     dx, dx

	shr     cl, 2
	cmp     cl, 0
	je      MC_ModPart2D

MC109:
	mov     eax, [esi][edx]
	add     dl, 4
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	shr     eax, 16
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	mov	al, ah
	xlatb   [bx]
	mov	es:[di], al
	inc	di

	loop    MC109

MC_ModPart2D:
	mov     cl, ModCounter
	cmp     cl, 0
	je      MC115

MC_ModL2D:
	mov     al, [esi][edx]
	inc     dl
	xlatb   [bx]
	mov	es:[di], al
	inc	di
	loop    MC_ModL2D



; Line's 1 Block Complete
;----------------------------------------

;****************************************
; Fill 320 Dot
MC115:
	push    si
	mov     bx, XLengthOffset
	mov     cl, [bx]
	mov     bx, cx                  ; BX = XLength's Doubler
	mov     dx, VScreenOffset       ; DX = VScreenOffset

MC111:

; Byte Process
	cmp     bx, 160
	jae     MC110
	test    bx, 11b
	jz      MC_DW11
	test    bx, 1
	jz      MC_W11

	mov     si, dx
	rep     movsb [di], es:[si]

	cmp     bx, (160 / 2)
	jae     MC_W12P
	jmp     MC_W11P

; Word Process
MC_W11:
	shr     bx, 1
MC_W11P:
	mov     si, dx
	mov     cx, bx
	rep     movsw [di], es:[si]
	cmp     bx, (160 / 4)
	jae     MC_DW12P
	jmp     MC_DW11P

; DWord Process
MC_DW11:
	shr     bl, 2
MC_DW11P:
	mov     si, dx
	mov     cx, bx
	rep     movsd [di], es:[si]
	shl     bx, 1
	cmp     bx, (160 / 16)
	jae     MC_DW12P
	jmp     MC_DW11P


; test over 160
MC110:
	test    bx, 11b
	jz      MC_DW12
	test    bx, 1
	jz      MC_W12


; byte process

	mov     cx, 320
	sub     cx, bx
	mov     si, dx
	rep     movsb [di], es:[si]
	jmp     MC113

MC_W12:
	shr     bx, 1
MC_W12P:
	mov     cx, (320 / 2)
	sub     cx, bx
	mov     si, dx
	rep     movsw [di], es:[si]
	jmp     MC113

MC_DW12:
	shr     bx, 2
MC_DW12P:
	mov     cx, (320 / 4)
	sub     cx, bx
	mov     si, dx
	rep     movsd [di], es:[si]
	jmp     MC113



; One Line Draw Complete
;---------------------------------------

;***************************************
; Increase Counters

MC113:
	cmp     DetailPass, 0
	je      DetailHighDown_MC

	mov     si, dx
	mov     cx, (320 / 4)
	rep     movsd [di], es:[si]

	pop     si
	pop     cx
	dec     cx
	jz      MC114

	mov     bx, XLengthOffset
	xor     dh, dh
	mov     dl, [bx]
	sub     si, dx                  ; Sub SI ( = PixelPos's offset )
	dec     bx
	mov     dl, [bx]
	sub     si, dx                  ; Sub SI ( = PixelPos's offset )
	dec     bx
	mov     XLengthOffset, bx       ; Decreased XLengthOffset

	sub     XCalOffset, word ptr 2  ; Decreased XCalOffset
	add     VScreenOffset, word ptr 640
					; Increased VScreenOffset
	mov     bx, DeptOffset
	sub     bx, 4
	mov     DeptOffset, bx          ; Decreased DeptOffset

	jmp     MC112

DetailHighDown_MC:
	pop     si
	pop     cx
	dec     cx
	jz      MC114

	mov     bx, XLengthOffset
	xor     dh, dh
	mov     dl, [bx]
	sub     si, dx                  ; Add SI ( = PixelPos's offset )
	dec     bx
	mov     XLengthOffset, bx       ; Increased XLengthOffset

	dec     word ptr XCalOffset     ; Increased XCalOffset
	add     VScreenOffset, word ptr 320
					; Increased VScreenOffset
	mov     bx, DeptOffset
	sub     bx, 2
	mov     DeptOffset, bx          ; Increased DeptOffset

	jmp     MC112


MC114:

; Lower Cloud End
;----------------------------------------


;****************************************
; Insert Half Line
	mov     di, ((offset Vscreen) + (320 * 96))
	mov     eax, 01010101h          ; Color = 01h
	mov     cx, ((320 * 8) / 4)
	rep     stosd
; Half Line End
;----------------------------------------

	ret


MakeCloud       Endp
