;************
; File Reader
;************

;DS = MainData
;GS = FileBuffer

;***************************
FileRead        Proc    Near

assume DS:MainData
OpenFile:
        mov     dx, PassName            ; file open parameter
        xor     al, al                  ; file attribute = read
        mov     ah, 3dh                 ; file open int
        int     21h
        jc      ErrorHandle             ; Jump to Error Handling Routine

ReadFile:
        mov     bx, ax                  ; AX = file handle
        mov     cx, PassSize
        mov     dx, BufferOffset
        mov     ax, BufferSegment
        mov     ds, ax
        mov     ah, 3fh                 ; file read int
        int     21h
        jc      readerr
        mov     ax, MainData
        mov     ds, ax

MessagePrint:
assume DS:MainData
        mov     dx, offset OkMessage
        mov     ah, 9
        int     21h

        ret



;**********************
;error handling routile
;**********************
ErrorHandle:
filerr:                                 ; if CF = 1 -> file error 
;        cmp     ax, 2
;        jz      fnotfound       
;        mov     dx, offset otherr
;        mov     ah, 9
;        int     21h
;        jmp     exitprg

fnotfound:                              ; AX = 2 -> file not found
;        mov     dx, offset fnexist
;        mov     ah, 9
;        int     21h
;        jmp     exitprg

readerr:                                ; pcx reading error routine
;        mov     ax, nametable
;        mov     ds, ax
;        mov     dx, offset rerr
;        mov     ah, 9
;        int     21h
;        jmp     exitprg



assume ds:virtualscreen
assume es:filebuffer
        
;        mov     ax, virtualscreen       ; address initial
;        mov     ds, ax                  ; ds, si = virtual screen
;        mov     ax, filebuffer          ; 
;        mov     es, ax                  ; es, di = file buffer
;        mov     edi, offset fstart      ;
;        add     di, 80h                 ;
;        mov     esi, offset sstart      ;

;exitprg:                                ; program terminate
        ret

FileRead        Endp



;fexist          db      'file exist$'
;fnexist         db      'file not exist$'
;otherr          db      'other error$'
;rerr            db      'read err$'
