;*************
;Macro2nd
;      Routine
;*************



;***************************
Macro2nd        Proc    Near

	mov     si, GMacroOffset
	lodsd
	mov     GMacroOffset, si
	mov     cx, 4

PicSearch_M2:
	or      al, al
	jz      PicDone_M2
	mov     edx, eax
	push    cx
	call    PicPress
	pop     cx
	mov     eax, edx
PicDone_M2:
	shr     eax, 8
	loop    PicSearch_M2

	ret

Macro2nd        Endp



;***************************
PicPress        Proc    near

	xor     ebx, ebx
	mov     bl, al
	mov     si, ((offset PicAddress) - 4)
	lgs     si, [esi][ebx*4]        ; GS:SI = Pic Address
	mov     di, offset VScreen      ; ES:DI = Virtual Screen
	xor     cx, cx

	lodsw   gs:[si]
	add     di, ax

Decode_PP:
	lodsb   gs:[si]
	or      al, al
	jz      Exit_PP

	shl     al, 1
	jnc     Ncmp_PP

;Compress Routine
	shr     al, 1
	mov     cl, al
	lodsb   gs:[si]
	or      al, al
	jz      CmpEmpty_PP
	rep     stosb
	jmp     Decode_PP
CmpEmpty_PP:
	add     di, cx
	jmp     Decode_PP

Ncmp_PP:
	shr     al, 1
	mov     cl, al
	rep     movsb [di], gs:[si]
	jmp     Decode_PP

Exit_PP:
	ret

PicPress        Endp
