;**************
;Macor3rd
;       Routine
;**************


;***************************
Macro3rd        Proc    Near

	mov     si, GMacroOffset
	lodsd
	mov     GMacroOffset, si
	mov     GlassWNumber, al
	shr     ax, 8
	or      al, al
	jz      PalMacro_M3
	push    eax
	call    TextPress
	pop     eax

PalMacro_M3:
	shr     eax, 16
	mov     PalCodew, ax
	mov     PalCounter, al
	ret

Macro3rd        Endp



;***************************
TextPress       Proc    Near

	xor     ebx, ebx
	mov     bl, al
	cmp     bl, 58
	jae     Repair_TP
	mov     si, ((offset TextAddress) - 4)
	jmp     RepDone_TP
Repair_TP:
	sub     bl, 57
	mov     si, ((offset TextAddress2) - 4)
RepDone_TP:
	lgs     si, [esi][ebx*4]        ; GS:SI = Text Address
	mov     di, offset VScreen      ; ES:DI = Virtual Screen
	xor     cx, cx

Decode_TP:
	lodsb   gs:[si]
	or      al, al
	jz      Exit_TP

	shl     al, 1
	jnc     Ncmp_TP

;Compress Routine
	shr     al, 1
	mov     dl, gs:[si]
	inc     si
	or      dl, dl
	jz      DataZero_TP
	cmp     dl, 255
	je      Data255_TP

;Other Compress
	mov     dh, al

	mov     cl, 4
OCMakeH_TP:
	shl     dl, 1
	jc      OCSet255H_TP
	xor     al, al
	jmp     OCDoneH_TP
		OCSet255H_TP:
			mov     al, 255
		OCDoneH_TP:
			ror     eax, 8
	loop    OCMakeH_TP

	mov     cl, 4
OCMakeL_TP:
	shl     dl, 1
	jc      OCSet255L_TP
	xor     bl, bl
	jmp     OCDoneL_TP
		OCSet255L_TP:
			mov     bl, 255
		OCDoneL_TP:
			ror     ebx, 8
	loop    OCMakeL_TP

	mov     cl, dh

OCPut_TP:
	or      es:[di], eax
	add     di, 4
	or      es:[di], ebx
	add     di, 4
	loop    OCPut_TP
	jmp     Decode_TP

;-------
Data255_TP:
	mov     cl, al
	mov     eax, 0ffffffffh
		LP255_TP:
			mov     es:[di], eax
			add     di, 4
			mov     es:[di], eax
			add     di, 4
		loop    LP255_TP
	jmp     Decode_TP

;--------
DataZero_TP:
	shl     ax, 8
	shr     ax, 5
	add     di, ax
	jmp     Decode_TP

Ncmp_TP:
	shr     al, 1
	mov     cl, al
	mov     al, 255

NCLoop_TP:
	mov     dl, gs:[si]
	inc     si
	mov     bx, cx
	mov     cl, 8

NC8_TP:
	shl     dl, 1
	jnc     DataPass_TP
	mov     es:[di], al
DataPass_TP:
	inc     di
	loop    NC8_TP

	mov     cx, bx
	loop    NCLoop_TP
	jmp     Decode_TP

Exit_TP:
	ret

TextPress       Endp
