;********************
; Palette
;       Process
; Entry:
;       DH = PalCode1
;       DL = PalCode2
;********************



;***************************
PalProcess      Proc    Near

	cmp     dh, 5
	ja      Lightning_PP
	mov     al, SpeedCntPass
	cmp     PalCounter, al
	jbe     Multiply_PP
	sub     PalCounter, al
	ret
Multiply_PP:
	cmp     dl, al
	jae     SpeedCntSub

	xor     ah, ah
	div     dl
	add     PalCounter, ah
	cmp     PalCounter, dl
	jbe     IncDone_PP
	inc     al
	sub     PalCounter, dl
	jmp     IncDone_PP

SpeedCntSub:
	mov     ah, dl
	Sub     ah, al
	add     PalCounter, ah
	mov     al, 1

IncDone_PP:


;-----------
;GfadeIn_PP:
	cmp     dh, 1
	jne     GFadeOut_PP
	mov     di, offset PalTable1    ; DI = PalTable1
	xor     ebx, ebx
	mov     bl, PalNumber1
	mov     si, ((offset PalAddress) - 2)
	mov	si, [esi][ebx*2]        ; SI = Pal Address1
	mov     bl, al
	mov     cx, (3*128/4)
GFIMakeH_PP:
	lodsd
	mov     edx, [di]
	add     dl, bl
	cmp     dl, al
	jbe     GFadeIncH1_PP
	mov     dl, al
GFadeIncH1_PP:
	add     dh, bl
	cmp     dh, ah
	jbe     GFadeIncH2_PP
	mov     dh, ah
GFadeIncH2_PP:
	ror     eax, 16
	ror     edx, 16
	add     dl, bl
	cmp     dl, al
	jbe     GFadeIncH3_PP
	mov     dl, al
GFadeIncH3_PP:
	add     dh, bl
	cmp     dh, ah
	jbe     GFadeIncH4_PP
	mov     dh, ah
GFadeIncH4_PP:
	ror     edx, 16
	mov     [di], edx
	add     di, 4
	loop    GFIMakeH_PP
	mov     al, bl
	mov     bl, PalNumber2
	mov     si, ((offset PalAddress) - 2)
	mov     si, [esi][ebx*2]     ; SI = Pal Address1
	mov     bl, al
	mov     cx, (3*128/4)
GFIMakeL_PP:
	lodsd
	mov     edx, [di]
	add     dl, bl
	cmp     dl, al
	jbe     GFadeIncL1_PP
	mov     dl, al
GFadeIncL1_PP:
	add     dh, bl
	cmp     dh, ah
	jbe     GFadeIncL2_PP
	mov     dh, ah
GFadeIncL2_PP:
	ror     eax, 16
	ror     edx, 16
	add     dl, bl
	cmp     dl, al
	jbe     GFadeIncL3_PP
	mov     dl, al
GFadeIncL3_PP:
	add     dh, bl
	cmp     dh, ah
	jbe     GFadeIncL4_PP
	mov     dh, ah
GFadeIncL4_PP:
	ror     edx, 16
	mov     [di], edx
	add     di, 4
	loop    GFIMakeL_PP
	mov     si, offset PalTable1
	xor     al, al
	mov     dx, 3c8h
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	ret


;-----------
GFadeOut_PP:
	cmp     dh, 2
	jne     GFOLight_PP
	jne     FadeIn2_PP
	mov     bl, al
	mov     si, offset PalTable1
	mov     di, si
	mov     cx, (3*256/4)
GFOMake_PP:
	lodsd
	sub     al, bl
	jae     GFadeDec1_PP
	xor     al, al
GFadeDec1_PP:
	sub     ah, bl
	jae     GFadeDec2_PP
	xor     ah, ah
GFadeDec2_PP:
	ror     eax, 16
	sub     al, bl
	jae     GFadeDec3_PP
	xor     al, al
GFadeDec3_PP:
	sub     ah, bl
	jae     GFadeDec4_PP
	xor     ah, ah
GFadeDec4_PP:
	ror     eax, 16
	mov	[di], eax
	add	di, 4
	loop    GFOMake_PP
	mov     si, offset PalTable1
	xor     al, al
	mov     dx, 3c8h
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	ret


;-----------
GFOLight_PP:
	cmp     dh, 3
	jne     FadeIn2_PP
	mov     di, offset PalTable1    ; DI = PalTable1
	xor     ebx, ebx
	mov     bl, PalNumber1
	mov     esi, ((offset PalAddress) - 2)
	mov	si, [esi][ebx*2]        ; SI = Pal Address1
	mov     bl, al
	mov     cx, (3*128/4)
GFOLMakeH_PP:
	lodsd
	mov     edx, [di]
	cmp     al, dl
	je      GFOLPass1H_PP
	sub     dl, bl
	jb      GFOLSamer1H_PP
	cmp     al, dl
	jbe     GFOLPass1H_PP
GFOLSamer1H_PP:
	mov     dl, al
GFOLPass1H_PP:
	cmp     ah, dh
	je      GFOLPass2H_PP
	sub     dh, bl
	jb      GFOLSamer2H_PP
	cmp     ah, dh
	jbe     GFOLPass2H_PP
GFOLSamer2H_PP:
	mov     dh, ah
GFOLPass2H_PP:
	ror     eax, 16
	ror     edx, 16
	cmp     al, dl
	je      GFOLPass3H_PP
	sub     dl, bl
	jb      GFOLSamer3H_PP
	cmp     al, dl
	jbe     GFOLPass3H_PP
GFOLSamer3H_PP:
	mov     dl, al
GFOLPass3H_PP:
	cmp     ah, dh
	je      GFOLPass4H_PP
	sub     dh, bl
	jb      GFOLSamer4H_PP
	cmp     ah, dh
	jbe     GFOLPass4H_PP
GFOLSamer4H_PP:
	mov     dh, ah
GFOLPass4H_PP:
	ror     edx, 16
	mov     [di], edx
	add     di, 4
	loop    GFOLMakeH_PP
	mov     bl, PalNumber2
	mov     si, ((offset PalAddress) - 2)
	mov	si, [esi][ebx*2]        ; DS:SI = Pal Address2
	mov     cx, (3*128/4)
GFOLMakeL_PP:
	lodsd
	mov     edx, [di]
	cmp     al, dl
	je      GFOLPass1L_PP
	sub     dl, bl
	jb      GFOLSamer1L_PP
	cmp     al, dl
	jbe     GFOLPass1L_PP
GFOLSamer1L_PP:
	mov     dl, al
GFOLPass1L_PP:
	cmp     ah, dh
	je      GFOLPass2L_PP
	sub     dh, bl
	jb      GFOLSamer2L_PP
	cmp     ah, dh
	jbe     GFOLPass2L_PP
GFOLSamer2L_PP:
	mov     dh, ah
GFOLPass2L_PP:
	ror     eax, 16
	ror     edx, 16
	cmp     al, dl
	je      GFOLPass3L_PP
	sub     dl, bl
	jb      GFOLSamer3L_PP
	cmp     al, dl
	jbe     GFOLPass3L_PP
	jmp     GFOLSamer3L_PP
GFOLSamer3L_PP:
	mov     dl, al
GFOLPass3L_PP:
	cmp     ah, dh
	je      GFOLPass4L_PP
	sub     dh, bl
	jb      GFOLSamer4L_PP
	cmp     ah, dh
	jbe     GFOLPass4L_PP
GFOLSamer4L_PP:
	mov     dh, ah
GFOLPass4L_PP:
	ror     edx, 16
	mov     [di], edx
	add     di, 4
	loop    GFOLMakeL_PP
	mov     si, offset PalTable1
	mov     dx, 3c8h
	xor     al, al
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	ret


;----------
FadeIn2_PP:
	cmp     dh, 4
	jne     FadeOut2_PP
	ret


;-----------
FadeOut2_PP:
	mov     dl, al
	mov     si, offset PalTable1    ; SI = PalTable1
	mov     di, offset PalTable2    ; DI = PalTable2
	mov     cx, (3*128/4)
FO2Make_PP:
	lodsd
	mov     ebx, [di]
	cmp     al, bl
	ja      FO2Inc1_PP
	je      FO2Pass1_PP
	sub     bl, dl
	jb      FO2Samer1_PP
	cmp     al, bl
	jbe     FO2Pass1_PP
	jmp     FO2Samer1_PP
FO2Inc1_PP:
	add     bl, dl
	cmp     al, bl
	jae     FO2Pass1_PP
FO2Samer1_PP:
	mov     bl, al
FO2Pass1_PP:
	cmp     ah, bh
	ja      FO2Inc2_PP
	je      FO2Pass2_PP
	sub     bh, dl
	jb      FO2Samer2_PP
	cmp     ah, bh
	jbe     FO2Pass2_PP
	jmp     FO2Samer2_PP
FO2Inc2_PP:
	add     bh, dl
	cmp     ah, bh
	jae     FO2Pass2_PP
FO2Samer2_PP:
	mov     bh, ah
FO2Pass2_PP:
	ror     eax, 16
	ror     ebx, 16
	cmp     al, bl
	ja      FO2Inc3_PP
	je      FO2Pass3_PP
	sub     bl, dl
	jb      FO2Samer3_PP
	cmp     al, bl
	jbe     FO2Pass3_PP
	jmp     FO2Samer3_PP
FO2Inc3_PP:
	add     bl, dl
	cmp     al, bl
	jae     FO2Pass3_PP
FO2Samer3_PP:
	mov     bl, al
FO2Pass3_PP:
	cmp     ah, bh
	ja      FO2Inc4_PP
	je      FO2Pass4_PP
	sub     bh, dl
	jb      FO2Samer4_PP
	cmp     ah, bh
	jbe     FO2Pass4_PP
	jmp     FO2Samer4_PP
FO2Inc4_PP:
	add     bh, dl
	cmp     ah, bh
	jae     FO2Pass4_PP
FO2Samer4_PP:
	mov     bh, ah
FO2Pass4_PP:
	ror     ebx, 16
	mov     [di], ebx
	add     di, 4
	loop    FO2Make_PP
	mov     dx, 3c8h
	mov     al, 128
	mov     cx, (3*128)
	out     dx, al
	inc     dx
	rep     outsb
	ret


;------------
Lightning_PP:
	cmp     dh, 6
	jne     Darker_PP
	mov     al, dl
	and     al, 00001111b
	mov     PalNumber1, al
	shr     dl, 4
	mov     PalNumber2, dl
	mov	ax, MainData
	mov	es, ax
	mov     di, offset PalTable1    ; DI = PalTable1
	mov     si, di                  ; SI =    //
	mov     eax, 3f3f3f3fh
	mov     cx, (3*256/4)
	rep     stosd
	mov	ax, VirtualScreen
	mov	es, ax
	xor     al, al
	mov     dx, 3c8h
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	mov     PalCode1, byte ptr 0
	ret


;---------
Darker_PP:
	cmp     dh, 7
	jne     PalLoad_PP
	mov     al, dl
	and     al, 00001111b
	mov     PalNumber1, al
	shr     dl, 4
	mov     PalNumber2, dl
	mov	ax, MainData
	mov     es, ax
	mov     di, offset PalTable1    ; ES:DI = PalTable1
	mov     si, di                  ; DS:SI =    //
	xor     eax, eax
	mov     cx, (3*256/4)
	rep     stosd
	mov	ax, VirtualScreen
	mov	es, ax
	mov     dx, 3c8h
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	mov     PalCode1, byte ptr 0
	ret


;----------
PalLoad_PP:
	xor     ebx, ebx
	mov     bl, dl
	and     bl, 00001111b
	mov     PalNumber1, bl
	mov     di, offset PalTable1    ; ES:DI = PalTable1
	mov     eax, ((offset PalAddress) - 2)
	mov	si, [eax][ebx*2]        ; DS:SI = PalAddress
	shr     dl, 4
	mov     PalNumber2, dl
	mov     bl, dl
	mov	cx, MainData
	mov	es, cx
	mov     cx, (3*128/4)
	rep     movsd
	mov     si, [eax][ebx*2]
	mov     cx, (3*128/4)
	rep     movsd
	mov	cx, VirtualScreen
	mov	es, cx
	mov     si, offset PalTable1
	xor     al, al
	mov     dx, 3c8h
	mov     cx, (3*256)
	out     dx, al
	inc     dx
	rep     outsb
	mov     PalCode1, byte ptr 0
	ret

PalProcess      Endp
