;****************
; Timer Interrupt
; Initial Routine
;****************



;***************************
TimerInit       Proc    Near

	cli
	mov     eax, gs:[8*4]
	mov     Int8Bios, eax

	mov     ax, offset New_Timer_Routine
	mov     gs:[8*4], ax
	mov     gs:[8*4+2], cs

;-------------------
;New Counter Writing
	mov     al, 34h
	out     43h, al
	mov     al, ((1234ddh / FrameLimit) mod 256)
	out     40h, al
	mov     al, ((1234ddh / FrameLimit) / 256)
	out     40h, al
	sti
	ret

TimerInit       Endp



;***************************
New_Timer_Routine       Proc

	push    ds
	push    eax

	mov     ax, MainData
	mov     ds, ax
	inc     byte ptr SpeedCounter
	cmp     SpeedCounter, byte ptr 192
	ja      TimeOut_NT

	mov     eax, Clock_Ticks
	add     eax, (1234ddh / FrameLimit)
	cmp     eax, 10000h
	jb      Quit_Handler_NT
	sub     eax, 10000h
	pushf
	call    dword ptr [Int8Bios]

Quit_Handler_NT:
	mov     Clock_Ticks, eax
	mov     al, 20h
	out     20h, al
	pop     eax
	pop     ds
	iret

TimeOut_NT:
	mov     TimeOut, byte ptr 1
	pop     eax
	pop     ds
	iret

New_Timer_Routine       Endp
