;****************
; XEXEX Fake A.D.
;    Main Program
;****************
.Model Large
.386


FrameLimit      equ     82
CloudXVello     equ     1               ; 70 Frame = 2, 3
CloudYVello     equ     2               ; 35 Frame = 4, 6
CloudPicWidth   equ     64
CloudPicDepth   equ     400
GlobalLoop      equ     3

;***********************************
MainCode Segment Dword Public 'Code'

assume  DS:MainData
Include CludPres.prc
Include PressGls.prc
Include PPosMake.prc
Include KeyInit .prc
Include TimerInt.prc
Include Macro1st.prc
Include Macro2nd.prc
Include Macro3rd.prc
Include PalPrces.prc
Include FileLoad.prc

;----------------
; Program Initial

Start:
	mov     ax, MainData
	mov     ds, ax
	cld
	xor     esi, esi
	mov     edi, esi

	; Initial Message

	call    FileLoader
	call    PixelPosMake
	xor     ax, ax
	mov     gs, ax
	call    KeyInit
	call    TimerInit
	mov     ax, 0013h
	int     10h
	mov     ax, VirtualScreen
	mov     es, ax
	mov     fs, ax
	mov     TimeDelay, word ptr 0

;-------------
; Main Process

MainLoop:
	cmp     TimeOut, byte ptr 0
	jne     ExitPrg
	cmp     TimeDelay, word ptr 0
	jne     Cloud_Search
	call    Macro1st
	call    Macro2nd
	call    Macro3rd
Cloud_Search:
	cmp     CloudActivity, byte ptr 0
	je      GlassWindo_Search
	call    MakeCloud
	mov     DisplayOrder, byte ptr 1
GlassWindo_Search:
	cmp     GlassWNumber, byte ptr 0
	je      Display_Search
	call    GlassWPress
Display_Search:
	cmp     DisplayOrder, 0
	je      Pal_Search
	mov     bx, es
	mov     ax, 0a000h
	mov     es, ax
	mov     si, offset VScreen
	xor     di, di
	mov     cx, 64000/4
	rep     movsd [di], fs:[si]
	mov     es, bx
	mov     DisplayOrder, byte ptr 0
Pal_Search:
	mov     dx, PalCodew
	or      dh, dh
	jz      MLoop_Search
	call    PalProcess
MLoop_Search:
	cmp     MLoopOrder, byte ptr 0
	je      Exit_Search
	mov     GMacroOffset, offset GMacroData
	mov     MLoopOrder, byte ptr 0
	inc     byte ptr LoopCounter
	cmp     LoopCounter, byte ptr GlobalLoop
	jne     Exit_Search
	mov     GMacroOffset, offset SMacroData
	mov     LoopCounter, byte ptr 0
	mov     MLoopOrder, byte ptr 0
Exit_Search:
	cmp     ExitOn, byte ptr 0
	jne     ExitPrg
Timing_Sync:
	cmp     SpeedCounter, byte ptr 0
	je      Timing_Sync
	xor     cx, cx
	xchg    cl, SpeedCounter
	mov     SpeedCntPass, cl
	sub     TimeDelay, cx
	jae     MainLoop
	mov     TimeDelay, word ptr 0
	jmp     MainLoop

ExitPrg:

	; Int9 Handler Restore
	cli
	xor     ax, ax
	mov     gs, ax

	mov     al, 34h
	out     43h, al
	xor     al, al
	out     40h, al
	out     40h, al

	mov     eax, Int8Bios
	mov     gs:[8*4], eax
	mov     eax, OldKeyPair
	mov     gs:[9*4], eax

	sti

	mov     ax, 0003h               ; return to text mode
	int     10h
	mov     ax, 4c00h               ; return to dos
	int     21h

MainCode Ends





;***********************************
MainData Segment Para Public 'Data'

	Include         MacroDat.inc    ; Align 4

	PicAddress       dd      Pic1Address
			dd      Pic2Address
			dd      Pic3Address
			dd      Pic4Address
			dd      Pic5Address
			dd      Pic6Address
			dd      Pic7Address
			dd      Pic8Address
			dd      Pic9Address
			dd      Pic10Address
			dd      Pic11Address
			dd      Pic12Address
			dd      Pic13Address
			dd      Pic14Address
			dd      Pic15Address
			dd      Pic16Address
			dd      Pic17Address
			dd      Pic18Address
			dd      Pic19Address
			dd      Pic20Address
			dd      Pic21Address

	TextAddress     dd      Text1Address
			dd      Text2Address
			dd      Text3Address
			dd      Text4Address
			dd      Text5Address
			dd      Text6Address
			dd      Text7Address
			dd      Text8Address
			dd      Text9Address
			dd      Text10Address
			dd      Text11Address
			dd      Text12Address
			dd      Text13Address
			dd      Text14Address
			dd      Text15Address
			dd      Text17Address
			dd      Text18Address
			dd      Text19Address
			dd      Text20Address
			dd      Text21Address
			dd      Text22Address
			dd      Text23Address
			dd      Text24Address
			dd      Text25Address
			dd      Text26Address
			dd      Text27Address
			dd      Text28Address
			dd      Text29Address
			dd      Text30Address
			dd      Text31Address
			dd      Text32Address
			dd      Text33Address
			dd      Text34Address
			dd      Text35Address
			dd      Text36Address
			dd      Text37Address
			dd      Text38Address
			dd      Text39Address
			dd      Text40Address
			dd      Text41Address
			dd      Text42Address
			dd      Text43Address
			dd      Text44Address
			dd      Text45Address
			dd      Text46Address
			dd      Text47Address
			dd      Text48Address
			dd      Text49Address
			dd      Text50Address
			dd      Text51Address
			dd      Text52Address
			dd      Text53Address
			dd      Text54Address
			dd      Text55Address
			dd      Text56Address
			dd      Text57Address
	TextAddress2    dd      Text58Address
			dd      Text59Address
			dd      Text60Address
			dd      Text61Address
			dd      Text62Address
			dd      Text63Address
			dd      Text64Address
			dd      Text65Address

	GlassWAddress   dd      GlassW1Address
			dd      GlassW2Address
			dd      GlassW3Address
			dd      GlassW4Address
			dd      GlassW5Address
			dd      GlassW6Address
			dd      GlassW7Address
			dd      GlassW8Address
			dd      GlassW9Address
			dd      GlassW10Address
			dd      GlassW11Address

	Clock_Ticks     dd      0

	PalAddress      dw      Pal1Address
			dw      Pal2Address
			dw      Pal3Address
			dw      Pal4Address
			dw      Pal5Address
			dw      Pal6Address
			dw      Pal7Address
			dw      Pal8Address
			dw      Pal9Address
			dw      Pal10Address

	Include         ClouDept.inc    ; Cloud's Y Line number
					; Align 2
	GMacroOffset    dw      GMStart
	CloudYCoordy    dw      0
	CloudXCoordy    db      0
	ExitOn          db      0
	DetailKey       db      0
	CloudActivity   db      0
	MLoopOrder      db      0
	LoopCounter     db      1
	TimeOut         db      0
	OkMessage       db      'Read Ok',13,10,'$'

	Include         LoadList.inc    ; Align 1

	Include         XLength.inc     ; Each X Line's Width
					; Align 1
	Include         StartPxl.inc    ; ( 0 , y ) 's Pixel Position
					; Align 1

					;Align 4
	GMacroDWord     label   dword
	GMacroCounter   dw      0
	GMacroCode      dw      ?

	Pal1Address     db      384 dup (?)
	Pal2Address     db      384 dup (?)
	Pal3Address     db      384 dup (?)
	Pal4Address     db      384 dup (?)
	Pal5Address     db      384 dup (?)
	Pal6Address     db      384 dup (?)
	Pal7Address     db      384 dup (?)
	Pal8Address     db      384 dup (?)
	Pal9Address     db      384 dup (?)
	Pal10Address    db      384 dup (?)

	PalTable1       db      (3 * 128) dup (?)
	PalTable2       db      (3 * 128) dup (?)
	CloudAddress    db      25600   dup (?)
	XStartCal       db      96 dup (?)

	OldKeyPair      label   dword
	OldKeyOff       dw      ?
	OldKeySeg       dw      ?
	Int8Bios        label   dword
	OldInt8Off      dw      ?
	OldInt8Seg      dw      ?

	TimeDelay       dw      ?
	PalCodew        label   word
	PalCode2        db      ?
	PalCode1        db      ?
	PalNumber1      db      ?
	PalNumber2      db      ?

	XCalOffset      dw      ?
	XLengthOffset   dw      ?
	DeptOffset      dw      ?
	VScreenOffset   dw      ?
	InvertYCoordy   dw      ?
	FHandle         dw      ?
	FileCounter     dw      ?

	PixelPos        db      10321 dup (?)   ; Source Pix : Printed Pix

	DisplayOrder    db      ?
	GlassWNumber    db      ?
	PalCounter      db      ?

	ModCounter      db      ?
	SpeedCounter    db      ?
	SpeedCntPass    db      ?
	DetailPass      db      ?

MainData Ends



Include FileSgmt.inc


;****************************************
VirtualScreen Segment Dword Public 'Data'
	VScreen         db      64000 dup (?)
VirtualScreen Ends



;***********************************
Stackseg Segment Dword Stack 'Stack'
			db      1024 dup (?)
Stackseg Ends



End Start
